/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.plugins.circular;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.gradle.internal.impldep.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.gradle.internal.impldep.org.apache.ivy.core.module.id.ModuleRevisionId;

public final class CircularDependencyHelper {
    private CircularDependencyHelper() {
    }

    public static String formatMessage(ModuleRevisionId[] mrids) {
        HashSet<ModuleRevisionId> alreadyAdded = new HashSet<ModuleRevisionId>();
        StringBuilder buff = new StringBuilder();
        for (ModuleRevisionId mrid : mrids) {
            if (buff.length() > 0) {
                buff.append("->");
            }
            if (!alreadyAdded.add(mrid)) {
                buff.append("...");
                break;
            }
            buff.append(mrid);
        }
        return buff.toString();
    }

    public static String formatMessage(ModuleDescriptor[] descriptors) {
        return CircularDependencyHelper.formatMessageFromDescriptors(Arrays.asList(descriptors));
    }

    public static String formatMessageFromDescriptors(List<ModuleDescriptor> loopElements) {
        LinkedList<ModuleRevisionId> mrids = new LinkedList<ModuleRevisionId>();
        for (ModuleDescriptor descriptor : loopElements) {
            mrids.add(descriptor.getModuleRevisionId());
        }
        return CircularDependencyHelper.formatMessage(mrids.toArray(new ModuleRevisionId[mrids.size()]));
    }
}

