/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.palette.impl;

import com.intellij.designer.LightToolWindowContent;
import com.intellij.ide.palette.PaletteGroup;
import com.intellij.ide.palette.PaletteItem;
import com.intellij.ide.palette.PaletteItemProvider;
import com.intellij.ide.palette.impl.PaletteComponentList;
import com.intellij.ide.palette.impl.PaletteContentWindow;
import com.intellij.ide.palette.impl.PaletteGroupHeader;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CompositeDataProvider;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.util.ArrayUtilRt;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaletteWindow
extends JPanel
implements LightToolWindowContent,
DataProvider {
    private final Project myProject;
    private final ArrayList<PaletteGroupHeader> myGroupHeaders = new ArrayList();
    private final PaletteItemProvider[] myProviders;
    private final MyPropertyChangeListener myPropertyChangeListener = new MyPropertyChangeListener();
    private final Set<PaletteGroup> myGroups = new HashSet<PaletteGroup>();
    private final JTabbedPane myTabbedPane = new JBTabbedPane();
    private final JScrollPane myScrollPane = ScrollPaneFactory.createScrollPane();
    private final MyListSelectionListener myListSelectionListener = new MyListSelectionListener();
    private PaletteGroupHeader myLastFocusedGroup;
    @NonNls
    private static final String ourHelpID = "guiDesigner.uiTour.palette";
    private final DragSourceListener myDragSourceListener = new DragSourceAdapter(){

        @Override
        public void dragDropEnd(DragSourceDropEvent event) {
            Component component = event.getDragSourceContext().getComponent();
            if (!event.getDropSuccess() && component instanceof PaletteComponentList && PaletteWindow.this.getRootPane() == ((JComponent)component).getRootPane()) {
                PaletteWindow.this.clearActiveItem();
            }
        }
    };
    private GuiEditor myDesigner;

    public PaletteWindow(Project project) {
        this.myProject = project;
        this.myProviders = (PaletteItemProvider[])PaletteItemProvider.EP_NAME.getExtensions((AreaInstance)project);
        this.setLayout(new GridLayout(1, 1));
        this.myScrollPane.addMouseListener((MouseListener)((Object)new MyScrollPanePopupHandler()));
        this.myScrollPane.setBorder(null);
        KeyStroke escStroke = KeyStroke.getKeyStroke(27, 0);
        new ClearActiveItemAction().registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(escStroke), this.myScrollPane);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            DragSource.getDefaultDragSource().addDragSourceListener(this.myDragSourceListener);
        }
    }

    public void dispose() {
        this.removePaletteProviderListener();
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            DragSource.getDefaultDragSource().removeDragSourceListener(this.myDragSourceListener);
        }
    }

    private void addPaletteProviderListener() {
        for (PaletteItemProvider provider : this.myProviders) {
            provider.addListener(this.myPropertyChangeListener);
        }
    }

    private void removePaletteProviderListener() {
        for (PaletteItemProvider provider : this.myProviders) {
            provider.removeListener(this.myPropertyChangeListener);
        }
    }

    public void refreshPaletteIfChanged(@Nullable GuiEditor designer) {
        VirtualFile file;
        HashSet<PaletteGroup> currentGroups;
        this.removePaletteProviderListener();
        this.myDesigner = designer;
        if (designer != null) {
            this.addPaletteProviderListener();
        }
        if (!(currentGroups = new HashSet<PaletteGroup>(this.collectCurrentGroups(file = designer == null ? null : designer.getFile()))).equals(this.myGroups)) {
            this.refreshPalette(file);
        }
    }

    private void refreshPalette(@Nullable VirtualFile selectedFile) {
        for (PaletteGroupHeader groupHeader : this.myGroupHeaders) {
            groupHeader.getComponentList().removeListSelectionListener(this.myListSelectionListener);
        }
        String[] oldTabNames = PaletteWindow.collectTabNames(this.myGroups);
        this.myTabbedPane.removeAll();
        this.myGroupHeaders.clear();
        this.myGroups.clear();
        ArrayList<PaletteGroup> currentGroups = this.collectCurrentGroups(selectedFile);
        String[] tabNames = PaletteWindow.collectTabNames(currentGroups);
        if (tabNames.length == 1) {
            if (oldTabNames.length != 1) {
                this.remove(this.myTabbedPane);
                this.add(this.myScrollPane);
            }
            PaletteContentWindow contentWindow = new PaletteContentWindow();
            this.myScrollPane.getViewport().setView(contentWindow);
            for (PaletteGroup group : currentGroups) {
                this.addGroupToControl(group, contentWindow);
            }
            JComponent view = (JComponent)this.myScrollPane.getViewport().getView();
            if (view != null) {
                view.revalidate();
                for (Component component : view.getComponents()) {
                    component.revalidate();
                }
            }
        } else {
            if (oldTabNames.length <= 1) {
                this.remove(this.myScrollPane);
                this.add(this.myTabbedPane);
            }
            for (String tabName : tabNames) {
                PaletteContentWindow contentWindow = new PaletteContentWindow();
                JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)contentWindow);
                scrollPane.addMouseListener((MouseListener)((Object)new MyScrollPanePopupHandler()));
                this.myTabbedPane.add(tabName, scrollPane);
                for (PaletteGroup group : currentGroups) {
                    if (!group.getTabName().equals(tabName)) continue;
                    this.addGroupToControl(group, contentWindow);
                }
            }
            this.myTabbedPane.revalidate();
        }
    }

    private void addGroupToControl(PaletteGroup group, JComponent control) {
        PaletteGroupHeader groupHeader = new PaletteGroupHeader(this, group);
        this.myGroupHeaders.add(groupHeader);
        this.myGroups.add(group);
        control.add(groupHeader);
        PaletteComponentList componentList = new PaletteComponentList(this.myProject, this, group);
        control.add((Component)((Object)componentList));
        groupHeader.setComponentList(componentList);
        componentList.addListSelectionListener(this.myListSelectionListener);
    }

    private static String[] collectTabNames(Collection<PaletteGroup> groups) {
        TreeSet<String> result = new TreeSet<String>();
        for (PaletteGroup group : groups) {
            result.add(group.getTabName());
        }
        return ArrayUtilRt.toStringArray(result);
    }

    private ArrayList<PaletteGroup> collectCurrentGroups(@Nullable VirtualFile selectedFile) {
        ArrayList<PaletteGroup> result = new ArrayList<PaletteGroup>();
        if (selectedFile != null) {
            for (PaletteItemProvider provider : this.myProviders) {
                PaletteGroup[] groups = provider.getActiveGroups(selectedFile);
                Collections.addAll(result, groups);
            }
        }
        return result;
    }

    public void clearActiveItem() {
        if (this.getActiveItem() == null) {
            return;
        }
        for (PaletteGroupHeader group : this.myGroupHeaders) {
            group.getComponentList().clearSelection();
        }
        ListSelectionEvent event = new ListSelectionEvent(this, -1, -1, false);
        this.notifySelectionChanged(event);
    }

    @Nullable
    public PaletteItem getActiveItem() {
        for (PaletteGroupHeader groupHeader : this.myGroupHeaders) {
            if (!groupHeader.isSelected() || groupHeader.getComponentList().getSelectedValue() == null) continue;
            return (PaletteItem)groupHeader.getComponentList().getSelectedValue();
        }
        return null;
    }

    @Nullable
    public <T extends PaletteItem> T getActiveItem(Class<T> cls) {
        PaletteItem item = this.getActiveItem();
        if (item != null && item.getClass().isInstance(item)) {
            return (T)item;
        }
        return null;
    }

    @Nullable
    private PaletteGroup getActiveGroup() {
        JScrollPane activeScrollPane;
        PaletteContentWindow activeContentWindow;
        PaletteGroupHeader groupHeader;
        for (PaletteGroupHeader groupHeader2 : this.myGroupHeaders) {
            if ((!groupHeader2.isSelected() || groupHeader2.getComponentList().getSelectedValue() == null) && groupHeader2 != this.myLastFocusedGroup) continue;
            return groupHeader2.getGroup();
        }
        int tabCount = PaletteWindow.collectTabNames(this.myGroups).length;
        if (tabCount > 0 && (groupHeader = (activeContentWindow = (PaletteContentWindow)(activeScrollPane = tabCount == 1 ? this.myScrollPane : (JScrollPane)this.myTabbedPane.getSelectedComponent()).getViewport().getView()).getLastGroupHeader()) != null) {
            return groupHeader.getGroup();
        }
        return null;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Object data;
        if (dataId == null) {
            PaletteWindow.$$$reportNull$$$0(0);
        }
        if (PlatformCoreDataKeys.HELP_ID.is(dataId)) {
            return ourHelpID;
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (PlatformCoreDataKeys.BGT_DATA_PROVIDER.is(dataId)) {
            DataProvider provider2;
            PaletteItem item = this.getActiveItem();
            PaletteGroup group = this.getActiveGroup();
            DataProvider provider1 = item == null ? null : (DataProvider)item.getData(this.myProject, dataId);
            DataProvider dataProvider = provider2 = group == null ? null : (DataProvider)group.getData(this.myProject, dataId);
            if (provider1 == null && provider2 == null) {
                return null;
            }
            return provider1 == null ? provider2 : CompositeDataProvider.compose((DataProvider)provider1, (DataProvider)provider2);
        }
        PaletteItem item = this.getActiveItem();
        if (item != null && (data = item.getData(this.myProject, dataId)) != null) {
            return data;
        }
        PaletteGroup group = this.getActiveGroup();
        if (group != null) {
            return group.getData(this.myProject, dataId);
        }
        return null;
    }

    public Project getProject() {
        return this.myProject;
    }

    void setLastFocusedGroup(PaletteGroupHeader focusedGroup) {
        this.myLastFocusedGroup = focusedGroup;
        for (PaletteGroupHeader group : this.myGroupHeaders) {
            group.getComponentList().clearSelection();
        }
    }

    void notifyKeyEvent(KeyEvent e) {
        if (this.myDesigner != null) {
            if (e.getID() == 401) {
                this.myDesigner.paletteKeyPressed(e);
            } else if (e.getID() == 402) {
                this.myDesigner.paletteKeyReleased(e);
            }
        }
    }

    void notifyDropActionChanged(int gestureModifiers) {
        if (this.myDesigner != null) {
            this.myDesigner.paletteDropActionChanged(gestureModifiers);
        }
    }

    void notifySelectionChanged(ListSelectionEvent event) {
        if (this.myDesigner != null) {
            this.myDesigner.paletteValueChanged(event);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/ide/palette/impl/PaletteWindow", "getData"));
    }

    private class MyPropertyChangeListener
    implements PropertyChangeListener {
        private MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PaletteWindow.this.refreshPalette(PaletteWindow.this.myDesigner.getFile());
        }
    }

    private class MyListSelectionListener
    implements ListSelectionListener {
        private MyListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            PaletteComponentList sourceList = (PaletteComponentList)((Object)e.getSource());
            for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
                if (!sourceList.isSelectedIndex(i)) continue;
                for (PaletteGroupHeader group : PaletteWindow.this.myGroupHeaders) {
                    if (group.getComponentList() == sourceList) continue;
                    group.getComponentList().clearSelection();
                }
                break;
            }
            PaletteWindow.this.notifySelectionChanged(e);
        }
    }

    private static class MyScrollPanePopupHandler
    extends PopupHandler {
        private MyScrollPanePopupHandler() {
        }

        public void invokePopup(Component comp, int x, int y) {
            PaletteGroupHeader groupHeader;
            JScrollPane scrollPane = (JScrollPane)comp;
            PaletteContentWindow contentWindow = (PaletteContentWindow)scrollPane.getViewport().getView();
            if (contentWindow != null && (groupHeader = contentWindow.getLastGroupHeader()) != null) {
                groupHeader.showGroupPopupMenu(comp, x, y);
            }
        }
    }

    private class ClearActiveItemAction
    extends AnAction {
        private ClearActiveItemAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ClearActiveItemAction.$$$reportNull$$$0(0);
            }
            PaletteWindow.this.clearActiveItem();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/palette/impl/PaletteWindow$ClearActiveItemAction", "actionPerformed"));
        }
    }
}

