/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.MessagePool;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.internal.performanceTests.ProjectInitializationDiagnosticService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackRunner;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.util.Alarm;
import com.intellij.util.SystemProperties;
import com.jetbrains.performancePlugin.CommandLogger;
import com.jetbrains.performancePlugin.CommandsRunner;
import com.jetbrains.performancePlugin.PerformanceTestSpan;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.PlaybackRunnerExtended;
import com.jetbrains.performancePlugin.ProjectLoaded;
import com.jetbrains.performancePlugin.ProjectLoadedKt;
import com.jetbrains.performancePlugin.ProjectLoadedService;
import com.jetbrains.performancePlugin.commands.OpenProjectCommand;
import com.jetbrains.performancePlugin.commands.TakeScreenshotCommandKt;
import com.jetbrains.performancePlugin.profilers.Profiler;
import com.jetbrains.performancePlugin.profilers.ProfilersController;
import com.jetbrains.performancePlugin.utils.ReporterCommandAsTelemetrySpan;
import io.opentelemetry.context.Context;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\b\u0010\r\u001a\u00020\u000eH\u0002\u001a\u001c\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u0011\u0018\u00010\u0010H\u0002\u001a\u001c\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0006\u0010\u0018\u001a\u00020\u0013\u001a\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u001a$\u0010\u001f\u001a\u00020\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010 \u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u001a\u0018\u0010!\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0002\u001a\u0010\u0010$\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u001a\u0018\u0010%\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0002\u001a\u0012\u0010&\u001a\u00020\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u0018\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"INDEXING_PROFILER_PREFIX", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "TIMEOUT", "", "generifyErrorMessage", "originalMessage", "getNonEmptyThrowableMessage", "throwable", "", "getTestFile", "Ljava/io/File;", "initializeProfilerSettingsForIndexing", "Lcom/intellij/openapi/util/Pair;", "", "registerOnFinishRunnables", "", "future", "Ljava/util/concurrent/CompletableFuture;", "mustExitOnFailure", "", "reportErrorsFromMessagePool", "reportScriptError", "errorMessage", "Lcom/intellij/diagnostic/AbstractMessage;", "runOnProjectInit", "project", "Lcom/intellij/openapi/project/Project;", "runPerformanceScript", "script", "runScriptDuringIndexing", "alarm", "Lcom/intellij/util/Alarm;", "runScriptFromFile", "runScriptWhenInitializedAndIndexed", "storeFailureToFile", "writeAttachmentToErrorDir", "attachment", "Lcom/intellij/openapi/diagnostic/Attachment;", "path", "Ljava/nio/file/Path;", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nProjectLoaded.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectLoaded.kt\ncom/jetbrains/performancePlugin/ProjectLoadedKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,412:1\n731#2,9:413\n*S KotlinDebug\n*F\n+ 1 ProjectLoaded.kt\ncom/jetbrains/performancePlugin/ProjectLoadedKt\n*L\n267#1:413,9\n*E\n"})
public final class ProjectLoadedKt {
    private static final int TIMEOUT = 500;
    @NotNull
    private static final String INDEXING_PROFILER_PREFIX = "%%profileIndexing";

    private static final Logger getLOG() {
        Logger logger = Logger.getInstance((String)"PerformancePlugin");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    private static final File getTestFile() {
        String string = ProjectLoaded.TEST_SCRIPT_FILE_PATH;
        Intrinsics.checkNotNull((Object)string);
        File file = new File(string);
        if (!file.isFile()) {
            Object[] objectArray = new Object[]{file.getAbsolutePath()};
            System.err.println(PerformanceTestingBundle.message("startup.noscript", objectArray));
            ApplicationManagerEx.getApplicationEx().exit(true, true, 1);
        }
        return file;
    }

    private static final void runOnProjectInit(Project project) {
        if (ProjectLoaded.TEST_SCRIPT_FILE_PATH == null || ProjectLoadedService.scriptStarted) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                ProjectLoadedKt.getLOG().info(PerformanceTestingBundle.message("startup.silent", new Object[0]));
            }
            return;
        }
        ProjectLoadedService.scriptStarted = true;
        if (System.getProperty("ide.performance.screenshot") != null) {
            String string = System.getProperty("ide.performance.screenshot");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
            CoroutineScope coroutineScope = project.getCoroutineScope();
            Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"getCoroutineScope(...)");
            ProjectLoadedService.INSTANCE.registerScreenshotTaking(string, coroutineScope);
        }
        ProjectLoadedKt.getLOG().info("Start Execution");
        PerformanceTestSpan.startSpan();
        Pair<String, List<String>> profilerSettings = ProjectLoadedKt.initializeProfilerSettingsForIndexing();
        if (profilerSettings != null) {
            try {
                Profiler profiler = ProfilersController.getInstance().getCurrentProfilerHandler();
                Object object = profilerSettings.first;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
                String string = (String)object;
                Object object2 = profilerSettings.second;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"second");
                profiler.startProfiling(string, (List)object2);
            }
            catch (Exception e) {
                System.err.println("Start profile failed: " + e.getMessage());
                ApplicationManagerEx.getApplicationEx().exit(true, true, 1);
            }
        }
        if (OpenProjectCommand.Companion.shouldOpenInSmartMode(project)) {
            ProjectLoadedKt.runScriptWhenInitializedAndIndexed(project, ProjectLoadedService.INSTANCE.getAlarm());
        } else if (SystemProperties.getBooleanProperty((String)"performance.execute.script.after.scanning", (boolean)false)) {
            ProjectLoadedKt.runScriptDuringIndexing(project, ProjectLoadedService.INSTANCE.getAlarm());
        } else {
            ProjectLoadedKt.runScriptFromFile(project);
        }
    }

    private static final void runScriptWhenInitializedAndIndexed(Project project, Alarm alarm2) {
        DumbService dumbService = DumbService.Companion.getInstance(project);
        Runnable runnable = Context.current().wrap(() -> ProjectLoadedKt.runScriptWhenInitializedAndIndexed$lambda$1(alarm2, project));
        Intrinsics.checkNotNullExpressionValue((Object)runnable, (String)"wrap(...)");
        dumbService.smartInvokeLater(runnable);
    }

    private static final void runScriptDuringIndexing(Project project, Alarm alarm2) {
        ApplicationManager.getApplication().executeOnPooledThread(Context.current().wrap(() -> ProjectLoadedKt.runScriptDuringIndexing$lambda$3(alarm2, project)));
    }

    public static final void runPerformanceScript(@Nullable Project project, @Nullable String script, boolean mustExitOnFailure) {
        PlaybackRunner.StatusCallback statusCallback = new CommandLogger();
        Project project2 = project;
        Intrinsics.checkNotNull((Object)project2);
        PlaybackRunnerExtended playback = new PlaybackRunnerExtended(script, statusCallback, project2);
        CompletableFuture<?> scriptCallback = playback.run();
        CommandsRunner.setActionCallback(scriptCallback);
        Intrinsics.checkNotNull(scriptCallback);
        ProjectLoadedKt.registerOnFinishRunnables(scriptCallback, mustExitOnFailure);
    }

    @NotNull
    public static final String generifyErrorMessage(@NotNull String originalMessage) {
        Intrinsics.checkNotNullParameter((Object)originalMessage, (String)"originalMessage");
        CharSequence charSequence = originalMessage;
        Regex regex = new Regex("[$@#][A-Za-z0-9-_]+");
        String string = "<ID>";
        charSequence = regex.replace(charSequence, string);
        regex = new Regex("[.]([A-Za-z]+[0-9]|[0-9]+[A-Za-z])[A-Za-z0-9]*");
        string = ".<HASH>";
        charSequence = regex.replace(charSequence, string);
        regex = new Regex("0x[0-9a-fA-F]+");
        string = "<HEX>";
        charSequence = regex.replace(charSequence, string);
        regex = new Regex("[0-9]+");
        string = "<NUM>";
        return regex.replace(charSequence, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void reportErrorsFromMessagePool() {
        MessagePool messagePool = MessagePool.getInstance();
        List ideErrors = messagePool.getFatalErrors(false, true);
        for (AbstractMessage message : ideErrors) {
            try {
                Intrinsics.checkNotNull((Object)message);
                ProjectLoadedKt.reportScriptError(message);
            }
            catch (IOException e) {
                ProjectLoadedKt.getLOG().error((Throwable)e);
            }
            finally {
                message.setRead(true);
            }
        }
    }

    private static final Pair<String, List<String>> initializeProfilerSettingsForIndexing() {
        try {
            List list = FileUtil.loadLines((File)ProjectLoadedKt.getTestFile());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"loadLines(...)");
            List lines = list;
            for (String line : lines) {
                List list2;
                Intrinsics.checkNotNull((Object)line);
                if (!StringsKt.startsWith$default((String)line, (String)INDEXING_PROFILER_PREFIX, (boolean)false, (int)2, null)) continue;
                String string = line.substring(17);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)string)).toString();
                Regex regex = new Regex("\\s+");
                int n = 2;
                List command = regex.split(charSequence, n);
                String indexingActivity = (String)command.get(0);
                if (command.size() > 1) {
                    char[] cArray = new char[]{','};
                    List $this$dropLastWhile$iv = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)((String)command.get(1)))).toString(), (char[])cArray, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$dropLastWhile = false;
                    if (!$this$dropLastWhile$iv.isEmpty()) {
                        ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            String it = (String)iterator$iv.previous();
                            boolean bl = false;
                            if (((CharSequence)it).length() == 0) continue;
                            list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                            break;
                        }
                    } else {
                        list2 = CollectionsKt.emptyList();
                    }
                } else {
                    list2 = new ArrayList();
                }
                List profilingParameters = list2;
                return new Pair((Object)indexingActivity, (Object)profilingParameters);
            }
        }
        catch (IOException ignored) {
            System.err.println(PerformanceTestingBundle.message("startup.script.read.error", new Object[0]));
            ApplicationManagerEx.getApplicationEx().exit(true, true, 1);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void reportScriptError(AbstractMessage errorMessage) throws IOException {
        Throwable throwable;
        Throwable throwable2 = errorMessage.getThrowable();
        Intrinsics.checkNotNullExpressionValue((Object)throwable2, (String)"getThrowable(...)");
        Throwable cause = throwable = throwable2;
        String causeMessage = null;
        causeMessage = "";
        while (cause.getCause() != null) {
            Throwable throwable3 = cause = cause.getCause();
            Intrinsics.checkNotNull((Object)throwable3);
            causeMessage = throwable3.getMessage();
        }
        CharSequence charSequence = causeMessage;
        if ((charSequence == null || charSequence.length() == 0) && ((charSequence = (CharSequence)(causeMessage = errorMessage.getMessage())) == null || charSequence.length() == 0)) {
            String string;
            String throwableMessage = ProjectLoadedKt.getNonEmptyThrowableMessage(throwable);
            int index = StringsKt.indexOf$default((CharSequence)throwableMessage, (String)"\tat ", (int)0, (boolean)false, (int)6, null);
            if (index == -1) {
                string = throwableMessage;
            } else {
                String string2 = throwableMessage.substring(0, index);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            }
            causeMessage = string;
        }
        Object index = new String[]{"script-errors"};
        Path scriptErrorsDir = Path.of(PathManager.getLogPath(), index);
        Files.createDirectories(scriptErrorsDir, new FileAttribute[0]);
        index = Files.walk(scriptErrorsDir, new FileVisitOption[0]);
        Throwable throwable4 = null;
        try {
            Stream stream = (Stream)index;
            boolean bl = false;
            String finalCauseMessage = causeMessage;
            boolean isDuplicated2 = stream.filter(arg_0 -> ProjectLoadedKt.reportScriptError$lambda$7$lambda$5(reportScriptError.1.isDuplicated.1.INSTANCE, arg_0)).anyMatch(arg_0 -> ProjectLoadedKt.reportScriptError$lambda$7$lambda$6((Function1)new Function1<Path, Boolean>(finalCauseMessage){
                final /* synthetic */ String $finalCauseMessage;
                {
                    this.$finalCauseMessage = $finalCauseMessage;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(Path path) {
                    try {
                        return Intrinsics.areEqual((Object)Files.readString(path), (Object)this.$finalCauseMessage);
                    }
                    catch (IOException e) {
                        ProjectLoadedKt.access$getLOG().error(e.getMessage());
                        return false;
                    }
                }
            }, arg_0));
            if (isDuplicated2) {
                return;
            }
            stream = Unit.INSTANCE;
        }
        catch (Throwable stream) {
            throwable4 = stream;
            throw stream;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)index, (Throwable)throwable4);
        }
        for (int i = 1; i < 1000; ++i) {
            Path errorDir = scriptErrorsDir.resolve("error-" + i);
            if (Files.exists(errorDir, new LinkOption[0])) continue;
            Files.createDirectories(errorDir, new FileAttribute[0]);
            Files.writeString(errorDir.resolve("message.txt"), (CharSequence)causeMessage, new OpenOption[0]);
            Files.writeString(errorDir.resolve("stacktrace.txt"), (CharSequence)errorMessage.getThrowableText(), new OpenOption[0]);
            List list = errorMessage.getAllAttachments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllAttachments(...)");
            List attachments = list;
            int n = attachments.size();
            for (int j = 0; j < n; ++j) {
                Attachment attachment = (Attachment)attachments.get(j);
                Intrinsics.checkNotNull((Object)attachment);
                Path path = errorDir.resolve(j + "-" + attachment.getName());
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                ProjectLoadedKt.writeAttachmentToErrorDir(attachment, path);
            }
            return;
        }
        ProjectLoadedKt.getLOG().error("Too many errors have been reported during script execution. See " + scriptErrorsDir);
    }

    private static final void writeAttachmentToErrorDir(Attachment attachment, Path path) {
        try {
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.APPEND, StandardOpenOption.CREATE};
            Files.writeString(path, (CharSequence)attachment.getDisplayText(), openOptionArray);
            openOptionArray = new OpenOption[]{StandardOpenOption.APPEND, StandardOpenOption.CREATE};
            Files.writeString(path, (CharSequence)System.lineSeparator(), openOptionArray);
        }
        catch (Exception e) {
            ProjectLoadedKt.getLOG().warn("Failed to write attachment `display text`", (Throwable)e);
        }
    }

    private static final String getNonEmptyThrowableMessage(Throwable throwable) {
        if (throwable.getMessage() != null) {
            String string = throwable.getMessage();
            Intrinsics.checkNotNull((Object)string);
            if (!(((CharSequence)string).length() == 0)) {
                String string2 = throwable.getMessage();
                Intrinsics.checkNotNull((Object)string2);
                return string2;
            }
        }
        String string = throwable.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    private static final void runScriptFromFile(Project project) {
        PlaybackRunnerExtended playback = new PlaybackRunnerExtended("%include " + ProjectLoadedKt.getTestFile(), new CommandLogger(), project);
        playback.setScriptDir(ProjectLoadedKt.getTestFile().getParentFile());
        if (SystemProperties.getBooleanProperty((String)"performance.execute.script.reportEachCommandAsTelemetrySpan", (boolean)false)) {
            playback.setCommandStartStopProcessor(new ReporterCommandAsTelemetrySpan());
        }
        CompletableFuture<?> scriptCallback = playback.run();
        CommandsRunner.setActionCallback(scriptCallback);
        Intrinsics.checkNotNull(scriptCallback);
        ProjectLoadedKt.registerOnFinishRunnables(scriptCallback, true);
    }

    private static final void registerOnFinishRunnables(CompletableFuture<?> future, boolean mustExitOnFailure) {
        ((CompletableFuture)future.thenRun(ProjectLoadedKt::registerOnFinishRunnables$lambda$8)).exceptionally(new Function(mustExitOnFailure){
            final /* synthetic */ boolean $mustExitOnFailure;
            {
                this.$mustExitOnFailure = $mustExitOnFailure;
            }

            @Nullable
            public final Void apply(Throwable e) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> registerOnFinishRunnables.2.apply$lambda$0(e, this.$mustExitOnFailure));
                return null;
            }

            private static final void apply$lambda$0(Throwable $e, boolean $mustExitOnFailure) {
                if (SystemProperties.getBooleanProperty((String)"startup.performance.framework", (boolean)false)) {
                    ProjectLoadedKt.access$storeFailureToFile($e.getMessage());
                }
                BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                    int label;

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = TakeScreenshotCommandKt.takeScreenshotOfAllWindows("onFailure", (Continuation<? super Unit>)((Continuation)this));
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)1, null);
                String threadDump = StringsKt.trimIndent((String)("\n            Thread dump before IDE termination:\n            " + ThreadDumper.dumpThreadsToString() + "\n            "));
                ProjectLoadedKt.access$getLOG().info(threadDump);
                if ($mustExitOnFailure) {
                    ApplicationManagerEx.getApplicationEx().exit(true, true, 1);
                }
            }
        });
    }

    private static final void storeFailureToFile(String errorMessage) {
        try {
            String string;
            Path logDir = Path.of(PathManager.getLogPath(), new String[0]);
            String ideaLogContent = Files.readString(logDir.resolve("idea.log"));
            Intrinsics.checkNotNull((Object)ideaLogContent);
            CharSequence charSequence = ideaLogContent;
            String string2 = errorMessage;
            Intrinsics.checkNotNull((Object)string2);
            String string3 = ideaLogContent.substring(StringsKt.indexOf$default((CharSequence)charSequence, (String)string2, (int)0, (boolean)false, (int)6, null));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            String substringBegin = string3;
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            String string4 = timestamp.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
            String string5 = string4;
            int n = 0;
            int n2 = 10;
            String string6 = string5.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String date = string6;
            int endIndex = StringsKt.indexOf$default((CharSequence)substringBegin, (String)date, (int)0, (boolean)false, (int)6, null);
            if (endIndex == -1) {
                string = substringBegin;
            } else {
                String string7 = substringBegin.substring(0, endIndex);
                string = string7;
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            }
            String errorMessageFromLog = string;
            Path failureCause = logDir.resolve("failure_cause.txt");
            Files.writeString(failureCause, (CharSequence)errorMessageFromLog, new OpenOption[0]);
        }
        catch (Exception e) {
            ProjectLoadedKt.getLOG().error(e.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    private static final void runScriptWhenInitializedAndIndexed$lambda$1$lambda$0(Project $project) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        v0 = WindowManager.getInstance().getIdeFrame($project);
        var2_1 = v0 != null ? v0.getStatusBar() : null;
        v1 = statusBar = var2_1 instanceof StatusBarEx != false ? (StatusBarEx)var2_1 : null;
        if (statusBar == null) ** GOTO lbl-1000
        v2 = statusBar.getBackgroundProcesses();
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getBackgroundProcesses(...)");
        if (((Collection)v2).isEmpty() == false) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = hasUserVisibleIndicators = false;
        }
        if (DumbService.Companion.isDumb($project) || hasUserVisibleIndicators || !ProjectInitializationDiagnosticService.getInstance((Project)$project).isProjectInitializationAndIndexingFinished()) {
            ProjectLoadedKt.runScriptWhenInitializedAndIndexed($project, ProjectLoadedService.INSTANCE.getAlarm());
        } else {
            ProjectLoadedKt.runScriptFromFile($project);
        }
    }

    private static final void runScriptWhenInitializedAndIndexed$lambda$1(Alarm $alarm, Project $project) {
        Intrinsics.checkNotNullParameter((Object)$alarm, (String)"$alarm");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        $alarm.addRequest(Context.current().wrap(() -> ProjectLoadedKt.runScriptWhenInitializedAndIndexed$lambda$1$lambda$0($project)), 500);
    }

    private static final void runScriptDuringIndexing$lambda$3$lambda$2(Project $project, Alarm $alarm) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$alarm, (String)"$alarm");
        List list = CoreProgressManager.getCurrentIndicators();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCurrentIndicators(...)");
        List indicators = list;
        boolean indexingInProgress = false;
        for (ProgressIndicator indicator : indicators) {
            String indicatorText = indicator.getText();
            if (indicatorText == null || !StringsKt.contains$default((CharSequence)indicatorText, (CharSequence)"Indexing", (boolean)false, (int)2, null)) continue;
            indexingInProgress = true;
            break;
        }
        if (indexingInProgress) {
            ProjectLoadedKt.runScriptFromFile($project);
        } else {
            ProjectLoadedKt.runScriptDuringIndexing($project, $alarm);
        }
    }

    private static final void runScriptDuringIndexing$lambda$3(Alarm $alarm, Project $project) {
        Intrinsics.checkNotNullParameter((Object)$alarm, (String)"$alarm");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        $alarm.addRequest(Context.current().wrap(() -> ProjectLoadedKt.runScriptDuringIndexing$lambda$3$lambda$2($project, $alarm)), 500);
    }

    private static final boolean reportScriptError$lambda$7$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean reportScriptError$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void registerOnFinishRunnables$lambda$8() {
        ProjectLoadedKt.getLOG().info("Execution of the script has been finished successfully");
    }

    public static final /* synthetic */ void access$runOnProjectInit(Project project) {
        ProjectLoadedKt.runOnProjectInit(project);
    }

    public static final /* synthetic */ Logger access$getLOG() {
        return ProjectLoadedKt.getLOG();
    }

    public static final /* synthetic */ void access$storeFailureToFile(String errorMessage) {
        ProjectLoadedKt.storeFailureToFile(errorMessage);
    }
}

