/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.performancePlugin.utils.AbstractCallbackBasedCommand;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/performancePlugin/commands/StopDebugProcessCommand;", "Lcom/jetbrains/performancePlugin/utils/AbstractCallbackBasedCommand;", "text", "", "line", "", "(Ljava/lang/String;I)V", "execute", "", "callback", "Lcom/intellij/openapi/util/ActionCallback;", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "Companion", "intellij.performanceTesting"})
public final class StopDebugProcessCommand
extends AbstractCallbackBasedCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PREFIX = "%stopDebugProcess";

    public StopDebugProcessCommand(@NotNull String text2, int line) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        super(text2, line, true);
    }

    @Override
    protected void execute(@NotNull ActionCallback callback2, @NotNull PlaybackContext context) {
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        XDebugSession[] xDebugSessionArray = XDebuggerManager.getInstance((Project)context.getProject()).getDebugSessions();
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSessionArray, (String)"getDebugSessions(...)");
        XDebugSession[] debugSessions = xDebugSessionArray;
        if (debugSessions.length == 0) {
            callback2.reject("Debug process was not started");
            return;
        }
        if (debugSessions.length > 1) {
            callback2.reject("Currently running " + debugSessions.length + " debug processes");
            return;
        }
        WriteAction.runAndWait(() -> StopDebugProcessCommand.execute$lambda$0(debugSessions, callback2));
    }

    private static final void execute$lambda$0(XDebugSession[] $debugSessions, ActionCallback $callback) {
        Intrinsics.checkNotNullParameter((Object)$debugSessions, (String)"$debugSessions");
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        $debugSessions[0].stop();
        $callback.setDone();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/performancePlugin/commands/StopDebugProcessCommand$Companion;", "", "()V", "PREFIX", "", "Lorg/jetbrains/annotations/NonNls;", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

