/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.serialization;

import com.amazon.ion.IonReader;
import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.amazon.ion.system.IonReaderBuilder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.ClasspathEntryModel;
import org.jetbrains.plugins.gradle.tooling.internal.BuildScriptClasspathModelImpl;
import org.jetbrains.plugins.gradle.tooling.internal.ClasspathEntryModelImpl;
import org.jetbrains.plugins.gradle.tooling.serialization.SerializationService;
import org.jetbrains.plugins.gradle.tooling.serialization.ToolingStreamApiUtils;
import org.jetbrains.plugins.gradle.tooling.util.IntObjectMap;
import org.jetbrains.plugins.gradle.tooling.util.ObjectCollector;

public final class BuildScriptClasspathModelSerializationService
implements SerializationService<BuildScriptClasspathModel> {
    private final WriteContext myWriteContext = new WriteContext();
    private final ReadContext myReadContext = new ReadContext();

    public byte[] write(BuildScriptClasspathModel classpathModel, Class<? extends BuildScriptClasspathModel> modelClazz) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (IonWriter writer = ToolingStreamApiUtils.createIonWriter().build((OutputStream)out);){
            BuildScriptClasspathModelSerializationService.write(writer, this.myWriteContext, classpathModel);
        }
        return out.toByteArray();
    }

    public BuildScriptClasspathModel read(byte[] object, Class<? extends BuildScriptClasspathModel> modelClazz) throws IOException {
        try (IonReader reader = IonReaderBuilder.standard().build(object);){
            BuildScriptClasspathModel buildScriptClasspathModel = BuildScriptClasspathModelSerializationService.read(reader, this.myReadContext);
            return buildScriptClasspathModel;
        }
    }

    public Class<? extends BuildScriptClasspathModel> getModelClass() {
        return BuildScriptClasspathModel.class;
    }

    private static void write(final IonWriter writer, final WriteContext context, final BuildScriptClasspathModel model) throws IOException {
        context.objectCollector.add(model, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    if (!context.isFirstModelWritten) {
                        context.isFirstModelWritten = true;
                        ToolingStreamApiUtils.writeString(writer, "gradleVersion", model.getGradleVersion());
                        ToolingStreamApiUtils.writeFile(writer, "gradleHomeDir", model.getGradleHomeDir());
                    }
                    BuildScriptClasspathModelSerializationService.writeClasspath(writer, (Set)model.getClasspath());
                }
                writer.stepOut();
            }
        });
    }

    private static void writeClasspath(IonWriter writer, Set<? extends ClasspathEntryModel> classpath) throws IOException {
        writer.setFieldName("classpath");
        writer.stepIn(IonType.LIST);
        for (ClasspathEntryModel classpathEntryModel : classpath) {
            BuildScriptClasspathModelSerializationService.writeClasspathEntry(writer, classpathEntryModel);
        }
        writer.stepOut();
    }

    private static void writeClasspathEntry(IonWriter writer, ClasspathEntryModel entry) throws IOException {
        writer.stepIn(IonType.STRUCT);
        ToolingStreamApiUtils.writeStrings(writer, "classes", entry.getClasses());
        ToolingStreamApiUtils.writeStrings(writer, "sources", entry.getSources());
        ToolingStreamApiUtils.writeStrings(writer, "javadoc", entry.getJavadoc());
        writer.stepOut();
    }

    @Nullable
    private static BuildScriptClasspathModel read(final IonReader reader, final ReadContext context) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        BuildScriptClasspathModelImpl model = (BuildScriptClasspathModelImpl)context.objectMap.computeIfAbsent(ToolingStreamApiUtils.readInt(reader, "objectID"), (IntObjectMap.ObjectFactory)new IntObjectMap.SimpleObjectFactory<BuildScriptClasspathModelImpl>(){

            public BuildScriptClasspathModelImpl create() {
                BuildScriptClasspathModelImpl classpathModel = new BuildScriptClasspathModelImpl();
                if (!context.isFirstModelRead) {
                    context.isFirstModelRead = true;
                    context.gradleVersion = ToolingStreamApiUtils.assertNotNull(ToolingStreamApiUtils.readString(reader, "gradleVersion"));
                    context.gradleHomeDir = ToolingStreamApiUtils.readFile(reader, "gradleHomeDir");
                }
                classpathModel.setGradleVersion(context.gradleVersion);
                classpathModel.setGradleHomeDir(context.gradleHomeDir);
                List classpathEntries = BuildScriptClasspathModelSerializationService.readClasspath(reader);
                for (ClasspathEntryModel entry : classpathEntries) {
                    classpathModel.add(entry);
                }
                return classpathModel;
            }
        });
        reader.stepOut();
        return model;
    }

    private static List<ClasspathEntryModel> readClasspath(IonReader reader) {
        ClasspathEntryModel entry;
        ArrayList<ClasspathEntryModel> list = new ArrayList<ClasspathEntryModel>();
        reader.next();
        reader.stepIn();
        while ((entry = BuildScriptClasspathModelSerializationService.readClasspathEntry(reader)) != null) {
            list.add(entry);
        }
        reader.stepOut();
        return list;
    }

    private static ClasspathEntryModel readClasspathEntry(IonReader reader) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        ClasspathEntryModelImpl entryModel = new ClasspathEntryModelImpl(ToolingStreamApiUtils.readFilesSet(reader), ToolingStreamApiUtils.readFilesSet(reader), ToolingStreamApiUtils.readFilesSet(reader));
        reader.stepOut();
        return entryModel;
    }

    private static class WriteContext {
        private boolean isFirstModelWritten;
        private final ObjectCollector<BuildScriptClasspathModel, IOException> objectCollector = new ObjectCollector();

        private WriteContext() {
        }
    }

    private static class ReadContext {
        private boolean isFirstModelRead;
        private File gradleHomeDir;
        private String gradleVersion;
        private final IntObjectMap<BuildScriptClasspathModelImpl> objectMap = new IntObjectMap();

        private ReadContext() {
        }
    }
}

