/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.fileStructure;

import com.intellij.ide.structureView.SearchableTextProvider;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.jetbrains.rd.ide.model.CodeStructureNavigateTo;
import com.jetbrains.rd.ide.model.CodeStructureTreeModel;
import com.jetbrains.rd.ide.model.CodeStructureTreeNode;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ui.icons.UtilKt;
import com.jetbrains.rdclient.fileStructure.CodeStructureTextAttributeProvider;
import com.jetbrains.rdclient.fileStructure.ProtocolFileStructureFakePsiElement;
import com.jetbrains.rdclient.fileStructure.TextAttributeProvider;
import java.util.Arrays;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002BA\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00000\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u000eJ\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020%H\u0016J\u0015\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020'0\bH\u0016\u00a2\u0006\u0002\u0010(J\u0006\u0010)\u001a\u00020*J\b\u0010+\u001a\u00020,H\u0016J\n\u0010-\u001a\u0004\u0018\u00010.H\u0016J\b\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020%H\u0016R\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00000\bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\r\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u00064"}, d2={"Lcom/jetbrains/rdclient/fileStructure/ProtocolStructureViewTreeElement;", "Lcom/intellij/ide/structureView/StructureViewTreeElement;", "Lcom/intellij/ide/structureView/SearchableTextProvider;", "codeTree", "Lcom/jetbrains/rd/ide/model/CodeStructureTreeModel;", "protocolTreeNode", "Lcom/jetbrains/rd/ide/model/CodeStructureTreeNode;", "children", "", "project", "Lcom/intellij/openapi/project/Project;", "documentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "parent", "(Lcom/jetbrains/rd/ide/model/CodeStructureTreeModel;Lcom/jetbrains/rd/ide/model/CodeStructureTreeNode;[Lcom/jetbrains/rdclient/fileStructure/ProtocolStructureViewTreeElement;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/ide/model/RdDocumentId;Lcom/jetbrains/rdclient/fileStructure/ProtocolStructureViewTreeElement;)V", "getChildren", "()[Lcom/jetbrains/rdclient/fileStructure/ProtocolStructureViewTreeElement;", "setChildren", "([Lcom/jetbrains/rdclient/fileStructure/ProtocolStructureViewTreeElement;)V", "[Lcom/jetbrains/rdclient/fileStructure/ProtocolStructureViewTreeElement;", "getCodeTree", "()Lcom/jetbrains/rd/ide/model/CodeStructureTreeModel;", "getDocumentId", "()Lcom/jetbrains/rd/ide/model/RdDocumentId;", "setDocumentId", "(Lcom/jetbrains/rd/ide/model/RdDocumentId;)V", "myFakePsiNode", "Lcom/jetbrains/rdclient/fileStructure/ProtocolFileStructureFakePsiElement;", "getMyFakePsiNode", "()Lcom/jetbrains/rdclient/fileStructure/ProtocolFileStructureFakePsiElement;", "getParent", "()Lcom/jetbrains/rdclient/fileStructure/ProtocolStructureViewTreeElement;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getProtocolTreeNode", "()Lcom/jetbrains/rd/ide/model/CodeStructureTreeNode;", "canNavigate", "", "canNavigateToSource", "Lcom/intellij/ide/util/treeView/smartTree/TreeElement;", "()[Lcom/intellij/ide/util/treeView/smartTree/TreeElement;", "getOffset", "", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getSearchableText", "", "getValue", "", "navigate", "", "requestFocus", "intellij.rd.client"})
public final class ProtocolStructureViewTreeElement
implements StructureViewTreeElement,
SearchableTextProvider {
    @Nullable
    private final CodeStructureTreeModel codeTree;
    @NotNull
    private final CodeStructureTreeNode protocolTreeNode;
    @NotNull
    private ProtocolStructureViewTreeElement[] children;
    @NotNull
    private final Project project;
    @Nullable
    private RdDocumentId documentId;
    @Nullable
    private final ProtocolStructureViewTreeElement parent;
    @NotNull
    private final ProtocolFileStructureFakePsiElement myFakePsiNode;

    public ProtocolStructureViewTreeElement(@Nullable CodeStructureTreeModel codeTree, @NotNull CodeStructureTreeNode protocolTreeNode, @NotNull ProtocolStructureViewTreeElement[] children, @NotNull Project project, @Nullable RdDocumentId documentId, @Nullable ProtocolStructureViewTreeElement parent) {
        Intrinsics.checkNotNullParameter((Object)protocolTreeNode, (String)"protocolTreeNode");
        Intrinsics.checkNotNullParameter((Object)children, (String)"children");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.codeTree = codeTree;
        this.protocolTreeNode = protocolTreeNode;
        this.children = children;
        this.project = project;
        this.documentId = documentId;
        this.parent = parent;
        this.myFakePsiNode = new ProtocolFileStructureFakePsiElement(this.protocolTreeNode, this, this.project, this.documentId);
    }

    @Nullable
    public final CodeStructureTreeModel getCodeTree() {
        return this.codeTree;
    }

    @NotNull
    public final CodeStructureTreeNode getProtocolTreeNode() {
        return this.protocolTreeNode;
    }

    @NotNull
    public final ProtocolStructureViewTreeElement[] getChildren() {
        return this.children;
    }

    public final void setChildren(@NotNull ProtocolStructureViewTreeElement[] protocolStructureViewTreeElementArray) {
        Intrinsics.checkNotNullParameter((Object)protocolStructureViewTreeElementArray, (String)"<set-?>");
        this.children = protocolStructureViewTreeElementArray;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final RdDocumentId getDocumentId() {
        return this.documentId;
    }

    public final void setDocumentId(@Nullable RdDocumentId rdDocumentId) {
        this.documentId = rdDocumentId;
    }

    @Nullable
    public final ProtocolStructureViewTreeElement getParent() {
        return this.parent;
    }

    @NotNull
    public final ProtocolFileStructureFakePsiElement getMyFakePsiNode() {
        return this.myFakePsiNode;
    }

    @Nullable
    public String getSearchableText() {
        String searchableText = CollectionsKt.joinToString$default((Iterable)this.protocolTreeNode.getSearchableTexts(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        if (StringsKt.isBlank((CharSequence)searchableText)) {
            return null;
        }
        return searchableText;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return (ItemPresentation)new ColoredItemPresentation(this){
            final /* synthetic */ ProtocolStructureViewTreeElement this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public String getPresentableText() {
                return this.this$0.getProtocolTreeNode().getName();
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                IconModel iconModel = this.this$0.getProtocolTreeNode().getIcon();
                return iconModel != null ? UtilKt.fromModel((IconModel)iconModel) : null;
            }

            @Nullable
            public TextAttributesKey getTextAttributesKey() {
                PsiFile psiFile = this.this$0.getMyFakePsiNode().getContainingFile();
                if (psiFile == null || (psiFile = psiFile.getFileType()) == null) {
                    return null;
                }
                PsiFile fileType = psiFile;
                TextAttributeProvider textAttributeProvider = (TextAttributeProvider)CodeStructureTextAttributeProvider.INSTANCE.forFileType((FileType)fileType);
                if (textAttributeProvider == null) {
                    return null;
                }
                TextAttributeProvider provider2 = textAttributeProvider;
                return provider2.getTextAttributesKeyFrom(this.this$0.getProtocolTreeNode());
            }
        };
    }

    @NotNull
    public TreeElement[] getChildren() {
        ProtocolStructureViewTreeElement[] protocolStructureViewTreeElementArray = Arrays.copyOf(this.children, this.children.length);
        Intrinsics.checkNotNullExpressionValue((Object)protocolStructureViewTreeElementArray, (String)"copyOf(this, size)");
        return (TreeElement[])protocolStructureViewTreeElementArray;
    }

    public final int getOffset() {
        return this.protocolTreeNode.getOffset();
    }

    public void navigate(boolean requestFocus) {
        block0: {
            CodeStructureTreeModel codeStructureTreeModel = this.codeTree;
            if (codeStructureTreeModel == null || (codeStructureTreeModel = codeStructureTreeModel.getNavigateTo()) == null) break block0;
            codeStructureTreeModel.fire((Object)new CodeStructureNavigateTo(this.protocolTreeNode.getId(), requestFocus));
        }
    }

    public boolean canNavigate() {
        return this.protocolTreeNode.getNavigable();
    }

    public boolean canNavigateToSource() {
        return this.protocolTreeNode.getNavigable();
    }

    @NotNull
    public Object getValue() {
        return this.myFakePsiNode;
    }
}

