/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.buildtool;

import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.FilePosition;
import com.intellij.build.SyncViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.MessageEventResult;
import com.intellij.build.events.impl.BuildIssueEventImpl;
import com.intellij.build.events.impl.DerivedResultImpl;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FileMessageEventImpl;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.FinishEventImpl;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.events.impl.OutputBuildEventImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.events.impl.StartEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.issue.BuildIssueException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThreeState;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.ArtifactSyncListener;
import org.jetbrains.idea.maven.buildtool.MavenImportSpec;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsole;
import org.jetbrains.idea.maven.buildtool.MessageEventUtilsKt;
import org.jetbrains.idea.maven.buildtool.quickfix.OffMavenOfflineModeQuickFix;
import org.jetbrains.idea.maven.buildtool.quickfix.OpenMavenSettingsQuickFix;
import org.jetbrains.idea.maven.buildtool.quickfix.UseBundledMavenQuickFix;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.externalSystemIntegration.output.importproject.quickfixes.DownloadArtifactBuildIssue;
import org.jetbrains.idea.maven.model.MavenProjectProblem;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.server.MavenArtifactEvent;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;
import org.jetbrains.idea.maven.server.MavenServerConsoleIndicator;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00dc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 ~2\u00020\u0001:\u0002}~B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!J\u0016\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\u0018\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0019H\u0007J\"\u0010+\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020\u00012\b\b\u0001\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\tH\u0002J\u0010\u0010+\u001a\u00020\u000f2\b\b\u0001\u0010-\u001a\u00020\u0007J\u0018\u0010+\u001a\u00020\u000f2\b\b\u0001\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\tJ\u001a\u0010/\u001a\u00020\u000f2\b\b\u0001\u0010-\u001a\u00020\u00072\b\b\u0001\u00100\u001a\u00020\u0007J$\u0010/\u001a\u00020\u000f2\b\b\u0001\u0010-\u001a\u00020\u00072\b\b\u0001\u00100\u001a\u00020\u00072\b\u00101\u001a\u0004\u0018\u000102J\u0010\u00103\u001a\u00020\u000f2\b\b\u0001\u0010-\u001a\u00020\u0007J\b\u00104\u001a\u00020\u000fH\u0002J\"\u00105\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020\u00012\b\b\u0001\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u000208H\u0002J\u0010\u00109\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020\u0007H\u0002J\r\u0010;\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017H\u0002J\b\u0010<\u001a\u00020\u000fH\u0002J\u0017\u0010=\u001a\u00020\u000f2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0082\bJ\u0016\u0010?\u001a\u00020\u000f2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0010\u0010@\u001a\u00020\u000f2\u0006\u0010A\u001a\u00020BH\u0002J\u0018\u0010C\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020\u00072\u0006\u0010D\u001a\u00020\u0007H\u0002J0\u0010E\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020\u00072\b\b\u0001\u0010D\u001a\u00020\u00072\b\b\u0001\u0010F\u001a\u00020\u00072\n\b\u0001\u0010G\u001a\u0004\u0018\u00010\u0007H\u0002J\u0018\u0010H\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020\u00072\u0006\u0010D\u001a\u00020\u0007H\u0002J\u0006\u0010I\u001a\u00020\u000fJ\u0012\u0010J\u001a\u00020\u000f2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)J\u000e\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NJ\u000b\u0010O\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017J\u0014\u0010P\u001a\u00020\u000f2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020S0RJ\u0010\u0010T\u001a\u00020\t2\u0006\u0010D\u001a\u00020\u0007H\u0002J\u0010\u0010U\u001a\u00020\t2\u0006\u0010V\u001a\u00020\u0007H\u0002J\u000e\u0010W\u001a\u00020\u000f2\u0006\u0010X\u001a\u00020YJ?\u0010Z\u001a\u0002H[\"\u0004\b\u0000\u0010[2\b\b\u0001\u00106\u001a\u00020\u00072\u001c\u0010\\\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H[0^\u0012\u0006\u0012\u0004\u0018\u00010\u00010]H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010_J)\u0010`\u001a\u0002H[\"\u0004\b\u0000\u0010[2\b\b\u0001\u00106\u001a\u00020\u00072\f\u0010\\\u001a\b\u0012\u0004\u0012\u0002H[0\u000e\u00a2\u0006\u0002\u0010aJ\"\u0010b\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020\u00072\u0006\u0010D\u001a\u00020\u00072\b\u0010c\u001a\u0004\u0018\u00010\u0007H\u0002J\u0018\u0010d\u001a\u00020\u000f2\u0006\u0010e\u001a\u00020\u00072\u0006\u0010f\u001a\u00020$H\u0002J\u0018\u0010g\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020\u00072\u0006\u0010D\u001a\u00020\u0007H\u0002J\u000e\u0010h\u001a\u00020\u000f2\u0006\u0010i\u001a\u00020jJ\u0016\u0010k\u001a\u00020\u000f2\u0006\u0010l\u001a\u00020\u00072\u0006\u0010%\u001a\u00020&J\u000e\u0010m\u001a\u00020\u000f2\u0006\u0010n\u001a\u00020\u0007J\u0016\u0010o\u001a\u00020\u000f2\u0006\u0010p\u001a\u00020\u00192\u0006\u0010q\u001a\u00020rJ\u001a\u0010s\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020\u00012\b\b\u0001\u00106\u001a\u00020\u0007H\u0002J\u0006\u0010t\u001a\u00020\u000fJ\u000e\u0010u\u001a\u00020\u000f2\u0006\u0010A\u001a\u00020BJ\f\u0010v\u001a\u000202*\u00020jH\u0002J,\u0010w\u001a\u0010\u0012\u0004\u0012\u00020B\u0012\u0004\u0012\u00020B\u0018\u00010\u0013*\u00020j2\b\u0010x\u001a\u0004\u0018\u00010\u00072\u0006\u0010y\u001a\u00020zH\u0002J\u001a\u0010{\u001a\u0010\u0012\u0004\u0012\u00020B\u0012\u0004\u0012\u00020B\u0018\u00010\u0013*\u00020jH\u0002J\u001a\u0010|\u001a\u0010\u0012\u0004\u0012\u00020B\u0012\u0004\u0012\u00020B\u0018\u00010\u0013*\u00020jH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0011\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u00130\u0012j\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u0013`\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u001bj\b\u0012\u0004\u0012\u00020\u0007`\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u007f"}, d2={"Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsole;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "JAVADOC_AND_SOURCE_CLASSIFIERS", "", "", "finished", "", "hasErrors", "hasUnresolved", "myPostponed", "Ljava/util/ArrayList;", "Lkotlin/Function0;", "", "Lkotlin/collections/ArrayList;", "myStartedSet", "Ljava/util/LinkedHashSet;", "Lkotlin/Pair;", "Lkotlin/collections/LinkedHashSet;", "mySyncId", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "Lorg/jetbrains/annotations/NotNull;", "mySyncView", "Lcom/intellij/build/BuildProgressListener;", "shownIssues", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "started", "syncTransactionStarted", "addBuildEvent", "buildEvent", "Lcom/intellij/build/events/BuildEvent;", "addBuildIssue", "issue", "Lcom/intellij/build/issue/BuildIssue;", "kind", "Lcom/intellij/build/events/MessageEvent$Kind;", "addException", "e", "", "progressListener", "addText", "parentId", "text", "stdout", "addWarning", "description", "filePosition", "Lcom/intellij/build/FilePosition;", "addWrapperProgressText", "attachOfflineQuickFix", "completeTask", "taskName", "result", "Lcom/intellij/build/events/EventResult;", "completeUmbrellaEvents", "keyPrefix", "createTaskId", "doFinish", "doIfImportInProcess", "action", "doIfImportInProcessOrPostpone", "doTerminate", "exitCode", "", "downloadEventCompleted", "dependency", "downloadEventFailed", "error", "stackTrace", "downloadEventStarted", "finishImport", "finishWrapperResolving", "getListener", "Lorg/jetbrains/idea/maven/buildtool/ArtifactSyncListener;", "type", "Lorg/jetbrains/idea/maven/server/MavenServerConsoleIndicator$ResolveType;", "getTaskId", "handleDownloadEvents", "downloadEvents", "", "Lorg/jetbrains/idea/maven/server/MavenArtifactEvent;", "isJavadocOrSource", "newIssue", "s", "notifyReadingProblems", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "runTask", "Result", "task", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "runTaskSync", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "showBuildIssue", "errorMessage", "showBuildIssueNode", "key", "buildIssue", "showError", "showProblem", "problem", "Lorg/jetbrains/idea/maven/model/MavenProjectProblem;", "showQuickFixBadMaven", "message", "showQuickFixJDK", "version", "startImport", "syncView", "spec", "Lorg/jetbrains/idea/maven/buildtool/MavenImportSpec;", "startTask", "startWrapperResolving", "terminated", "getFilePosition", "getPosition", "source", "pattern", "Lkotlin/text/Regex;", "getPositionFromDescription", "getPositionFromPath", "ArtifactSyncListenerImpl", "Companion", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenSyncConsole.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenSyncConsole.kt\norg/jetbrains/idea/maven/buildtool/MavenSyncConsole\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,601:1\n503#1,3:603\n503#1,3:607\n503#1,3:610\n503#1,3:613\n503#1,3:616\n503#1,3:619\n503#1,3:622\n503#1,3:627\n503#1,3:630\n503#1,3:635\n503#1,3:638\n503#1,3:641\n503#1,3:644\n503#1,3:647\n503#1,3:650\n503#1,3:653\n503#1,3:656\n503#1,3:659\n1855#2:602\n1856#2:606\n1855#2,2:625\n1855#2,2:633\n*S KotlinDebug\n*F\n+ 1 MavenSyncConsole.kt\norg/jetbrains/idea/maven/buildtool/MavenSyncConsole\n*L\n101#1:603,3\n113#1:607,3\n118#1:610,3\n123#1:613,3\n132#1:616,3\n147#1:619,3\n171#1:622,3\n213#1:627,3\n223#1:630,3\n323#1:635,3\n335#1:638,3\n347#1:641,3\n355#1:644,3\n364#1:647,3\n375#1:650,3\n381#1:653,3\n389#1:656,3\n401#1:659,3\n101#1:602\n101#1:606\n182#1:625,2\n295#1:633,2\n*E\n"})
public final class MavenSyncConsole {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private volatile BuildProgressListener mySyncView;
    @NotNull
    private ExternalSystemTaskId mySyncId;
    private boolean finished;
    private boolean started;
    private boolean syncTransactionStarted;
    private boolean hasErrors;
    private boolean hasUnresolved;
    @NotNull
    private final Set<String> JAVADOC_AND_SOURCE_CLASSIFIERS;
    @NotNull
    private final HashSet<String> shownIssues;
    @NotNull
    private final ArrayList<Function0<Unit>> myPostponed;
    @NotNull
    private LinkedHashSet<Pair<Object, String>> myStartedSet;
    private static final int EXIT_CODE_OK;
    private static final int EXIT_CODE_SIGTERM;

    public MavenSyncConsole(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        this.mySyncView = MavenSyncConsole::mySyncView$lambda$0;
        this.mySyncId = this.createTaskId();
        Object[] objectArray = new String[]{"javadoc", "sources", "test-javadoc", "test-sources"};
        this.JAVADOC_AND_SOURCE_CLASSIFIERS = SetsKt.setOf((Object[])objectArray);
        this.shownIssues = new HashSet();
        this.myPostponed = new ArrayList();
        this.myStartedSet = new LinkedHashSet();
    }

    public final synchronized void startImport(@NotNull BuildProgressListener syncView, @NotNull MavenImportSpec spec) {
        Intrinsics.checkNotNullParameter((Object)syncView, (String)"syncView");
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        if (this.started) {
            return;
        }
        AnAction restartAction2 = new AnAction(this){
            final /* synthetic */ MavenSyncConsole this$0;
            {
                this.this$0 = $receiver;
            }

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(!MavenSyncConsole.access$getStarted$p(this.this$0) || MavenSyncConsole.access$getFinished$p(this.this$0));
                e.getPresentation().setIcon(AllIcons.Actions.Refresh);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Project project2 = e.getProject();
                    if (project2 == null) break block0;
                    Project it = project2;
                    boolean bl = false;
                    MavenProjectsManager.getInstance(it).forceUpdateAllProjectsOrFindAllAvailablePomFiles();
                }
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }
        };
        this.started = true;
        this.finished = false;
        this.hasErrors = false;
        this.hasUnresolved = false;
        this.mySyncView = syncView;
        this.shownIssues.clear();
        this.mySyncId = this.createTaskId();
        String string = SyncBundle.message("maven.sync.title", new Object[0]);
        String string2 = this.myProject.getBasePath();
        Intrinsics.checkNotNull((Object)string2);
        DefaultBuildDescriptor descriptor2 = new DefaultBuildDescriptor((Object)this.mySyncId, string, string2, System.currentTimeMillis()).withRestartAction(restartAction2);
        descriptor2.setActivateToolWindowWhenFailed(spec.isExplicitImport());
        descriptor2.setActivateToolWindowWhenAdded(false);
        descriptor2.setNavigateToError(spec.isExplicitImport() ? ThreeState.YES : ThreeState.UNSURE);
        Object[] objectArray = new Object[]{this.myProject.getName()};
        this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new StartBuildEventImpl((BuildDescriptor)descriptor2, SyncBundle.message("maven.sync.project.title", objectArray)));
        org.jetbrains.idea.maven.buildtool.MavenSyncConsole$Companion.debugLog$default(Companion, "maven sync: started importing " + this.myProject, null, 2, null);
        Iterable $this$forEach$iv = this.myPostponed;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 p0 = (Function0)element$iv;
            boolean bl = false;
            MavenSyncConsole this_$iv = this;
            boolean $i$f$doIfImportInProcess = false;
            if (!this_$iv.started || this_$iv.finished) continue;
            p0.invoke();
        }
        this.myPostponed.clear();
    }

    private final ExternalSystemTaskId createTaskId() {
        ExternalSystemTaskId externalSystemTaskId = ExternalSystemTaskId.create((ProjectSystemId)MavenUtil.SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.RESOLVE_PROJECT, (Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)externalSystemTaskId, (String)"create(...)");
        return externalSystemTaskId;
    }

    @NotNull
    public final ExternalSystemTaskId getTaskId() {
        return this.mySyncId;
    }

    public final void addText(@Nls @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.addText(text, true);
    }

    public final synchronized void addText(@Nls @NotNull String text, boolean stdout) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            this.addText(this.mySyncId, text, true);
        }
    }

    public final synchronized void addWrapperProgressText(@Nls @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            String string = SyncBundle.message("maven.sync.wrapper", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.addText(string, text, true);
        }
    }

    private final synchronized void addText(Object parentId2, @Nls String text, boolean stdout) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            if (StringUtil.isEmpty((String)text)) {
                return;
            }
            Object toPrint = StringsKt.endsWith$default((CharSequence)text, (char)'\n', (boolean)false, (int)2, null) ? text : text + "\n";
            this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new OutputBuildEventImpl(parentId2, (String)toPrint, stdout));
        }
    }

    public final synchronized void addBuildEvent(@NotNull BuildEvent buildEvent) {
        Intrinsics.checkNotNullParameter((Object)buildEvent, (String)"buildEvent");
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            this.mySyncView.onEvent((Object)this.mySyncId, buildEvent);
        }
    }

    public final synchronized void addWarning(@Nls @NotNull String text, @Nls @NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        this.addWarning(text, description, null);
    }

    public final void addBuildIssue(@NotNull BuildIssue issue, @NotNull MessageEvent.Kind kind) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        this.doIfImportInProcessOrPostpone((Function0<Unit>)((Function0)new Function0<Unit>(this, issue, kind){
            final /* synthetic */ MavenSyncConsole this$0;
            final /* synthetic */ BuildIssue $issue;
            final /* synthetic */ MessageEvent.Kind $kind;
            {
                this.this$0 = $receiver;
                this.$issue = $issue;
                this.$kind = $kind;
                super(0);
            }

            public final void invoke() {
                if (!MavenSyncConsole.access$newIssue(this.this$0, this.$issue.getTitle() + this.$issue.getDescription())) {
                    return;
                }
                MavenSyncConsole.access$getMySyncView$p(this.this$0).onEvent((Object)MavenSyncConsole.access$getMySyncId$p(this.this$0), (BuildEvent)new BuildIssueEventImpl((Object)MavenSyncConsole.access$getMySyncId$p(this.this$0), this.$issue, this.$kind));
                MavenSyncConsole.access$setHasErrors$p(this.this$0, MavenSyncConsole.access$getHasErrors$p(this.this$0) || this.$kind == MessageEvent.Kind.ERROR);
            }
        }));
    }

    public final synchronized void addWarning(@Nls @NotNull String text, @Nls @NotNull String description, @Nullable FilePosition filePosition) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            if (!this.newIssue(text + description + filePosition)) {
                return;
            }
            if (filePosition == null) {
                this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new MessageEventImpl((Object)this.mySyncId, MessageEvent.Kind.WARNING, SyncBundle.message("maven.sync.group.compiler", new Object[0]), text, description));
            } else {
                this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new FileMessageEventImpl((Object)this.mySyncId, MessageEvent.Kind.WARNING, SyncBundle.message("maven.sync.group.compiler", new Object[0]), text, description, filePosition));
            }
        }
    }

    private final boolean newIssue(String s) {
        return this.shownIssues.add(s);
    }

    public final synchronized void finishImport() {
        org.jetbrains.idea.maven.buildtool.MavenSyncConsole$Companion.debugLog$default(Companion, "Maven sync: finishImport", null, 2, null);
        this.doFinish();
    }

    public final void terminated(int exitCode) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            if (EXIT_CODE_OK == exitCode || EXIT_CODE_SIGTERM == exitCode) {
                this.doFinish();
            } else {
                this.doTerminate(exitCode);
            }
        }
    }

    private final void doTerminate(int exitCode) {
        if (this.syncTransactionStarted) {
            org.jetbrains.idea.maven.buildtool.MavenSyncConsole$Companion.debugLog$default(Companion, "Maven sync: sync transaction is still not finished, postpone build finish event", null, 2, null);
            return;
        }
        List tasks = CollectionsKt.asReversed((List)CollectionsKt.toList((Iterable)this.myStartedSet));
        org.jetbrains.idea.maven.buildtool.MavenSyncConsole$Companion.debugLog$default(Companion, "Tasks " + tasks + " are not completed! Force complete", null, 2, null);
        Iterable $this$forEach$iv = tasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            Object[] objectArray = new Object[]{exitCode};
            this.completeTask(it.getFirst(), (String)it.getSecond(), (EventResult)new FailureResultImpl(SyncBundle.message("maven.sync.failure.terminated", objectArray)));
        }
        Object[] objectArray = new Object[]{exitCode};
        this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new FinishBuildEventImpl((Object)this.mySyncId, null, System.currentTimeMillis(), "", (EventResult)new FailureResultImpl(SyncBundle.message("maven.sync.failure.terminated", objectArray))));
        this.finished = true;
        this.started = false;
    }

    public final synchronized void startWrapperResolving() {
        if (!this.started || this.finished) {
            Object object = this.myProject.getService(SyncViewManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            BuildProgressListener buildProgressListener = (BuildProgressListener)object;
            MavenImportSpec mavenImportSpec = MavenImportSpec.EXPLICIT_IMPORT;
            Intrinsics.checkNotNullExpressionValue((Object)mavenImportSpec, (String)"EXPLICIT_IMPORT");
            this.startImport(buildProgressListener, mavenImportSpec);
        }
        String string = SyncBundle.message("maven.sync.wrapper", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.startTask(this.mySyncId, string);
    }

    public final synchronized void finishWrapperResolving(@Nullable Throwable e) {
        if (e != null) {
            this.addBuildIssue(new BuildIssue(e){
                @NotNull
                private final String title;
                @NotNull
                private final String description;
                @NotNull
                private final List<BuildIssueQuickFix> quickFixes;
                {
                    String string = SyncBundle.message("maven.sync.wrapper.failure", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    this.title = string;
                    Object[] objectArray = new Object[]{$e.getLocalizedMessage(), "open_maven_settings_quick_fix"};
                    String string2 = SyncBundle.message("maven.sync.wrapper.failure.description", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                    this.description = string2;
                    this.quickFixes = CollectionsKt.listOf((Object)new OpenMavenSettingsQuickFix());
                }

                @NotNull
                public String getTitle() {
                    return this.title;
                }

                @NotNull
                public String getDescription() {
                    return this.description;
                }

                @NotNull
                public List<BuildIssueQuickFix> getQuickFixes() {
                    return this.quickFixes;
                }

                @Nullable
                public Navigatable getNavigatable(@NotNull Project project2) {
                    Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                    return null;
                }
            }, MessageEvent.Kind.WARNING);
        }
        String string = SyncBundle.message("maven.sync.wrapper", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.completeTask(this.mySyncId, string, (EventResult)new SuccessResultImpl());
    }

    public static /* synthetic */ void finishWrapperResolving$default(MavenSyncConsole mavenSyncConsole, Throwable throwable, int n, Object object) {
        if ((n & 1) != 0) {
            throwable = null;
        }
        mavenSyncConsole.finishWrapperResolving(throwable);
    }

    public final synchronized void notifyReadingProblems(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            org.jetbrains.idea.maven.buildtool.MavenSyncConsole$Companion.debugLog$default(Companion, "reading problems in " + file, null, 2, null);
            this.hasErrors = true;
            Object[] objectArray = new Object[]{file.getPath()};
            String desc = SyncBundle.message("maven.sync.failure.error.reading.file", objectArray);
            this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new FileMessageEventImpl((Object)this.mySyncId, MessageEvent.Kind.ERROR, SyncBundle.message("maven.sync.group.error", new Object[0]), desc, desc, new FilePosition(new File(file.getPath()), -1, -1)));
        }
    }

    public final synchronized void showProblem(@NotNull MavenProjectProblem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            String string;
            String message;
            boolean bl = false;
            this.hasErrors = true;
            String group = SyncBundle.message("maven.sync.group.error", new Object[0]);
            FilePosition position = this.getFilePosition(problem);
            String string2 = problem.getDescription();
            if (string2 == null) {
                string2 = message = SyncBundle.message("maven.sync.failure.error.undefined.message", new Object[0]);
            }
            if ((string = problem.getDescription()) == null) {
                Object[] objectArray = new Object[]{problem.getPath()};
                string = SyncBundle.message("maven.sync.failure.error.undefined.detailed.message", objectArray);
            }
            String detailedMessage = string;
            FileMessageEventImpl eventImpl = new FileMessageEventImpl((Object)this.mySyncId, MessageEvent.Kind.ERROR, group, message, detailedMessage, position);
            this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)eventImpl);
        }
    }

    private final FilePosition getFilePosition(MavenProjectProblem $this$getFilePosition) {
        Pair pair = this.getPositionFromDescription($this$getFilePosition);
        if (pair == null && (pair = this.getPositionFromPath($this$getFilePosition)) == null) {
            pair = TuplesKt.to((Object)-1, (Object)-1);
        }
        Pair pair2 = pair;
        int line = ((Number)pair2.component1()).intValue();
        int column2 = ((Number)pair2.component2()).intValue();
        String string = $this$getFilePosition.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String pathWithoutPosition = StringsKt.substringBeforeLast$default((String)string, (String)(":" + (line + 1) + ":" + column2), null, (int)2, null);
        return new FilePosition(new File(pathWithoutPosition), line, column2);
    }

    private final Pair<Integer, Integer> getPositionFromDescription(MavenProjectProblem $this$getPositionFromDescription) {
        return this.getPosition($this$getPositionFromDescription, $this$getPositionFromDescription.getDescription(), new Regex("@(\\d+):(\\d+)"));
    }

    private final Pair<Integer, Integer> getPositionFromPath(MavenProjectProblem $this$getPositionFromPath) {
        return this.getPosition($this$getPositionFromPath, $this$getPositionFromPath.getPath(), new Regex(":(\\d+):(\\d+)"));
    }

    private final Pair<Integer, Integer> getPosition(MavenProjectProblem $this$getPosition, String source, Regex pattern) {
        if (source == null) {
            return null;
        }
        if ($this$getPosition.getType() == MavenProjectProblem.ProblemType.STRUCTURE) {
            Sequence matchResults = Regex.findAll$default((Regex)pattern, (CharSequence)source, (int)0, (int)2, null);
            MatchResult matchResult = (MatchResult)SequencesKt.lastOrNull((Sequence)matchResults);
            if (matchResult == null) {
                return null;
            }
            MatchResult matchResult2 = matchResult;
            List list = matchResult2.getGroupValues();
            String line = (String)list.get(1);
            String offset = (String)list.get(2);
            return TuplesKt.to((Object)(Integer.parseInt(line) - 1), (Object)Integer.parseInt(offset));
        }
        return null;
    }

    @ApiStatus.Internal
    public final synchronized void addException(@NotNull Throwable e, @NotNull BuildProgressListener progressListener) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)progressListener, (String)"progressListener");
        if (this.started && !this.finished) {
            MavenLog.LOG.warn(e);
            this.hasErrors = true;
            BuildIssueException buildIssueException = (BuildIssueException)ExceptionUtil.findCause((Throwable)e, BuildIssueException.class);
            if (buildIssueException != null) {
                BuildIssue buildIssue = buildIssueException.getBuildIssue();
                Intrinsics.checkNotNullExpressionValue((Object)buildIssue, (String)"<get-buildIssue>(...)");
                this.addBuildIssue(buildIssue, MessageEvent.Kind.ERROR);
            } else {
                this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)MessageEventUtilsKt.createMessageEvent(this.myProject, this.mySyncId, e));
            }
        } else {
            MavenImportSpec mavenImportSpec = MavenImportSpec.EXPLICIT_IMPORT;
            Intrinsics.checkNotNullExpressionValue((Object)mavenImportSpec, (String)"EXPLICIT_IMPORT");
            this.startImport(progressListener, mavenImportSpec);
            this.addException(e, progressListener);
            this.finishImport();
        }
    }

    @NotNull
    public final ArtifactSyncListener getListener(@NotNull MavenServerConsoleIndicator.ResolveType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1 -> new ArtifactSyncListenerImpl("maven.sync.plugins");
            case 2 -> new ArtifactSyncListenerImpl("maven.sync.dependencies");
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final synchronized void doFinish() {
        if (this.syncTransactionStarted) {
            org.jetbrains.idea.maven.buildtool.MavenSyncConsole$Companion.debugLog$default(Companion, "Maven sync: sync transaction is still not finished, postpone build finish event", null, 2, null);
            return;
        }
        List tasks = CollectionsKt.asReversed((List)CollectionsKt.toList((Iterable)this.myStartedSet));
        org.jetbrains.idea.maven.buildtool.MavenSyncConsole$Companion.debugLog$default(Companion, "Tasks " + tasks + " are not completed! Force complete", null, 2, null);
        Iterable $this$forEach$iv = tasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            this.completeTask(it.getFirst(), (String)it.getSecond(), (EventResult)new DerivedResultImpl());
        }
        this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new FinishBuildEventImpl((Object)this.mySyncId, null, System.currentTimeMillis(), "", this.hasErrors ? (EventResult)new FailureResultImpl() : (EventResult)new DerivedResultImpl()));
        this.attachOfflineQuickFix();
        this.finished = true;
        this.started = false;
    }

    private final void attachOfflineQuickFix() {
        try {
            MavenGeneralSettings generalSettings = MavenWorkspaceSettingsComponent.getInstance(this.myProject).getSettings().getGeneralSettings();
            if (this.hasUnresolved && generalSettings.isWorkOffline()) {
                this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new BuildIssueEventImpl((Object)this.mySyncId, new BuildIssue(){
                    @NotNull
                    private final String title;
                    @NotNull
                    private final String description;
                    @NotNull
                    private final List<BuildIssueQuickFix> quickFixes;
                    {
                        this.title = "Dependency Resolution Failed";
                        this.description = "<a href=\"off_maven_offline_mode_quick_fix\">Switch Off Offline Mode</a>\n";
                        this.quickFixes = CollectionsKt.listOf((Object)new OffMavenOfflineModeQuickFix());
                    }

                    @NotNull
                    public String getTitle() {
                        return this.title;
                    }

                    @NotNull
                    public String getDescription() {
                        return this.description;
                    }

                    @NotNull
                    public List<BuildIssueQuickFix> getQuickFixes() {
                        return this.quickFixes;
                    }

                    @Nullable
                    public Navigatable getNavigatable(@NotNull Project project2) {
                        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                        return null;
                    }
                }, MessageEvent.Kind.ERROR));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final synchronized void showError(String keyPrefix, String dependency) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            this.hasErrors = true;
            this.hasUnresolved = true;
            String umbrellaString = SyncBundle.message(keyPrefix + ".resolve", new Object[0]);
            Object[] objectArray = new Object[]{dependency};
            String errorString = SyncBundle.message(keyPrefix + ".resolve.error", objectArray);
            Intrinsics.checkNotNull((Object)umbrellaString);
            this.startTask(this.mySyncId, umbrellaString);
            this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new MessageEventImpl((Object)umbrellaString, MessageEvent.Kind.ERROR, SyncBundle.message("maven.sync.group.error", new Object[0]), errorString, errorString));
            Intrinsics.checkNotNull((Object)errorString);
            this.addText(this.mySyncId, errorString, false);
        }
    }

    private final synchronized void showBuildIssue(String keyPrefix, String dependency, String errorMessage) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            this.hasErrors = true;
            this.hasUnresolved = true;
            String umbrellaString = SyncBundle.message(keyPrefix + ".resolve", new Object[0]);
            Object[] objectArray = new Object[]{dependency};
            String errorString = SyncBundle.message(keyPrefix + ".resolve.error", objectArray);
            Intrinsics.checkNotNull((Object)umbrellaString);
            this.startTask(this.mySyncId, umbrellaString);
            Intrinsics.checkNotNull((Object)errorString);
            String string = errorMessage;
            if (string == null) {
                string = errorString;
            }
            BuildIssue buildIssue = DownloadArtifactBuildIssue.INSTANCE.getIssue(errorString, string);
            this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new BuildIssueEventImpl((Object)umbrellaString, buildIssue, MessageEvent.Kind.ERROR));
            this.addText(this.mySyncId, errorString, false);
        }
    }

    private final synchronized void showBuildIssueNode(String key, BuildIssue buildIssue) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            this.hasErrors = true;
            this.hasUnresolved = true;
            this.startTask(this.mySyncId, key);
            this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new BuildIssueEventImpl((Object)key, buildIssue, MessageEvent.Kind.ERROR));
        }
    }

    private final synchronized void startTask(Object parentId2, @NlsSafe String taskName) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            org.jetbrains.idea.maven.buildtool.MavenSyncConsole$Companion.debugLog$default(Companion, "Maven sync: start " + taskName, null, 2, null);
            if (this.myStartedSet.add((Pair<Object, String>)TuplesKt.to((Object)parentId2, (Object)taskName))) {
                this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new StartEventImpl((Object)taskName, parentId2, System.currentTimeMillis(), taskName));
            }
        }
    }

    private final synchronized void completeTask(Object parentId2, @NlsSafe String taskName, EventResult result2) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            this.hasErrors = this.hasErrors || result2 instanceof FailureResultImpl;
            org.jetbrains.idea.maven.buildtool.MavenSyncConsole$Companion.debugLog$default(Companion, "Maven sync: complete " + taskName + " with " + result2, null, 2, null);
            if (this.myStartedSet.remove(TuplesKt.to((Object)parentId2, (Object)taskName))) {
                this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new FinishEventImpl((Object)taskName, parentId2, System.currentTimeMillis(), taskName, result2));
            }
        }
    }

    private final synchronized void completeUmbrellaEvents(String keyPrefix) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            String taskName = SyncBundle.message(keyPrefix + ".resolve", new Object[0]);
            Intrinsics.checkNotNull((Object)taskName);
            this.completeTask(this.mySyncId, taskName, (EventResult)new DerivedResultImpl());
        }
    }

    private final synchronized void downloadEventStarted(String keyPrefix, String dependency) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            String downloadString = SyncBundle.message(keyPrefix + ".download", new Object[0]);
            Object[] objectArray = new Object[]{dependency};
            String downloadArtifactString = SyncBundle.message(keyPrefix + ".artifact.download", objectArray);
            Intrinsics.checkNotNull((Object)downloadString);
            this.startTask(this.mySyncId, downloadString);
            Intrinsics.checkNotNull((Object)downloadArtifactString);
            this.startTask(downloadString, downloadArtifactString);
        }
    }

    private final synchronized void downloadEventCompleted(String keyPrefix, String dependency) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            String downloadString = SyncBundle.message(keyPrefix + ".download", new Object[0]);
            Object[] objectArray = new Object[]{dependency};
            String downloadArtifactString = SyncBundle.message(keyPrefix + ".artifact.download", objectArray);
            Intrinsics.checkNotNull((Object)downloadArtifactString);
            this.addText(downloadArtifactString, downloadArtifactString, true);
            Intrinsics.checkNotNull((Object)downloadString);
            this.completeTask(downloadString, downloadArtifactString, (EventResult)new SuccessResultImpl(false));
        }
    }

    private final synchronized void downloadEventFailed(String keyPrefix, @NlsSafe String dependency, @NlsSafe String error, @NlsSafe String stackTrace) {
        MavenSyncConsole this_$iv = this;
        boolean $i$f$doIfImportInProcess = false;
        if (this_$iv.started && !this_$iv.finished) {
            boolean bl = false;
            String downloadString = SyncBundle.message(keyPrefix + ".download", new Object[0]);
            Object[] objectArray = new Object[]{dependency};
            String downloadArtifactString = SyncBundle.message(keyPrefix + ".artifact.download", objectArray);
            if (this.isJavadocOrSource(dependency)) {
                Intrinsics.checkNotNull((Object)downloadArtifactString);
                Object[] objectArray2 = new Object[]{dependency};
                String string = SyncBundle.message("maven.sync.failure.dependency.not.found", objectArray2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this.addText(downloadArtifactString, string, true);
                Intrinsics.checkNotNull((Object)downloadString);
                this.completeTask(downloadString, downloadArtifactString, (EventResult)new MessageEventResult(dependency){
                    final /* synthetic */ String $dependency;
                    {
                        this.$dependency = $dependency;
                    }

                    @NotNull
                    public MessageEvent.Kind getKind() {
                        return MessageEvent.Kind.WARNING;
                    }

                    @Nullable
                    public String getDetails() {
                        Object[] objectArray = new Object[]{this.$dependency};
                        return SyncBundle.message("maven.sync.failure.dependency.not.found", objectArray);
                    }
                });
            } else {
                if (stackTrace != null && Registry.is((String)"maven.spy.events.debug")) {
                    Intrinsics.checkNotNull((Object)downloadArtifactString);
                    this.addText(downloadArtifactString, stackTrace, false);
                } else {
                    Intrinsics.checkNotNull((Object)downloadArtifactString);
                    this.addText(downloadArtifactString, error, true);
                }
                Intrinsics.checkNotNull((Object)downloadString);
                this.completeTask(downloadString, downloadArtifactString, (EventResult)new FailureResultImpl(error));
            }
        }
    }

    public final synchronized void showQuickFixBadMaven(@NotNull String message, @NotNull MessageEvent.Kind kind) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        String bundledVersion = MavenDistributionsCache.resolveEmbeddedMavenHome().getVersion();
        this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new BuildIssueEventImpl((Object)this.mySyncId, new BuildIssue(message, bundledVersion){
            private final String title;
            @NotNull
            private final String description;
            @NotNull
            private final List<BuildIssueQuickFix> quickFixes;
            {
                this.title = SyncBundle.message("maven.sync.version.issue.title", new Object[0]);
                Object[] objectArray = new Object[]{$bundledVersion};
                this.description = $message + "\n- <a href=\"open_maven_settings_quick_fix\">" + SyncBundle.message("maven.sync.version.open.settings", new Object[0]) + "</a>\n- <a href=\"use_bundled_maven_quick_fix\">" + SyncBundle.message("maven.sync.version.use.bundled", objectArray) + "</a>\n";
                objectArray = new BuildIssueQuickFix[]{new OpenMavenSettingsQuickFix(), new UseBundledMavenQuickFix()};
                this.quickFixes = CollectionsKt.listOf((Object[])objectArray);
            }

            public String getTitle() {
                return this.title;
            }

            @NotNull
            public String getDescription() {
                return this.description;
            }

            @NotNull
            public List<BuildIssueQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            @Nullable
            public Navigatable getNavigatable(@NotNull Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                return null;
            }
        }, kind));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final <Result> Object runTask(@NlsSafe @NotNull String var1_1, @NotNull Function1<? super Continuation<? super Result>, ? extends Object> var2_2, @NotNull Continuation<? super Result> var3_3) {
        if (!(var3_3 instanceof runTask.1)) ** GOTO lbl-1000
        var9_4 = var3_3;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ MavenSyncConsole this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.runTask(null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.startTask(this.mySyncId, taskName);
                startTime = System.currentTimeMillis();
                $continuation.L$0 = this;
                $continuation.L$1 = taskName;
                $continuation.J$0 = startTime;
                $continuation.label = 1;
                v0 = task.invoke($continuation);
                ** if (v0 != var10_6) goto lbl23
lbl22:
                // 1 sources

                return var10_6;
lbl23:
                // 1 sources

                ** GOTO lbl32
            }
            case 1: {
                startTime = $continuation.J$0;
                taskName = (String)$continuation.L$1;
                this = (MavenSyncConsole)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl32:
                    // 2 sources

                    var6_8 = v0;
                    $i$a$-also-MavenSyncConsole$runTask$2 = false;
                    this.completeTask(this.mySyncId, taskName, (EventResult)new SuccessResultImpl());
                    return var6_8;
                }
                catch (Exception e) {
                    MavenProjectsManager.getInstance(this.myProject).showServerException(e);
                    throw e;
                }
            }
            catch (Throwable var6_10) {
                throw var6_10;
            }
            {
                finally {
                    MavenLog.LOG.info("[maven import] " + taskName + " took " + (System.currentTimeMillis() - startTime) + "ms");
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <Result> Result runTaskSync(@NlsSafe @NotNull String taskName, @NotNull Function0<? extends Result> task) {
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        Intrinsics.checkNotNullParameter(task, (String)"task");
        this.startTask(this.mySyncId, taskName);
        long startTime = System.currentTimeMillis();
        try {
            Object object;
            Object it = object = task.invoke();
            boolean bl = false;
            this.completeTask(this.mySyncId, taskName, (EventResult)new SuccessResultImpl());
            return (Result)object;
        }
        catch (Exception e) {
            MavenProjectsManager.getInstance(this.myProject).showServerException(e);
            throw e;
        }
        finally {
            MavenLog.LOG.info("[maven import] " + taskName + " took " + (System.currentTimeMillis() - startTime) + "ms");
        }
    }

    public final synchronized void showQuickFixJDK(@NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        this.mySyncView.onEvent((Object)this.mySyncId, (BuildEvent)new BuildIssueEventImpl((Object)this.mySyncId, new BuildIssue(version2){
            private final String title;
            @NotNull
            private final String description;
            @NotNull
            private final List<BuildIssueQuickFix> quickFixes;
            {
                this.title = SyncBundle.message("maven.sync.quickfixes.maven.jdk.version.title", new Object[0]);
                Object[] objectArray = new Object[]{$version};
                this.description = SyncBundle.message("maven.sync.quickfixes.upgrade.to.jdk7", objectArray) + "\n- <a href=\"open_maven_settings_quick_fix\">" + SyncBundle.message("maven.sync.quickfixes.open.settings", new Object[0]) + "</a>\n";
                this.quickFixes = CollectionsKt.listOf((Object)new OpenMavenSettingsQuickFix());
            }

            public String getTitle() {
                return this.title;
            }

            @NotNull
            public String getDescription() {
                return this.description;
            }

            @NotNull
            public List<BuildIssueQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            @Nullable
            public Navigatable getNavigatable(@NotNull Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                return null;
            }
        }, MessageEvent.Kind.ERROR));
    }

    private final boolean isJavadocOrSource(String dependency) {
        char[] cArray = new char[]{':'};
        List split = StringsKt.split$default((CharSequence)dependency, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        if (split.size() < 4) {
            return false;
        }
        String classifier = (String)split.get(2);
        return this.JAVADOC_AND_SOURCE_CLASSIFIERS.contains(classifier);
    }

    private final void doIfImportInProcess(Function0<Unit> action) {
        boolean $i$f$doIfImportInProcess = false;
        if (!this.started || this.finished) {
            return;
        }
        action.invoke();
    }

    private final void doIfImportInProcessOrPostpone(Function0<Unit> action) {
        if (!this.started || this.finished) {
            this.myPostponed.add(action);
        } else {
            action.invoke();
        }
    }

    public final synchronized void handleDownloadEvents(@NotNull List<? extends MavenArtifactEvent> downloadEvents) {
        Intrinsics.checkNotNullParameter(downloadEvents, (String)"downloadEvents");
        for (MavenArtifactEvent mavenArtifactEvent : downloadEvents) {
            MavenServerConsoleIndicator.ResolveType resolveType = mavenArtifactEvent.getResolveType();
            Intrinsics.checkNotNullExpressionValue((Object)resolveType, (String)"getResolveType(...)");
            ArtifactSyncListener listener2 = this.getListener(resolveType);
            String id = mavenArtifactEvent.getDependencyId();
            switch (WhenMappings.$EnumSwitchMapping$1[mavenArtifactEvent.getArtifactEventType().ordinal()]) {
                case 1: {
                    Intrinsics.checkNotNull((Object)id);
                    listener2.downloadStarted(id);
                    break;
                }
                case 2: {
                    Intrinsics.checkNotNull((Object)id);
                    listener2.downloadCompleted(id);
                    break;
                }
                case 3: {
                    Intrinsics.checkNotNull((Object)id);
                    String string = mavenArtifactEvent.getErrorMessage();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getErrorMessage(...)");
                    listener2.downloadFailed(id, string, mavenArtifactEvent.getStackTrace());
                }
            }
        }
    }

    private static final void mySyncView$lambda$0(Object object, BuildEvent buildEvent) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)buildEvent, (String)"<anonymous parameter 1>");
    }

    @JvmStatic
    @ApiStatus.Experimental
    public static final void startTransaction(@NotNull Project project2) {
        Companion.startTransaction(project2);
    }

    @JvmStatic
    @ApiStatus.Experimental
    public static final void finishTransaction(@NotNull Project project2) {
        Companion.finishTransaction(project2);
    }

    public static final /* synthetic */ boolean access$getStarted$p(MavenSyncConsole $this) {
        return $this.started;
    }

    public static final /* synthetic */ boolean access$getFinished$p(MavenSyncConsole $this) {
        return $this.finished;
    }

    public static final /* synthetic */ boolean access$newIssue(MavenSyncConsole $this, String s) {
        return $this.newIssue(s);
    }

    public static final /* synthetic */ BuildProgressListener access$getMySyncView$p(MavenSyncConsole $this) {
        return $this.mySyncView;
    }

    public static final /* synthetic */ ExternalSystemTaskId access$getMySyncId$p(MavenSyncConsole $this) {
        return $this.mySyncId;
    }

    public static final /* synthetic */ void access$setHasErrors$p(MavenSyncConsole $this, boolean bl) {
        $this.hasErrors = bl;
    }

    public static final /* synthetic */ boolean access$getHasErrors$p(MavenSyncConsole $this) {
        return $this.hasErrors;
    }

    static {
        EXIT_CODE_SIGTERM = 143;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\"\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016J\u001a\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsole$ArtifactSyncListenerImpl;", "Lorg/jetbrains/idea/maven/buildtool/ArtifactSyncListener;", "keyPrefix", "", "(Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsole;Ljava/lang/String;)V", "getKeyPrefix", "()Ljava/lang/String;", "downloadCompleted", "", "dependency", "downloadFailed", "error", "stackTrace", "downloadStarted", "finish", "showArtifactBuildIssue", "errorMessage", "showBuildIssue", "buildIssue", "Lcom/intellij/build/issue/BuildIssue;", "showError", "intellij.maven"})
    private final class ArtifactSyncListenerImpl
    implements ArtifactSyncListener {
        @NotNull
        private final String keyPrefix;

        public ArtifactSyncListenerImpl(String keyPrefix) {
            Intrinsics.checkNotNullParameter((Object)keyPrefix, (String)"keyPrefix");
            this.keyPrefix = keyPrefix;
        }

        @NotNull
        public final String getKeyPrefix() {
            return this.keyPrefix;
        }

        @Override
        public void downloadStarted(@NotNull String dependency) {
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            MavenSyncConsole.this.downloadEventStarted(this.keyPrefix, dependency);
        }

        @Override
        public void downloadCompleted(@NotNull String dependency) {
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            MavenSyncConsole.this.downloadEventCompleted(this.keyPrefix, dependency);
        }

        @Override
        public void downloadFailed(@NotNull String dependency, @NotNull String error, @Nullable String stackTrace) {
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            MavenSyncConsole.this.downloadEventFailed(this.keyPrefix, dependency, error, stackTrace);
        }

        @Override
        public void finish() {
            MavenSyncConsole.this.completeUmbrellaEvents(this.keyPrefix);
        }

        @Override
        public void showError(@NotNull String dependency) {
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            MavenSyncConsole.this.showError(this.keyPrefix, dependency);
        }

        @Override
        public void showArtifactBuildIssue(@NotNull String dependency, @Nullable String errorMessage) {
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            MavenSyncConsole.this.showBuildIssue(this.keyPrefix, dependency, errorMessage);
        }

        @Override
        public void showBuildIssue(@NotNull String dependency, @NotNull BuildIssue buildIssue) {
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            Intrinsics.checkNotNullParameter((Object)buildIssue, (String)"buildIssue");
            MavenSyncConsole.this.showBuildIssueNode(this.keyPrefix, buildIssue);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/idea/maven/buildtool/MavenSyncConsole$Companion;", "", "()V", "EXIT_CODE_OK", "", "getEXIT_CODE_OK", "()I", "EXIT_CODE_SIGTERM", "getEXIT_CODE_SIGTERM", "debugLog", "", "s", "", "exception", "", "finishTransaction", "project", "Lcom/intellij/openapi/project/Project;", "startTransaction", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        public final int getEXIT_CODE_OK() {
            return EXIT_CODE_OK;
        }

        public final int getEXIT_CODE_SIGTERM() {
            return EXIT_CODE_SIGTERM;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @ApiStatus.Experimental
        public final void startTransaction(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            MavenSyncConsole syncConsole = MavenProjectsManager.getInstance(project2).getSyncConsole();
            Intrinsics.checkNotNull((Object)syncConsole);
            MavenSyncConsole mavenSyncConsole = syncConsole;
            synchronized (mavenSyncConsole) {
                boolean bl = false;
                syncConsole.syncTransactionStarted = true;
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @ApiStatus.Experimental
        public final void finishTransaction(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            MavenSyncConsole syncConsole = MavenProjectsManager.getInstance(project2).getSyncConsole();
            Intrinsics.checkNotNull((Object)syncConsole);
            MavenSyncConsole mavenSyncConsole = syncConsole;
            synchronized (mavenSyncConsole) {
                boolean bl = false;
                syncConsole.syncTransactionStarted = false;
                syncConsole.finishImport();
                Unit unit = Unit.INSTANCE;
            }
        }

        private final void debugLog(String s, Throwable exception) {
            MavenLog.LOG.debug(s, exception);
        }

        static /* synthetic */ void debugLog$default(Companion companion, String string, Throwable throwable, int n, Object object) {
            if ((n & 2) != 0) {
                throwable = null;
            }
            companion.debugLog(string, throwable);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[MavenServerConsoleIndicator.ResolveType.values().length];
            try {
                nArray[MavenServerConsoleIndicator.ResolveType.PLUGIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MavenServerConsoleIndicator.ResolveType.DEPENDENCY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[MavenArtifactEvent.ArtifactEventType.values().length];
            try {
                nArray[MavenArtifactEvent.ArtifactEventType.DOWNLOAD_STARTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MavenArtifactEvent.ArtifactEventType.DOWNLOAD_COMPLETED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MavenArtifactEvent.ArtifactEventType.DOWNLOAD_FAILED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

