/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.indices.IndicesContentUpdateRequest;
import org.jetbrains.idea.maven.indices.MavenArchetypeManager;
import org.jetbrains.idea.maven.indices.MavenGAVIndex;
import org.jetbrains.idea.maven.indices.MavenIndex;
import org.jetbrains.idea.maven.indices.MavenIndexHolder;
import org.jetbrains.idea.maven.indices.MavenIndexImpl;
import org.jetbrains.idea.maven.indices.MavenIndexUpdateManager;
import org.jetbrains.idea.maven.indices.MavenIndices;
import org.jetbrains.idea.maven.indices.MavenRepositoryProvider;
import org.jetbrains.idea.maven.indices.MavenSearchIndex;
import org.jetbrains.idea.maven.indices.MavenSystemIndicesManager;
import org.jetbrains.idea.maven.indices.MavenUpdatableIndex;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.server.AddArtifactResponse;
import org.jetbrains.idea.maven.server.MavenServerConnector;
import org.jetbrains.idea.maven.server.MavenServerDownloadListener;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.reposearch.DependencySearchService;

public final class MavenIndicesManager
implements Disposable {
    @Topic.AppLevel
    public static final Topic<MavenIndexerListener> INDEXER_TOPIC = new Topic(MavenIndexerListener.class.getSimpleName(), MavenIndexerListener.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final MavenIndices myMavenIndices;
    private final MavenIndexServerDownloadListener myDownloadListener;
    private final IndexFixer myIndexFixer;
    private final MavenIndexUpdateManager myIndexUpdateManager;

    public static MavenIndicesManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            MavenIndicesManager.$$$reportNull$$$0(0);
        }
        return (MavenIndicesManager)project2.getService(MavenIndicesManager.class);
    }

    public MavenIndicesManager(@NotNull Project project2) {
        if (project2 == null) {
            MavenIndicesManager.$$$reportNull$$$0(1);
        }
        this.myDownloadListener = new MavenIndexServerDownloadListener(this);
        this.myIndexFixer = new IndexFixer();
        this.myProject = project2;
        this.myIndexUpdateManager = new MavenIndexUpdateManager();
        this.myMavenIndices = MavenSystemIndicesManager.getInstance().getOrCreateIndices(project2);
        this.initListeners();
        Disposer.register((Disposable)this, (Disposable)this.myIndexUpdateManager);
    }

    public void dispose() {
        this.myIndexFixer.stop();
        this.deleteIndicesDirInUnitTests();
    }

    private void deleteIndicesDirInUnitTests() {
        if (MavenUtil.isMavenUnitTestModeEnabled()) {
            MavenIndex localIndex;
            if (!this.myMavenIndices.isDisposed() && (localIndex = this.myMavenIndices.getIndexHolder().getLocalIndex()) instanceof MavenIndexImpl) {
                MavenIndexImpl impl = (MavenIndexImpl)localIndex;
                impl.closeAndClean();
            }
            Path dir2 = MavenSystemIndicesManager.getInstance().getIndicesDir();
            try {
                PathKt.delete((Path)dir2);
            }
            catch (Exception e) {
                try {
                    Stream<Path> stream = Files.walk(dir2, new FileVisitOption[0]);
                    try {
                        List<String> files2 = stream.map(Path::toString).toList();
                        String message = files2.isEmpty() ? "Failed to delete the index directory" : "Failed to delete files in the index directory: " + String.join((CharSequence)", ", files2);
                        throw new RuntimeException(message, e);
                    }
                    catch (Throwable throwable) {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    @NotNull
    public MavenIndexHolder getIndex() {
        if (this.myMavenIndices.isNotInit() && !ApplicationManager.getApplication().isUnitTestMode()) {
            this.myIndexUpdateManager.scheduleUpdateIndicesList(this.myProject, null);
        }
        MavenIndexHolder mavenIndexHolder = this.myMavenIndices.getIndexHolder();
        if (mavenIndexHolder == null) {
            MavenIndicesManager.$$$reportNull$$$0(2);
        }
        return mavenIndexHolder;
    }

    void updateIndicesListSync() {
        this.myMavenIndices.updateRepositoriesList();
    }

    public boolean isInit() {
        return this.myMavenIndices.isIndicesInit();
    }

    private void initListeners() {
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(MavenServerConnector.DOWNLOAD_LISTENER_TOPIC, (Object)this.myDownloadListener);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(MavenIndex.INDEX_IS_BROKEN, (Object)new MavenSearchIndexListener(this));
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            MavenProjectsManager.getInstance(this.myProject).addProjectsTreeListener(new MavenProjectsTree.Listener(){

                @Override
                public void projectsUpdated(@NotNull List<Pair<MavenProject, MavenProjectChanges>> updated, @NotNull List<MavenProject> deleted) {
                    if (updated == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (deleted == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    DependencySearchService.getInstance((Project)MavenIndicesManager.this.myProject).clearCache();
                }

                @Override
                public void projectResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges, @Nullable NativeMavenProjectHolder nativeMavenProject) {
                    if (projectWithChanges == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    DependencySearchService.getInstance((Project)MavenIndicesManager.this.myProject).clearCache();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "updated";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "deleted";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "projectWithChanges";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/idea/maven/indices/MavenIndicesManager$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "projectsUpdated";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "projectResolved";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, this);
            return;
        }
        MavenRepositoryProvider.EP_NAME.addChangeListener(() -> this.scheduleUpdateIndicesList(null), (Disposable)this);
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(this.myProject);
        projectsManager.addProjectsTreeListener(new MavenProjectsTree.Listener(){

            @Override
            public void projectResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges, @Nullable NativeMavenProjectHolder nativeMavenProject) {
                if (projectWithChanges == null) {
                    2.$$$reportNull$$$0(0);
                }
                MavenIndicesManager.this.scheduleUpdateIndicesList(null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectWithChanges", "org/jetbrains/idea/maven/indices/MavenIndicesManager$2", "projectResolved"));
            }
        }, this);
    }

    public static void addArchetype(@NotNull MavenArchetype archetype) {
        if (archetype == null) {
            MavenIndicesManager.$$$reportNull$$$0(3);
        }
        MavenArchetypeManager.addArchetype(archetype, MavenIndicesManager.getUserArchetypesFile());
    }

    public boolean hasLocalGroupId(@NotNull String groupId) {
        MavenIndex localIndex;
        if (groupId == null) {
            MavenIndicesManager.$$$reportNull$$$0(4);
        }
        return (localIndex = this.getIndex().getLocalIndex()) != null && localIndex.hasGroupId(groupId);
    }

    public boolean hasLocalArtifactId(@Nullable String groupId, @Nullable String artifactId) {
        MavenIndex localIndex = this.getIndex().getLocalIndex();
        return localIndex != null && localIndex.hasArtifactId(groupId, artifactId);
    }

    public boolean hasLocalVersion(@Nullable String groupId, @Nullable String artifactId, @Nullable String version2) {
        MavenIndex localIndex = this.getIndex().getLocalIndex();
        return localIndex != null && localIndex.hasVersion(groupId, artifactId, version2);
    }

    public boolean scheduleArtifactIndexing(@Nullable MavenId mavenId2, @NotNull File artifactFile) {
        if (artifactFile == null) {
            MavenIndicesManager.$$$reportNull$$$0(5);
        }
        if (this.myMavenIndices.isNotInit()) {
            return false;
        }
        try {
            MavenIndex localIndex = this.myMavenIndices.getIndexHolder().getLocalIndex();
            if (localIndex == null) {
                return false;
            }
            if (mavenId2 != null) {
                if (mavenId2.getGroupId() == null || mavenId2.getArtifactId() == null || mavenId2.getVersion() == null) {
                    return false;
                }
                if (localIndex.hasVersion(mavenId2.getGroupId(), mavenId2.getArtifactId(), mavenId2.getVersion())) {
                    return false;
                }
            }
            AppExecutorUtil.getAppExecutorService().execute(() -> this.myIndexFixer.fixIndex(artifactFile));
        }
        catch (AlreadyDisposedException ignore) {
            return false;
        }
        return true;
    }

    public void scheduleUpdateContentAll() {
        this.myIndexUpdateManager.scheduleUpdateContent(this.myProject, IndicesContentUpdateRequest.explicit(ContainerUtil.map(this.myMavenIndices.getIndices(), MavenGAVIndex::getRepository)));
    }

    public CompletableFuture<?> scheduleUpdateContent(@NotNull List<MavenIndex> indices, boolean explicit) {
        if (indices == null) {
            MavenIndicesManager.$$$reportNull$$$0(6);
        }
        IndicesContentUpdateRequest request = new IndicesContentUpdateRequest(ContainerUtil.map(indices, MavenGAVIndex::getRepository), explicit, true, explicit);
        return this.myIndexUpdateManager.scheduleUpdateContent(this.myProject, request);
    }

    public void scheduleUpdateIndicesList(@Nullable Consumer<? super List<MavenIndex>> consumer) {
        this.myIndexUpdateManager.scheduleUpdateIndicesList(this.myProject, consumer);
    }

    @NotNull
    private static Path getUserArchetypesFile() {
        Path path2 = MavenSystemIndicesManager.getInstance().getIndicesDir().resolve("UserArchetypes.xml");
        if (path2 == null) {
            MavenIndicesManager.$$$reportNull$$$0(7);
        }
        return path2;
    }

    @TestOnly
    public void waitForBackgroundTasksInTests() {
        this.myIndexUpdateManager.waitForBackgroundTasksInTests();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/indices/MavenIndicesManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archetype";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/indices/MavenIndicesManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndex";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserArchetypesFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addArchetype";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasLocalGroupId";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "scheduleArtifactIndexing";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "scheduleUpdateContent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7 -> new IllegalStateException(string);
        };
    }

    private static class MavenIndexServerDownloadListener
    implements MavenServerDownloadListener {
        private final MavenIndicesManager myManager;

        private MavenIndexServerDownloadListener(MavenIndicesManager manager) {
            this.myManager = manager;
        }

        public void artifactDownloaded(File file, String relativePath) {
            this.myManager.scheduleArtifactIndexing(null, file);
        }
    }

    private final class IndexFixer {
        private final ConcurrentLinkedQueue<File> queueToAdd = new ConcurrentLinkedQueue();
        private final MergingUpdateQueue myMergingUpdateQueue;
        private final AddToIndexRunnable taskConsumer = new AddToIndexRunnable();
        private final AtomicBoolean stopped = new AtomicBoolean(false);

        private IndexFixer() {
            this.myMergingUpdateQueue = new MergingUpdateQueue(this.getClass().getName(), 1000, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)MavenIndicesManager.this, null, false).usePassThroughInUnitTestMode();
        }

        public void fixIndex(@NotNull File file) {
            if (file == null) {
                IndexFixer.$$$reportNull$$$0(0);
            }
            if (this.stopped.get()) {
                return;
            }
            this.queueToAdd.add(file);
            this.myMergingUpdateQueue.queue(new Update(this){

                public void run() {
                    IndexFixer.this.taskConsumer.run();
                }

                public boolean isDisposed() {
                    return MavenIndicesManager.this.myMavenIndices.isDisposed();
                }
            });
        }

        public void stop() {
            this.stopped.set(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/maven/indices/MavenIndicesManager$IndexFixer", "fixIndex"));
        }

        private class AddToIndexRunnable
        implements Runnable {
            private AddToIndexRunnable() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MavenIndex localIndex = MavenIndicesManager.this.myMavenIndices.getIndexHolder().getLocalIndex();
                if (localIndex == null) {
                    return;
                }
                TreeSet<File> addedFiles = new TreeSet<File>();
                TreeSet<File> failedToAddFiles = new TreeSet<File>();
                ConcurrentLinkedQueue<File> concurrentLinkedQueue = IndexFixer.this.queueToAdd;
                synchronized (concurrentLinkedQueue) {
                    File elementToAdd;
                    if (IndexFixer.this.stopped.get()) {
                        return;
                    }
                    if (IndexFixer.this.queueToAdd.isEmpty()) {
                        return;
                    }
                    TreeSet<File> filesToAddNow = new TreeSet<File>();
                    while ((elementToAdd = IndexFixer.this.queueToAdd.poll()) != null) {
                        filesToAddNow.add(elementToAdd);
                    }
                    if (filesToAddNow.isEmpty()) {
                        return;
                    }
                    TreeSet<File> retryElements = new TreeSet<File>();
                    List<AddArtifactResponse> addArtifactResponses = localIndex.tryAddArtifacts(filesToAddNow);
                    for (AddArtifactResponse addArtifactResponse : addArtifactResponses) {
                        boolean added;
                        File file = addArtifactResponse.artifactFile();
                        boolean bl = added = addArtifactResponse.indexedMavenId() != null;
                        if (added) {
                            addedFiles.add(file);
                            continue;
                        }
                        retryElements.add(file);
                    }
                    if (!retryElements.isEmpty()) {
                        if (retryElements.size() < 10000) {
                            IndexFixer.this.queueToAdd.addAll(retryElements);
                        } else {
                            MavenLog.LOG.error("Failed to index artifacts: " + retryElements.size());
                            failedToAddFiles.addAll(retryElements);
                        }
                    }
                }
                this.fireUpdated(addedFiles, failedToAddFiles);
            }

            private void fireUpdated(Set<File> added, Set<File> failedToAdd) {
                if (IndexFixer.this.stopped.get()) {
                    return;
                }
                if (!added.isEmpty() || !failedToAdd.isEmpty()) {
                    ((MavenIndexerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(INDEXER_TOPIC)).indexUpdated(added, failedToAdd);
                }
            }
        }
    }

    private static class MavenSearchIndexListener
    implements MavenSearchIndex.IndexListener {
        private final MavenIndicesManager myManager;

        private MavenSearchIndexListener(MavenIndicesManager manager) {
            this.myManager = manager;
        }

        @Override
        public void indexIsBroken(@NotNull MavenSearchIndex index) {
            if (index == null) {
                MavenSearchIndexListener.$$$reportNull$$$0(0);
            }
            if (index instanceof MavenUpdatableIndex) {
                this.myManager.myIndexUpdateManager.scheduleUpdateContent(this.myManager.myProject, IndicesContentUpdateRequest.explicit(List.of(index.getRepository())));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "org/jetbrains/idea/maven/indices/MavenIndicesManager$MavenSearchIndexListener", "indexIsBroken"));
        }
    }

    public static interface MavenIndexerListener {
        public void indexUpdated(Set<File> var1, Set<File> var2);
    }
}

