/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.auto.reload;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemModificationType;
import com.intellij.openapi.externalSystem.autoimport.changes.AsyncFilesChangesListener;
import com.intellij.openapi.externalSystem.autoimport.changes.FilesChangesListener;
import com.intellij.openapi.externalSystem.autoimport.settings.AsyncSupplier;
import com.intellij.openapi.externalSystem.autoimport.settings.ReadAsyncSupplier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.NioPathUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.MavenImportSpec;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;
import org.jetbrains.idea.maven.utils.MavenCoroutineScopeProvider;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\n \t*\u0004\u0018\u00010\r0\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/idea/maven/project/auto/reload/MavenGeneralSettingsWatcher;", "", "manager", "Lorg/jetbrains/idea/maven/project/MavenProjectsManager;", "backgroundExecutor", "Ljava/util/concurrent/ExecutorService;", "(Lorg/jetbrains/idea/maven/project/MavenProjectsManager;Ljava/util/concurrent/ExecutorService;)V", "embeddersManager", "Lorg/jetbrains/idea/maven/project/MavenEmbeddersManager;", "kotlin.jvm.PlatformType", "getEmbeddersManager", "()Lorg/jetbrains/idea/maven/project/MavenEmbeddersManager;", "generalSettings", "Lorg/jetbrains/idea/maven/project/MavenGeneralSettings;", "getGeneralSettings", "()Lorg/jetbrains/idea/maven/project/MavenGeneralSettings;", "collectSettingsFiles", "", "", "fireSettingsChange", "", "fireSettingsXmlChange", "subscribeOnSettingsChanges", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "subscribeOnSettingsFileChanges", "intellij.maven"})
@ApiStatus.Internal
public final class MavenGeneralSettingsWatcher {
    @NotNull
    private final MavenProjectsManager manager;
    @NotNull
    private final ExecutorService backgroundExecutor;

    public MavenGeneralSettingsWatcher(@NotNull MavenProjectsManager manager, @NotNull ExecutorService backgroundExecutor) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)backgroundExecutor, (String)"backgroundExecutor");
        this.manager = manager;
        this.backgroundExecutor = backgroundExecutor;
    }

    private final MavenGeneralSettings getGeneralSettings() {
        return this.manager.getGeneralSettings();
    }

    private final MavenEmbeddersManager getEmbeddersManager() {
        return this.manager.getEmbeddersManager();
    }

    private final Set<String> collectSettingsFiles() {
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        File file = MavenUtil.resolveUserSettingsFile(this.getGeneralSettings().getUserSettingsFile());
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"resolveUserSettingsFile(...)");
        File userSettingsFile = file;
        Path path2 = userSettingsFile.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
        result2.add(NioPathUtil.toCanonicalPath((Path)path2));
        return result2;
    }

    private final void fireSettingsChange() {
        this.getEmbeddersManager().reset();
        Project project2 = this.manager.getProject();
        MavenDistributionsCache.getInstance(project2).cleanCaches();
        CoroutineScope cs = MavenCoroutineScopeProvider.Companion.getCoroutineScope(project2);
        BuildersKt.launch$default((CoroutineScope)cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ MavenGeneralSettingsWatcher this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        MavenProjectsManager mavenProjectsManager = MavenGeneralSettingsWatcher.access$getManager$p(this.this$0);
                        MavenImportSpec mavenImportSpec = MavenImportSpec.IMPLICIT_IMPORT;
                        Intrinsics.checkNotNullExpressionValue((Object)mavenImportSpec, (String)"IMPLICIT_IMPORT");
                        this.label = 1;
                        Object object3 = mavenProjectsManager.updateAllMavenProjects(mavenImportSpec, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void fireSettingsXmlChange() {
        this.getGeneralSettings().changed();
    }

    public final void subscribeOnSettingsChanges(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.getGeneralSettings().addListener(this::fireSettingsChange, parentDisposable);
    }

    public final void subscribeOnSettingsFileChanges(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Object[] objectArray = new Object[]{this};
        AsyncSupplier filesProvider2 = new ReadAsyncSupplier.Builder((Function0)new Function0<Set<? extends String>>((Object)this){

            @NotNull
            public final Set<String> invoke() {
                return MavenGeneralSettingsWatcher.access$collectSettingsFiles((MavenGeneralSettingsWatcher)this.receiver);
            }
        }).coalesceBy(objectArray).build((Executor)this.backgroundExecutor);
        AsyncFilesChangesListener.Companion.subscribeOnVirtualFilesChanges(false, filesProvider2, new FilesChangesListener(this){
            final /* synthetic */ MavenGeneralSettingsWatcher this$0;
            {
                this.this$0 = $receiver;
            }

            public void onFileChange(@NotNull String path2, long modificationStamp, @NotNull ExternalSystemModificationType modificationType) {
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                Intrinsics.checkNotNullParameter((Object)modificationType, (String)"modificationType");
                String fileChangeMessage = "File change: " + path2 + ", " + modificationStamp + ", " + modificationType;
                MavenLog.LOG.debug(fileChangeMessage);
            }

            public void apply() {
                MavenGeneralSettingsWatcher.access$fireSettingsXmlChange(this.this$0);
            }
        }, parentDisposable);
    }

    public static final /* synthetic */ MavenProjectsManager access$getManager$p(MavenGeneralSettingsWatcher $this) {
        return $this.manager;
    }

    public static final /* synthetic */ Set access$collectSettingsFiles(MavenGeneralSettingsWatcher $this) {
        return $this.collectSettingsFiles();
    }

    public static final /* synthetic */ void access$fireSettingsXmlChange(MavenGeneralSettingsWatcher $this) {
        $this.fireSettingsXmlChange();
    }
}

