/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.GitSilentFileAdder;
import com.intellij.openapi.GitSilentFileAdderProvider;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.xml.XmlElement;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomModule;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.statistics.MavenActionsUsagesCollector;
import org.jetbrains.idea.maven.utils.MavenCoroutineScopeProvider;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.wizards.MavenModuleBuilderHelper;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000 )2\u00020\u0001:\u0001)B`\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r\u0012\r\u0010\u000f\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0002\u0010\u0011J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\bH\u0016J,\u0010\u001f\u001a\u00020\u00192\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010#\u001a\u0004\u0018\u00010\u000eH\u0007J!\u0010$\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u001dH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010%J\u001a\u0010&\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010'\u001a\u0004\u0018\u00010\u001dH\u0004J\u001a\u0010(\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\"\u001a\u0004\u0018\u00010\u001dH\u0004R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006*"}, d2={"Lorg/jetbrains/idea/maven/wizards/MavenModuleBuilderHelper;", "", "myProjectId", "Lorg/jetbrains/idea/maven/model/MavenId;", "myAggregatorProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "myParentProject", "myInheritGroupId", "", "myInheritVersion", "myArchetype", "Lorg/jetbrains/idea/maven/model/MavenArchetype;", "myPropertiesToCreateByArtifact", "", "", "myCommandName", "Lcom/intellij/openapi/util/NlsContexts$Command;", "(Lorg/jetbrains/idea/maven/model/MavenId;Lorg/jetbrains/idea/maven/project/MavenProject;Lorg/jetbrains/idea/maven/project/MavenProject;ZZLorg/jetbrains/idea/maven/model/MavenArchetype;Ljava/util/Map;Ljava/lang/String;)V", "getMyAggregatorProject", "()Lorg/jetbrains/idea/maven/project/MavenProject;", "getMyCommandName", "()Ljava/lang/String;", "getMyProjectId", "()Lorg/jetbrains/idea/maven/model/MavenId;", "configure", "", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "isInteractive", "copyGeneratedFiles", "workingDir", "Ljava/io/File;", "pom", "artifactId", "generateFromArchetype", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setPomPackagingForAggregatorProject", "file", "updateProjectPom", "Companion", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenModuleBuilderHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenModuleBuilderHelper.kt\norg/jetbrains/idea/maven/wizards/MavenModuleBuilderHelper\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,247:1\n37#2,2:248\n*S KotlinDebug\n*F\n+ 1 MavenModuleBuilderHelper.kt\norg/jetbrains/idea/maven/wizards/MavenModuleBuilderHelper\n*L\n157#1:248,2\n*E\n"})
public class MavenModuleBuilderHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MavenId myProjectId;
    @Nullable
    private final MavenProject myAggregatorProject;
    @Nullable
    private final MavenProject myParentProject;
    private final boolean myInheritGroupId;
    private final boolean myInheritVersion;
    @Nullable
    private final MavenArchetype myArchetype;
    @Nullable
    private final Map<String, String> myPropertiesToCreateByArtifact;
    @Nullable
    private final String myCommandName;

    public MavenModuleBuilderHelper(@NotNull MavenId myProjectId, @Nullable MavenProject myAggregatorProject, @Nullable MavenProject myParentProject, boolean myInheritGroupId, boolean myInheritVersion, @Nullable MavenArchetype myArchetype, @Nullable Map<String, String> myPropertiesToCreateByArtifact, @Nullable String myCommandName) {
        Intrinsics.checkNotNullParameter((Object)myProjectId, (String)"myProjectId");
        this.myProjectId = myProjectId;
        this.myAggregatorProject = myAggregatorProject;
        this.myParentProject = myParentProject;
        this.myInheritGroupId = myInheritGroupId;
        this.myInheritVersion = myInheritVersion;
        this.myArchetype = myArchetype;
        this.myPropertiesToCreateByArtifact = myPropertiesToCreateByArtifact;
        this.myCommandName = myCommandName;
    }

    @NotNull
    protected final MavenId getMyProjectId() {
        return this.myProjectId;
    }

    @Nullable
    protected final MavenProject getMyAggregatorProject() {
        return this.myAggregatorProject;
    }

    @Nullable
    protected final String getMyCommandName() {
        return this.myCommandName;
    }

    public void configure(@NotNull Project project2, @NotNull VirtualFile root, boolean isInteractive) {
        PsiFile[] psiFileArray;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        MavenActionsUsagesCollector.Companion.trigger(project2, MavenActionsUsagesCollector.CREATE_MAVEN_PROJECT);
        if (this.myAggregatorProject != null) {
            PsiFile[] psiFileArray2 = new PsiFile[1];
            psiFileArray2[0] = MavenModuleBuilderHelper.getPsiFile(project2, this.myAggregatorProject.getFile());
            psiFileArray = psiFileArray2;
        } else {
            psiFileArray = PsiFile.EMPTY_ARRAY;
        }
        PsiFile[] psiFiles = psiFileArray;
        VirtualFile pom = (VirtualFile)WriteCommandAction.writeCommandAction((Project)project2, (PsiFile[])Arrays.copyOf(psiFiles, psiFiles.length)).withName(this.myCommandName).compute(() -> MavenModuleBuilderHelper.configure$lambda$0(project2, root, this, isInteractive));
        if (pom == null) {
            return;
        }
        if (this.myAggregatorProject == null) {
            MavenProjectsManager manager = MavenProjectsManager.getInstance(project2);
            manager.addManagedFilesOrUnignore(CollectionsKt.listOf((Object)pom));
        }
        if (this.myArchetype == null) {
            try {
                VfsUtil.createDirectories((String)(root.getPath() + "/src/main/java"));
                VfsUtil.createDirectories((String)(root.getPath() + "/src/main/resources"));
                VfsUtil.createDirectories((String)(root.getPath() + "/src/test/java"));
            }
            catch (IOException e) {
                MavenLog.LOG.info((Throwable)e);
            }
        }
        MavenProjectsManager.getInstance(project2).forceUpdateAllProjectsOrFindAllAvailablePomFiles();
        CoroutineScope cs = MavenCoroutineScopeProvider.Companion.getCoroutineScope(project2);
        BuildersKt.launch$default((CoroutineScope)cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(pom, project2, this, null){
            int label;
            final /* synthetic */ VirtualFile $pom;
            final /* synthetic */ Project $project;
            final /* synthetic */ MavenModuleBuilderHelper this$0;
            {
                this.$pom = $pom;
                this.$project = $project;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
                        ModalityState modalityState = ModalityState.nonModal();
                        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"nonModal(...)");
                        this.label = 1;
                        Object object3 = BuildersKt.withContext((CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$pom, this.$project, this.this$0, null){
                            int label;
                            final /* synthetic */ VirtualFile $pom;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ MavenModuleBuilderHelper this$0;
                            {
                                this.$pom = $pom;
                                this.$project = $project;
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        if (!this.$pom.isValid()) {
                                            MavenModuleBuilderHelper.showError(this.$project, new RuntimeException("Project is not valid"));
                                            return Unit.INSTANCE;
                                        }
                                        PsiFile psiFile = MavenModuleBuilderHelper.getPsiFile(this.$project, this.$pom);
                                        Intrinsics.checkNotNull((Object)psiFile);
                                        EditorHelper.openInEditor((PsiElement)((PsiElement)psiFile));
                                        if (MavenModuleBuilderHelper.access$getMyArchetype$p(this.this$0) == null) return Unit.INSTANCE;
                                        VirtualFile virtualFile = this.$pom;
                                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"$pom");
                                        this.label = 1;
                                        Object object3 = MavenModuleBuilderHelper.access$generateFromArchetype(this.this$0, this.$project, virtualFile, (Continuation)this);
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    protected final void setPomPackagingForAggregatorProject(@NotNull Project project2, @Nullable VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        MavenProject mavenProject2 = this.myAggregatorProject;
        Intrinsics.checkNotNull((Object)mavenProject2);
        VirtualFile virtualFile = mavenProject2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        VirtualFile aggregatorProjectFile = virtualFile;
        MavenDomProjectModel model = MavenDomUtil.getMavenDomProjectModel(project2, aggregatorProjectFile);
        if (model != null) {
            model.getPackaging().setStringValue("pom");
            MavenDomModule module2 = model.getModules().addModule();
            module2.setValue(MavenModuleBuilderHelper.getPsiFile(project2, file));
            VirtualFile[] virtualFileArray = new VirtualFile[]{aggregatorProjectFile};
            MavenModuleBuilderHelper.Companion.unblockAndSaveDocuments(project2, virtualFileArray);
        }
    }

    protected final void updateProjectPom(@NotNull Project project2, @Nullable VirtualFile pom) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (this.myParentProject == null) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)project2).withName(this.myCommandName).run(() -> MavenModuleBuilderHelper.updateProjectPom$lambda$1(project2, pom, this));
    }

    private final Object generateFromArchetype(Project project2, VirtualFile pom, Continuation<? super Unit> $completion) {
        MavenActionsUsagesCollector.Companion.trigger(project2, MavenActionsUsagesCollector.CREATE_MAVEN_PROJECT_FROM_ARCHETYPE);
        File workingDir = null;
        try {
            File file = FileUtil.createTempDirectory((String)"archetype", (String)"tmp");
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempDirectory(...)");
            workingDir = file;
            workingDir.deleteOnExit();
        }
        catch (IOException e) {
            MavenModuleBuilderHelper.showError(project2, e);
            return Unit.INSTANCE;
        }
        MavenRunnerParameters params = new MavenRunnerParameters(false, workingDir.getPath(), null, (List<String>)CollectionsKt.listOf((Object)"org.apache.maven.plugins:maven-archetype-plugin:RELEASE:generate"), (Collection<String>)CollectionsKt.emptyList());
        MavenRunner runner = MavenRunner.getInstance(project2);
        MavenRunnerSettings mavenRunnerSettings = runner.getState().clone();
        Intrinsics.checkNotNullExpressionValue((Object)mavenRunnerSettings, (String)"clone(...)");
        MavenRunnerSettings settings = mavenRunnerSettings;
        Map<String, String> props = settings.getMavenProperties();
        Intrinsics.checkNotNull(props);
        props.put("interactiveMode", "false");
        if (this.myPropertiesToCreateByArtifact != null) {
            props.putAll(this.myPropertiesToCreateByArtifact);
        }
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(runner, params, settings, this, workingDir, pom, project2, props, null){
            int label;
            final /* synthetic */ MavenRunner $runner;
            final /* synthetic */ MavenRunnerParameters $params;
            final /* synthetic */ MavenRunnerSettings $settings;
            final /* synthetic */ MavenModuleBuilderHelper this$0;
            final /* synthetic */ File $workingDir;
            final /* synthetic */ VirtualFile $pom;
            final /* synthetic */ Project $project;
            final /* synthetic */ Map<String, String> $props;
            {
                this.$runner = $runner;
                this.$params = $params;
                this.$settings = $settings;
                this.this$0 = $receiver;
                this.$workingDir = $workingDir;
                this.$pom = $pom;
                this.$project = $project;
                this.$props = $props;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.$runner.run(this.$params, this.$settings, () -> generateFromArchetype.2.invokeSuspend$lambda$0(this.this$0, this.$workingDir, this.$pom, this.$project, this.$props));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(MavenModuleBuilderHelper this$0, File $workingDir, VirtualFile $pom, Project $project, Map $props) {
                this$0.copyGeneratedFiles($workingDir, $pom, $project, (String)$props.get("artifactId"));
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final void copyGeneratedFiles(@Nullable File workingDir, @NotNull VirtualFile pom, @NotNull Project project2, @Nullable String artifactId) {
        Intrinsics.checkNotNullParameter((Object)pom, (String)"pom");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        String artifactId2 = artifactId;
        GitSilentFileAdder gitSilentFileAdder = GitSilentFileAdderProvider.create((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)gitSilentFileAdder, (String)"create(...)");
        GitSilentFileAdder vcsFileAdder = gitSilentFileAdder;
        try {
            try {
                String string = artifactId2;
                if (string == null) {
                    string = this.myProjectId.getArtifactId();
                }
                if ((artifactId2 = string) != null) {
                    File sourceDir = new File(workingDir, artifactId2);
                    File targetDir = new File(pom.getParent().getPath());
                    vcsFileAdder.markFileForAdding(targetDir, true);
                    FileUtil.copyDir((File)sourceDir, (File)targetDir);
                }
                File file = workingDir;
                Intrinsics.checkNotNull((Object)file);
                FileUtil.delete((File)file);
            }
            catch (Exception e) {
                MavenModuleBuilderHelper.showError(project2, e);
                vcsFileAdder.finish();
                return;
            }
            pom.getParent().refresh(false, false);
            pom.refresh(false, false);
            this.updateProjectPom(project2, pom);
            LocalFileSystem.getInstance().refreshWithoutFileWatcher(true);
        }
        finally {
            vcsFileAdder.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final VirtualFile configure$lambda$0(Project $project, VirtualFile $root, MavenModuleBuilderHelper this$0, boolean $isInteractive) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$root, (String)"$root");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        GitSilentFileAdder gitSilentFileAdder = GitSilentFileAdderProvider.create((Project)$project);
        Intrinsics.checkNotNullExpressionValue((Object)gitSilentFileAdder, (String)"create(...)");
        GitSilentFileAdder vcsFileAdder = gitSilentFileAdder;
        VirtualFile file = null;
        try {
            try {
                VirtualFile virtualFile = file = $root.findChild("pom.xml");
                if (virtualFile != null) {
                    virtualFile.delete((Object)this$0);
                }
                file = $root.createChildData((Object)this$0, "pom.xml");
                vcsFileAdder.markFileForAdding(file);
                MavenUtil.runOrApplyMavenProjectFileTemplate($project, file, this$0.myProjectId, $isInteractive);
            }
            catch (IOException e) {
                MavenModuleBuilderHelper.showError($project, e);
                VirtualFile virtualFile = file;
                vcsFileAdder.finish();
                return virtualFile;
            }
            this$0.updateProjectPom($project, file);
        }
        finally {
            vcsFileAdder.finish();
        }
        if (this$0.myAggregatorProject != null) {
            this$0.setPomPackagingForAggregatorProject($project, file);
        }
        return file;
    }

    private static final void updateProjectPom$lambda$1(Project $project, VirtualFile $pom, MavenModuleBuilderHelper this$0) {
        XmlElement el;
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        PsiDocumentManager.getInstance((Project)$project).commitAllDocuments();
        VirtualFile virtualFile = $pom;
        Intrinsics.checkNotNull((Object)virtualFile);
        MavenDomProjectModel model = MavenDomUtil.getMavenDomProjectModel($project, virtualFile);
        if (model == null) {
            return;
        }
        MavenDomUtil.updateMavenParent(model, this$0.myParentProject);
        if (this$0.myInheritGroupId) {
            XmlElement xmlElement = el = model.getGroupId().getXmlElement();
            if (xmlElement != null) {
                xmlElement.delete();
            }
        }
        if (this$0.myInheritVersion) {
            XmlElement xmlElement = el = model.getVersion().getXmlElement();
            if (xmlElement != null) {
                xmlElement.delete();
            }
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)$project);
        PsiFile psiFile = MavenModuleBuilderHelper.getPsiFile($project, $pom);
        Intrinsics.checkNotNull((Object)psiFile);
        codeStyleManager.reformat((PsiElement)psiFile);
        List pomFiles = new ArrayList(2);
        pomFiles.add($pom);
        if (!FileUtil.namesEqual((String)"pom.xml", (String)this$0.myParentProject.getFile().getName())) {
            VirtualFile virtualFile2 = this$0.myParentProject.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
            pomFiles.add(virtualFile2);
            MavenProjectsManager.getInstance($project).scheduleForceUpdateMavenProject(this$0.myParentProject);
        }
        Collection $this$toTypedArray$iv = pomFiles;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        VirtualFile[] virtualFileArray = thisCollection$iv.toArray(new VirtualFile[0]);
        MavenModuleBuilderHelper.Companion.unblockAndSaveDocuments($project, Arrays.copyOf(virtualFileArray, virtualFileArray.length));
    }

    @JvmStatic
    @Nullable
    protected static final PsiFile getPsiFile(@Nullable Project project2, @Nullable VirtualFile pom) {
        return Companion.getPsiFile(project2, pom);
    }

    @JvmStatic
    protected static final void showError(@Nullable Project project2, @Nullable Throwable e) {
        Companion.showError(project2, e);
    }

    public static final /* synthetic */ MavenArchetype access$getMyArchetype$p(MavenModuleBuilderHelper $this) {
        return $this.myArchetype;
    }

    public static final /* synthetic */ Object access$generateFromArchetype(MavenModuleBuilderHelper $this, Project project2, VirtualFile pom, Continuation $completion) {
        return $this.generateFromArchetype(project2, pom, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0005J\u001c\u0010\t\u001a\u00020\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0005J)\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u000f\"\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/idea/maven/wizards/MavenModuleBuilderHelper$Companion;", "", "()V", "getPsiFile", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "pom", "Lcom/intellij/openapi/vfs/VirtualFile;", "showError", "", "e", "", "unblockAndSaveDocuments", "files", "", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/openapi/vfs/VirtualFile;)V", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        private final void unblockAndSaveDocuments(Project project2, VirtualFile ... files2) {
            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
            FileDocumentManager fileDocumentManager2 = fileDocumentManager;
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project2);
            for (VirtualFile file : files2) {
                Document document = fileDocumentManager2.getDocument(file);
                if (document == null) continue;
                psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
                fileDocumentManager2.saveDocument(document);
            }
        }

        @JvmStatic
        @Nullable
        protected final PsiFile getPsiFile(@Nullable Project project2, @Nullable VirtualFile pom) {
            Project project3 = project2;
            Intrinsics.checkNotNull((Object)project3);
            PsiManager psiManager = PsiManager.getInstance((Project)project3);
            VirtualFile virtualFile = pom;
            Intrinsics.checkNotNull((Object)virtualFile);
            return psiManager.findFile(virtualFile);
        }

        @JvmStatic
        protected final void showError(@Nullable Project project2, @Nullable Throwable e) {
            MavenUtil.showError(project2, MavenProjectBundle.message("notification.title.failed.to.create.maven.project", new Object[0]), e);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

