/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.grammar;

import com.intellij.grazie.GrazieBundle;
import com.intellij.grazie.GraziePlugin;
import com.intellij.grazie.detection.LangDetector;
import com.intellij.grazie.grammar.LanguageToolChecker;
import com.intellij.grazie.grammar.LanguageToolRule;
import com.intellij.grazie.jlanguage.Lang;
import com.intellij.grazie.jlanguage.LangTool;
import com.intellij.grazie.text.Rule;
import com.intellij.grazie.text.RuleGroup;
import com.intellij.grazie.text.TextChecker;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextProblem;
import com.intellij.grazie.utils.HtmlUtilsKt;
import com.intellij.grazie.utils.JLangUtilsKt;
import com.intellij.grazie.utils.UtilsKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.psi.PsiElement;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.Interner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.html.ApiKt;
import kotlinx.html.BODY;
import kotlinx.html.CommonAttributeGroupFacade;
import kotlinx.html.FlowContent;
import kotlinx.html.FlowOrPhrasingContent;
import kotlinx.html.Gen_attr_traitsKt;
import kotlinx.html.P;
import kotlinx.html.TABLE;
import kotlinx.html.TD;
import kotlinx.html.TR;
import kotlinx.html.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.markup.AnnotatedTextBuilder;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.RuleMatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b\u0016\u0018\u0000 !2\u00020\u0001:\u0003!\"#B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0019H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\nH\u0002J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u000fH\u0002\u00a8\u0006$\u00b2\u0006\u0010\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u008a\u0084\u0002"}, d2={"Lcom/intellij/grazie/grammar/LanguageToolChecker;", "Lcom/intellij/grazie/text/TextChecker;", "()V", "check", "", "Lcom/intellij/grazie/grammar/LanguageToolChecker$Problem;", "extracted", "Lcom/intellij/grazie/text/TextContent;", "checkQuotedText", "Ljava/util/function/Predicate;", "Lorg/languagetool/rules/RuleMatch;", "tool", "Lorg/languagetool/JLanguageTool;", "collectLanguageToolProblems", "text", "", "lang", "Lcom/intellij/grazie/jlanguage/Lang;", "doCheck", "getRules", "", "Lcom/intellij/grazie/text/Rule;", "locale", "Ljava/util/Locale;", "includeSentenceBounds", "Lcom/intellij/openapi/util/TextRange;", "", "range", "possiblyMarkupDependent", "", "match", "runLT", "str", "Companion", "Problem", "TestChecker", "intellij.grazie.core", "disappearsAfterAddingQuotes"})
@SourceDebugExtension(value={"SMAP\nLanguageToolChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageToolChecker.kt\ncom/intellij/grazie/grammar/LanguageToolChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,315:1\n1#2:316\n1747#3,3:317\n2624#3,3:320\n*S KotlinDebug\n*F\n+ 1 LanguageToolChecker.kt\ncom/intellij/grazie/grammar/LanguageToolChecker\n*L\n83#1:317,3\n110#1:320,3\n*E\n"})
public class LanguageToolChecker
extends TextChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger logger = LoggerFactory.getLogger(LanguageToolChecker.class);
    @NotNull
    private static final Key<List<Problem>> cacheKey;
    @NotNull
    private static final Interner<String> interner;
    @NotNull
    private static final Set<String> sentenceSeparationRules;
    @NotNull
    private static final Regex openClosedRangeStart;
    @NotNull
    private static final Regex openClosedRangeEnd;

    @NotNull
    public Collection<Rule> getRules(@NotNull Locale locale) {
        Lang lang;
        block2: {
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            Language language = Languages.getLanguageForLocale(locale);
            Lang[] langArray = Lang.values();
            int n = langArray.length;
            for (int i = 0; i < n; ++i) {
                Lang lang2;
                Lang it = lang2 = langArray[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getJLanguage(), (Object)language)) continue;
                lang = lang2;
                break block2;
            }
            lang = null;
        }
        if (lang == null) {
            return CollectionsKt.emptyList();
        }
        Lang lang3 = lang;
        return Companion.grammarRules$intellij_grazie_core(LangTool.INSTANCE.getTool(lang3), lang3);
    }

    @NotNull
    public List<Problem> check(@NotNull TextContent extracted) {
        Intrinsics.checkNotNullParameter((Object)extracted, (String)"extracted");
        List<Problem> result2 = (List<Problem>)cacheKey.get((UserDataHolder)extracted);
        if (result2 == null) {
            result2 = this.doCheck(extracted);
            extracted.putUserDataIfAbsent(cacheKey, result2);
        }
        List<Problem> list = result2;
        Intrinsics.checkNotNull(list);
        return list;
    }

    private final List<Problem> doCheck(TextContent extracted) {
        String text2 = ((Object)extracted).toString();
        if (StringsKt.isBlank((CharSequence)text2)) {
            return CollectionsKt.emptyList();
        }
        Lang lang = LangDetector.INSTANCE.getLang(text2);
        if (lang == null) {
            return CollectionsKt.emptyList();
        }
        Lang language = lang;
        try {
            Object object = ClassLoaderUtil.computeWithClassLoader((ClassLoader)GraziePlugin.INSTANCE.getClassLoader(), () -> LanguageToolChecker.doCheck$lambda$1(this, extracted, text2, language));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"computeWithClassLoader(...)");
            return (List)object;
        }
        catch (Throwable exception) {
            if (ExceptionUtil.causedBy((Throwable)exception, ProcessCanceledException.class)) {
                throw new ProcessCanceledException();
            }
            logger.warn("Got exception from LanguageTool", exception);
            return CollectionsKt.emptyList();
        }
    }

    private final List<Problem> collectLanguageToolProblems(TextContent extracted, String text2, Lang lang) {
        boolean bl;
        JLanguageTool tool;
        block4: {
            tool = LangTool.INSTANCE.getTool(lang);
            List<String> sentences2 = tool.sentenceTokenize(text2);
            Intrinsics.checkNotNull(sentences2);
            Iterable $this$any$iv = sentences2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(it.length() > 1000)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            return CollectionsKt.emptyList();
        }
        List<RuleMatch> matches = this.runLT(tool, text2);
        Lazy disappearsAfterAddingQuotes$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Predicate<RuleMatch>>(this, extracted, tool){
            final /* synthetic */ LanguageToolChecker this$0;
            final /* synthetic */ TextContent $extracted;
            final /* synthetic */ JLanguageTool $tool;
            {
                this.this$0 = $receiver;
                this.$extracted = $extracted;
                this.$tool = $tool;
                super(0);
            }

            @NotNull
            public final Predicate<RuleMatch> invoke() {
                return LanguageToolChecker.access$checkQuotedText(this.this$0, this.$extracted, this.$tool);
            }
        }));
        return SequencesKt.toList((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)matches), (Function1)((Function1)new Function1<RuleMatch, Boolean>(this, (Lazy<? extends Predicate<RuleMatch>>)disappearsAfterAddingQuotes$delegate){
            final /* synthetic */ LanguageToolChecker this$0;
            final /* synthetic */ Lazy<Predicate<RuleMatch>> $disappearsAfterAddingQuotes$delegate;
            {
                this.this$0 = $receiver;
                this.$disappearsAfterAddingQuotes$delegate = $disappearsAfterAddingQuotes$delegate;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull RuleMatch it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return LanguageToolChecker.access$possiblyMarkupDependent(this.this$0, it) && LanguageToolChecker.access$collectLanguageToolProblems$lambda$3(this.$disappearsAfterAddingQuotes$delegate).test(it);
            }
        })), (Function1)((Function1)new Function1<RuleMatch, Problem>(lang, extracted, this){
            final /* synthetic */ Lang $lang;
            final /* synthetic */ TextContent $extracted;
            final /* synthetic */ LanguageToolChecker this$0;
            {
                this.$lang = $lang;
                this.$extracted = $extracted;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Problem invoke(@NotNull RuleMatch it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new Problem(it, this.$lang, this.$extracted, this.this$0 instanceof TestChecker);
            }
        })), (Function1)((Function1)new Function1<Problem, Boolean>(extracted){
            final /* synthetic */ TextContent $extracted;
            {
                this.$extracted = $extracted;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Problem it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return com.intellij.grazie.grammar.LanguageToolChecker$Companion.access$isGitCherryPickedFrom(LanguageToolChecker.Companion, it.getMatch(), this.$extracted);
            }
        })), (Function1)((Function1)new Function1<Problem, Boolean>(extracted){
            final /* synthetic */ TextContent $extracted;
            {
                this.$extracted = $extracted;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Problem it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return com.intellij.grazie.grammar.LanguageToolChecker$Companion.access$isKnownLTBug(LanguageToolChecker.Companion, it.getMatch(), this.$extracted);
            }
        })), (Function1)((Function1)new Function1<Problem, Boolean>(this, extracted){
            final /* synthetic */ LanguageToolChecker this$0;
            final /* synthetic */ TextContent $extracted;
            {
                this.this$0 = $receiver;
                this.$extracted = $extracted;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Problem it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                TextRange range = it.fitsGroup(RuleGroup.CASING) ? LanguageToolChecker.access$includeSentenceBounds(this.this$0, this.$extracted, it.getPatternRange()) : it.getPatternRange();
                return this.$extracted.hasUnknownFragmentsIn(range);
            }
        })));
    }

    private final Predicate<RuleMatch> checkQuotedText(TextContent extracted, JLanguageTool tool) {
        Predicate<RuleMatch> predicate;
        int[] nArray = extracted.markupOffsets();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"markupOffsets(...)");
        if (nArray.length == 0) {
            Predicate<RuleMatch> predicate2 = Predicates.alwaysFalse();
            predicate = predicate2;
            Intrinsics.checkNotNullExpressionValue((Object)predicate2, (String)"alwaysFalse(...)");
        } else {
            TextContent.WithMarkup quotedText = extracted.replaceMarkupWith('\"');
            List<RuleMatch> quotedMatches = this.runLT(tool, quotedText.toString());
            predicate = arg_0 -> LanguageToolChecker.checkQuotedText$lambda$5(quotedMatches, quotedText, arg_0);
        }
        return predicate;
    }

    private final boolean possiblyMarkupDependent(RuleMatch match) {
        String string2 = match.getMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMessage(...)");
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        return StringsKt.contains$default((CharSequence)string3, (CharSequence)"capitalize", (boolean)false, (int)2, null);
    }

    private final List<RuleMatch> runLT(JLanguageTool tool, String str) {
        List<RuleMatch> list = tool.check(new AnnotatedTextBuilder().addText(str).build(), true, JLanguageTool.ParagraphHandling.NORMAL, null, JLanguageTool.Mode.ALL, JLanguageTool.Level.PICKY);
        Intrinsics.checkNotNullExpressionValue(list, (String)"check(...)");
        return list;
    }

    private final TextRange includeSentenceBounds(CharSequence text2, TextRange range) {
        int start;
        int end = range.getEndOffset();
        for (start = range.getStartOffset(); start > 0 && CharsKt.isWhitespace((char)text2.charAt(start - 1)); --start) {
        }
        while (end < text2.length() && CharsKt.isWhitespace((char)text2.charAt(end))) {
            ++end;
        }
        return new TextRange(start, end);
    }

    private static final List doCheck$lambda$1(LanguageToolChecker this$0, TextContent $extracted, String $text, Lang $language) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$extracted, (String)"$extracted");
        Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
        Intrinsics.checkNotNullParameter((Object)((Object)$language), (String)"$language");
        return (List)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends Problem>>, Object>(this$0, $extracted, $text, $language, null){
            int label;
            final /* synthetic */ LanguageToolChecker this$0;
            final /* synthetic */ TextContent $extracted;
            final /* synthetic */ String $text;
            final /* synthetic */ Lang $language;
            {
                this.this$0 = $receiver;
                this.$extracted = $extracted;
                this.$text = $text;
                this.$language = $language;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends Problem>>, Object>(this.this$0, this.$extracted, this.$text, this.$language, null){
                            int label;
                            final /* synthetic */ LanguageToolChecker this$0;
                            final /* synthetic */ TextContent $extracted;
                            final /* synthetic */ String $text;
                            final /* synthetic */ Lang $language;
                            {
                                this.this$0 = $receiver;
                                this.$extracted = $extracted;
                                this.$text = $text;
                                this.$language = $language;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = CoroutinesKt.coroutineToIndicator((Function0)((Function0)new Function0<List<? extends Problem>>(this.this$0, this.$extracted, this.$text, this.$language){
                                            final /* synthetic */ LanguageToolChecker this$0;
                                            final /* synthetic */ TextContent $extracted;
                                            final /* synthetic */ String $text;
                                            final /* synthetic */ Lang $language;
                                            {
                                                this.this$0 = $receiver;
                                                this.$extracted = $extracted;
                                                this.$text = $text;
                                                this.$language = $language;
                                                super(0);
                                            }

                                            public final List<Problem> invoke() {
                                                ProgressIndicator indicator = ProgressManager.getGlobalProgressIndicator();
                                                if (indicator == null) {
                                                    boolean bl = false;
                                                    String string2 = "Indicator was not set for current job";
                                                    throw new IllegalStateException(string2.toString());
                                                }
                                                return (List)ApplicationUtil.runWithCheckCanceled(() -> doCheck.1.1.invoke$lambda$1(this.this$0, this.$extracted, this.$text, this.$language), (ProgressIndicator)indicator);
                                            }

                                            private static final List invoke$lambda$1(LanguageToolChecker this$0, TextContent $extracted, String $text, Lang $language) {
                                                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                                                Intrinsics.checkNotNullParameter((Object)$extracted, (String)"$extracted");
                                                Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
                                                Intrinsics.checkNotNullParameter((Object)((Object)$language), (String)"$language");
                                                return LanguageToolChecker.access$collectLanguageToolProblems(this$0, $extracted, $text, $language);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (object3 != object2) return object3;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return object3;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<Problem>> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<Problem>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private static final Predicate<RuleMatch> collectLanguageToolProblems$lambda$3(Lazy<? extends Predicate<RuleMatch>> $disappearsAfterAddingQuotes$delegate) {
        Lazy<? extends Predicate<RuleMatch>> lazy = $disappearsAfterAddingQuotes$delegate;
        return (Predicate)lazy.getValue();
    }

    private static final boolean checkQuotedText$lambda$5(List $quotedMatches, TextContent.WithMarkup $quotedText, RuleMatch om) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$quotedMatches, (String)"$quotedMatches");
            Intrinsics.checkNotNullParameter((Object)om, (String)"om");
            ProgressManager.checkCanceled();
            Iterable $this$none$iv = $quotedMatches;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    RuleMatch qm = (RuleMatch)element$iv;
                    boolean bl2 = false;
                    boolean bl3 = Intrinsics.areEqual((Object)qm.getRule(), (Object)om.getRule()) && $quotedText.offsetToOriginal(qm.getFromPos()) == om.getFromPos() && $quotedText.offsetToOriginal(qm.getToPos()) == om.getToPos();
                    if (!bl3) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final /* synthetic */ Predicate access$checkQuotedText(LanguageToolChecker $this, TextContent extracted, JLanguageTool tool) {
        return $this.checkQuotedText(extracted, tool);
    }

    public static final /* synthetic */ boolean access$possiblyMarkupDependent(LanguageToolChecker $this, RuleMatch match) {
        return $this.possiblyMarkupDependent(match);
    }

    public static final /* synthetic */ Predicate access$collectLanguageToolProblems$lambda$3(Lazy $disappearsAfterAddingQuotes$delegate) {
        return LanguageToolChecker.collectLanguageToolProblems$lambda$3((Lazy<? extends Predicate<RuleMatch>>)$disappearsAfterAddingQuotes$delegate);
    }

    public static final /* synthetic */ TextRange access$includeSentenceBounds(LanguageToolChecker $this, CharSequence text2, TextRange range) {
        return $this.includeSentenceBounds(text2, range);
    }

    public static final /* synthetic */ List access$collectLanguageToolProblems(LanguageToolChecker $this, TextContent extracted, String text2, Lang lang) {
        return $this.collectLanguageToolProblems(extracted, text2, lang);
    }

    static {
        Key key2 = Key.create((String)"grazie.LT.problem.cache");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        cacheKey = key2;
        Interner interner = Interner.createWeakInterner();
        Intrinsics.checkNotNullExpressionValue((Object)interner, (String)"createWeakInterner(...)");
        LanguageToolChecker.interner = interner;
        Object[] objectArray = new String[]{"LC_AFTER_PERIOD", "PUNT_GEEN_HL", "KLEIN_NACH_PUNKT"};
        sentenceSeparationRules = SetsKt.setOf((Object[])objectArray);
        openClosedRangeStart = new Regex("[\\[(].+?(\\.\\.|:|,).+[])]");
        openClosedRangeEnd = new Regex(".*" + openClosedRangeStart.getPattern());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J#\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00052\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ\u0018\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010#\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010'\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010(\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"H\u0003R-\u0010\u0003\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \u0007*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u0007*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/grazie/grammar/LanguageToolChecker$Companion;", "", "()V", "cacheKey", "Lcom/intellij/openapi/util/Key;", "", "Lcom/intellij/grazie/grammar/LanguageToolChecker$Problem;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "interner", "Lcom/intellij/util/containers/Interner;", "", "logger", "Lorg/slf4j/Logger;", "openClosedRangeEnd", "Lkotlin/text/Regex;", "openClosedRangeStart", "sentenceSeparationRules", "", "couldBeOpenClosedRange", "", "text", "Lcom/intellij/grazie/text/TextContent;", "index", "", "grammarRules", "Lcom/intellij/grazie/grammar/LanguageToolRule;", "tool", "Lorg/languagetool/JLanguageTool;", "lang", "Lcom/intellij/grazie/jlanguage/Lang;", "grammarRules$intellij_grazie_core", "isGitCherryPickedFrom", "match", "Lorg/languagetool/rules/RuleMatch;", "isKnownLTBug", "isNumberRange", "startOffset", "endOffset", "isPathPart", "toTooltipTemplate", "intellij.grazie.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<LanguageToolRule> grammarRules$intellij_grazie_core(@NotNull JLanguageTool tool, @NotNull Lang lang) {
            Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
            Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
            List<org.languagetool.rules.Rule> list = tool.getAllRules();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getAllRules(...)");
            return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.distinctBy((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)grammarRules.1.INSTANCE), (Function1)grammarRules.2.INSTANCE), (Function1)((Function1)new Function1<org.languagetool.rules.Rule, LanguageToolRule>(lang){
                final /* synthetic */ Lang $lang;
                {
                    this.$lang = $lang;
                    super(1);
                }

                @NotNull
                public final LanguageToolRule invoke(org.languagetool.rules.Rule it) {
                    Intrinsics.checkNotNull((Object)it);
                    return new LanguageToolRule(this.$lang, it);
                }
            })));
        }

        private final boolean isGitCherryPickedFrom(RuleMatch match, TextContent text2) {
            return Intrinsics.areEqual((Object)match.getRule().getId(), (Object)"EN_COMPOUNDS") && match.getFromPos() > 0 && StringsKt.startsWith$default((CharSequence)text2, (CharSequence)"(cherry picked from", (int)(match.getFromPos() - 1), (boolean)false, (int)4, null) && (text2.getDomain() == TextContent.TextDomain.LITERALS || text2.getDomain() == TextContent.TextDomain.PLAIN_TEXT && (Boolean)ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(text2){
                final /* synthetic */ TextContent $text;
                {
                    this.$text = $text;
                    super(0);
                }

                @NotNull
                public final Boolean invoke() {
                    return CommitMessage.isCommitMessage((PsiElement)((PsiElement)this.$text.getContainingFile()));
                }
            })) != false);
        }

        private final boolean isKnownLTBug(RuleMatch match, TextContent text2) {
            if (match.getRule() instanceof GenericUnpairedBracketsRule) {
                if (match.getFromPos() > 0 && (StringsKt.startsWith$default((CharSequence)text2, (CharSequence)"\")", (int)(match.getFromPos() - 1), (boolean)false, (int)4, null) || StringsKt.contains$default((CharSequence)text2.subSequence(0, match.getFromPos()), (CharSequence)"(\"", (boolean)false, (int)2, null))) {
                    return true;
                }
                if (StringsKt.startsWith$default((CharSequence)text2, (CharSequence)"'", (int)match.getFromPos(), (boolean)false, (int)4, null) && StringsKt.contains$default((CharSequence)text2.subSequence(match.getFromPos() + 1, text2.length()), (CharSequence)"'", (boolean)false, (int)2, null)) {
                    return true;
                }
                if (Intrinsics.areEqual((Object)((Object)((CharSequence)text2).subSequence(match.getFromPos(), match.getToPos())).toString(), (Object)"\"") && StringsKt.contains$default((CharSequence)text2.subSequence(0, match.getFromPos()), (CharSequence)"\"", (boolean)false, (int)2, null)) {
                    return true;
                }
                if (this.couldBeOpenClosedRange(text2, match.getFromPos())) {
                    return true;
                }
            }
            if (Intrinsics.areEqual((Object)match.getRule().getId(), (Object)"ARTICLE_ADJECTIVE_OF") && StringsKt.equals((String)((Object)((CharSequence)text2).subSequence(match.getFromPos(), match.getToPos())).toString(), (String)"iterable", (boolean)true)) {
                return true;
            }
            String string2 = match.getRule().getId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
            return StringsKt.endsWith$default((String)string2, (String)"DOUBLE_PUNCTUATION", (boolean)false, (int)2, null) && (this.isNumberRange(match.getFromPos(), match.getToPos(), text2) || this.isPathPart(match.getFromPos(), match.getToPos(), text2));
        }

        private final boolean couldBeOpenClosedRange(TextContent text2, int index) {
            char unpaired = text2.charAt(index);
            return StringsKt.contains$default((CharSequence)"([", (char)unpaired, (boolean)false, (int)2, null) && openClosedRangeStart.matchesAt((CharSequence)text2, index) || StringsKt.contains$default((CharSequence)")]", (char)unpaired, (boolean)false, (int)2, null) && openClosedRangeEnd.matches(text2.subSequence(0, index + 1));
        }

        private final boolean isNumberRange(int startOffset, int endOffset, TextContent text2) {
            return startOffset > 0 && endOffset < text2.length() && Character.isDigit(text2.charAt(startOffset - 1)) && Character.isDigit(text2.charAt(endOffset));
        }

        private final boolean isPathPart(int startOffset, int endOffset, TextContent text2) {
            return StringsKt.endsWith$default((CharSequence)text2.subSequence(0, startOffset), (char)'/', (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)text2.subSequence(endOffset, text2.length()), (char)'/', (boolean)false, (int)2, null);
        }

        @NlsSafe
        private final String toTooltipTemplate(RuleMatch match) {
            String html2 = HtmlUtilsKt.html((Function1<? super BODY, Unit>)((Function1)new Function1<BODY, Unit>(match){
                final /* synthetic */ RuleMatch $match;
                {
                    this.$match = $match;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull BODY $this$html) {
                    FlowContent $this$p_u24default$iv;
                    Object v4;
                    void $this$filterTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)$this$html, (String)"$this$html");
                    List<IncorrectExample> list = this.$match.getRule().getIncorrectExamples();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getIncorrectExamples(...)");
                    List<IncorrectExample> $this$filter$iv = list;
                    boolean $i$f$filter = false;
                    List<IncorrectExample> list2 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        IncorrectExample it = (IncorrectExample)element$iv$iv;
                        boolean bl = false;
                        List<String> list3 = it.getCorrections();
                        Intrinsics.checkNotNullExpressionValue(list3, (String)"getCorrections(...)");
                        boolean bl2 = !((Collection)list3).isEmpty();
                        if (!bl2) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List<IncorrectExample> it = $this$filter$iv = (List)destination$iv$iv;
                    boolean bl = false;
                    List<IncorrectExample> withCorrections = !((Collection)it).isEmpty() ? $this$filter$iv : null;
                    List<IncorrectExample> list4 = withCorrections;
                    if (list4 == null) {
                        list4 = this.$match.getRule().getIncorrectExamples();
                    }
                    it = list4;
                    Intrinsics.checkNotNull((Object)it);
                    Iterable $this$minByOrNull$iv = it;
                    boolean $i$f$minByOrNull = false;
                    Object iterator$iv = $this$minByOrNull$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        v4 = null;
                    } else {
                        Object minElem$iv = iterator$iv.next();
                        if (!iterator$iv.hasNext()) {
                            v4 = minElem$iv;
                        } else {
                            IncorrectExample it2 = (IncorrectExample)minElem$iv;
                            boolean bl3 = false;
                            int minValue$iv = it2.getExample().length();
                            do {
                                E e$iv = iterator$iv.next();
                                IncorrectExample it3 = (IncorrectExample)e$iv;
                                $i$a$-minByOrNull-LanguageToolChecker$Companion$toTooltipTemplate$html$1$incorrectExample$1 = false;
                                int v$iv = it3.getExample().length();
                                if (minValue$iv <= v$iv) continue;
                                minElem$iv = e$iv;
                                minValue$iv = v$iv;
                            } while (iterator$iv.hasNext());
                            v4 = minElem$iv;
                        }
                    }
                    IncorrectExample incorrectExample = v4;
                    $this$minByOrNull$iv = (FlowContent)$this$html;
                    iterator$iv = this.$match;
                    String classes$iv = null;
                    boolean $i$f$p = false;
                    Tag $this$visit$iv$iv = (Tag)new P(ApiKt.attributesMapOf((String)"class", classes$iv), $this$p_u24default$iv.getConsumer());
                    boolean $i$f$visit = false;
                    Tag $this$visitTag$iv$iv$iv = $this$visit$iv$iv;
                    boolean $i$f$visitTag = false;
                    $this$visitTag$iv$iv$iv.getConsumer().onTagStart($this$visitTag$iv$iv$iv);
                    Tag $this$visit_u24lambda_u240$iv$iv = $this$visitTag$iv$iv$iv;
                    boolean bl4 = false;
                    P $this$invoke_u24lambda_u244 = (P)$this$visit_u24lambda_u240$iv$iv;
                    boolean bl5 = false;
                    IncorrectExample incorrectExample2 = incorrectExample;
                    if (incorrectExample2 != null) {
                        IncorrectExample it4 = incorrectExample2;
                        boolean bl6 = false;
                        Gen_attr_traitsKt.setStyle((CommonAttributeGroupFacade)((CommonAttributeGroupFacade)$this$invoke_u24lambda_u244), (String)"padding-bottom: 8px;");
                    }
                    $this$invoke_u24lambda_u244.unaryPlus(JLangUtilsKt.getMessageSanitized((RuleMatch)iterator$iv));
                    HtmlUtilsKt.nbsp((FlowContent)$this$invoke_u24lambda_u244);
                    $this$visitTag$iv$iv$iv.getConsumer().onTagEnd($this$visitTag$iv$iv$iv);
                    FlowContent $this$table_u24default$iv = (FlowContent)$this$html;
                    classes$iv = null;
                    boolean $i$f$table = false;
                    Tag $this$visit$iv$iv2 = (Tag)new TABLE(ApiKt.attributesMapOf((String)"class", classes$iv), $this$table_u24default$iv.getConsumer());
                    boolean $i$f$visit2 = false;
                    Tag $this$visitTag$iv$iv$iv2 = $this$visit$iv$iv2;
                    boolean $i$f$visitTag2 = false;
                    $this$visitTag$iv$iv$iv2.getConsumer().onTagStart($this$visitTag$iv$iv$iv2);
                    Tag $this$visit_u24lambda_u240$iv$iv2 = $this$visitTag$iv$iv$iv2;
                    $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
                    TABLE $this$invoke_u24lambda_u2412 = (TABLE)$this$visit_u24lambda_u240$iv$iv2;
                    boolean bl7 = false;
                    HtmlUtilsKt.setCellpading($this$invoke_u24lambda_u2412, "0");
                    HtmlUtilsKt.setCellspacing($this$invoke_u24lambda_u2412, "0");
                    IncorrectExample incorrectExample3 = incorrectExample;
                    if (incorrectExample3 != null) {
                        IncorrectExample it5 = incorrectExample3;
                        boolean bl8 = false;
                        TABLE $this$tr_u24default$iv = $this$invoke_u24lambda_u2412;
                        String classes$iv2 = null;
                        boolean $i$f$tr = false;
                        Tag $this$visit$iv$iv3 = (Tag)new TR(ApiKt.attributesMapOf((String)"class", classes$iv2), $this$tr_u24default$iv.getConsumer());
                        boolean $i$f$visit3 = false;
                        Tag $this$visitTag$iv$iv$iv3 = $this$visit$iv$iv3;
                        boolean $i$f$visitTag3 = false;
                        $this$visitTag$iv$iv$iv3.getConsumer().onTagStart($this$visitTag$iv$iv$iv3);
                        Tag $this$visit_u24lambda_u240$iv$iv3 = $this$visitTag$iv$iv$iv3;
                        $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
                        TR $this$invoke_u24lambda_u2412_u24lambda_u2411_u24lambda_u247 = (TR)$this$visit_u24lambda_u240$iv$iv3;
                        boolean bl9 = false;
                        TR $this$td_u24default$iv = $this$invoke_u24lambda_u2412_u24lambda_u2411_u24lambda_u247;
                        String classes$iv3 = null;
                        boolean $i$f$td = false;
                        Tag $this$visit$iv$iv4 = (Tag)new TD(ApiKt.attributesMapOf((String)"class", classes$iv3), $this$td_u24default$iv.getConsumer());
                        boolean $i$f$visit4 = false;
                        Tag $this$visitTag$iv$iv$iv4 = $this$visit$iv$iv4;
                        boolean $i$f$visitTag4 = false;
                        $this$visitTag$iv$iv$iv4.getConsumer().onTagStart($this$visitTag$iv$iv$iv4);
                        Tag $this$visit_u24lambda_u240$iv$iv4 = $this$visitTag$iv$iv$iv4;
                        $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
                        TD $this$invoke_u24lambda_u2412_u24lambda_u2411_u24lambda_u247_u24lambda_u245 = (TD)$this$visit_u24lambda_u240$iv$iv4;
                        boolean bl10 = false;
                        HtmlUtilsKt.setValign($this$invoke_u24lambda_u2412_u24lambda_u2411_u24lambda_u247_u24lambda_u245, "top");
                        Gen_attr_traitsKt.setStyle((CommonAttributeGroupFacade)((CommonAttributeGroupFacade)$this$invoke_u24lambda_u2412_u24lambda_u2411_u24lambda_u247_u24lambda_u245), (String)"padding-right: 5px; color: gray; vertical-align: top; white-space: nowrap;");
                        $this$invoke_u24lambda_u2412_u24lambda_u2411_u24lambda_u247_u24lambda_u245.unaryPlus(" ");
                        $this$invoke_u24lambda_u2412_u24lambda_u2411_u24lambda_u247_u24lambda_u245.unaryPlus(GrazieBundle.message("grazie.settings.grammar.rule.incorrect", new Object[0]));
                        $this$invoke_u24lambda_u2412_u24lambda_u2411_u24lambda_u247_u24lambda_u245.unaryPlus(" ");
                        HtmlUtilsKt.nbsp((FlowContent)$this$invoke_u24lambda_u2412_u24lambda_u2411_u24lambda_u247_u24lambda_u245);
                        $this$visitTag$iv$iv$iv4.getConsumer().onTagEnd($this$visitTag$iv$iv$iv4);
                        $this$td_u24default$iv = $this$invoke_u24lambda_u2412_u24lambda_u2411_u24lambda_u247;
                        classes$iv3 = null;
                        $i$f$td = false;
                        $this$visit$iv$iv4 = (Tag)new TD(ApiKt.attributesMapOf((String)"class", classes$iv3), $this$td_u24default$iv.getConsumer());
                        $i$f$visit4 = false;
                        $this$visitTag$iv$iv$iv4 = $this$visit$iv$iv4;
                        $i$f$visitTag4 = false;
                        $this$visitTag$iv$iv$iv4.getConsumer().onTagStart($this$visitTag$iv$iv$iv4);
                        $this$visit_u24lambda_u240$iv$iv4 = $this$visitTag$iv$iv$iv4;
                        $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
                        TD $this$invoke_u24lambda_u2412_u24lambda_u2411_u24lambda_u247_u24lambda_u246 = (TD)$this$visit_u24lambda_u240$iv$iv4;
                        boolean bl11 = false;
                        Gen_attr_traitsKt.setStyle((CommonAttributeGroupFacade)((CommonAttributeGroupFacade)$this$invoke_u24lambda_u2412_u24lambda_u2411_u24lambda_u247_u24lambda_u246), (String)"width: 100%;");
                        JLangUtilsKt.toIncorrectHtml((FlowOrPhrasingContent)$this$invoke_u24lambda_u2412_u24lambda_u2411_u24lambda_u247_u24lambda_u246, it5);
                        HtmlUtilsKt.nbsp((FlowContent)$this$invoke_u24lambda_u2412_u24lambda_u2411_u24lambda_u247_u24lambda_u246);
                        $this$visitTag$iv$iv$iv4.getConsumer().onTagEnd($this$visitTag$iv$iv$iv4);
                        $this$visitTag$iv$iv$iv3.getConsumer().onTagEnd($this$visitTag$iv$iv$iv3);
                        List<String> list5 = it5.getCorrections();
                        Intrinsics.checkNotNullExpressionValue(list5, (String)"getCorrections(...)");
                        if (!((Collection)list5).isEmpty()) {
                            $this$tr_u24default$iv = $this$invoke_u24lambda_u2412;
                            classes$iv2 = null;
                            $i$f$tr = false;
                            $this$visit$iv$iv3 = (Tag)new TR(ApiKt.attributesMapOf((String)"class", classes$iv2), $this$tr_u24default$iv.getConsumer());
                            $i$f$visit3 = false;
                            $this$visitTag$iv$iv$iv3 = $this$visit$iv$iv3;
                            $i$f$visitTag3 = false;
                            $this$visitTag$iv$iv$iv3.getConsumer().onTagStart($this$visitTag$iv$iv$iv3);
                            $this$visit_u24lambda_u240$iv$iv3 = $this$visitTag$iv$iv$iv3;
                            $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
                            TR $this$invoke_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410 = (TR)$this$visit_u24lambda_u240$iv$iv3;
                            boolean bl12 = false;
                            $this$td_u24default$iv = $this$invoke_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410;
                            classes$iv3 = null;
                            $i$f$td = false;
                            $this$visit$iv$iv4 = (Tag)new TD(ApiKt.attributesMapOf((String)"class", classes$iv3), $this$td_u24default$iv.getConsumer());
                            $i$f$visit4 = false;
                            $this$visitTag$iv$iv$iv4 = $this$visit$iv$iv4;
                            $i$f$visitTag4 = false;
                            $this$visitTag$iv$iv$iv4.getConsumer().onTagStart($this$visitTag$iv$iv$iv4);
                            $this$visit_u24lambda_u240$iv$iv4 = $this$visitTag$iv$iv$iv4;
                            $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
                            TD $this$invoke_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u248 = (TD)$this$visit_u24lambda_u240$iv$iv4;
                            boolean bl13 = false;
                            HtmlUtilsKt.setValign($this$invoke_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u248, "top");
                            Gen_attr_traitsKt.setStyle((CommonAttributeGroupFacade)((CommonAttributeGroupFacade)$this$invoke_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u248), (String)"padding-top: 5px; padding-right: 5px; color: gray; vertical-align: top; white-space: nowrap;");
                            $this$invoke_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u248.unaryPlus(" ");
                            $this$invoke_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u248.unaryPlus(GrazieBundle.message("grazie.settings.grammar.rule.correct", new Object[0]));
                            $this$invoke_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u248.unaryPlus(" ");
                            HtmlUtilsKt.nbsp((FlowContent)$this$invoke_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u248);
                            $this$visitTag$iv$iv$iv4.getConsumer().onTagEnd($this$visitTag$iv$iv$iv4);
                            $this$td_u24default$iv = $this$invoke_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410;
                            classes$iv3 = null;
                            $i$f$td = false;
                            $this$visit$iv$iv4 = (Tag)new TD(ApiKt.attributesMapOf((String)"class", classes$iv3), $this$td_u24default$iv.getConsumer());
                            $i$f$visit4 = false;
                            $this$visitTag$iv$iv$iv4 = $this$visit$iv$iv4;
                            $i$f$visitTag4 = false;
                            $this$visitTag$iv$iv$iv4.getConsumer().onTagStart($this$visitTag$iv$iv$iv4);
                            $this$visit_u24lambda_u240$iv$iv4 = $this$visitTag$iv$iv$iv4;
                            $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
                            TD $this$invoke_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u249 = (TD)$this$visit_u24lambda_u240$iv$iv4;
                            boolean bl14 = false;
                            Gen_attr_traitsKt.setStyle((CommonAttributeGroupFacade)((CommonAttributeGroupFacade)$this$invoke_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u249), (String)"padding-top: 5px; width: 100%;");
                            JLangUtilsKt.toCorrectHtml((FlowOrPhrasingContent)$this$invoke_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u249, it5);
                            HtmlUtilsKt.nbsp((FlowContent)$this$invoke_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u249);
                            $this$visitTag$iv$iv$iv4.getConsumer().onTagEnd($this$visitTag$iv$iv$iv4);
                            $this$visitTag$iv$iv$iv3.getConsumer().onTagEnd($this$visitTag$iv$iv$iv3);
                        }
                    }
                    $this$visitTag$iv$iv$iv2.getConsumer().onTagEnd($this$visitTag$iv$iv$iv2);
                    $this$p_u24default$iv = (FlowContent)$this$html;
                    classes$iv = null;
                    boolean $i$f$p2 = false;
                    $this$visit$iv$iv2 = (Tag)new P(ApiKt.attributesMapOf((String)"class", classes$iv), $this$p_u24default$iv.getConsumer());
                    $i$f$visit2 = false;
                    $this$visitTag$iv$iv$iv2 = $this$visit$iv$iv2;
                    $i$f$visitTag2 = false;
                    $this$visitTag$iv$iv$iv2.getConsumer().onTagStart($this$visitTag$iv$iv$iv2);
                    $this$visit_u24lambda_u240$iv$iv2 = $this$visitTag$iv$iv$iv2;
                    $i$a$-visitTag-ApiKt$visit$1$iv$iv = false;
                    P $this$invoke_u24lambda_u2413 = (P)$this$visit_u24lambda_u240$iv$iv2;
                    boolean bl15 = false;
                    Gen_attr_traitsKt.setStyle((CommonAttributeGroupFacade)((CommonAttributeGroupFacade)$this$invoke_u24lambda_u2413), (String)"text-align: left; font-size: x-small; color: gray; padding-top: 10px; padding-bottom: 0px;");
                    $this$invoke_u24lambda_u2413.unaryPlus(" ");
                    $this$invoke_u24lambda_u2413.unaryPlus(GrazieBundle.message("grazie.tooltip.powered-by-language-tool", new Object[0]));
                    $this$visitTag$iv$iv$iv2.getConsumer().onTagEnd($this$visitTag$iv$iv$iv2);
                }
            }));
            Object object = interner.intern((Object)html2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"intern(...)");
            return (String)object;
        }

        public static final /* synthetic */ boolean access$isGitCherryPickedFrom(Companion $this, RuleMatch match, TextContent text2) {
            return $this.isGitCherryPickedFrom(match, text2);
        }

        public static final /* synthetic */ boolean access$isKnownLTBug(Companion $this, RuleMatch match, TextContent text2) {
            return $this.isKnownLTBug(match, text2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u0011H\u0016J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/grazie/grammar/LanguageToolChecker$Problem;", "Lcom/intellij/grazie/text/TextProblem;", "match", "Lorg/languagetool/rules/RuleMatch;", "lang", "Lcom/intellij/grazie/jlanguage/Lang;", "text", "Lcom/intellij/grazie/text/TextContent;", "testDescription", "", "(Lorg/languagetool/rules/RuleMatch;Lcom/intellij/grazie/jlanguage/Lang;Lcom/intellij/grazie/text/TextContent;Z)V", "getMatch", "()Lorg/languagetool/rules/RuleMatch;", "fitsGroup", "group", "Lcom/intellij/grazie/text/RuleGroup;", "getDescriptionTemplate", "", "isOnTheFly", "getPatternRange", "Lcom/intellij/openapi/util/TextRange;", "getShortMessage", "getSuggestions", "", "Lcom/intellij/grazie/text/TextProblem$Suggestion;", "getTooltipTemplate", "isAbstractCategory", "id", "intellij.grazie.core"})
    @SourceDebugExtension(value={"SMAP\nLanguageToolChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageToolChecker.kt\ncom/intellij/grazie/grammar/LanguageToolChecker$Problem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,315:1\n1549#2:316\n1620#2,3:317\n1747#2,3:320\n*S KotlinDebug\n*F\n+ 1 LanguageToolChecker.kt\ncom/intellij/grazie/grammar/LanguageToolChecker$Problem\n*L\n146#1:316\n146#1:317,3\n167#1:320,3\n*E\n"})
    public static final class Problem
    extends TextProblem {
        @NotNull
        private final RuleMatch match;
        private final boolean testDescription;

        public Problem(@NotNull RuleMatch match, @NotNull Lang lang, @NotNull TextContent text2, boolean testDescription) {
            Intrinsics.checkNotNullParameter((Object)match, (String)"match");
            Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            org.languagetool.rules.Rule rule = match.getRule();
            Intrinsics.checkNotNullExpressionValue((Object)rule, (String)"getRule(...)");
            super((Rule)new LanguageToolRule(lang, rule), text2, new TextRange(match.getFromPos(), match.getToPos()));
            this.match = match;
            this.testDescription = testDescription;
        }

        @NotNull
        public final RuleMatch getMatch() {
            return this.match;
        }

        @Override
        @NotNull
        public String getShortMessage() {
            String string2 = this.match.getShortMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getShortMessage(...)");
            String string3 = UtilsKt.trimToNull(string2);
            if (string3 == null) {
                String string4 = this.match.getRule().getDescription();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getDescription(...)");
                string3 = UtilsKt.trimToNull(string4);
                if (string3 == null) {
                    String string5 = this.match.getRule().getCategory().getName();
                    string3 = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
                }
            }
            return string3;
        }

        @Override
        @NotNull
        public String getDescriptionTemplate(boolean isOnTheFly) {
            String string2;
            if (this.testDescription) {
                String string3 = this.match.getRule().getId();
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getId(...)");
            } else {
                string2 = JLangUtilsKt.getMessageSanitized(this.match);
            }
            return string2;
        }

        @Override
        @NotNull
        public String getTooltipTemplate() {
            return Companion.toTooltipTemplate(this.match);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<TextProblem.Suggestion> getSuggestions() {
            void $this$mapTo$iv$iv;
            List<String> list = this.match.getSuggestedReplacements();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getSuggestedReplacements(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TextProblem.Suggestion.replace(this.getHighlightRanges().get(0), (CharSequence)it));
            }
            return (List)destination$iv$iv;
        }

        @Override
        @NotNull
        public TextRange getPatternRange() {
            return new TextRange(this.match.getPatternFromPos(), this.match.getPatternToPos());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean fitsGroup(@NotNull RuleGroup group) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            TextRange highlightRange = this.getHighlightRanges().get(0);
            String ruleId = this.match.getRule().getId();
            if (group.getRules().contains("INCOMPLETE_SENTENCE")) {
                if (highlightRange.getStartOffset() == 0) {
                    if (Intrinsics.areEqual((Object)ruleId, (Object)"SENTENCE_FRAGMENT")) return true;
                    if (Intrinsics.areEqual((Object)ruleId, (Object)"SENT_START_CONJUNCTIVE_LINKING_ADVERB_COMMA")) return true;
                    if (Intrinsics.areEqual((Object)ruleId, (Object)"AGREEMENT_SENT_START")) {
                        return true;
                    }
                }
                if (Intrinsics.areEqual((Object)ruleId, (Object)"MASS_AGREEMENT") && StringsKt.startsWith$default((CharSequence)this.getText().subSequence(highlightRange.getEndOffset(), this.getText().length()), (CharSequence)".", (boolean)false, (int)2, null)) {
                    return true;
                }
            }
            if (group.getRules().contains("UNDECORATED_SENTENCE_SEPARATION") && sentenceSeparationRules.contains(ruleId)) {
                return true;
            }
            if (super.fitsGroup(group)) return true;
            Iterable $this$any$iv = group.getRules();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                String id = (String)element$iv;
                boolean bl2 = false;
                if (this.isAbstractCategory(id) && Intrinsics.areEqual((Object)ruleId, (Object)id)) {
                    return true;
                }
                bl = false;
            } while (!bl);
            return true;
        }

        private final boolean isAbstractCategory(String id) {
            return Intrinsics.areEqual((Object)id, (Object)"PUNCTUATION_PARAGRAPH_END") || Intrinsics.areEqual((Object)id, (Object)"UPPERCASE_SENTENCE_START") || Intrinsics.areEqual((Object)id, (Object)"UNLIKELY_OPENING_PUNCTUATION");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/grazie/grammar/LanguageToolChecker$TestChecker;", "Lcom/intellij/grazie/grammar/LanguageToolChecker;", "()V", "intellij.grazie.core"})
    public static final class TestChecker
    extends LanguageToolChecker {
    }
}

