/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.spi.connector.transport;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aether.spi.connector.transport.TransportListener;
import org.eclipse.aether.spi.connector.transport.TransportTask;

public final class GetTask
extends TransportTask {
    private File dataFile;
    private boolean resume;
    private ByteArrayOutputStream dataBytes;
    private Map<String, String> checksums = Collections.emptyMap();

    public GetTask(URI location) {
        this.setLocation(location);
    }

    public OutputStream newOutputStream() throws IOException {
        return this.newOutputStream(false);
    }

    public OutputStream newOutputStream(boolean resume2) throws IOException {
        if (this.dataFile != null) {
            return new FileOutputStream(this.dataFile, this.resume && resume2);
        }
        if (this.dataBytes == null) {
            this.dataBytes = new ByteArrayOutputStream(1024);
        } else if (!resume2) {
            this.dataBytes.reset();
        }
        return this.dataBytes;
    }

    public File getDataFile() {
        return this.dataFile;
    }

    public GetTask setDataFile(File dataFile) {
        return this.setDataFile(dataFile, false);
    }

    public GetTask setDataFile(File dataFile, boolean resume2) {
        this.dataFile = dataFile;
        this.resume = resume2;
        return this;
    }

    public long getResumeOffset() {
        if (this.resume) {
            if (this.dataFile != null) {
                return this.dataFile.length();
            }
            if (this.dataBytes != null) {
                return this.dataBytes.size();
            }
        }
        return 0L;
    }

    public byte[] getDataBytes() {
        if (this.dataFile != null || this.dataBytes == null) {
            return EMPTY;
        }
        return this.dataBytes.toByteArray();
    }

    public String getDataString() {
        if (this.dataFile != null || this.dataBytes == null) {
            return "";
        }
        return new String(this.dataBytes.toByteArray(), StandardCharsets.UTF_8);
    }

    @Override
    public GetTask setListener(TransportListener listener) {
        super.setListener(listener);
        return this;
    }

    public Map<String, String> getChecksums() {
        return this.checksums;
    }

    public GetTask setChecksum(String algorithm, String value) {
        if (algorithm != null) {
            if (this.checksums.isEmpty()) {
                this.checksums = new HashMap<String, String>();
            }
            if (value != null && value.length() > 0) {
                this.checksums.put(algorithm, value);
            } else {
                this.checksums.remove(algorithm);
            }
        }
        return this;
    }

    public String toString() {
        return "<< " + this.getLocation();
    }
}

