/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyAccessToStaticFieldLockedOnInstanceInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = GroovyBundle.message("inspection.message.access.to.static.field.locked.on.instance.data", new Object[0]);
        if (string == null) {
            GroovyAccessToStaticFieldLockedOnInstanceInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/threading/GroovyAccessToStaticFieldLockedOnInstanceInspection", "buildErrorString"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitReferenceExpression(@NotNull GrReferenceExpression expression) {
            GrSynchronizedStatement syncStatement;
            if (expression == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitReferenceExpression(expression);
            boolean isLockedOnInstance = false;
            boolean isLockedOnClass = false;
            GrMethod containingMethod = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, GrMethod.class);
            if (containingMethod != null && containingMethod.hasModifierProperty("synchronized")) {
                if (containingMethod.hasModifierProperty("static")) {
                    isLockedOnClass = true;
                } else {
                    isLockedOnInstance = true;
                }
            }
            GrStatement elementToCheck = expression;
            while ((syncStatement = (GrSynchronizedStatement)PsiTreeUtil.getParentOfType((PsiElement)elementToCheck, GrSynchronizedStatement.class)) != null) {
                GrReferenceExpression reference;
                PsiElement referent;
                GrExpression lockExpression = syncStatement.getMonitor();
                if (lockExpression instanceof GrReferenceExpression && PsiUtil.isThisReference(lockExpression)) {
                    isLockedOnInstance = true;
                } else if (lockExpression instanceof GrReferenceExpression && (referent = (reference = (GrReferenceExpression)lockExpression).resolve()) instanceof PsiField) {
                    PsiField referentField = (PsiField)referent;
                    if (referentField.hasModifierProperty("static")) {
                        isLockedOnClass = true;
                    } else {
                        isLockedOnInstance = true;
                    }
                }
                elementToCheck = syncStatement;
            }
            if (!isLockedOnInstance || isLockedOnClass) {
                return;
            }
            PsiElement referent = expression.resolve();
            if (!(referent instanceof PsiField)) {
                return;
            }
            PsiField referredField = (PsiField)referent;
            if (!referredField.hasModifierProperty("static") || Visitor.isConstant(referredField)) {
                return;
            }
            PsiClass containingClass = referredField.getContainingClass();
            if (!PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)expression, (boolean)false)) {
                return;
            }
            this.registerError(expression);
        }

        private static boolean isConstant(PsiField field) {
            return field.hasModifierProperty("final");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/threading/GroovyAccessToStaticFieldLockedOnInstanceInspection$Visitor", "visitReferenceExpression"));
        }
    }
}

