/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.variable;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.util.LinkedHashSet;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceDialog;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.variable.GrVariableNameSuggester;
import org.jetbrains.plugins.groovy.refactoring.introduce.variable.GroovyIntroduceVariableSettings;
import org.jetbrains.plugins.groovy.refactoring.ui.GrTypeComboBox;
import org.jetbrains.plugins.groovy.settings.GroovyApplicationSettings;

public class GroovyIntroduceVariableDialog
extends DialogWrapper
implements GrIntroduceDialog<GroovyIntroduceVariableSettings> {
    private final Project myProject;
    private final GrExpression myExpression;
    private final int myOccurrencesCount;
    private final GrIntroduceHandlerBase.Validator myValidator;
    private final GrIntroduceContext myContext;
    private NameSuggestionsField myNameField;
    private JCheckBox myCbIsFinal;
    private JCheckBox myCbReplaceAllOccurrences;
    private GrTypeComboBox myTypeComboBox;

    public GroovyIntroduceVariableDialog(GrIntroduceContext context, GrIntroduceHandlerBase.Validator validator) {
        super(context.getProject(), true);
        this.myContext = context;
        this.myProject = context.getProject();
        this.myExpression = context.getStringPart() != null ? context.getStringPart().getLiteral() : context.getExpression();
        this.myOccurrencesCount = context.getOccurrences().length;
        this.myValidator = validator;
        this.init();
    }

    protected void init() {
        super.init();
        this.setModal(true);
        this.setTitle(GroovyRefactoringBundle.message("introduce.variable.title", new Object[0]));
        this.myCbReplaceAllOccurrences.setFocusable(false);
        this.myCbIsFinal.setFocusable(false);
        this.myCbIsFinal.setSelected(GroovyApplicationSettings.getInstance().INTRODUCE_LOCAL_CREATE_FINALS);
        if (this.myOccurrencesCount > 1) {
            this.myCbReplaceAllOccurrences.setSelected(false);
            this.myCbReplaceAllOccurrences.setEnabled(true);
            this.myCbReplaceAllOccurrences.setText(UIUtil.replaceMnemonicAmpersand((String)GroovyBundle.message("introduce.variable.replace.all.0.occurrences", this.myOccurrencesCount)));
        } else {
            this.myCbReplaceAllOccurrences.setSelected(false);
            this.myCbReplaceAllOccurrences.setEnabled(false);
        }
        this.pack();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add((Component)this.createNamePanel(), "Center");
        contentPane.add((Component)this.createCBPanel(), "South");
        return contentPane;
    }

    protected ValidationInfo doValidate() {
        String text = this.getEnteredName();
        if (!GroovyNamesUtil.isIdentifier(text)) {
            return new ValidationInfo(GroovyRefactoringBundle.message("name.is.wrong", text), (JComponent)this.myNameField);
        }
        return null;
    }

    private JPanel createCBPanel() {
        JPanel panel = new JPanel(new FlowLayout());
        this.myCbIsFinal = new JCheckBox(UIUtil.replaceMnemonicAmpersand((String)GroovyBundle.message("introduce.variable.declare.final.label", new Object[0])));
        panel.add(this.myCbIsFinal);
        this.myCbReplaceAllOccurrences = new JCheckBox(UIUtil.replaceMnemonicAmpersand((String)GroovyBundle.message("introduce.variable.replace.all.occurrences", new Object[0])));
        panel.add(this.myCbReplaceAllOccurrences);
        return panel;
    }

    private JPanel createNamePanel() {
        GridBag c = new GridBag().setDefaultAnchor(17).setDefaultInsets(1, 1, 1, 1);
        JPanel namePanel = new JPanel(new GridBagLayout());
        JLabel typeLabel = new JLabel(UIUtil.replaceMnemonicAmpersand((String)GroovyBundle.message("introduce.variable.type.label", new Object[0])));
        c.nextLine().next().weightx(0.0).fillCellNone();
        namePanel.add((Component)typeLabel, c);
        this.myTypeComboBox = GrTypeComboBox.createTypeComboBoxFromExpression(this.myExpression, GroovyApplicationSettings.getInstance().INTRODUCE_LOCAL_SELECT_DEF);
        c.next().weightx(1.0).fillCellHorizontally();
        namePanel.add((Component)((Object)this.myTypeComboBox), c);
        typeLabel.setLabelFor((Component)((Object)this.myTypeComboBox));
        JLabel nameLabel = new JLabel(UIUtil.replaceMnemonicAmpersand((String)GroovyBundle.message("introduce.variable.name.label", new Object[0])));
        c.nextLine().next().weightx(0.0).fillCellNone();
        namePanel.add((Component)nameLabel, c);
        this.myNameField = this.setUpNameComboBox();
        c.next().weightx(1.0).fillCellHorizontally();
        namePanel.add((Component)this.myNameField, c);
        nameLabel.setLabelFor((Component)this.myNameField);
        GrTypeComboBox.registerUpDownHint((JComponent)this.myNameField, this.myTypeComboBox);
        return namePanel;
    }

    @Nullable
    protected String getEnteredName() {
        return this.myNameField.getEnteredName();
    }

    protected boolean isReplaceAllOccurrences() {
        return this.myCbReplaceAllOccurrences.isSelected();
    }

    private boolean isDeclareFinal() {
        return this.myCbIsFinal.isSelected();
    }

    @Nullable
    private PsiType getSelectedType() {
        return this.myTypeComboBox.getSelectedType();
    }

    private NameSuggestionsField setUpNameComboBox() {
        LinkedHashSet<String> names = this.suggestNames();
        return new NameSuggestionsField(ArrayUtilRt.toStringArray(names), this.myProject, (FileType)GroovyFileType.GROOVY_FILE_TYPE);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    protected void doOKAction() {
        if (!this.myValidator.isOK(this)) {
            return;
        }
        if (this.myCbIsFinal.isEnabled()) {
            GroovyApplicationSettings.getInstance().INTRODUCE_LOCAL_CREATE_FINALS = this.myCbIsFinal.isSelected();
        }
        GroovyApplicationSettings.getInstance().INTRODUCE_LOCAL_SELECT_DEF = this.myTypeComboBox.getSelectedType() == null;
        super.doOKAction();
    }

    protected String getHelpId() {
        return "refactoring.introduceVariable";
    }

    private void createUIComponents() {
    }

    @Override
    public GroovyIntroduceVariableSettings getSettings() {
        return new MyGroovyIntroduceVariableSettings(this);
    }

    @Override
    @NotNull
    public LinkedHashSet<String> suggestNames() {
        LinkedHashSet<String> linkedHashSet = new GrVariableNameSuggester(this.myContext, this.myValidator).suggestNames();
        if (linkedHashSet == null) {
            GroovyIntroduceVariableDialog.$$$reportNull$$$0(0);
        }
        return linkedHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/variable/GroovyIntroduceVariableDialog", "suggestNames"));
    }

    private static class MyGroovyIntroduceVariableSettings
    implements GroovyIntroduceVariableSettings {
        String myEnteredName;
        boolean myIsReplaceAllOccurrences;
        boolean myIsDeclareFinal;
        PsiType mySelectedType;

        MyGroovyIntroduceVariableSettings(GroovyIntroduceVariableDialog dialog) {
            this.myEnteredName = dialog.getEnteredName();
            this.myIsReplaceAllOccurrences = dialog.isReplaceAllOccurrences();
            this.myIsDeclareFinal = dialog.isDeclareFinal();
            this.mySelectedType = dialog.getSelectedType();
        }

        @Override
        public String getName() {
            return this.myEnteredName;
        }

        @Override
        public boolean replaceAllOccurrences() {
            return this.myIsReplaceAllOccurrences;
        }

        @Override
        public boolean isDeclareFinal() {
            return this.myIsDeclareFinal;
        }

        @Override
        public PsiType getSelectedType() {
            return this.mySelectedType;
        }
    }
}

