/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.artifact;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.artifact.DirectoryArtifactType;
import org.jetbrains.jps.model.artifact.JarArtifactType;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.JpsArtifactService;
import org.jetbrains.jps.model.artifact.JpsArtifactType;
import org.jetbrains.jps.model.artifact.elements.JpsArchivePackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsArtifactOutputPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsArtifactRootElement;
import org.jetbrains.jps.model.artifact.elements.JpsCompositePackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsDirectoryCopyPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsDirectoryPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsExtractedDirectoryPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsFileCopyPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsLibraryFilesPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElementFactory;
import org.jetbrains.jps.model.module.JpsModuleReference;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.artifact.ArtifactPropertiesState;
import org.jetbrains.jps.model.serialization.artifact.ArtifactState;
import org.jetbrains.jps.model.serialization.artifact.JpsArtifactDummyPropertiesSerializer;
import org.jetbrains.jps.model.serialization.artifact.JpsArtifactExtensionSerializer;
import org.jetbrains.jps.model.serialization.artifact.JpsArtifactPropertiesSerializer;
import org.jetbrains.jps.model.serialization.artifact.JpsPackagingElementSerializer;
import org.jetbrains.jps.model.serialization.library.JpsLibraryTableSerializer;

public final class JpsArtifactSerializer {
    private static final JpsPackagingElementSerializer<?>[] STANDARD_SERIALIZERS = new JpsPackagingElementSerializer[]{new ArtifactRootElementSerializer(), new DirectoryElementSerializer(), new ArchiveElementSerializer(), new FileCopyElementSerializer(), new DirectoryCopyElementSerializer(), new ExtractedDirectoryElementSerializer(), new LibraryFilesElementSerializer(), new ArtifactOutputElementSerializer()};
    private static final JpsArtifactPropertiesSerializer<?>[] STANDARD_TYPE_SERIALIZERS = new JpsArtifactPropertiesSerializer[]{new JpsArtifactDummyPropertiesSerializer("plain", DirectoryArtifactType.INSTANCE), new JpsArtifactDummyPropertiesSerializer("jar", JarArtifactType.INSTANCE)};
    private static final String ELEMENT_TAG = "element";
    private static final String ID_ATTRIBUTE = "id";

    public static void loadArtifacts(@NotNull JpsProject project, @Nullable Element componentElement) {
        if (project == null) {
            JpsArtifactSerializer.$$$reportNull$$$0(0);
        }
        JpsArtifactService service = JpsArtifactService.getInstance();
        for (Element artifactElement : JDOMUtil.getChildren((Element)componentElement, (String)"artifact")) {
            ArtifactState state = (ArtifactState)XmlSerializer.deserialize((Element)artifactElement, ArtifactState.class);
            JpsArtifactPropertiesSerializer<?> serializer = JpsArtifactSerializer.getTypePropertiesSerializer(state.getArtifactType());
            JpsArtifactSerializer.loadArtifact(project, service, state, serializer);
        }
    }

    private static <P extends JpsElement> void loadArtifact(JpsProject project, JpsArtifactService service, ArtifactState state, JpsArtifactPropertiesSerializer<P> serializer) {
        JpsPackagingElement rootElement = JpsArtifactSerializer.loadPackagingElement(state.getRootElement());
        if (rootElement != null) {
            List<ArtifactPropertiesState> propertiesList = state.getPropertiesList();
            JpsArtifact artifact = service.addArtifact(project, state.getName(), (JpsCompositePackagingElement)rootElement, (JpsArtifactType)serializer.getType(), serializer.loadProperties(propertiesList));
            artifact.setBuildOnMake(state.isBuildOnMake());
            artifact.setOutputPath(state.getOutputPath());
            for (ArtifactPropertiesState propertiesState : propertiesList) {
                JpsArtifactExtensionSerializer<?> extensionSerializer = JpsArtifactSerializer.getExtensionSerializer(propertiesState.getId());
                if (extensionSerializer == null) continue;
                JpsArtifactSerializer.loadExtension(extensionSerializer, artifact, propertiesState.getOptions());
            }
        }
    }

    private static <E extends JpsElement> void loadExtension(JpsArtifactExtensionSerializer<E> serializer, JpsArtifact artifact, Element options) {
        E e = serializer.loadExtension(options);
        artifact.getContainer().setChild(serializer.getRole(), e);
    }

    @Nullable
    private static JpsPackagingElement loadPackagingElement(Element element) {
        JpsPackagingElement packagingElement = JpsArtifactSerializer.createPackagingElement(element);
        if (packagingElement instanceof JpsCompositePackagingElement) {
            for (Element childElement : JDOMUtil.getChildren((Element)element, (String)ELEMENT_TAG)) {
                JpsPackagingElement child = JpsArtifactSerializer.loadPackagingElement(childElement);
                if (child == null) continue;
                ((JpsCompositePackagingElement)packagingElement).addChild(child);
            }
        }
        return packagingElement;
    }

    @Nullable
    private static JpsPackagingElement createPackagingElement(Element element) {
        String typeId = element.getAttributeValue(ID_ATTRIBUTE);
        if (typeId == null) {
            return null;
        }
        JpsPackagingElementSerializer<?> serializer = JpsArtifactSerializer.findElementSerializer(typeId);
        if (serializer != null) {
            return serializer.load(element);
        }
        return null;
    }

    @Nullable
    private static JpsPackagingElementSerializer<?> findElementSerializer(@NotNull String typeId) {
        if (typeId == null) {
            JpsArtifactSerializer.$$$reportNull$$$0(1);
        }
        for (JpsPackagingElementSerializer<?> serializer : STANDARD_SERIALIZERS) {
            if (!serializer.getTypeId().equals(typeId)) continue;
            return serializer;
        }
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsPackagingElementSerializer<?> serializer : extension.getPackagingElementSerializers()) {
                if (!serializer.getTypeId().equals(typeId)) continue;
                return serializer;
            }
        }
        return null;
    }

    @Nullable
    private static JpsArtifactExtensionSerializer<?> getExtensionSerializer(String id) {
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsArtifactExtensionSerializer<?> serializer : extension.getArtifactExtensionSerializers()) {
                if (!serializer.getId().equals(id)) continue;
                return serializer;
            }
        }
        return null;
    }

    private static JpsArtifactPropertiesSerializer<?> getTypePropertiesSerializer(String typeId) {
        for (JpsArtifactPropertiesSerializer<?> serializer : STANDARD_TYPE_SERIALIZERS) {
            if (!serializer.getTypeId().equals(typeId)) continue;
            return serializer;
        }
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsArtifactPropertiesSerializer<?> serializer : extension.getArtifactTypePropertiesSerializers()) {
                if (!serializer.getTypeId().equals(typeId)) continue;
                return serializer;
            }
        }
        return STANDARD_TYPE_SERIALIZERS[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeId";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/model/serialization/artifact/JpsArtifactSerializer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadArtifacts";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementSerializer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ArtifactRootElementSerializer
    extends JpsPackagingElementSerializer<JpsArtifactRootElement> {
        ArtifactRootElementSerializer() {
            super("root", JpsArtifactRootElement.class);
        }

        @Override
        public JpsArtifactRootElement load(Element element) {
            return JpsPackagingElementFactory.getInstance().createArtifactRoot();
        }
    }

    private static class DirectoryElementSerializer
    extends JpsPackagingElementSerializer<JpsDirectoryPackagingElement> {
        DirectoryElementSerializer() {
            super("directory", JpsDirectoryPackagingElement.class);
        }

        @Override
        public JpsDirectoryPackagingElement load(Element element) {
            return JpsPackagingElementFactory.getInstance().createDirectory(element.getAttributeValue("name"));
        }
    }

    private static class ArchiveElementSerializer
    extends JpsPackagingElementSerializer<JpsArchivePackagingElement> {
        ArchiveElementSerializer() {
            super("archive", JpsArchivePackagingElement.class);
        }

        @Override
        public JpsArchivePackagingElement load(Element element) {
            return JpsPackagingElementFactory.getInstance().createArchive(element.getAttributeValue("name"));
        }
    }

    private static class FileCopyElementSerializer
    extends JpsPackagingElementSerializer<JpsFileCopyPackagingElement> {
        FileCopyElementSerializer() {
            super("file-copy", JpsFileCopyPackagingElement.class);
        }

        @Override
        public JpsFileCopyPackagingElement load(Element element) {
            return JpsPackagingElementFactory.getInstance().createFileCopy(element.getAttributeValue("path"), element.getAttributeValue("output-file-name"));
        }
    }

    private static class DirectoryCopyElementSerializer
    extends JpsPackagingElementSerializer<JpsDirectoryCopyPackagingElement> {
        DirectoryCopyElementSerializer() {
            super("dir-copy", JpsDirectoryCopyPackagingElement.class);
        }

        @Override
        public JpsDirectoryCopyPackagingElement load(Element element) {
            return JpsPackagingElementFactory.getInstance().createDirectoryCopy(element.getAttributeValue("path"));
        }
    }

    private static class ExtractedDirectoryElementSerializer
    extends JpsPackagingElementSerializer<JpsExtractedDirectoryPackagingElement> {
        ExtractedDirectoryElementSerializer() {
            super("extracted-dir", JpsExtractedDirectoryPackagingElement.class);
        }

        @Override
        public JpsExtractedDirectoryPackagingElement load(Element element) {
            return JpsPackagingElementFactory.getInstance().createExtractedDirectory(element.getAttributeValue("path"), element.getAttributeValue("path-in-jar"));
        }
    }

    private static class LibraryFilesElementSerializer
    extends JpsPackagingElementSerializer<JpsLibraryFilesPackagingElement> {
        LibraryFilesElementSerializer() {
            super("library", JpsLibraryFilesPackagingElement.class);
        }

        @Override
        public JpsLibraryFilesPackagingElement load(Element element) {
            String level = element.getAttributeValue("level");
            String libraryName = element.getAttributeValue("name");
            String moduleName = element.getAttributeValue("module-name");
            JpsModuleReference parentReference = moduleName != null ? JpsElementFactory.getInstance().createModuleReference(moduleName) : JpsLibraryTableSerializer.createLibraryTableReference(level);
            return JpsPackagingElementFactory.getInstance().createLibraryElement(JpsElementFactory.getInstance().createLibraryReference(libraryName, parentReference));
        }
    }

    private static class ArtifactOutputElementSerializer
    extends JpsPackagingElementSerializer<JpsArtifactOutputPackagingElement> {
        ArtifactOutputElementSerializer() {
            super("artifact", JpsArtifactOutputPackagingElement.class);
        }

        @Override
        public JpsArtifactOutputPackagingElement load(Element element) {
            return JpsPackagingElementFactory.getInstance().createArtifactOutput(JpsArtifactService.getInstance().createReference(element.getAttributeValue("artifact-name")));
        }
    }
}

