/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.toc;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.editor.toc.GenerateTableOfContentsAction;
import org.intellij.plugins.markdown.editor.toc.GenerateTableOfContentsAction$Companion$collectHeaders$;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.intellij.plugins.markdown.ui.actions.MarkdownActionPlaces;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/intellij/plugins/markdown/editor/toc/GenerateTableOfContentsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "Companion", "intellij.markdown.core"})
public final class GenerateTableOfContentsAction
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NlsSafe
    @NotNull
    private static final String sectionDelimiter = "<!-- TOC -->";

    public GenerateTableOfContentsAction() {
        this.addTextOverride(MarkdownActionPlaces.getINSERT_POPUP(), GenerateTableOfContentsAction::_init_$lambda$0);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object = event.getRequiredData(CommonDataKeys.PSI_FILE);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile");
        MarkdownFile file = (MarkdownFile)object;
        Object object2 = event.getRequiredData(CommonDataKeys.EDITOR);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getRequiredData(...)");
        Editor editor2 = (Editor)object2;
        String content2 = Companion.obtainToc(file);
        int caretOffset = editor2.getCaretModel().getPrimaryCaret().getOffset();
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        List existingRanges = SequencesKt.toList(Companion.findExistingTocs(file));
        ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(project, editor2, (List<? extends TextRange>)existingRanges, caretOffset, content2){
            final /* synthetic */ Project $project;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ List<TextRange> $existingRanges;
            final /* synthetic */ int $caretOffset;
            final /* synthetic */ String $content;
            {
                this.$project = $project;
                this.$editor = $editor;
                this.$existingRanges = $existingRanges;
                this.$caretOffset = $caretOffset;
                this.$content = $content;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void project$iv;
                Project project = this.$project;
                Editor editor2 = this.$editor;
                List<TextRange> list2 = this.$existingRanges;
                int n = this.$caretOffset;
                String string = this.$content;
                String name$iv = null;
                Object groupId$iv = null;
                boolean $i$f$executeCommand = false;
                CommandProcessor.getInstance().executeCommand((Project)project$iv, new Runnable(editor2, list2, n, string){
                    final /* synthetic */ Editor $editor$inlined;
                    final /* synthetic */ List $existingRanges$inlined;
                    final /* synthetic */ int $caretOffset$inlined;
                    final /* synthetic */ String $content$inlined;
                    {
                        this.$editor$inlined = editor2;
                        this.$existingRanges$inlined = list2;
                        this.$caretOffset$inlined = n;
                        this.$content$inlined = string;
                    }

                    public final void run() {
                        boolean bl = false;
                        Document document = this.$editor$inlined.getDocument();
                        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                        Document document2 = document;
                        if (CollectionsKt.none((Iterable)this.$existingRanges$inlined)) {
                            document2.insertString(this.$caretOffset$inlined, (CharSequence)this.$content$inlined);
                        } else {
                            Iterable $this$forEach$iv = CollectionsKt.asReversed((List)this.$existingRanges$inlined);
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                TextRange it = (TextRange)element$iv;
                                boolean bl2 = false;
                                org.intellij.plugins.markdown.editor.toc.GenerateTableOfContentsAction$Companion.access$replaceString(GenerateTableOfContentsAction.Companion, document2, it, this.$content$inlined);
                            }
                        }
                    }
                }, name$iv, groupId$iv);
            }
        }));
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object = event.getData(CommonDataKeys.PSI_FILE);
        MarkdownFile file = object instanceof MarkdownFile ? (MarkdownFile)object : null;
        Editor editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
        if (file == null || editor2 == null) {
            event.getPresentation().setEnabled(false);
            return;
        }
        if (SequencesKt.any(Companion.findExistingTocs(file))) {
            event.getPresentation().setText(MarkdownBundle.message("action.Markdown.GenerateTableOfContents.update.text", new Object[0]));
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private static final String _init_$lambda$0() {
        return MarkdownBundle.message("action.Markdown.GenerateTableOfContents.insert.popup.text", new Object[0]);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\u0013\u001a\u00020\u0014*\u00060\u0015j\u0002`\u00162\u0006\u0010\u0017\u001a\u00020\nH\u0002J\u001c\u0010\u0018\u001a\u00020\u0014*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0004H\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/intellij/plugins/markdown/editor/toc/GenerateTableOfContentsAction$Companion;", "", "()V", "sectionDelimiter", "", "buildToc", "file", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownFile;", "collectHeaders", "Lkotlin/sequences/Sequence;", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeader;", "collectTopLevelElements", "Lcom/intellij/psi/PsiElement;", "findExistingTocs", "Lcom/intellij/openapi/util/TextRange;", "isTocBlock", "", "element", "obtainToc", "appendHeader", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "header", "replaceString", "Lcom/intellij/openapi/editor/Document;", "range", "replacement", "intellij.markdown.core"})
    @SourceDebugExtension(value={"SMAP\nGenerateTableOfContentsAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateTableOfContentsAction.kt\norg/intellij/plugins/markdown/editor/toc/GenerateTableOfContentsAction$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,132:1\n1#2:133\n473#3:134\n*S KotlinDebug\n*F\n+ 1 GenerateTableOfContentsAction.kt\norg/intellij/plugins/markdown/editor/toc/GenerateTableOfContentsAction$Companion\n*L\n115#1:134\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void replaceString(Document $this$replaceString, TextRange range, String replacement) {
            $this$replaceString.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)replacement);
        }

        @NotNull
        public final Sequence<TextRange> findExistingTocs(@NotNull MarkdownFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Sequence<PsiElement> elements2 = this.collectTopLevelElements(file);
            Sequence blockElements2 = SequencesKt.windowed$default((Sequence)SequencesKt.filter(elements2, (Function1)((Function1)new Function1<PsiElement, Boolean>((Object)this){

                @NotNull
                public final Boolean invoke(@NotNull PsiElement p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return org.intellij.plugins.markdown.editor.toc.GenerateTableOfContentsAction$Companion.access$isTocBlock((Companion)this.receiver, p0);
                }
            })), (int)2, (int)2, (boolean)false, (int)4, null);
            return SequencesKt.map((Sequence)blockElements2, (Function1)findExistingTocs.1.INSTANCE);
        }

        private final boolean isTocBlock(PsiElement element2) {
            block2: {
                Object object;
                block4: {
                    block3: {
                        PsiElement psiElement;
                        IElementType iElementType = MarkdownElementTypes.HTML_BLOCK;
                        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"HTML_BLOCK");
                        if (!PsiUtilsKt.hasType(element2, iElementType)) break block2;
                        object = element2.getFirstChild();
                        if (object == null) break block3;
                        PsiElement it = psiElement = object;
                        boolean bl = false;
                        IElementType iElementType2 = MarkdownTokenTypes.HTML_BLOCK_CONTENT;
                        Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"HTML_BLOCK_CONTENT");
                        object = PsiUtilsKt.hasType(it, iElementType2) ? psiElement : null;
                        if (object != null) break block4;
                    }
                    return false;
                }
                PsiElement child2 = object;
                return child2.textMatches((CharSequence)GenerateTableOfContentsAction.sectionDelimiter);
            }
            return false;
        }

        private final String buildToc(MarkdownFile file) {
            StringBuilder stringBuilder;
            Sequence<MarkdownHeader> headers2 = this.collectHeaders(file);
            StringBuilder $this$buildToc_u24lambda_u241 = stringBuilder = new StringBuilder();
            boolean bl = false;
            StringBuilder stringBuilder2 = $this$buildToc_u24lambda_u241.append(GenerateTableOfContentsAction.sectionDelimiter);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
            for (MarkdownHeader header : headers2) {
                Companion.appendHeader($this$buildToc_u24lambda_u241, header);
                Intrinsics.checkNotNullExpressionValue((Object)$this$buildToc_u24lambda_u241.append('\n'), (String)"append('\\n')");
            }
            $this$buildToc_u24lambda_u241.append(GenerateTableOfContentsAction.sectionDelimiter);
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        @NotNull
        public final String obtainToc(@NotNull MarkdownFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)file), () -> Companion.obtainToc$lambda$2(file));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
            return (String)object;
        }

        private final Sequence<PsiElement> collectTopLevelElements(MarkdownFile file) {
            PsiElement psiElement = file.getFirstChild();
            Sequence elements2 = psiElement != null ? PsiTreeUtilKt.siblings((PsiElement)psiElement, (boolean)true, (boolean)true) : null;
            Sequence sequence = elements2;
            if (sequence == null) {
                sequence = SequencesKt.emptySequence();
            }
            return sequence;
        }

        private final Sequence<MarkdownHeader> collectHeaders(MarkdownFile file) {
            Sequence<PsiElement> topLevelElements;
            Sequence<PsiElement> $this$filterIsInstance$iv = topLevelElements = this.collectTopLevelElements(file);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter($this$filterIsInstance$iv, (Function1)Companion$collectHeaders$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            return sequence;
        }

        private final void appendHeader(StringBuilder $this$appendHeader, MarkdownHeader header) {
            String string = header.buildVisibleText(false);
            if (string == null) {
                return;
            }
            String text2 = string;
            String string2 = header.getAnchorText();
            if (string2 == null) {
                return;
            }
            String reference = string2;
            int n = header.getLevel() - 1;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                $this$appendHeader.append("  ");
            }
            $this$appendHeader.append("* [");
            $this$appendHeader.append(text2);
            $this$appendHeader.append("](#");
            $this$appendHeader.append(reference);
            $this$appendHeader.append(")");
        }

        private static final CachedValueProvider.Result obtainToc$lambda$2(MarkdownFile $file) {
            Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
            Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
            return CachedValueProvider.Result.create((Object)Companion.buildToc($file), (Object[])objectArray);
        }

        public static final /* synthetic */ void access$replaceString(Companion $this, Document $receiver, TextRange range, String replacement) {
            $this.replaceString($receiver, range, replacement);
        }

        public static final /* synthetic */ boolean access$isTocBlock(Companion $this, PsiElement element2) {
            return $this.isTocBlock(element2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

