/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.references.headers;

import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceProviderBase;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkDestination;
import org.intellij.plugins.markdown.lang.references.headers.HeaderAnchorPathReferenceProvider$findFileReference$;
import org.intellij.plugins.markdown.lang.references.headers.HeaderAnchorReference;
import org.intellij.plugins.markdown.lang.references.paths.FileWithoutExtensionReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J:\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\tH\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00110\u0010H\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u0018"}, d2={"Lorg/intellij/plugins/markdown/lang/references/headers/HeaderAnchorPathReferenceProvider;", "Lcom/intellij/openapi/paths/PathReferenceProviderBase;", "()V", "calculateAnchorTextRange", "Lcom/intellij/openapi/util/TextRange;", "elementText", "", "valueTextRange", "createReferences", "", "element", "Lcom/intellij/psi/PsiElement;", "offset", "", "text", "references", "", "Lcom/intellij/psi/PsiReference;", "soft", "findFileReference", "alreadyCreatedReferences", "getPathReference", "Lcom/intellij/openapi/paths/PathReference;", "path", "intellij.markdown.core"})
@SourceDebugExtension(value={"SMAP\nHeaderAnchorPathReferenceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeaderAnchorPathReferenceProvider.kt\norg/intellij/plugins/markdown/lang/references/headers/HeaderAnchorPathReferenceProvider\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n473#2:66\n473#2:68\n1#3:67\n*S KotlinDebug\n*F\n+ 1 HeaderAnchorPathReferenceProvider.kt\norg/intellij/plugins/markdown/lang/references/headers/HeaderAnchorPathReferenceProvider\n*L\n38#1:66\n44#1:68\n*E\n"})
public final class HeaderAnchorPathReferenceProvider
extends PathReferenceProviderBase {
    public boolean createReferences(@NotNull PsiElement element2, int offset, @Nullable String text2, @NotNull List<? super PsiReference> references, boolean soft) {
        PsiReference psiReference;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter(references, (String)"references");
        if (!(element2 instanceof MarkdownLinkDestination)) {
            return false;
        }
        TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)element2);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getValueTextRange(...)");
        TextRange range = textRange;
        String elementText = element2.getText();
        Intrinsics.checkNotNull((Object)elementText);
        TextRange textRange2 = this.calculateAnchorTextRange(elementText, range);
        if (textRange2 == null) {
            return false;
        }
        TextRange actualTextRange = textRange2;
        String string = actualTextRange.substring(elementText);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String anchor = string2;
        if (actualTextRange.getStartOffset() != range.getStartOffset()) {
            psiReference = this.findFileReference(references);
            if (psiReference == null) {
                return false;
            }
        } else {
            psiReference = null;
        }
        PsiReference fileReference = psiReference;
        references.add((PsiReference)new HeaderAnchorReference((MarkdownLinkDestination)element2, fileReference, anchor, actualTextRange));
        return false;
    }

    private final PsiReference findFileReference(List<? super PsiReference> alreadyCreatedReferences) {
        FileWithoutExtensionReference fileWithoutExtensionReference;
        FileWithoutExtensionReference fileWithoutExtensionReference2;
        FileReference resolvedReference;
        FileReference actualReference;
        FileReference fileReference;
        Sequence references;
        Sequence $this$filterIsInstance$iv = references = CollectionsKt.asSequence((Iterable)alreadyCreatedReferences);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)findFileReference$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        FileReference reference = (FileReference)SequencesKt.firstOrNull((Sequence)sequence);
        FileReference fileReference2 = reference;
        if (fileReference2 == null || (fileReference2 = fileReference2.getFileReferenceSet()) == null || (fileReference2 = fileReference2.getLastReference()) == null) {
            return null;
        }
        FileReference it = fileReference = (actualReference = fileReference2);
        boolean bl = false;
        Object object = resolvedReference = it.resolve() != null ? fileReference : null;
        if (resolvedReference != null) {
            return (PsiReference)resolvedReference;
        }
        Sequence $this$filterIsInstance$iv2 = references;
        boolean $i$f$filterIsInstance2 = false;
        Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv2, (Function1)findFileReference$$inlined$filterIsInstance$2.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        FileWithoutExtensionReference fileWithoutExtensionReference3 = fileWithoutExtensionReference2 = (FileWithoutExtensionReference)((Object)SequencesKt.firstOrNull((Sequence)sequence2));
        if (fileWithoutExtensionReference3 != null) {
            FileWithoutExtensionReference fileWithoutExtensionReference4;
            FileWithoutExtensionReference it2 = fileWithoutExtensionReference4 = fileWithoutExtensionReference3;
            boolean bl2 = false;
            fileWithoutExtensionReference = it2.resolve() != null ? fileWithoutExtensionReference4 : null;
        } else {
            fileWithoutExtensionReference = null;
        }
        return (PsiReference)fileWithoutExtensionReference;
    }

    @Nullable
    public PathReference getPathReference(@NotNull String path, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return null;
    }

    private final TextRange calculateAnchorTextRange(String elementText, TextRange valueTextRange) {
        int anchorOffset = StringsKt.indexOf$default((CharSequence)elementText, (char)'#', (int)0, (boolean)false, (int)6, null);
        if (anchorOffset == -1) {
            return null;
        }
        int endOffset = valueTextRange.getEndOffset();
        int endIndex = endOffset <= anchorOffset ? anchorOffset + 1 : endOffset;
        return new TextRange(anchorOffset + 1, endIndex);
    }
}

