/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.completion.network.status;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.stats.completion.network.UtilsKt;
import com.intellij.stats.completion.network.service.RequestService;
import com.intellij.stats.completion.network.service.ResponseData;
import com.intellij.stats.completion.network.status.WebServiceStatus;
import com.intellij.stats.completion.network.status.bean.AnalyticsPlatformSettings;
import com.intellij.stats.completion.network.status.bean.AnalyticsPlatformSettingsDeserializer;
import com.intellij.stats.completion.network.status.bean.EndpointSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/stats/completion/network/status/AnalyticsPlatformServiceStatus;", "Lcom/intellij/stats/completion/network/status/WebServiceStatus;", "statusUrl", "", "(Ljava/lang/String;)V", "dataServerUrl", "id", "getId", "()Ljava/lang/String;", "isServerOk", "", "requestService", "Lcom/intellij/stats/completion/network/service/RequestService;", "update", "", "Companion", "intellij.statsCollector"})
@SourceDebugExtension(value={"SMAP\nAnalyticsPlatformServiceStatus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyticsPlatformServiceStatus.kt\ncom/intellij/stats/completion/network/status/AnalyticsPlatformServiceStatus\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,54:1\n43#2,3:55\n766#3:58\n857#3,2:59\n10#4:61\n*S KotlinDebug\n*F\n+ 1 AnalyticsPlatformServiceStatus.kt\ncom/intellij/stats/completion/network/status/AnalyticsPlatformServiceStatus\n*L\n24#1:55,3\n41#1:58\n41#1:59,2\n13#1:61\n*E\n"})
public final class AnalyticsPlatformServiceStatus
implements WebServiceStatus {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String statusUrl;
    private volatile boolean isServerOk;
    @NotNull
    private volatile String dataServerUrl;
    @NotNull
    private final RequestService requestService;
    @NotNull
    private final String id;
    @NotNull
    private static final Logger LOG;

    public AnalyticsPlatformServiceStatus(@NotNull String statusUrl) {
        Intrinsics.checkNotNullParameter((Object)statusUrl, (String)"statusUrl");
        this.statusUrl = statusUrl;
        this.dataServerUrl = "";
        boolean $i$f$service = false;
        Class<RequestService> serviceClass$iv = RequestService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        this.requestService = (RequestService)object;
        this.id = "AnalyticsPlatform";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isServerOk() {
        return this.isServerOk;
    }

    @Override
    @NotNull
    public String dataServerUrl() {
        return this.dataServerUrl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update() {
        this.isServerOk = false;
        this.dataServerUrl = "";
        UtilsKt.assertNotEDT();
        ResponseData response = this.requestService.get(this.statusUrl);
        if (response != null && response.isOK()) {
            void $this$filterTo$iv$iv;
            AnalyticsPlatformSettings analyticsPlatformSettings = AnalyticsPlatformSettingsDeserializer.INSTANCE.deserialize(response.getText());
            if (analyticsPlatformSettings == null) {
                return;
            }
            AnalyticsPlatformSettings settings = analyticsPlatformSettings;
            Iterable $this$filter$iv = settings.getVersions();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                EndpointSettings it = (EndpointSettings)element$iv$iv;
                boolean bl = false;
                if (!(it.satisfies() && it.getEndpoint() != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List satisfyingEndpoints = (List)destination$iv$iv;
            if (satisfyingEndpoints.isEmpty()) {
                LOG.debug("Analytics Platform completion web service status. No satisfying endpoints.");
                return;
            }
            if (satisfyingEndpoints.size() > 1) {
                LOG.error("Analytics Platform completion web service status. More than one satisfying endpoints. First one will be used.");
            }
            EndpointSettings endpointSettings = (EndpointSettings)CollectionsKt.first((List)satisfyingEndpoints);
            this.isServerOk = true;
            String string = endpointSettings.getEndpoint();
            Intrinsics.checkNotNull((Object)string);
            this.dataServerUrl = string;
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AnalyticsPlatformServiceStatus.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/stats/completion/network/status/AnalyticsPlatformServiceStatus$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "productCode", "", "withDefaultUrl", "Lcom/intellij/stats/completion/network/status/AnalyticsPlatformServiceStatus;", "intellij.statsCollector"})
    public static final class Companion {
        private Companion() {
        }

        private final String productCode() {
            String string = ApplicationInfo.getInstance().getBuild().getProductCode();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProductCode(...)");
            return string;
        }

        @NotNull
        public final AnalyticsPlatformServiceStatus withDefaultUrl() {
            return new AnalyticsPlatformServiceStatus("https://resources.jetbrains.com/storage/ap/mlcc/config/v1/" + this.productCode() + ".json");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

