/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.completion.network.status;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.stats.completion.network.status.AnalyticsPlatformServiceStatus;
import com.intellij.stats.completion.network.status.WebServiceStatus;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/stats/completion/network/status/WebServiceStatusManager;", "", "()V", "ANALYTICS_PLATFORM_URL_REGISTRY", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "USE_ANALYTICS_PLATFORM_REGISTRY", "statuses", "", "Lcom/intellij/stats/completion/network/status/WebServiceStatus;", "getAllStatuses", "", "register", "", "status", "registerAnalyticsPlatformStatus", "intellij.statsCollector"})
@SourceDebugExtension(value={"SMAP\nWebServiceStatusManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebServiceStatusManager.kt\ncom/intellij/stats/completion/network/status/WebServiceStatusManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,44:1\n10#2:45\n*S KotlinDebug\n*F\n+ 1 WebServiceStatusManager.kt\ncom/intellij/stats/completion/network/status/WebServiceStatusManager\n*L\n10#1:45\n*E\n"})
public final class WebServiceStatusManager {
    @NotNull
    public static final WebServiceStatusManager INSTANCE = new WebServiceStatusManager();
    @NotNull
    private static final String USE_ANALYTICS_PLATFORM_REGISTRY = "completion.stats.analytics.platform.send";
    @NotNull
    private static final String ANALYTICS_PLATFORM_URL_REGISTRY = "completion.stats.analytics.platform.url";
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Map<String, WebServiceStatus> statuses;

    private WebServiceStatusManager() {
    }

    @NotNull
    public final List<WebServiceStatus> getAllStatuses() {
        return CollectionsKt.toList((Iterable)statuses.values());
    }

    private final void registerAnalyticsPlatformStatus() {
        try {
            RegistryValue registryValue = Registry.get((String)ANALYTICS_PLATFORM_URL_REGISTRY);
            Intrinsics.checkNotNullExpressionValue((Object)registryValue, (String)"get(...)");
            RegistryValue registry = registryValue;
            if (registry.isChangedFromDefault()) {
                String string = registry.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                this.register(new AnalyticsPlatformServiceStatus(string));
                return;
            }
        }
        catch (Throwable e) {
            LOG.error("No url for Analytics Platform web status. Set registry: completion.stats.analytics.platform.url");
        }
        this.register(AnalyticsPlatformServiceStatus.Companion.withDefaultUrl());
    }

    private final void register(WebServiceStatus status) {
        WebServiceStatus old = statuses.get(status.getId());
        if (old != null) {
            LOG.warn("Service status with id [" + old.getId() + "] already created.");
            return;
        }
        statuses.put(status.getId(), status);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WebServiceStatusManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        statuses = new LinkedHashMap();
        if (Registry.is((String)USE_ANALYTICS_PLATFORM_REGISTRY, (boolean)false)) {
            INSTANCE.registerAnalyticsPlatformStatus();
        }
    }
}

