/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.completion.tracker;

import com.intellij.codeInsight.completion.BaseCompletionService;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.completion.ml.storage.LookupStorage;
import com.intellij.completion.ml.util.LookupElementExtensionsKt;
import com.intellij.completion.ml.util.RelevanceUtil;
import com.intellij.stats.completion.LookupEntryDiff;
import com.intellij.stats.completion.LookupEntryInfo;
import com.intellij.stats.completion.LookupState;
import com.intellij.util.SlowOperations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 &2\u00020\u0001:\u0001&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00060\u00062\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u001c\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J(\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u0017\u0010\u001b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001c\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J\u0010\u0010 \u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J\u0016\u0010!\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0003J@\u0010\"\u001a\u00020#*\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00060\t2\u0006\u0010$\u001a\u00020\u00072\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J4\u0010%\u001a\b\u0012\u0004\u0012\u00020\f0\u0012*\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\u0006H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/stats/completion/tracker/LookupStateManager;", "", "shouldLogElementFeatures", "", "(Z)V", "currentSessionFactors", "", "", "elementToId", "", "", "idToEntryInfo", "Lcom/intellij/stats/completion/LookupEntryInfo;", "lookupStringToHash", "calculateRelevance", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "items", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "computeAnalyticsItemFeatures", "lookupElement", "computeSessionFactorsToLog", "factors", "doUpdate", "Lcom/intellij/stats/completion/LookupState;", "factorsUpdated", "getElementId", "item", "(Lcom/intellij/codeInsight/lookup/LookupElement;)Ljava/lang/Integer;", "getLookupStringHash", "lookupString", "registerElement", "update", "setFactors", "", "itemId", "toLookupInfos", "Companion", "intellij.statsCollector"})
@SourceDebugExtension(value={"SMAP\nLookupStateManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LookupStateManager.kt\ncom/intellij/stats/completion/tracker/LookupStateManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,160:1\n766#2:161\n857#2,2:162\n1603#2,9:164\n1855#2:173\n1856#2:175\n1612#2:176\n1855#2,2:177\n766#2:179\n857#2,2:180\n1855#2,2:182\n1549#2:184\n1620#2,3:185\n1208#2,2:188\n1238#2,4:190\n1238#2,4:196\n766#2:200\n857#2,2:201\n1#3:174\n453#4:194\n403#4:195\n478#4,7:207\n215#5,2:203\n215#5,2:205\n*S KotlinDebug\n*F\n+ 1 LookupStateManager.kt\ncom/intellij/stats/completion/tracker/LookupStateManager\n*L\n52#1:161\n52#1:162,2\n54#1:164,9\n54#1:173\n54#1:175\n54#1:176\n55#1:177,2\n59#1:179\n59#1:180,2\n60#1:182,2\n85#1:184\n85#1:185,3\n110#1:188,2\n110#1:190,4\n117#1:196,4\n125#1:200\n125#1:201,2\n54#1:174\n117#1:194\n117#1:195\n148#1:207,7\n132#1:203,2\n133#1:205,2\n*E\n"})
public final class LookupStateManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean shouldLogElementFeatures;
    @NotNull
    private final Map<String, Integer> elementToId;
    @NotNull
    private final Map<Integer, LookupEntryInfo> idToEntryInfo;
    @NotNull
    private final Map<String, Integer> lookupStringToHash;
    @NotNull
    private Map<String, String> currentSessionFactors;
    @NotNull
    private static final Set<String> REQUIRED_FACTORS;

    public LookupStateManager(boolean shouldLogElementFeatures) {
        this.shouldLogElementFeatures = shouldLogElementFeatures;
        this.elementToId = new LinkedHashMap();
        this.idToEntryInfo = new LinkedHashMap();
        this.lookupStringToHash = new LinkedHashMap();
        this.currentSessionFactors = MapsKt.emptyMap();
    }

    @NotNull
    public final LookupState update(@NotNull LookupImpl lookup, boolean factorsUpdated) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        Object object = SlowOperations.allowSlowOperations(() -> LookupStateManager.update$lambda$0(this, lookup, factorsUpdated));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"allowSlowOperations(...)");
        return (LookupState)object;
    }

    /*
     * WARNING - void declaration
     */
    private final LookupState doUpdate(LookupImpl lookup, boolean factorsUpdated) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        List ids = new ArrayList();
        Set newIds = new LinkedHashSet();
        List items = lookup.getItems();
        int currentPosition = items.indexOf(lookup.getCurrentItem());
        Map elementToId = new LinkedHashMap();
        for (LookupElement item : items) {
            Intrinsics.checkNotNull((Object)item);
            Integer id = this.getElementId(item);
            if (id == null) {
                id = this.registerElement(item);
                newIds.add(id);
            }
            elementToId.put(LookupElementExtensionsKt.idString((LookupElement)item), id);
            ids.add(id);
        }
        LookupStorage storage = LookupStorage.Companion.get(lookup);
        Object object = storage;
        if (object == null || (object = object.getSessionFactors()) == null || (object = object.getLastUsedCommonFactors()) == null) {
            object = MapsKt.emptyMap();
        }
        Object commonSessionFactors = object;
        Map<String, String> sessionFactorsToLog = this.computeSessionFactorsToLog((Map<String, String>)commonSessionFactors);
        if (factorsUpdated) {
            Iterator $this$mapNotNullTo$iv$iv;
            void $this$filterTo$iv$iv2;
            Intrinsics.checkNotNull((Object)items);
            List<LookupEntryInfo> infos = this.toLookupInfos(items, lookup, elementToId);
            Iterable $this$filter$iv2 = infos;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv2;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                LookupEntryInfo it = (LookupEntryInfo)element$iv$iv;
                boolean bl = false;
                if (!newIds.contains(it.getId())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List newInfos = (List)destination$iv$iv;
            Iterable $this$mapNotNull$iv = infos;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                LookupEntryDiff it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                LookupEntryInfo it = (LookupEntryInfo)element$iv$iv;
                boolean bl2 = false;
                LookupEntryInfo lookupEntryInfo = this.idToEntryInfo.get(it.getId());
                if ((lookupEntryInfo != null ? lookupEntryInfo.calculateDiff(it) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List itemsDiff = (List)destination$iv$iv2;
            Iterable $this$forEach$iv = infos;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                LookupEntryInfo it = (LookupEntryInfo)element$iv;
                boolean bl = false;
                this.idToEntryInfo.put(it.getId(), it);
            }
            return new LookupState(ids, newInfos, itemsDiff, currentPosition, sessionFactorsToLog);
        }
        Intrinsics.checkNotNull((Object)items);
        Iterable newInfos = items;
        LookupStateManager lookupStateManager = this;
        boolean $i$f$filter = false;
        void $this$forEach$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LookupElement it = (LookupElement)element$iv$iv;
            boolean bl = false;
            Iterable iterable = newIds;
            Intrinsics.checkNotNull((Object)it);
            if (!CollectionsKt.contains((Iterable)iterable, (Object)this.getElementId(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List<LookupEntryInfo> newItems = lookupStateManager.toLookupInfos((List)destination$iv$iv, lookup, elementToId);
        Iterable $this$forEach$iv2 = newItems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            LookupEntryInfo it = (LookupEntryInfo)element$iv;
            boolean bl = false;
            this.idToEntryInfo.put(it.getId(), it);
        }
        return new LookupState(ids, newItems, CollectionsKt.emptyList(), currentPosition, sessionFactorsToLog);
    }

    private final Integer getElementId(LookupElement item) {
        String itemString = LookupElementExtensionsKt.idString((LookupElement)item);
        return this.elementToId.get(itemString);
    }

    private final Map<String, String> computeSessionFactorsToLog(Map<String, String> factors) {
        if (Intrinsics.areEqual(factors, this.currentSessionFactors)) {
            return MapsKt.emptyMap();
        }
        this.currentSessionFactors = factors;
        return factors;
    }

    private final int registerElement(LookupElement item) {
        String itemString = LookupElementExtensionsKt.idString((LookupElement)item);
        int newId = this.elementToId.size();
        Integer n = newId;
        this.elementToId.put(itemString, n);
        return newId;
    }

    /*
     * WARNING - void declaration
     */
    private final List<LookupEntryInfo> toLookupInfos(List<? extends LookupElement> $this$toLookupInfos, LookupImpl lookup, Map<String, Integer> elementToId) {
        void $this$mapTo$iv$iv;
        Map<String, Map<String, String>> item2relevance = this.calculateRelevance(lookup, $this$toLookupInfos);
        Iterable $this$map$iv = $this$toLookupInfos;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String lookupString;
            void lookupElement;
            LookupElement lookupElement2 = (LookupElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String id = LookupElementExtensionsKt.idString((LookupElement)lookupElement);
            Intrinsics.checkNotNullExpressionValue((Object)lookupElement.getLookupString(), (String)"getLookupString(...)");
            int itemHash = this.getLookupStringHash(lookupString);
            collection.add(new LookupEntryInfo(((Number)MapsKt.getValue(elementToId, (Object)id)).intValue(), lookupString.length(), itemHash, (Map)MapsKt.getValue(item2relevance, (Object)id)));
        }
        return (List)destination$iv$iv;
    }

    private final Map<String, String> computeAnalyticsItemFeatures(LookupElement lookupElement) {
        Map features;
        block2: {
            Number it;
            features = new LinkedHashMap();
            Long l = (Long)lookupElement.getUserData(LookupElement.LOOKUP_ELEMENT_SHOW_TIMESTAMP_MILLIS);
            if (l != null) {
                it = l;
                boolean bl = false;
                features.put("ml_analytics_timestamp_show", String.valueOf((Long)it));
            }
            Long l2 = (Long)lookupElement.getUserData(BaseCompletionService.LOOKUP_ELEMENT_RESULT_ADD_TIMESTAMP_MILLIS);
            if (l2 != null) {
                it = l2;
                boolean bl = false;
                features.put("ml_analytics_timestamp_add", String.valueOf((Long)it));
            }
            Integer n = (Integer)lookupElement.getUserData(BaseCompletionService.LOOKUP_ELEMENT_RESULT_SET_ORDER);
            if (n == null) break block2;
            it = n;
            boolean bl = false;
            features.put("ml_analytics_to_result_set_add_order", String.valueOf((Integer)it));
        }
        return features;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Map<String, String>> calculateRelevance(LookupImpl lookup, List<? extends LookupElement> items) {
        void $this$filterTo$iv$iv;
        Iterable factors;
        LookupStorage lookupStorage;
        LookupStorage lookupStorage2 = lookupStorage = LookupStorage.Companion.get(lookup);
        boolean bl = lookupStorage2 != null ? !lookupStorage2.shouldComputeFeatures() : false;
        if (bl) {
            void $this$associateByTo$iv$iv;
            Iterable $this$associateBy$iv = items;
            boolean $i$f$associateBy = false;
            int n = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(n);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                LookupElement lookupElement = (LookupElement)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl2 = false;
                LookupElement it = (LookupElement)element$iv$iv;
                String string = LookupElementExtensionsKt.idString((LookupElement)it);
                boolean bl3 = false;
                Map map2 = MapsKt.emptyMap();
                map.put(string, map2);
            }
            return destination$iv$iv;
        }
        Map result = new LinkedHashMap();
        if (lookupStorage != null) {
            for (LookupElement lookupElement : items) {
                Map map;
                String id = LookupElementExtensionsKt.idString((LookupElement)lookupElement);
                if (lookupStorage.getItemStorage(id).getLastUsedFactors() != null) {
                    void $this$mapValuesTo$iv$iv;
                    Map $this$mapValues$iv;
                    boolean $i$f$mapValues = false;
                    Map it = $this$mapValues$iv;
                    Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                    boolean $i$f$mapValuesTo = false;
                    Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                    boolean $i$f$associateByTo = false;
                    for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                        void it2;
                        void it$iv$iv;
                        Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                        Map map3 = destination$iv$iv;
                        boolean bl4 = false;
                        Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                        Object k = it$iv$iv.getKey();
                        Map map4 = map3;
                        boolean bl5 = false;
                        String string = it2.getValue().toString();
                        map4.put(k, string);
                    }
                    map = destination$iv$iv;
                } else {
                    map = null;
                }
                if ((factors = map) == null) continue;
                this.setFactors(result, id, MapsKt.plus((Map)((Object)factors), this.computeAnalyticsItemFeatures(lookupElement)));
            }
        }
        Iterable iterable = items;
        boolean $i$f$filter = false;
        factors = iterable;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LookupElement it = (LookupElement)element$iv$iv;
            boolean bl6 = false;
            boolean bl2 = !result.containsKey(LookupElementExtensionsKt.idString((LookupElement)it));
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List rest = (List)destination$iv$iv;
        if (!((Collection)rest).isEmpty()) {
            Map map = lookup.getRelevanceObjects((Iterable)rest, false);
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getRelevanceObjects(...)");
            Map map5 = map;
            for (LookupElement item : rest) {
                Map map6;
                if ((List)map5.get(item) != null) {
                    Map.Entry it;
                    Map.Entry element$iv;
                    List objects;
                    boolean bl8 = false;
                    Pair pair = RelevanceUtil.INSTANCE.asRelevanceMaps(objects);
                    Map relevanceMap = (Map)pair.component1();
                    Map additionalMap = (Map)pair.component2();
                    Map features = new LinkedHashMap();
                    Map $this$forEach$iv = relevanceMap;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        it = element$iv = iterator.next();
                        boolean bl9 = false;
                        features.put(it.getKey(), it.getValue().toString());
                    }
                    $this$forEach$iv = additionalMap;
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        it = element$iv = iterator.next();
                        boolean bl10 = false;
                        features.put(it.getKey(), it.getValue().toString());
                    }
                    features.putAll(this.computeAnalyticsItemFeatures(item));
                    map6 = features;
                } else {
                    map6 = MapsKt.emptyMap();
                }
                Map relevanceMap = map6;
                this.setFactors(result, LookupElementExtensionsKt.idString((LookupElement)item), relevanceMap);
            }
        }
        return result;
    }

    private final void setFactors(Map<String, Map<String, String>> $this$setFactors, String itemId, Map<String, String> factors) {
        if (this.shouldLogElementFeatures) {
            $this$setFactors.put(itemId, factors);
        } else {
            Map<String, Map<String, String>> map = $this$setFactors;
            Map<String, String> $this$filterKeys$iv = factors;
            boolean $i$f$filterKeys = false;
            LinkedHashMap<String, String> result$iv = new LinkedHashMap<String, String>();
            for (Map.Entry<String, String> entry$iv : $this$filterKeys$iv.entrySet()) {
                String it = entry$iv.getKey();
                boolean bl = false;
                if (!REQUIRED_FACTORS.contains(it)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Map map2 = result$iv;
            map.put(itemId, map2);
        }
    }

    private final int getLookupStringHash(String lookupString) {
        Integer n = this.lookupStringToHash.computeIfAbsent(lookupString, arg_0 -> LookupStateManager.getLookupStringHash$lambda$18((Function1)new Function1<String, Integer>(this){
            final /* synthetic */ LookupStateManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return LookupStateManager.access$getLookupStringToHash$p(this.this$0).size();
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"computeIfAbsent(...)");
        return ((Number)n).intValue();
    }

    private static final LookupState update$lambda$0(LookupStateManager this$0, LookupImpl $lookup, boolean $factorsUpdated) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$lookup, (String)"$lookup");
        return this$0.doUpdate($lookup, $factorsUpdated);
    }

    private static final Integer getLookupStringHash$lambda$18(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Map access$getLookupStringToHash$p(LookupStateManager $this) {
        return $this.lookupStringToHash;
    }

    static {
        Object[] objectArray = new String[]{"ml_common_item_class", "position", "result_length", "ml_rank", "kind", "ml_python_kind", "ml_php_element_element_type", "ml_scala_kind", "ml_clangd_kind", "kotlin.kind", "ml_js_kind"};
        REQUIRED_FACTORS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/stats/completion/tracker/LookupStateManager$Companion;", "", "()V", "REQUIRED_FACTORS", "", "", "intellij.statsCollector"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

