/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import java.io.File;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.IncrementalCompilationContext;
import org.jetbrains.kotlin.incremental.storage.AppendableAbstractBasicMap;
import org.jetbrains.kotlin.incremental.storage.IntExternalizer;
import org.jetbrains.kotlin.incremental.storage.LookupSymbolKey;
import org.jetbrains.kotlin.incremental.storage.LookupSymbolKeyDescriptor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\"\n\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00040\u0001B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0003J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0016\u0010\u0012\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0004H\u0016J\u0019\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u0002H\u0096\u0002J\u001f\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00022\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017H\u0086\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/LookupMap;", "Lorg/jetbrains/kotlin/incremental/storage/AppendableAbstractBasicMap;", "Lorg/jetbrains/kotlin/incremental/storage/LookupSymbolKey;", "", "", "storage", "Ljava/io/File;", "icContext", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;)V", "add", "", "name", "", "scope", "fileId", "dumpKey", "key", "dumpValue", "value", "get", "set", "fileIds", "", "kotlin-build-common"})
public final class LookupMap
extends AppendableAbstractBasicMap<LookupSymbolKey, Integer, Collection<? extends Integer>> {
    public LookupMap(@NotNull File storage2, @NotNull IncrementalCompilationContext icContext) {
        Intrinsics.checkNotNullParameter((Object)storage2, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)icContext, (String)"icContext");
        super(storage2, new LookupSymbolKeyDescriptor(icContext.getStoreFullFqNamesInLookupCache()), IntExternalizer.INSTANCE, icContext);
    }

    @Override
    @NotNull
    public String dumpKey(@NotNull LookupSymbolKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return key.toString();
    }

    @Override
    @NotNull
    public String dumpValue(@NotNull Collection<Integer> value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        return value2.toString();
    }

    public final void add(@NotNull String name, @NotNull String scope2, int fileId) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        this.getStorage().append(new LookupSymbolKey(name, scope2), fileId);
    }

    @Override
    @Nullable
    public Collection<Integer> get(@NotNull LookupSymbolKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Collection collection = (Collection)this.getStorage().get(key);
        return collection != null ? CollectionsKt.toSet((Iterable)collection) : null;
    }

    @Override
    public final void set(@NotNull LookupSymbolKey key, @NotNull Set<Integer> fileIds) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(fileIds, (String)"fileIds");
        this.getStorage().set(key, fileIds);
    }
}

