/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.coverage.report.impl.html;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.ResourceBundleModel;
import freemarker.template.Template;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import jetbrains.coverage.report.ReportGenerationFailedException;
import jetbrains.coverage.report.impl.IOUtil;
import jetbrains.coverage.report.impl.html.GeneratorPaths;
import jetbrains.coverage.report.impl.html.SortOption;
import jetbrains.coverage.report.impl.html.TemplateProcessor;
import jetbrains.coverage.report.impl.html.fs.FileSystem;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TemplateProcessorBase
implements TemplateProcessor {
    private final String myResourceBundleName;
    private final boolean myIncludeModule;
    private final FileSystem myFS;
    private final String myReportTitle;
    private final String myCharSet;

    protected TemplateProcessorBase(String resourceBundleName, boolean includeModule, @NotNull FileSystem fs, String reportTitle, String charSet) {
        this.myResourceBundleName = resourceBundleName;
        this.myIncludeModule = includeModule;
        this.myFS = fs;
        this.myReportTitle = reportTitle;
        this.myCharSet = charSet;
    }

    protected abstract String getFooterText();

    @Override
    public void renderTemplate(Map<String, Object> params, @NotNull GeneratorPaths paths) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resources", new ResourceBundleModel(this.getResourceBundle(), new BeansWrapper()));
        map.put("generateDate", new Date());
        map.putAll(params);
        map.put("paths", paths);
        map.put("sort_option_sort_by_name", (Object)SortOption.SORT_BY_NAME);
        map.put("sort_option_none", (Object)SortOption.NONE);
        map.put("include_modules", this.myIncludeModule);
        map.put("footerTextHTML", this.getFooterText());
        map.put("reportTitle", this.myReportTitle);
        map.put("charset", this.myCharSet);
        this.createFileFromTemplate(this.createTemplate(), map, paths.getReportFileName());
    }

    @NotNull
    protected abstract Template createTemplate() throws IOException;

    private void createFileFromTemplate(@NotNull Template tpl, @NotNull Map model, @NotNull File file) {
        OutputStream fos = null;
        try {
            fos = this.myFS.openFile(file);
            OutputStreamWriter writer = new OutputStreamWriter(fos);
            tpl.process(model, writer);
        }
        catch (Throwable e) {
            try {
                throw new ReportGenerationFailedException("Failed to generate file: " + file.getAbsolutePath() + ". " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fos);
                throw throwable;
            }
        }
        IOUtil.close(fos);
    }

    private ResourceBundle getResourceBundle() {
        return ResourceBundle.getBundle(this.myResourceBundleName);
    }
}

