/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontPanelFactory;
import com.intellij.application.options.colors.NewColorAndFontPanel;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.application.options.colors.SimpleEditorPreview;
import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.LineMarkerRendererWithErrorStripe;
import com.intellij.coverage.actions.HideCoverageInfoAction;
import com.intellij.coverage.actions.ShowCoveringTestsAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.FillingLineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.options.colors.pages.GeneralColorsPage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.ui.ColoredSideBorder;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverageLineMarkerRenderer
implements ActiveGutterRenderer,
FillingLineMarkerRenderer,
LineMarkerRendererWithErrorStripe {
    private static final int THICKNESS = 8;
    private final TextAttributesKey myKey;
    private final String myClassName;
    private final TreeMap<Integer, LineData> myLines;
    private final boolean myCoverageByTestApplicable;
    private final Function<? super Integer, Integer> myNewToOldConverter;
    private final Function<? super Integer, Integer> myOldToNewConverter;
    private final CoverageSuitesBundle myCoverageSuite;
    private final boolean mySubCoverageActive;
    private final int myLineNumber;

    protected CoverageLineMarkerRenderer(int lineNumber, @Nullable String className, TreeMap<Integer, LineData> lines, boolean coverageByTestApplicable, Function<? super Integer, Integer> newToOldConverter, Function<? super Integer, Integer> oldToNewConverter, CoverageSuitesBundle coverageSuite, boolean subCoverageActive) {
        this.myKey = CoverageLineMarkerRenderer.getAttributesKey(lineNumber, lines);
        this.myLineNumber = lineNumber;
        this.myClassName = className;
        this.myLines = lines;
        this.myCoverageByTestApplicable = coverageByTestApplicable;
        this.myNewToOldConverter = newToOldConverter;
        this.myOldToNewConverter = oldToNewConverter;
        this.myCoverageSuite = coverageSuite;
        this.mySubCoverageActive = subCoverageActive;
    }

    private int getLineNumber() {
        return this.myLineNumber;
    }

    @Nullable
    public Icon getIcon() {
        LineData lineData = this.getLineData(this.getLineNumber());
        if (lineData != null && lineData.isCoveredByOneTest()) {
            return AllIcons.Gutter.Unique;
        }
        return null;
    }

    @NotNull
    public TextAttributesKey getTextAttributesKey() {
        TextAttributesKey textAttributesKey = this.myKey;
        if (textAttributesKey == null) {
            CoverageLineMarkerRenderer.$$$reportNull$$$0(0);
        }
        return textAttributesKey;
    }

    @Nullable
    public Integer getMaxWidth() {
        return 8;
    }

    public static CoverageLineMarkerRenderer getRenderer(int lineNumber, @Nullable String className, TreeMap<Integer, LineData> lines, boolean coverageByTestApplicable, @NotNull CoverageSuitesBundle coverageSuite, Function<? super Integer, Integer> newToOldConverter, Function<? super Integer, Integer> oldToNewConverter, boolean subCoverageActive) {
        if (coverageSuite == null) {
            CoverageLineMarkerRenderer.$$$reportNull$$$0(1);
        }
        return new CoverageLineMarkerRenderer(lineNumber, className, lines, coverageByTestApplicable, newToOldConverter, oldToNewConverter, coverageSuite, subCoverageActive);
    }

    public static TextAttributesKey getAttributesKey(int lineNumber, TreeMap<Integer, LineData> lines) {
        return CoverageLineMarkerRenderer.getAttributesKey(lines.get(lineNumber));
    }

    private static TextAttributesKey getAttributesKey(LineData lineData) {
        int status = lineData == null ? 0 : lineData.getStatus();
        return switch (status) {
            case 2 -> CodeInsightColors.LINE_FULL_COVERAGE;
            case 1 -> CodeInsightColors.LINE_PARTIAL_COVERAGE;
            default -> CodeInsightColors.LINE_NONE_COVERAGE;
        };
    }

    public boolean canDoAction(@NotNull MouseEvent e) {
        Component component2;
        if (e == null) {
            CoverageLineMarkerRenderer.$$$reportNull$$$0(2);
        }
        if ((component2 = e.getComponent()) instanceof EditorGutterComponentEx) {
            EditorGutterComponentEx gutter = (EditorGutterComponentEx)component2;
            return e.getX() > gutter.getLineMarkerAreaOffset() && e.getX() < gutter.getIconAreaOffset();
        }
        return false;
    }

    public void doAction(@NotNull Editor editor, @NotNull MouseEvent e) {
        if (editor == null) {
            CoverageLineMarkerRenderer.$$$reportNull$$$0(3);
        }
        if (e == null) {
            CoverageLineMarkerRenderer.$$$reportNull$$$0(4);
        }
        e.consume();
        this.showHint(editor, this.getLineNumber());
    }

    private void showHint(Editor editor, int lineNumber) {
        EditorImpl uEditor;
        String report;
        JPanel panel2 = new JPanel(new BorderLayout());
        final Disposable unregisterActionsDisposable = Disposer.newDisposable();
        panel2.add((Component)this.createActionsToolbar(editor, lineNumber, unregisterActionsDisposable), "North");
        LineData lineData = this.getLineData(lineNumber);
        if (lineData != null && lineData.getStatus() != 0 && !this.mySubCoverageActive && (report = this.getReport(editor, lineNumber)) != null) {
            EditorFactory factory = EditorFactory.getInstance();
            Document doc = factory.createDocument((CharSequence)report);
            doc.setReadOnly(true);
            uEditor = (EditorImpl)factory.createEditor(doc, editor.getProject());
            panel2.add((Component)EditorFragmentComponent.createEditorFragmentComponent((Editor)uEditor, (int)0, (int)doc.getLineCount(), (boolean)false, (boolean)false), "Center");
        } else {
            uEditor = null;
        }
        LightweightHint hint = new LightweightHint(panel2){

            public void hide() {
                if (uEditor != null) {
                    EditorFactory.getInstance().releaseEditor((Editor)uEditor);
                }
                Disposer.dispose((Disposable)unregisterActionsDisposable);
                super.hide();
            }
        };
        int hideFlags = 58;
        HintHint hintInfo = new HintHint(editor, new Point());
        HintManagerImpl.getInstanceImpl().showGutterHint(hint, editor, lineNumber, 8, hideFlags, -1, false, hintInfo);
    }

    @Nullable
    private String getReport(Editor editor, int lineNumber) {
        LineData lineData = this.getLineData(lineNumber);
        Document document2 = editor.getDocument();
        Project project2 = editor.getProject();
        assert (project2 != null);
        PsiFile psiFile2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document2);
        if (psiFile2 == null) {
            return null;
        }
        int lineStartOffset = document2.getLineStartOffset(lineNumber);
        int lineEndOffset = document2.getLineEndOffset(lineNumber);
        return this.myCoverageSuite.getCoverageEngine().generateBriefReport(editor, psiFile2, lineNumber, lineStartOffset, lineEndOffset, lineData);
    }

    protected JComponent createActionsToolbar(Editor editor, int lineNumber, Disposable parent) {
        AnAction byteCodeViewAction;
        JComponent editorComponent = editor.getComponent();
        DefaultActionGroup group2 = new DefaultActionGroup();
        GotoPreviousCoveredLineAction prevAction = new GotoPreviousCoveredLineAction(editor, lineNumber);
        GotoNextCoveredLineAction nextAction = new GotoNextCoveredLineAction(editor, lineNumber);
        group2.add((AnAction)prevAction);
        group2.add((AnAction)nextAction);
        prevAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(38, 9)), editorComponent);
        nextAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(40, 9)), editorComponent);
        Disposer.register((Disposable)parent, () -> {
            prevAction.unregisterCustomShortcutSet(editorComponent);
            nextAction.unregisterCustomShortcutSet(editorComponent);
        });
        LineData lineData = this.getLineData(lineNumber);
        if (this.myCoverageByTestApplicable) {
            group2.add((AnAction)new ShowCoveringTestsAction(editor.getProject(), this.myCoverageSuite, this.myClassName, lineData));
        }
        if ((byteCodeViewAction = ActionManager.getInstance().getAction("ByteCodeViewer")) != null) {
            group2.add(byteCodeViewAction);
        }
        group2.add((AnAction)new EditCoverageColorsAction(editor, lineNumber));
        group2.add((AnAction)new HideCoverageInfoAction());
        ActionToolbar toolbar2 = ActionManager.getInstance().createActionToolbar("CoverageHintToolbar", (ActionGroup)group2, true);
        toolbar2.setTargetComponent(editorComponent);
        JComponent toolbarComponent = toolbar2.getComponent();
        Color background = ((EditorEx)editor).getBackgroundColor();
        Color foreground = editor.getColorsScheme().getColor(EditorColors.CARET_COLOR);
        toolbarComponent.setBackground(background);
        toolbarComponent.setBorder((Border)new ColoredSideBorder(foreground, foreground, lineData == null || lineData.getStatus() == 0 || this.mySubCoverageActive ? foreground : null, foreground, 1));
        return toolbarComponent;
    }

    public void moveToLine(int lineNumber, Editor editor) {
        int firstOffset = editor.getDocument().getLineStartOffset(lineNumber);
        editor.getCaretModel().moveToOffset(firstOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        editor.getScrollingModel().runActionOnScrollingFinished(() -> this.showHint(editor, lineNumber));
    }

    @Nullable
    public LineData getLineData(int lineNumber) {
        return this.myLines != null ? this.myLines.get(this.myNewToOldConverter != null ? (Integer)this.myNewToOldConverter.fun((Object)lineNumber) : lineNumber) : null;
    }

    @Override
    public Color getErrorStripeColor(Editor editor) {
        return editor.getColorsScheme().getAttributes(this.myKey).getErrorStripeColor();
    }

    @NotNull
    public LineMarkerRendererEx.Position getPosition() {
        LineMarkerRendererEx.Position position = LineMarkerRendererEx.Position.LEFT;
        if (position == null) {
            CoverageLineMarkerRenderer.$$$reportNull$$$0(5);
        }
        return position;
    }

    @NotNull
    public String getAccessibleName() {
        String string2 = CoverageBundle.message("marker.code.coverage", new Object[0]);
        if (string2 == null) {
            CoverageLineMarkerRenderer.$$$reportNull$$$0(6);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/CoverageLineMarkerRenderer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageSuite";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextAttributesKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/CoverageLineMarkerRenderer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPosition";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessibleName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRenderer";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canDoAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doAction";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string2);
        };
    }

    private class GotoPreviousCoveredLineAction
    extends BaseGotoCoveredLineAction {
        GotoPreviousCoveredLineAction(Editor editor, int lineNumber) {
            super(editor, lineNumber);
            ActionUtil.copyFrom((AnAction)this, (String)"PreviousOccurence");
            this.getTemplatePresentation().setText(CoverageBundle.message("coverage.previous.mark", new Object[0]));
        }

        @Override
        protected int next(int idx, int size) {
            if (idx <= 0) {
                return size - 1;
            }
            return idx - 1;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                GotoPreviousCoveredLineAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            String nextChange = this.getNextChange();
            if (nextChange != null) {
                e.getPresentation().setText(CoverageBundle.message("coverage.previous.place", nextChange));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/coverage/CoverageLineMarkerRenderer$GotoPreviousCoveredLineAction", "update"));
        }
    }

    private class GotoNextCoveredLineAction
    extends BaseGotoCoveredLineAction {
        GotoNextCoveredLineAction(Editor editor, int lineNumber) {
            super(editor, lineNumber);
            this.copyFrom(ActionManager.getInstance().getAction("NextOccurence"));
            this.getTemplatePresentation().setText(CoverageBundle.message("coverage.next.mark", new Object[0]));
        }

        @Override
        protected int next(int idx, int size) {
            if (idx == size - 1) {
                return 0;
            }
            return idx + 1;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                GotoNextCoveredLineAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            String nextChange = this.getNextChange();
            if (nextChange != null) {
                e.getPresentation().setText(CoverageBundle.message("coverage.next.place", nextChange));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/coverage/CoverageLineMarkerRenderer$GotoNextCoveredLineAction", "update"));
        }
    }

    private final class EditCoverageColorsAction
    extends AnAction {
        private final Editor myEditor;
        private final int myLineNumber;

        private EditCoverageColorsAction(Editor editor, int lineNumber) {
            super(CoverageBundle.message("coverage.edit.colors.action.name", new Object[0]), CoverageBundle.message("coverage.edit.colors.description", new Object[0]), AllIcons.General.Settings);
            this.myEditor = editor;
            this.myLineNumber = lineNumber;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                EditCoverageColorsAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setVisible(CoverageLineMarkerRenderer.this.getLineData(this.myLineNumber) != null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                EditCoverageColorsAction.$$$reportNull$$$0(1);
            }
            final GeneralColorsPage colorsPage = new GeneralColorsPage();
            final String fullDisplayName = CoverageBundle.message("configurable.name.editor.colors.page", ApplicationBundle.message((String)"title.colors.and.fonts", (Object[])new Object[0]), colorsPage.getDisplayName());
            ColorAndFontOptions colorAndFontOptions = new ColorAndFontOptions(){

                protected List<ColorAndFontPanelFactory> createPanelFactories() {
                    ColorAndFontPanelFactory panelFactory = new ColorAndFontPanelFactory(){

                        @NotNull
                        public NewColorAndFontPanel createPanel(@NotNull ColorAndFontOptions options) {
                            if (options == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            SimpleEditorPreview preview = new SimpleEditorPreview(options, (ColorSettingsPage)colorsPage);
                            NewColorAndFontPanel newColorAndFontPanel = NewColorAndFontPanel.create((PreviewPanel)preview, (String)colorsPage.getDisplayName(), (ColorAndFontOptions)options, null, (ColorSettingsPage)colorsPage);
                            if (newColorAndFontPanel == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return newColorAndFontPanel;
                        }

                        @NlsContexts.ConfigurableName
                        @NotNull
                        public String getPanelDisplayName() {
                            String string2 = fullDisplayName;
                            if (string2 == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            return string2;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[switch (n) {
                                default -> 3;
                                case 1, 2 -> 2;
                            }];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "options";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/intellij/coverage/CoverageLineMarkerRenderer$EditCoverageColorsAction$1$1";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/intellij/coverage/CoverageLineMarkerRenderer$EditCoverageColorsAction$1$1";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "createPanel";
                                    break;
                                }
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getPanelDisplayName";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray;
                                    objectArray[2] = "createPanel";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    break;
                                }
                            }
                            String string2 = String.format(v0, objectArray);
                            throw switch (n) {
                                default -> new IllegalArgumentException(string2);
                                case 1, 2 -> new IllegalStateException(string2);
                            };
                        }
                    };
                    return Collections.singletonList(panelFactory);
                }
            };
            Configurable[] configurables = colorAndFontOptions.buildConfigurables();
            try {
                NewColorAndFontPanel page = colorAndFontOptions.findPage(fullDisplayName);
                SearchableConfigurable general = colorAndFontOptions.findSubConfigurable(GeneralColorsPage.class);
                if (general != null && page != null) {
                    LineData lineData = CoverageLineMarkerRenderer.this.getLineData(this.myLineNumber);
                    ShowSettingsUtil.getInstance().editConfigurable(this.myEditor.getProject(), (Configurable)general, () -> page.selectOptionByType(CoverageLineMarkerRenderer.getAttributesKey(lineData).getExternalName()));
                }
            }
            finally {
                for (Configurable configurable : configurables) {
                    configurable.disposeUIResources();
                }
                colorAndFontOptions.disposeUIResources();
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                EditCoverageColorsAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/coverage/CoverageLineMarkerRenderer$EditCoverageColorsAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/coverage/CoverageLineMarkerRenderer$EditCoverageColorsAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }

    private abstract class BaseGotoCoveredLineAction
    extends AnAction {
        private final Editor myEditor;
        private final int myLineNumber;

        BaseGotoCoveredLineAction(Editor editor, int lineNumber) {
            this.myEditor = editor;
            this.myLineNumber = lineNumber;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Integer lineNumber;
            if (e == null) {
                BaseGotoCoveredLineAction.$$$reportNull$$$0(0);
            }
            if ((lineNumber = this.getLineEntry()) != null) {
                CoverageLineMarkerRenderer.this.moveToLine(lineNumber, this.myEditor);
            }
        }

        protected abstract int next(int var1, int var2);

        @Nullable
        private Integer getLineEntry() {
            Integer line;
            block3: {
                int newLine;
                List list2 = ContainerUtil.sorted(CoverageLineMarkerRenderer.this.myLines.keySet());
                int size = list2.size();
                LineData data2 = CoverageLineMarkerRenderer.this.getLineData(this.myLineNumber);
                int currentStatus = data2 != null ? data2.getStatus() : 0;
                int idx = list2.indexOf(CoverageLineMarkerRenderer.this.myNewToOldConverter != null ? (Integer)CoverageLineMarkerRenderer.this.myNewToOldConverter.fun((Object)this.myLineNumber) : this.myLineNumber);
                if (idx < 0) {
                    return null;
                }
                while (true) {
                    int index;
                    Integer key2;
                    if ((key2 = (Integer)list2.get(index = this.next(idx, size))) == this.myLineNumber) {
                        return null;
                    }
                    LineData lineData = CoverageLineMarkerRenderer.this.getLineData(key2);
                    idx = index;
                    if (lineData == null || lineData.getStatus() == currentStatus) continue;
                    line = (Integer)list2.get(idx);
                    if (CoverageLineMarkerRenderer.this.myOldToNewConverter == null) break block3;
                    newLine = (Integer)CoverageLineMarkerRenderer.this.myOldToNewConverter.fun((Object)line);
                    if (newLine != 0) break;
                }
                return newLine;
            }
            return line;
        }

        @Nullable
        protected String getNextChange() {
            LineData lineData;
            Integer entry2 = this.getLineEntry();
            if (entry2 != null && (lineData = CoverageLineMarkerRenderer.this.getLineData(entry2)) != null) {
                return switch (lineData.getStatus()) {
                    case 0 -> CoverageBundle.message("coverage.next.change.uncovered", new Object[0]);
                    case 1 -> CoverageBundle.message("coverage.next.change.partial.covered", new Object[0]);
                    case 2 -> CoverageBundle.message("coverage.next.change.fully.covered", new Object[0]);
                    default -> null;
                };
            }
            return null;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                BaseGotoCoveredLineAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(this.getLineEntry() != null);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                BaseGotoCoveredLineAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/coverage/CoverageLineMarkerRenderer$BaseGotoCoveredLineAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/coverage/CoverageLineMarkerRenderer$BaseGotoCoveredLineAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }
}

