/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.revertion;

import com.intellij.history.core.Content;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.Paths;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.revertion.Reverter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class DifferenceReverter
extends Reverter {
    private final List<? extends Difference> myDiffs;
    private final Revision myLeftRevision;

    public DifferenceReverter(Project p, LocalHistoryFacade vcs, IdeaGateway gw, List<? extends Difference> diffs, Revision leftRevision) {
        super(p, vcs, gw);
        this.myDiffs = diffs;
        this.myLeftRevision = leftRevision;
    }

    @Override
    protected Revision getTargetRevision() {
        return this.myLeftRevision;
    }

    @Override
    protected List<VirtualFile> getFilesToClearROStatus() throws IOException {
        LinkedHashSet<VirtualFile> files2 = new LinkedHashSet<VirtualFile>();
        for (Difference difference : this.myDiffs) {
            VirtualFile f;
            Entry l = difference.getLeft();
            Entry r = difference.getRight();
            VirtualFile virtualFile = f = l == null ? null : this.myGateway.findVirtualFile(l.getPath());
            if (f != null) {
                files2.add(f);
            }
            if ((f = r == null ? null : this.myGateway.findVirtualFile(r.getPath())) == null) continue;
            files2.add(f);
        }
        return new ArrayList<VirtualFile>(files2);
    }

    @Override
    protected void doRevert() throws IOException {
        this.doRevert(true);
    }

    public void doRevert(boolean revertContentChanges) throws IOException {
        HashSet<String> vetoedFiles = new HashSet<String>();
        for (Difference each : ContainerUtil.iterateBackward(this.myDiffs)) {
            Entry l = each.getLeft();
            Entry r = each.getRight();
            if (l == null) {
                this.revertCreation(r, vetoedFiles);
                continue;
            }
            vetoedFiles.add(l.getPath());
            if (r == null) {
                this.revertDeletion(l);
                continue;
            }
            VirtualFile file = this.myGateway.findOrCreateFileSafely(r.getPath(), r.isDirectory());
            this.revertRename(l, file);
            if (!revertContentChanges) continue;
            DifferenceReverter.revertContentChange(l, file);
        }
    }

    private void revertCreation(Entry r, Set<String> vetoedFiles) throws IOException {
        String path2 = r.getPath();
        for (String each : vetoedFiles) {
            if (!Paths.isParent(path2, each)) continue;
            return;
        }
        VirtualFile f = this.myGateway.findVirtualFile(path2);
        if (f != null) {
            f.delete((Object)this);
        }
    }

    private void revertDeletion(Entry l) throws IOException {
        VirtualFile f = this.myGateway.findOrCreateFileSafely(l.getPath(), l.isDirectory());
        if (l.isDirectory()) {
            return;
        }
        DifferenceReverter.setContent(l, f);
    }

    private void revertRename(Entry l, VirtualFile file) throws IOException {
        String oldName = l.getName();
        if (!oldName.equals(file.getName())) {
            VirtualFile existing = file.getParent().findChild(oldName);
            if (existing != null) {
                existing.delete((Object)this);
            }
            file.rename((Object)this, oldName);
        }
    }

    private static void revertContentChange(Entry l, VirtualFile file) throws IOException {
        if (l.isDirectory()) {
            return;
        }
        if (file.getTimeStamp() != l.getTimestamp()) {
            DifferenceReverter.setContent(l, file);
        }
    }

    private static void setContent(Entry l, VirtualFile file) throws IOException {
        Content c = l.getContent();
        if (!c.isAvailable()) {
            return;
        }
        file.setBinaryContent(c.getBytes());
    }
}

