/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.actions;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.ignore.actions.IgnoreFileActionKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/changes/ignore/actions/CreateNewIgnoreFileAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "ignoreFileName", "", "ignoreFileRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "confirmCreateIgnoreFile", "", "project", "Lcom/intellij/openapi/project/Project;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.platform.vcs.impl"})
public final class CreateNewIgnoreFileAction
extends DumbAwareAction {
    @NotNull
    private final String ignoreFileName;
    @NotNull
    private final VirtualFile ignoreFileRoot;

    public CreateNewIgnoreFileAction(@NotNull String ignoreFileName, @NotNull VirtualFile ignoreFileRoot) {
        Intrinsics.checkNotNullParameter((Object)ignoreFileName, (String)"ignoreFileName");
        Intrinsics.checkNotNullParameter((Object)ignoreFileRoot, (String)"ignoreFileRoot");
        this.ignoreFileName = ignoreFileName;
        this.ignoreFileRoot = ignoreFileRoot;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = e.getRequiredData(CommonDataKeys.PROJECT);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getRequiredData(...)");
        Project project2 = (Project)object;
        AbstractVcs abstractVcs = VcsUtil.getVcsFor(project2, this.ignoreFileRoot);
        if (abstractVcs == null) {
            return;
        }
        AbstractVcs ignoreFileRootVcs = abstractVcs;
        List<IgnoredFileBean> ignored = IgnoreFileActionKt.getIgnoredFileBeans(e, this.ignoreFileRoot, ignoreFileRootVcs);
        if (ignored.isEmpty() || !this.confirmCreateIgnoreFile(project2)) {
            return;
        }
        Object object2 = ActionsKt.runUndoTransparentWriteAction((Function0)((Function0)new Function0<VirtualFile>(this){
            final /* synthetic */ CreateNewIgnoreFileAction this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final VirtualFile invoke() {
                return CreateNewIgnoreFileAction.access$getIgnoreFileRoot$p(this.this$0).createChildData((Object)CreateNewIgnoreFileAction.access$getIgnoreFileRoot$p(this.this$0), CreateNewIgnoreFileAction.access$getIgnoreFileName$p(this.this$0));
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"runUndoTransparentWriteAction(...)");
        VirtualFile ignoreFile2 = (VirtualFile)object2;
        IgnoreFileActionKt.writeIgnoreFileEntries$default(project2, ignoreFile2, ignored, null, null, 24, null);
    }

    private final boolean confirmCreateIgnoreFile(Project project2) {
        Object[] objectArray = new Object[]{this.ignoreFileName, FileUtil.getLocationRelativeToUserHome((String)this.ignoreFileRoot.getPresentableUrl())};
        String string2 = VcsBundle.message("vcs.add.to.ignore.file.create.ignore.file.confirmation.message", objectArray);
        objectArray = new Object[]{this.ignoreFileName};
        String string3 = VcsBundle.message("vcs.add.to.ignore.file.create.ignore.file.confirmation.title", objectArray);
        objectArray = new String[]{IdeBundle.message((String)"button.create", (Object[])new Object[0]), CommonBundle.getCancelButtonText()};
        return Messages.showDialog((Project)project2, (String)string2, (String)string3, null, (String[])objectArray, (int)0, (int)1, (Icon)Messages.getQuestionIcon()) == 0;
    }

    public static final /* synthetic */ VirtualFile access$getIgnoreFileRoot$p(CreateNewIgnoreFileAction $this) {
        return $this.ignoreFileRoot;
    }

    public static final /* synthetic */ String access$getIgnoreFileName$p(CreateNewIgnoreFileAction $this) {
        return $this.ignoreFileName;
    }
}

