/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeHandlersKt;
import com.intellij.ui.DoubleClickListener;
import com.intellij.util.Processor;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R$\u0010\u0005\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u0007\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\f\u001a\f\u0012\u0006\b\u0000\u0012\u00020\r\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ChangesTreeHandlers;", "", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;)V", "doubleClickHandler", "Lcom/intellij/util/Processor;", "Ljava/awt/event/MouseEvent;", "getDoubleClickHandler", "()Lcom/intellij/util/Processor;", "setDoubleClickHandler", "(Lcom/intellij/util/Processor;)V", "enterKeyHandler", "Ljava/awt/event/KeyEvent;", "getEnterKeyHandler", "setEnterKeyHandler", "MyDoubleClickListener", "MyEnterListener", "intellij.platform.vcs.impl"})
final class ChangesTreeHandlers {
    @NotNull
    private final ChangesTree tree;
    @Nullable
    private Processor<? super KeyEvent> enterKeyHandler;
    @Nullable
    private Processor<? super MouseEvent> doubleClickHandler;

    public ChangesTreeHandlers(@NotNull ChangesTree tree2) {
        Intrinsics.checkNotNullParameter((Object)((Object)tree2), (String)"tree");
        this.tree = tree2;
        this.tree.addKeyListener(new MyEnterListener());
        new MyDoubleClickListener().installOn((Component)((Object)this.tree));
    }

    @Nullable
    public final Processor<? super KeyEvent> getEnterKeyHandler() {
        return this.enterKeyHandler;
    }

    public final void setEnterKeyHandler(@Nullable Processor<? super KeyEvent> processor2) {
        this.enterKeyHandler = processor2;
    }

    @Nullable
    public final Processor<? super MouseEvent> getDoubleClickHandler() {
        return this.doubleClickHandler;
    }

    public final void setDoubleClickHandler(@Nullable Processor<? super MouseEvent> processor2) {
        this.doubleClickHandler = processor2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ChangesTreeHandlers$MyDoubleClickListener;", "Lcom/intellij/ui/DoubleClickListener;", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesTreeHandlers;)V", "onDoubleClick", "", "e", "Ljava/awt/event/MouseEvent;", "intellij.platform.vcs.impl"})
    private final class MyDoubleClickListener
    extends DoubleClickListener {
        protected boolean onDoubleClick(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Processor<? super MouseEvent> processor2 = ChangesTreeHandlers.this.getDoubleClickHandler();
            if (processor2 == null) {
                return false;
            }
            Processor<? super MouseEvent> handler2 = processor2;
            TreePath clickPath = TreeUtil.getPathForLocation((JTree)((JTree)((Object)ChangesTreeHandlers.this.tree)), (int)e.getX(), (int)e.getY());
            if (clickPath == null) {
                return false;
            }
            if (ChangesTreeHandlers.this.tree.getPathIfCheckBoxClicked(e.getPoint()) != null) {
                return false;
            }
            return handler2.process((Object)e);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ChangesTreeHandlers$MyEnterListener;", "Ljava/awt/event/KeyAdapter;", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesTreeHandlers;)V", "keyPressed", "", "e", "Ljava/awt/event/KeyEvent;", "intellij.platform.vcs.impl"})
    private final class MyEnterListener
    extends KeyAdapter {
        @Override
        public void keyPressed(@NotNull KeyEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Processor<? super KeyEvent> processor2 = ChangesTreeHandlers.this.getEnterKeyHandler();
            if (processor2 == null) {
                return;
            }
            Processor<? super KeyEvent> handler2 = processor2;
            if (10 != e.getKeyCode() || e.getModifiers() != 0) {
                return;
            }
            if (ChangesTreeHandlers.this.tree.getSelectionCount() <= 1 && !ChangesTreeHandlersKt.access$isLeafSelected(ChangesTreeHandlers.this.tree)) {
                return;
            }
            if (handler2.process((Object)e)) {
                e.consume();
            }
        }
    }
}

