/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactoryImpl;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.history.ByteContent;
import com.intellij.history.Label;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.update.UpdateInfoTree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowUpdatedDiffActionProvider
implements AnActionExtensionProvider {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShowUpdatedDiffActionProvider.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public boolean isActive(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowUpdatedDiffActionProvider.$$$reportNull$$$0(1);
        }
        return ShowUpdatedDiffActionProvider.isVisible(e.getDataContext());
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowUpdatedDiffActionProvider.$$$reportNull$$$0(2);
        }
        DataContext dc = e.getDataContext();
        Presentation presentation2 = e.getPresentation();
        presentation2.setDescription(VcsBundle.messagePointer("action.presentation.ShowUpdatedDiffActionProvider.description", new Object[0]));
        presentation2.setEnabled(ShowUpdatedDiffActionProvider.isVisible(dc) && ShowUpdatedDiffActionProvider.isEnabled(dc));
    }

    private static boolean isVisible(DataContext dc) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dc);
        return project2 != null && UpdateInfoTree.LABEL_BEFORE.getData(dc) != null && UpdateInfoTree.LABEL_AFTER.getData(dc) != null;
    }

    private static boolean isEnabled(DataContext dc) {
        Iterable iterable = (Iterable)UpdateInfoTree.UPDATE_VIEW_FILES_ITERABLE.getData(dc);
        return iterable != null;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dc;
        if (e == null) {
            ShowUpdatedDiffActionProvider.$$$reportNull$$$0(3);
        }
        if (!ShowUpdatedDiffActionProvider.isVisible(dc = e.getDataContext()) || !ShowUpdatedDiffActionProvider.isEnabled(dc)) {
            return;
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dc);
        Iterable iterable = (Iterable)e.getRequiredData(UpdateInfoTree.UPDATE_VIEW_FILES_ITERABLE);
        Label before2 = (Label)e.getRequiredData(UpdateInfoTree.LABEL_BEFORE);
        Label after = (Label)e.getRequiredData(UpdateInfoTree.LABEL_AFTER);
        FilePath selectedUrl = (FilePath)UpdateInfoTree.UPDATE_VIEW_SELECTED_PATH.getData(dc);
        ChangeDiffRequestChain requestChain = ShowUpdatedDiffActionProvider.createDiffRequestChain(project2, before2, after, iterable, selectedUrl);
        DiffManager.getInstance().showDiff(project2, (DiffRequestChain)requestChain, DiffDialogHints.FRAME);
    }

    public static ChangeDiffRequestChain createDiffRequestChain(@Nullable Project project2, @NotNull Label before2, @NotNull Label after, @NotNull Iterable<? extends Pair<FilePath, FileStatus>> iterable, @Nullable FilePath selectedPath) {
        if (before2 == null) {
            ShowUpdatedDiffActionProvider.$$$reportNull$$$0(4);
        }
        if (after == null) {
            ShowUpdatedDiffActionProvider.$$$reportNull$$$0(5);
        }
        if (iterable == null) {
            ShowUpdatedDiffActionProvider.$$$reportNull$$$0(6);
        }
        ArrayList<MyDiffRequestProducer> requests = new ArrayList<MyDiffRequestProducer>();
        int selected = -1;
        for (Pair<FilePath, FileStatus> pair : iterable) {
            if (selected == -1 && ((FilePath)pair.first).equals(selectedPath)) {
                selected = requests.size();
            }
            requests.add(new MyDiffRequestProducer(project2, before2, after, (FilePath)pair.first, (FileStatus)pair.second));
        }
        if (selected == -1) {
            selected = 0;
        }
        return new ChangeDiffRequestChain(requests, selected);
    }

    private static byte @NotNull [] loadContent(@NotNull FilePath path2, @NotNull Label label2) throws DiffRequestProducerException {
        ByteContent byteContent;
        if (path2 == null) {
            ShowUpdatedDiffActionProvider.$$$reportNull$$$0(7);
        }
        if (label2 == null) {
            ShowUpdatedDiffActionProvider.$$$reportNull$$$0(8);
        }
        if ((byteContent = label2.getByteContent(path2.getPath())) == null || byteContent.isDirectory() || byteContent.getBytes() == null) {
            throw new DiffRequestProducerException(VcsBundle.message("update.can.t.load.content", new Object[0]));
        }
        byte[] byArray = byteContent.getBytes();
        if (byArray == null) {
            ShowUpdatedDiffActionProvider.$$$reportNull$$$0(9);
        }
        return byArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/update/ShowUpdatedDiffActionProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "before";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "after";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/update/ShowUpdatedDiffActionProvider";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "loadContent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isActive";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDiffRequestChain";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadContent";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string2);
        };
    }

    private static class MyDiffRequestProducer
    implements DiffRequestProducer,
    ChangeDiffRequestChain.Producer {
        @Nullable
        private final Project myProject;
        @NotNull
        private final Label myBefore;
        @NotNull
        private final Label myAfter;
        @NotNull
        private final FileStatus myFileStatus;
        @NotNull
        private final FilePath myFilePath;

        MyDiffRequestProducer(@Nullable Project project2, @NotNull Label before2, @NotNull Label after, @NotNull FilePath filePath, @NotNull FileStatus fileStatus) {
            if (before2 == null) {
                MyDiffRequestProducer.$$$reportNull$$$0(0);
            }
            if (after == null) {
                MyDiffRequestProducer.$$$reportNull$$$0(1);
            }
            if (filePath == null) {
                MyDiffRequestProducer.$$$reportNull$$$0(2);
            }
            if (fileStatus == null) {
                MyDiffRequestProducer.$$$reportNull$$$0(3);
            }
            this.myProject = project2;
            this.myBefore = before2;
            this.myAfter = after;
            this.myFileStatus = fileStatus;
            this.myFilePath = filePath;
        }

        @NotNull
        public String getName() {
            String string2 = this.myFilePath.getPresentableUrl();
            if (string2 == null) {
                MyDiffRequestProducer.$$$reportNull$$$0(4);
            }
            return string2;
        }

        @Override
        @NotNull
        public FilePath getFilePath() {
            FilePath filePath = this.myFilePath;
            if (filePath == null) {
                MyDiffRequestProducer.$$$reportNull$$$0(5);
            }
            return filePath;
        }

        @Override
        @NotNull
        public FileStatus getFileStatus() {
            FileStatus fileStatus = this.myFileStatus;
            if (fileStatus == null) {
                MyDiffRequestProducer.$$$reportNull$$$0(6);
            }
            return fileStatus;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
            if (context == null) {
                MyDiffRequestProducer.$$$reportNull$$$0(7);
            }
            if (indicator == null) {
                MyDiffRequestProducer.$$$reportNull$$$0(8);
            }
            try {
                EmptyContent content2;
                EmptyContent content1;
                DiffContentFactoryEx contentFactory = DiffContentFactoryEx.getInstanceEx();
                if (FileStatus.ADDED.equals(this.myFileStatus)) {
                    content1 = contentFactory.createEmpty();
                } else {
                    byte[] bytes1 = ShowUpdatedDiffActionProvider.loadContent(this.myFilePath, this.myBefore);
                    content1 = contentFactory.createFromBytes(this.myProject, bytes1, this.myFilePath);
                }
                if (FileStatus.DELETED.equals(this.myFileStatus)) {
                    content2 = contentFactory.createEmpty();
                } else {
                    byte[] bytes2 = ShowUpdatedDiffActionProvider.loadContent(this.myFilePath, this.myAfter);
                    content2 = contentFactory.createFromBytes(this.myProject, bytes2, this.myFilePath);
                }
                String title2 = DiffRequestFactoryImpl.getContentTitle((FilePath)this.myFilePath);
                return new SimpleDiffRequest(title2, (DiffContent)content1, (DiffContent)content2, VcsBundle.message("update.label.before.update", new Object[0]), VcsBundle.message("update.label.after.update", new Object[0]));
            }
            catch (IOException e) {
                throw new DiffRequestProducerException(VcsBundle.message("update.can.t.load.content", new Object[0]), (Throwable)e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyDiffRequestProducer producer = (MyDiffRequestProducer)o;
            return this.myBefore.equals(producer.myBefore) && this.myAfter.equals(producer.myAfter) && this.myFileStatus.equals(producer.myFileStatus) && this.myFilePath.equals(producer.myFilePath);
        }

        public int hashCode() {
            return Objects.hash(this.myBefore, this.myAfter, this.myFileStatus, this.myFilePath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "before";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "after";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileStatus";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/update/ShowUpdatedDiffActionProvider$MyDiffRequestProducer";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/update/ShowUpdatedDiffActionProvider$MyDiffRequestProducer";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePath";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileStatus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 4, 5, 6 -> new IllegalStateException(string2);
            };
        }
    }
}

