/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.ide.TypePresentationService;
import com.intellij.openapi.project.Project;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.SoftFactoryMap;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.highlighting.ResolvingElementQuickFix;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DomResolveConverter<T extends DomElement>
extends ResolvingConverter<T> {
    private static final Map<Class<? extends DomElement>, DomResolveConverter> ourCache = ConcurrentFactoryMap.createMap(key2 -> new DomResolveConverter(key2));
    private final boolean myAttribute;
    private final SoftFactoryMap<DomElement, CachedValue<Map<String, DomElement>>> myResolveCache = new SoftFactoryMap<DomElement, CachedValue<Map<String, DomElement>>>(){

        @NotNull
        protected CachedValue<Map<String, DomElement>> create(final @NotNull DomElement scope2) {
            DomManager domManager;
            if (scope2 == null) {
                1.$$$reportNull$$$0(0);
            }
            if ((domManager = scope2.getManager()) == null) {
                throw new AssertionError((Object)("Null DomManager for " + scope2.getClass()));
            }
            Project project2 = domManager.getProject();
            CachedValue cachedValue = CachedValuesManager.getManager((Project)project2).createCachedValue((CachedValueProvider)new CachedValueProvider<Map<String, DomElement>>(){

                public CachedValueProvider.Result<Map<String, DomElement>> compute() {
                    HashMap<String, DomElement> map2 = new HashMap<String, DomElement>();
                    this.visitDomElement(scope2, map2);
                    return new CachedValueProvider.Result(map2, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                }

                private void visitDomElement(DomElement element, Map<String, DomElement> map2) {
                    if (DomResolveConverter.this.myClass.isInstance(element)) {
                        String name = ElementPresentationManager.getElementName(element);
                        if (name != null && !map2.containsKey(name)) {
                            map2.put(name, element);
                        }
                    } else {
                        for (DomElement child : DomUtil.getDefinedChildren(element, true, DomResolveConverter.this.myAttribute)) {
                            this.visitDomElement(child, map2);
                        }
                    }
                }
            }, false);
            if (cachedValue == null) {
                1.$$$reportNull$$$0(1);
            }
            return cachedValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/xml/DomResolveConverter$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/xml/DomResolveConverter$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    };
    private final Class<T> myClass;

    public DomResolveConverter(Class<T> aClass) {
        this.myClass = aClass;
        this.myAttribute = GenericAttributeValue.class.isAssignableFrom(this.myClass);
    }

    public static <T extends DomElement> DomResolveConverter<T> createConverter(Class<T> aClass) {
        return ourCache.get(aClass);
    }

    @Override
    public T fromString(String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        return (T)((DomElement)((Map)((CachedValue)this.myResolveCache.get((Object)DomResolveConverter.getResolvingScope(context))).getValue()).get(s));
    }

    @Override
    public PsiElement getPsiElement(@Nullable T resolvedValue) {
        if (resolvedValue == null) {
            return null;
        }
        DomTarget target = DomTarget.getTarget(resolvedValue);
        return target == null ? super.getPsiElement(resolvedValue) : PomService.convertToPsi((PsiTarget)target);
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element, String stringValue, @Nullable T resolveResult, ConvertContext context) {
        if (element == null) {
            DomResolveConverter.$$$reportNull$$$0(0);
        }
        return resolveResult != null && element.getManager().areElementsEquivalent(element, (PsiElement)resolveResult.getXmlElement());
    }

    private static DomElement getResolvingScope(ConvertContext context) {
        DomElement invocationElement = context.getInvocationElement();
        return invocationElement.getManager().getResolvingScope((GenericDomValue)invocationElement);
    }

    @Override
    public String getErrorMessage(String s, ConvertContext context) {
        return CodeInsightBundle.message((String)"error.cannot.resolve.0.1", (Object[])new Object[]{TypePresentationService.getService().getTypePresentableName(this.myClass), s});
    }

    @Override
    public String toString(T t, ConvertContext context) {
        if (t == null) {
            return null;
        }
        return ElementPresentationManager.getElementName(t);
    }

    @Override
    @NotNull
    public Collection<? extends T> getVariants(ConvertContext context) {
        DomElement reference = context.getInvocationElement();
        DomElement scope2 = reference.getManager().getResolvingScope((GenericDomValue)reference);
        Collection collection = ((Map)((CachedValue)this.myResolveCache.get((Object)scope2)).getValue()).values();
        if (collection == null) {
            DomResolveConverter.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @Override
    public LocalQuickFix[] getQuickFixes(ConvertContext context) {
        DomElement element = context.getInvocationElement();
        GenericDomValue value2 = (GenericDomValue)element.createStableCopy();
        String newName = value2.getStringValue();
        if (newName == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        DomElement scope2 = value2.getManager().getResolvingScope(value2);
        return ResolvingElementQuickFix.createFixes(newName, this.myClass, scope2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/DomResolveConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/DomResolveConverter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

