/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentEnumerator;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.storage.AbstractStorage;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.VcsLogFullDetailsIndex;
import com.intellij.vcs.log.impl.VcsLogErrorHandler;
import com.intellij.vcs.log.impl.VcsLogIndexer;
import com.intellij.vcs.log.util.StorageId;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsLogPathsIndex
extends VcsLogFullDetailsIndex<List<ChangeKind>, VcsLogIndexer.CompressedDetails> {
    private static final Logger LOG = Logger.getInstance(VcsLogPathsIndex.class);
    public static final String PATHS = "paths";
    public static final String INDEX_PATHS_IDS = "paths-ids";
    public static final String RENAMES_MAP = "renames-map";
    @NotNull
    private final PathIndexer myPathsIndexer;

    public VcsLogPathsIndex(@NotNull StorageId.Directory storageId, @NotNull VcsLogStorage storage, @NotNull Set<VirtualFile> roots, @Nullable StorageLockContext storageLockContext, @NotNull VcsLogErrorHandler errorHandler2, @NotNull PersistentHashMap<int[], int[]> renamesMap, @NotNull Disposable disposableParent) throws IOException {
        if (storageId == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(0);
        }
        if (storage == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(1);
        }
        if (roots == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(2);
        }
        if (errorHandler2 == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(3);
        }
        if (renamesMap == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(4);
        }
        if (disposableParent == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(5);
        }
        super(storageId, PATHS, new PathIndexer(storage, VcsLogPathsIndex.createPathsEnumerator(roots, storageId, storageLockContext), renamesMap), new ChangeKindListKeyDescriptor(), storageLockContext, errorHandler2, disposableParent);
        this.myPathsIndexer = (PathIndexer)this.myIndexer;
        this.myPathsIndexer.setFatalErrorConsumer(e -> errorHandler2.handleError(VcsLogErrorHandler.Source.Index, (Throwable)e));
    }

    @NotNull
    private static PersistentEnumerator<LightFilePath> createPathsEnumerator(@NotNull Collection<VirtualFile> roots, @NotNull StorageId.Directory storageId, @Nullable StorageLockContext storageLockContext) throws IOException {
        if (roots == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(6);
        }
        if (storageId == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(7);
        }
        Path storageFile = storageId.getStorageFile(INDEX_PATHS_IDS);
        return new PersistentEnumerator(storageFile, (KeyDescriptor)new LightFilePathKeyDescriptor(roots), AbstractStorage.PAGE_SIZE, storageLockContext, storageId.getVersion());
    }

    @Nullable
    FilePath getPath(int pathId, boolean isDirectory) {
        try {
            return VcsLogPathsIndex.toFilePath(this.getPath(pathId), isDirectory);
        }
        catch (IOException e) {
            this.myPathsIndexer.myFatalErrorConsumer.accept(e);
            return null;
        }
    }

    int getPathId(@NotNull LightFilePath path2) throws IOException {
        if (path2 == null) {
            VcsLogPathsIndex.$$$reportNull$$$0(8);
        }
        return this.myPathsIndexer.myPathsEnumerator.enumerate((Object)path2);
    }

    @Nullable
    LightFilePath getPath(int pathId) throws IOException {
        return (LightFilePath)this.myPathsIndexer.myPathsEnumerator.valueOf(pathId);
    }

    @Override
    public void flush() throws StorageException {
        super.flush();
        this.myPathsIndexer.myRenamesMap.force();
        this.myPathsIndexer.myPathsEnumerator.force();
    }

    @Override
    public void dispose() {
        super.dispose();
        try {
            this.myPathsIndexer.myPathsEnumerator.close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    @Contract(value="null,_ -> null; !null,_ -> !null")
    @Nullable
    static FilePath toFilePath(@Nullable LightFilePath lightFilePath, boolean isDirectory) {
        if (lightFilePath == null) {
            return null;
        }
        return VcsUtil.getFilePath(lightFilePath.getRoot().getPath() + "/" + lightFilePath.getRelativePath(), isDirectory);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renamesMap";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposableParent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createPathsEnumerator";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getPathId";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class PathIndexer
    implements DataIndexer<Integer, List<ChangeKind>, VcsLogIndexer.CompressedDetails> {
        @NotNull
        private final VcsLogStorage myStorage;
        @NotNull
        private final PersistentEnumerator<LightFilePath> myPathsEnumerator;
        @NotNull
        private final PersistentHashMap<int[], int[]> myRenamesMap;
        @NotNull
        private Consumer<? super Exception> myFatalErrorConsumer;

        private PathIndexer(@NotNull VcsLogStorage storage, @NotNull PersistentEnumerator<LightFilePath> pathsEnumerator, @NotNull PersistentHashMap<int[], int[]> renamesMap) {
            if (storage == null) {
                PathIndexer.$$$reportNull$$$0(0);
            }
            if (pathsEnumerator == null) {
                PathIndexer.$$$reportNull$$$0(1);
            }
            if (renamesMap == null) {
                PathIndexer.$$$reportNull$$$0(2);
            }
            this.myFatalErrorConsumer = arg_0 -> ((Logger)LOG).error(arg_0);
            this.myStorage = storage;
            this.myPathsEnumerator = pathsEnumerator;
            this.myRenamesMap = renamesMap;
        }

        public void setFatalErrorConsumer(@NotNull Consumer<? super Exception> fatalErrorConsumer) {
            if (fatalErrorConsumer == null) {
                PathIndexer.$$$reportNull$$$0(3);
            }
            this.myFatalErrorConsumer = fatalErrorConsumer;
        }

        @NotNull
        public Map<Integer, List<ChangeKind>> map(@NotNull VcsLogIndexer.CompressedDetails inputData) {
            if (inputData == null) {
                PathIndexer.$$$reportNull$$$0(4);
            }
            Int2ObjectOpenHashMap result2 = new Int2ObjectOpenHashMap();
            int parentsCount = inputData.getParents().isEmpty() ? 1 : inputData.getParents().size();
            for (int parentIndex = 0; parentIndex < parentsCount; ++parentIndex) {
                try {
                    ObjectSet entries2 = inputData.getRenamedPaths(parentIndex).int2IntEntrySet();
                    if (!entries2.isEmpty()) {
                        int[] renames2 = new int[entries2.size() * 2];
                        int index = 0;
                        for (Int2IntMap.Entry entry2 : entries2) {
                            renames2[index++] = entry2.getIntKey();
                            renames2[index++] = entry2.getIntValue();
                            PathIndexer.getOrCreateChangeKindList((Int2ObjectMap<List<ChangeKind>>)result2, entry2.getIntKey(), parentsCount).set(parentIndex, ChangeKind.REMOVED);
                            PathIndexer.getOrCreateChangeKindList((Int2ObjectMap<List<ChangeKind>>)result2, entry2.getIntValue(), parentsCount).set(parentIndex, ChangeKind.ADDED);
                        }
                        int commit2 = this.myStorage.getCommitIndex((Hash)inputData.getId(), inputData.getRoot());
                        int parent = this.myStorage.getCommitIndex((Hash)inputData.getParents().get(parentIndex), inputData.getRoot());
                        this.myRenamesMap.put((Object)new int[]{parent, commit2}, (Object)renames2);
                    }
                    for (Int2ObjectMap.Entry entry3 : inputData.getModifiedPaths(parentIndex).int2ObjectEntrySet()) {
                        PathIndexer.getOrCreateChangeKindList((Int2ObjectMap<List<ChangeKind>>)result2, entry3.getIntKey(), parentsCount).set(parentIndex, PathIndexer.createChangeData((Change.Type)((Object)entry3.getValue())));
                    }
                    continue;
                }
                catch (IOException e) {
                    this.myFatalErrorConsumer.accept(e);
                }
            }
            Int2ObjectOpenHashMap int2ObjectOpenHashMap = result2;
            if (int2ObjectOpenHashMap == null) {
                PathIndexer.$$$reportNull$$$0(5);
            }
            return int2ObjectOpenHashMap;
        }

        @NotNull
        static List<ChangeKind> getOrCreateChangeKindList(@NotNull Int2ObjectMap<List<ChangeKind>> pathIdToChangeDataListsMap, int pathId, int parentsCount) {
            ArrayList<ChangeKind> changeDataList;
            if (pathIdToChangeDataListsMap == null) {
                PathIndexer.$$$reportNull$$$0(6);
            }
            if ((changeDataList = (ArrayList<ChangeKind>)pathIdToChangeDataListsMap.get(pathId)) == null) {
                if (parentsCount == 1) {
                    changeDataList = new SmartList((Object)ChangeKind.NOT_CHANGED);
                } else {
                    changeDataList = new ArrayList<ChangeKind>(parentsCount);
                    for (int i = 0; i < parentsCount; ++i) {
                        changeDataList.add(ChangeKind.NOT_CHANGED);
                    }
                }
                pathIdToChangeDataListsMap.put(pathId, changeDataList);
            }
            ArrayList<ChangeKind> arrayList = changeDataList;
            if (arrayList == null) {
                PathIndexer.$$$reportNull$$$0(7);
            }
            return arrayList;
        }

        @NotNull
        static ChangeKind createChangeData(@NotNull Change.Type type2) {
            if (type2 == null) {
                PathIndexer.$$$reportNull$$$0(8);
            }
            ChangeKind changeKind = switch (type2) {
                default -> throw new IncompatibleClassChangeError();
                case Change.Type.NEW -> ChangeKind.ADDED;
                case Change.Type.DELETED -> ChangeKind.REMOVED;
                case Change.Type.MOVED, Change.Type.MODIFICATION -> ChangeKind.MODIFIED;
            };
            if (changeKind == null) {
                PathIndexer.$$$reportNull$$$0(9);
            }
            return changeKind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 7, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathsEnumerator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renamesMap";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fatalErrorConsumer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 5: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathIndexer";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathIdToChangeDataListsMap";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$PathIndexer";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCreateChangeKindList";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createChangeData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setFatalErrorConsumer";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 5: 
                case 7: 
                case 9: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getOrCreateChangeKindList";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createChangeData";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 5, 7, 9 -> new IllegalStateException(string2);
            };
        }
    }

    private static class ChangeKindListKeyDescriptor
    implements DataExternalizer<List<ChangeKind>> {
        private ChangeKindListKeyDescriptor() {
        }

        public void save(@NotNull DataOutput out, List<ChangeKind> value2) throws IOException {
            if (out == null) {
                ChangeKindListKeyDescriptor.$$$reportNull$$$0(0);
            }
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value2.size());
            for (ChangeKind data2 : value2) {
                out.writeByte(data2.id);
            }
        }

        public List<ChangeKind> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                ChangeKindListKeyDescriptor.$$$reportNull$$$0(1);
            }
            SmartList value2 = new SmartList();
            int size = DataInputOutputUtil.readINT((DataInput)in);
            for (int i = 0; i < size; ++i) {
                value2.add(ChangeKind.getChangeKindById(in.readByte()));
            }
            return value2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$ChangeKindListKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class LightFilePathKeyDescriptor
    implements KeyDescriptor<LightFilePath> {
        @NotNull
        private final List<VirtualFile> myRoots;
        @NotNull
        private final Object2IntMap<VirtualFile> myRootsReversed;

        private LightFilePathKeyDescriptor(@NotNull Collection<VirtualFile> roots) {
            if (roots == null) {
                LightFilePathKeyDescriptor.$$$reportNull$$$0(0);
            }
            this.myRoots = ContainerUtil.sorted(roots, Comparator.comparing(VirtualFile::getPath));
            this.myRootsReversed = new Object2IntOpenHashMap();
            for (int i = 0; i < this.myRoots.size(); ++i) {
                this.myRootsReversed.put((Object)this.myRoots.get(i), i);
            }
        }

        public int getHashCode(@NotNull LightFilePath path2) {
            if (path2 == null) {
                LightFilePathKeyDescriptor.$$$reportNull$$$0(1);
            }
            return path2.hashCode();
        }

        public boolean isEqual(@Nullable LightFilePath path1, @Nullable LightFilePath path2) {
            return Objects.equals(path1, path2);
        }

        public void save(@NotNull DataOutput out, LightFilePath value2) throws IOException {
            if (out == null) {
                LightFilePathKeyDescriptor.$$$reportNull$$$0(2);
            }
            out.writeInt(this.myRootsReversed.getInt((Object)value2.getRoot()));
            IOUtil.writeUTF((DataOutput)out, (String)value2.getRelativePath());
        }

        public LightFilePath read(@NotNull DataInput in) throws IOException {
            int rootIndex;
            VirtualFile root;
            if (in == null) {
                LightFilePathKeyDescriptor.$$$reportNull$$$0(3);
            }
            if ((root = this.myRoots.get(rootIndex = in.readInt())) == null) {
                throw new IOException("Can not read root for index " + rootIndex + ". All roots " + this.myRoots);
            }
            String path2 = IOUtil.readUTF((DataInput)in);
            return new LightFilePath(root, path2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$LightFilePathKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getHashCode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class LightFilePath {
        @NotNull
        private final VirtualFile myRoot;
        @NotNull
        private final String myRelativePath;

        LightFilePath(@NotNull VirtualFile root, @NotNull String relativePath) {
            if (root == null) {
                LightFilePath.$$$reportNull$$$0(0);
            }
            if (relativePath == null) {
                LightFilePath.$$$reportNull$$$0(1);
            }
            this.myRoot = root;
            this.myRelativePath = relativePath;
        }

        LightFilePath(@NotNull VirtualFile root, @NotNull FilePath filePath) {
            if (root == null) {
                LightFilePath.$$$reportNull$$$0(2);
            }
            if (filePath == null) {
                LightFilePath.$$$reportNull$$$0(3);
            }
            this(root, VcsFileUtil.relativePath(root, filePath));
        }

        @NotNull
        public VirtualFile getRoot() {
            VirtualFile virtualFile = this.myRoot;
            if (virtualFile == null) {
                LightFilePath.$$$reportNull$$$0(4);
            }
            return virtualFile;
        }

        @NotNull
        public String getRelativePath() {
            String string2 = this.myRelativePath;
            if (string2 == null) {
                LightFilePath.$$$reportNull$$$0(5);
            }
            return string2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LightFilePath path2 = (LightFilePath)o;
            return this.myRoot.getPath().equals(path2.myRoot.getPath()) && this.myRelativePath.equals(path2.myRelativePath);
        }

        public int hashCode() {
            return Objects.hash(this.myRoot.getPath(), this.myRelativePath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "relativePath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$LightFilePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPathsIndex$LightFilePath";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRoot";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRelativePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 4, 5 -> new IllegalStateException(string2);
            };
        }
    }

    public static enum ChangeKind {
        MODIFIED(0),
        NOT_CHANGED(1),
        ADDED(2),
        REMOVED(3);

        public final byte id;
        private static final ChangeKind[] KINDS;

        private ChangeKind(byte id) {
            this.id = id;
        }

        @NotNull
        public static ChangeKind getChangeKindById(byte id) throws IOException {
            ChangeKind kind;
            ChangeKind changeKind = kind = id >= 0 && id < KINDS.length ? KINDS[id] : null;
            if (kind == null) {
                throw new IOException("Change kind by id " + id + " not found.");
            }
            ChangeKind changeKind2 = kind;
            if (changeKind2 == null) {
                ChangeKind.$$$reportNull$$$0(0);
            }
            return changeKind2;
        }

        static {
            KINDS = new ChangeKind[4];
            ChangeKind[] changeKindArray = ChangeKind.values();
            int n = changeKindArray.length;
            for (int i = 0; i < n; ++i) {
                ChangeKind kind;
                ChangeKind.KINDS[kind.id] = kind = changeKindArray[i];
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogPathsIndex$ChangeKind", "getChangeKindById"));
        }
    }
}

