/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.IdTypeMap;
import com.thaiopensource.relaxng.impl.SchemaBuilderImpl;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.xml.util.Name;
import com.thaiopensource.xml.util.StringSplitter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class IdSoundnessChecker
implements Validator,
ContentHandler {
    private final IdTypeMap idTypeMap;
    private final ErrorHandler eh;
    private Locator locator;
    private final Hashtable table = new Hashtable();

    public IdSoundnessChecker(IdTypeMap idTypeMap, ErrorHandler errorHandler2) {
        this.idTypeMap = idTypeMap;
        this.eh = errorHandler2;
    }

    public void reset() {
        this.table.clear();
        this.locator = null;
    }

    public ContentHandler getContentHandler() {
        return this;
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
    }

    void setComplete() {
    }

    public void endDocument() throws SAXException {
        Enumeration enumeration = this.table.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Entry entry2 = (Entry)this.table.get(string2);
            if (entry2.hadId) continue;
            Enumeration enumeration2 = entry2.idrefLocs.elements();
            while (enumeration2.hasMoreElements()) {
                this.error("missing_id", string2, (Locator)enumeration2.nextElement());
            }
        }
        this.setComplete();
    }

    public void startPrefixMapping(String string2, String string3) throws SAXException {
    }

    public void endPrefixMapping(String string2) throws SAXException {
    }

    public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
        Name name = new Name(string2, string3);
        int n = attributes.getLength();
        int n2 = 0;
        while (n2 < n) {
            Name name2 = new Name(attributes.getURI(n2), attributes.getLocalName(n2));
            int n3 = this.idTypeMap.getIdType(name, name2);
            if (n3 != 0) {
                String[] stringArray = StringSplitter.split(attributes.getValue(n2));
                switch (n3) {
                    case 1: {
                        if (stringArray.length == 1) {
                            this.id(stringArray[0]);
                            break;
                        }
                        if (stringArray.length == 0) {
                            this.error("id_no_tokens");
                            break;
                        }
                        this.error("id_multiple_tokens");
                        break;
                    }
                    case 2: {
                        if (stringArray.length == 1) {
                            this.idref(stringArray[0]);
                            break;
                        }
                        if (stringArray.length == 0) {
                            this.error("idref_no_tokens");
                            break;
                        }
                        this.error("idref_multiple_tokens");
                        break;
                    }
                    case 3: {
                        if (stringArray.length > 0) {
                            int n4 = 0;
                            while (n4 < stringArray.length) {
                                this.idref(stringArray[n4]);
                                ++n4;
                            }
                            break;
                        }
                        this.error("idrefs_no_tokens");
                    }
                }
            }
            ++n2;
        }
    }

    private void id(String string2) throws SAXException {
        Entry entry2 = (Entry)this.table.get(string2);
        if (entry2 == null) {
            entry2 = new Entry();
            this.table.put(string2, entry2);
        } else if (entry2.hadId) {
            this.error("duplicate_id", string2);
            this.error("first_id", string2, entry2.idLoc);
            return;
        }
        entry2.idLoc = new LocatorImpl(this.locator);
        entry2.hadId = true;
    }

    private void idref(String string2) {
        Entry entry2 = (Entry)this.table.get(string2);
        if (entry2 == null) {
            entry2 = new Entry();
            this.table.put(string2, entry2);
        }
        if (entry2.hadId) {
            return;
        }
        if (entry2.idrefLocs == null) {
            entry2.idrefLocs = new Vector();
        }
        entry2.idrefLocs.addElement(new LocatorImpl(this.locator));
    }

    public void endElement(String string2, String string3, String string4) throws SAXException {
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string2, String string3) throws SAXException {
    }

    public void skippedEntity(String string2) throws SAXException {
    }

    public void notationDecl(String string2, String string3, String string4) throws SAXException {
    }

    public void unparsedEntityDecl(String string2, String string3, String string4, String string5) throws SAXException {
    }

    private void error(String string2) throws SAXException {
        this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(string2), this.locator));
    }

    private void error(String string2, String string3) throws SAXException {
        this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(string2, string3), this.locator));
    }

    private void error(String string2, String string3, Locator locator) throws SAXException {
        this.eh.error(new SAXParseException(SchemaBuilderImpl.localizer.message(string2, string3), locator));
    }

    private static class Entry {
        Locator idLoc;
        Vector idrefLocs;
        boolean hadId;

        private Entry() {
        }
    }
}

