/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.psi.RegExpBackref;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpConditional;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.intellij.lang.regexp.psi.impl.RegExpGroupImpl;
import org.jetbrains.annotations.NotNull;

public class SuspiciousBackrefInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SuspiciousBackrefInspection.$$$reportNull$$$0(0);
        }
        return new SuspiciousBackrefVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/SuspiciousBackrefInspection", "buildVisitor"));
    }

    private static class SuspiciousBackrefVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        SuspiciousBackrefVisitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                SuspiciousBackrefVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpBackref(RegExpBackref backref) {
            super.visitRegExpBackref(backref);
            RegExpGroup target = backref.resolve();
            if (target == null) {
                return;
            }
            RegExpBranch branch = (RegExpBranch)PsiTreeUtil.getParentOfType((PsiElement)target, RegExpBranch.class);
            if (!PsiTreeUtil.isAncestor((PsiElement)branch, (PsiElement)backref, (boolean)true)) {
                String message2 = RegExpBundle.message("inspection.warning.group.back.reference.are.in.different.branches", backref.getIndex());
                this.myHolder.registerProblem((PsiElement)backref, message2, new LocalQuickFix[0]);
            } else if (target.getTextOffset() > backref.getTextOffset()) {
                String message3 = RegExpBundle.message("inspection.warning.group.defined.after.back.reference", backref.getIndex());
                this.myHolder.registerProblem((PsiElement)backref, message3, new LocalQuickFix[0]);
            }
        }

        @Override
        public void visitRegExpNamedGroupRef(RegExpNamedGroupRef groupRef) {
            super.visitRegExpNamedGroupRef(groupRef);
            RegExpGroup target = groupRef.resolve();
            if (target == null) {
                return;
            }
            RegExpBranch branch = (RegExpBranch)PsiTreeUtil.getParentOfType((PsiElement)target, RegExpBranch.class);
            if (!PsiTreeUtil.isAncestor((PsiElement)branch, (PsiElement)groupRef, (boolean)true) && !SuspiciousBackrefVisitor.isPcreCondition(branch)) {
                String message2 = RegExpBundle.message("inspection.warning.group.back.reference.are.in.different.branches", groupRef.getGroupName());
                this.myHolder.registerProblem((PsiElement)groupRef, message2, new LocalQuickFix[0]);
            } else if (target.getTextOffset() > groupRef.getTextOffset()) {
                String message3 = RegExpBundle.message("inspection.warning.group.defined.after.back.reference", groupRef.getGroupName());
                this.myHolder.registerProblem((PsiElement)groupRef, message3, new LocalQuickFix[0]);
            }
        }

        private static boolean isPcreCondition(RegExpBranch branch) {
            if (branch == null) {
                return false;
            }
            if (branch.getParent() instanceof RegExpConditional) {
                RegExpGroup groupCondition = (RegExpGroup)ObjectUtils.tryCast((Object)((RegExpConditional)branch.getParent()).getCondition(), RegExpGroup.class);
                return groupCondition != null && RegExpGroupImpl.isPcreConditionalGroup(groupCondition.getNode());
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/SuspiciousBackrefInspection$SuspiciousBackrefVisitor", "<init>"));
        }
    }
}

