/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.descriptors;

import com.intellij.codeInsight.daemon.Validator;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptorEx;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.intellij.plugins.relaxNG.model.descriptors.ChildElementFinder;
import org.intellij.plugins.relaxNG.model.descriptors.CompositeDescriptor;
import org.intellij.plugins.relaxNG.model.descriptors.NamedPatternFilter;
import org.intellij.plugins.relaxNG.model.descriptors.RngElementDescriptor;
import org.intellij.plugins.relaxNG.model.resolve.RelaxIncludeIndex;
import org.intellij.plugins.relaxNG.validation.RngParser;
import org.intellij.plugins.relaxNG.validation.XmlInstanceValidator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.rngom.digested.DElementPattern;
import org.kohsuke.rngom.digested.DPattern;
import org.kohsuke.rngom.nc.NameClass;

public class RngNsDescriptor
implements XmlNSDescriptorEx,
Validator {
    private final Map<QName, CachedValue<XmlElementDescriptor>> myDescriptorsMap = Collections.synchronizedMap(new HashMap());
    private XmlFile myFile;
    private PsiElement myElement;
    private String myUrl;
    private DPattern myPattern;
    private PsiManager myManager;

    @Override
    @Nullable
    public XmlElementDescriptor getElementDescriptor(@NotNull XmlTag tag) {
        XmlElementDescriptor desc;
        if (tag == null) {
            RngNsDescriptor.$$$reportNull$$$0(0);
        }
        if (this.myPattern == null) {
            return null;
        }
        LinkedList<XmlTag> chain = new LinkedList<XmlTag>();
        for (XmlTag _tag = tag; _tag != null; _tag = _tag.getParentTag()) {
            chain.addFirst(_tag);
        }
        while ((desc = this.findRootDescriptor((XmlTag)chain.removeFirst())) == null && chain.size() > 0) {
        }
        if (desc != null) {
            XmlTag xmlTag;
            Iterator iterator = chain.iterator();
            while (iterator.hasNext() && (desc = desc.getElementDescriptor(xmlTag = (XmlTag)iterator.next(), xmlTag.getParentTag())) != null) {
            }
        }
        if (desc == null || desc instanceof AnyXmlElementDescriptor) {
            return this.findRootDescriptor(tag);
        }
        return desc;
    }

    private XmlElementDescriptor findRootDescriptor(XmlTag tag) {
        return this.getElementDescriptor(tag.getLocalName(), tag.getNamespace());
    }

    private XmlElementDescriptor findRootDescriptorInner(QName qName) {
        XmlElementDescriptor descriptor = this.findDescriptor(qName, (List<? extends DElementPattern>)ContainerUtil.findAll(ChildElementFinder.find(-1, this.myPattern), (Condition)NamedPatternFilter.INSTANCE));
        return descriptor != null ? descriptor : this.findDescriptor(qName, ChildElementFinder.find(this.myPattern));
    }

    public XmlElementDescriptor findDescriptor(XmlTag tag, List<? extends DElementPattern> list2) {
        QName qName = new QName(tag.getNamespace(), tag.getLocalName());
        return this.findDescriptor(qName, list2);
    }

    private XmlElementDescriptor findDescriptor(QName qName, List<? extends DElementPattern> list2) {
        int max = -1;
        DElementPattern maxPattern = null;
        for (DElementPattern dElementPattern : list2) {
            int spec;
            NameClass nameClass = dElementPattern.getName();
            if (!nameClass.contains(qName) || (spec = nameClass.containsSpecificity(qName)) <= max) continue;
            maxPattern = dElementPattern;
            max = spec;
        }
        List patterns = ContainerUtil.findAll(list2, pattern2 -> {
            NameClass nameClass = pattern2.getName();
            return nameClass.contains(qName);
        });
        if (maxPattern != null) {
            if (patterns.size() > 1) {
                return this.initDescriptor(new CompositeDescriptor(this, maxPattern, patterns));
            }
            return this.initDescriptor(new RngElementDescriptor(this, maxPattern));
        }
        return null;
    }

    @Override
    public XmlElementDescriptor @NotNull [] getRootElementsDescriptors(@Nullable XmlDocument document2) {
        if (this.myPattern == null) {
            if (XmlElementDescriptor.EMPTY_ARRAY == null) {
                RngNsDescriptor.$$$reportNull$$$0(1);
            }
            return XmlElementDescriptor.EMPTY_ARRAY;
        }
        List<DElementPattern> list2 = ChildElementFinder.find(-1, this.myPattern);
        XmlElementDescriptor[] xmlElementDescriptorArray = this.convertElementDescriptors(list2);
        if (xmlElementDescriptorArray == null) {
            RngNsDescriptor.$$$reportNull$$$0(2);
        }
        return xmlElementDescriptorArray;
    }

    XmlElementDescriptor[] convertElementDescriptors(List<? extends DElementPattern> patterns) {
        patterns = ContainerUtil.findAll(patterns, (Condition)NamedPatternFilter.INSTANCE);
        LinkedHashMap name2patterns = new LinkedHashMap();
        for (DElementPattern pattern2 : patterns) {
            ProgressManager.checkCanceled();
            for (QName qName : pattern2.getName().listNames()) {
                ArrayList<DElementPattern> dPatterns = (ArrayList<DElementPattern>)name2patterns.get(qName);
                if (dPatterns == null) {
                    dPatterns = new ArrayList<DElementPattern>();
                    name2patterns.put(qName, dPatterns);
                }
                if (dPatterns.contains(pattern2)) continue;
                dPatterns.add(pattern2);
            }
        }
        ArrayList<XmlElementDescriptor> result2 = new ArrayList<XmlElementDescriptor>();
        for (QName qName : name2patterns.keySet()) {
            List patternList;
            XmlElementDescriptor descriptor = this.findDescriptor(qName, (List<? extends DElementPattern>)(patternList = (List)name2patterns.get(qName)));
            if (descriptor == null) continue;
            result2.add(descriptor);
        }
        return result2.toArray(XmlElementDescriptor.EMPTY_ARRAY);
    }

    protected XmlElementDescriptor initDescriptor(@NotNull XmlElementDescriptor descriptor) {
        if (descriptor == null) {
            RngNsDescriptor.$$$reportNull$$$0(3);
        }
        return descriptor;
    }

    @Override
    @NotNull
    public XmlFile getDescriptorFile() {
        XmlFile xmlFile = this.myFile;
        if (xmlFile == null) {
            RngNsDescriptor.$$$reportNull$$$0(4);
        }
        return xmlFile;
    }

    public synchronized PsiElement getDeclaration() {
        PsiFile file;
        VirtualFile fileByUrl;
        if (!(this.myElement.isValid() && this.myFile.isValid() || this.myUrl == null || (fileByUrl = VirtualFileManager.getInstance().findFileByUrl(this.myUrl)) == null || !((file = this.myManager.findFile(fileByUrl)) instanceof XmlFile))) {
            this.init(((XmlFile)file).getDocument());
        }
        return this.myFile.isValid() ? this.myFile.getDocument() : null;
    }

    @NonNls
    public String getName(PsiElement context) {
        return this.getName();
    }

    @NonNls
    public String getName() {
        return this.getDescriptorFile().getName();
    }

    public Object @NotNull [] getDependencies() {
        if (this.myPattern != null) {
            if (DumbService.isDumb((Project)this.myElement.getProject())) {
                Object[] objectArray = new Object[]{ModificationTracker.EVER_CHANGED, ExternalResourceManager.getInstance()};
                if (objectArray == null) {
                    RngNsDescriptor.$$$reportNull$$$0(5);
                }
                return objectArray;
            }
            Object[] a = new Object[]{this.myElement, ExternalResourceManager.getInstance()};
            PsiElementProcessor.CollectElements processor2 = new PsiElementProcessor.CollectElements();
            RelaxIncludeIndex.processForwardDependencies(this.myFile, (PsiElementProcessor<? super XmlFile>)processor2);
            if (processor2.getCollection().size() > 0) {
                Object[] objectArray = ArrayUtil.mergeArrays((Object[])a, (Object[])processor2.toArray());
                if (objectArray == null) {
                    RngNsDescriptor.$$$reportNull$$$0(6);
                }
                return objectArray;
            }
            if (a == null) {
                RngNsDescriptor.$$$reportNull$$$0(7);
            }
            return a;
        }
        Object[] objectArray = new Object[]{ModificationTracker.EVER_CHANGED};
        if (objectArray == null) {
            RngNsDescriptor.$$$reportNull$$$0(8);
        }
        return objectArray;
    }

    public synchronized void init(PsiElement element) {
        this.myElement = element;
        this.myFile = element instanceof XmlFile ? (XmlFile)element : (XmlFile)element.getContainingFile();
        this.myManager = this.myFile.getManager();
        VirtualFile file = this.myFile.getVirtualFile();
        if (file != null) {
            this.myUrl = file.getUrl();
        }
        this.myPattern = RngParser.getCachedPattern(this.getDescriptorFile(), RngParser.DEFAULT_HANDLER);
    }

    public void validate(@NotNull PsiElement context, @NotNull Validator.ValidationHost host) {
        XmlDocument doc;
        if (context == null) {
            RngNsDescriptor.$$$reportNull$$$0(9);
        }
        if (host == null) {
            RngNsDescriptor.$$$reportNull$$$0(10);
        }
        if ((doc = (XmlDocument)PsiTreeUtil.getContextOfType((PsiElement)context, XmlDocument.class, (boolean)false)) == null) {
            return;
        }
        XmlTag rootTag = doc.getRootTag();
        if (rootTag == null) {
            return;
        }
        if (!"http://relaxng.org/ns/structure/1.0".equals(rootTag.getNamespace())) {
            XmlInstanceValidator.doValidation(doc, host, this.getDescriptorFile());
        }
    }

    @Override
    public XmlElementDescriptor getElementDescriptor(String localName, String namespace) {
        QName qName = new QName(namespace, localName);
        CachedValue cachedValue = this.myDescriptorsMap.get(qName);
        if (cachedValue == null) {
            cachedValue = CachedValuesManager.getManager((Project)this.myElement.getProject()).createCachedValue(() -> {
                XmlElementDescriptor descriptor = this.findRootDescriptorInner(qName);
                return descriptor != null ? new CachedValueProvider.Result((Object)descriptor, descriptor.getDependencies()) : new CachedValueProvider.Result(null, this.getDependencies());
            }, false);
            this.myDescriptorsMap.put(qName, (CachedValue<XmlElementDescriptor>)cachedValue);
        }
        return (XmlElementDescriptor)cachedValue.getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/relaxNG/model/descriptors/RngNsDescriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/relaxNG/model/descriptors/RngNsDescriptor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElementsDescriptors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptorFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initDescriptor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 4, 5, 6, 7, 8 -> new IllegalStateException(string2);
        };
    }
}

