/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/ObjectClassLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "pendingTransformations", "", "Lkotlin/Function0;", "", "lower", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nObjectClassLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectClassLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/ObjectClassLowering\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
final class ObjectClassLowering
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final List<Function0<Unit>> pendingTransformations;

    public ObjectClassLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.pendingTransformations = new ArrayList();
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        super.lower(irFile);
        for (Function0<Unit> transformation : this.pendingTransformations) {
            transformation.invoke();
        }
    }

    public void lower(@NotNull IrClass irClass) {
        Object v0;
        IrField privateInstanceField;
        IrField publicInstanceField;
        block6: {
            Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
            if (!IrUtilsKt.isObject((IrClass)irClass)) {
                return;
            }
            publicInstanceField = this.context.getCachedDeclarations().getFieldForObjectInstance(irClass);
            privateInstanceField = this.context.getCachedDeclarations().getPrivateFieldForObjectInstance(irClass);
            Sequence sequence2 = IrUtilsKt.getConstructors((IrClass)irClass);
            for (Object e : sequence2) {
                IrConstructor it = (IrConstructor)e;
                boolean bl = false;
                if (!it.isPrimary()) continue;
                v0 = e;
                break block6;
            }
            v0 = null;
        }
        IrConstructor irConstructor = v0;
        if (irConstructor == null) {
            throw new AssertionError((Object)("Object should have a primary constructor: " + irClass.getName()));
        }
        IrConstructor constructor = irConstructor;
        if (!Intrinsics.areEqual((Object)privateInstanceField, (Object)publicInstanceField)) {
            DeclarationIrBuilder $this$lower_u24lambda_u241 = LowerUtilsKt.createIrBuilder$default((BackendContext)((BackendContext)this.context), (IrSymbol)((IrSymbol)privateInstanceField.getSymbol()), (int)0, (int)0, (int)6, null);
            boolean bl = false;
            privateInstanceField.setInitializer(ExpressionHelpersKt.irExprBody((IrBuilderWithScope)((IrBuilderWithScope)$this$lower_u24lambda_u241), (IrExpression)((IrExpression)ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)$this$lower_u24lambda_u241), (IrConstructorSymbol)constructor.getSymbol()))));
            DeclarationIrBuilder $this$lower_u24lambda_u242 = LowerUtilsKt.createIrBuilder$default((BackendContext)((BackendContext)this.context), (IrSymbol)((IrSymbol)publicInstanceField.getSymbol()), (int)0, (int)0, (int)6, null);
            boolean bl2 = false;
            publicInstanceField.setInitializer(ExpressionHelpersKt.irExprBody((IrBuilderWithScope)((IrBuilderWithScope)$this$lower_u24lambda_u242), (IrExpression)((IrExpression)ExpressionHelpersKt.irGetField$default((IrBuilderWithScope)((IrBuilderWithScope)$this$lower_u24lambda_u242), null, (IrField)privateInstanceField, null, (int)4, null))));
            this.pendingTransformations.add(new Function0<Unit>(privateInstanceField){
                final /* synthetic */ IrField $privateInstanceField;
                {
                    this.$privateInstanceField = $privateInstanceField;
                    super(0);
                }

                public final void invoke() {
                    IrDeclarationParent irDeclarationParent = this.$privateInstanceField.getParent();
                    Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer");
                    ((IrDeclarationContainer)irDeclarationParent).getDeclarations().add(0, this.$privateInstanceField);
                }
            });
        } else {
            DeclarationIrBuilder $this$lower_u24lambda_u243 = LowerUtilsKt.createIrBuilder$default((BackendContext)((BackendContext)this.context), (IrSymbol)((IrSymbol)publicInstanceField.getSymbol()), (int)0, (int)0, (int)6, null);
            boolean bl = false;
            publicInstanceField.setInitializer(ExpressionHelpersKt.irExprBody((IrBuilderWithScope)((IrBuilderWithScope)$this$lower_u24lambda_u243), (IrExpression)((IrExpression)ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)$this$lower_u24lambda_u243), (IrConstructorSymbol)constructor.getSymbol()))));
        }
        if (!this.context.getConfig().getLanguageVersionSettings().supportsFeature(LanguageFeature.ProperVisibilityForCompanionObjectInstanceField) && (Intrinsics.areEqual((Object)irClass.getVisibility(), (Object)DescriptorVisibilities.PRIVATE) || Intrinsics.areEqual((Object)irClass.getVisibility(), (Object)DescriptorVisibilities.PROTECTED))) {
            JvmIrBuilder $this$lower_u24lambda_u244 = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, (IrSymbol)irClass.getSymbol(), 0, 0, 6, null);
            boolean bl = false;
            publicInstanceField.setAnnotations(CollectionsKt.plus((Collection)AdditionalIrUtilsKt.filterOutAnnotations((FqName)DeprecationResolver.Companion.getJAVA_DEPRECATED(), (List)publicInstanceField.getAnnotations()), (Object)ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$lower_u24lambda_u244, (IrConstructorSymbol)$this$lower_u24lambda_u244.getIrSymbols().getJavaLangDeprecatedConstructorWithDeprecatedFlag())));
        }
        this.pendingTransformations.add(new Function0<Unit>(publicInstanceField){
            final /* synthetic */ IrField $publicInstanceField;
            {
                this.$publicInstanceField = $publicInstanceField;
                super(0);
            }

            public final void invoke() {
                IrDeclarationParent irDeclarationParent = this.$publicInstanceField.getParent();
                Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer");
                ((IrDeclarationContainer)irDeclarationParent).getDeclarations().add(0, this.$publicInstanceField);
            }
        });
    }
}

