/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner;

import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.LoaderFactory;
import com.intellij.uiDesigner.PsiPropertiesProvider;
import com.intellij.uiDesigner.SerializedComponentData;
import com.intellij.uiDesigner.SimpleTransferable;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.XmlReader;
import com.intellij.uiDesigner.XmlWriter;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.LwComponent;
import com.intellij.uiDesigner.lw.LwContainer;
import com.intellij.uiDesigner.lw.PropertiesProvider;
import com.intellij.uiDesigner.radComponents.RadComponent;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CutCopyPasteSupport
implements CopyProvider,
CutProvider,
PasteProvider {
    private static final Logger LOG = Logger.getInstance(CutCopyPasteSupport.class);
    private static final SAXBuilder SAX_BUILDER = new SAXBuilder();
    private final GuiEditor myEditor;
    @NonNls
    private static final String ELEMENT_SERIALIZED = "serialized";
    @NonNls
    private static final String ATTRIBUTE_X = "x";
    @NonNls
    private static final String ATTRIBUTE_Y = "y";
    @NonNls
    private static final String ATTRIBUTE_PARENT_LAYOUT = "parent-layout";
    private static final DataFlavor ourDataFlavor = FileCopyPasteUtil.createJvmDataFlavor(SerializedComponentData.class);

    public CutCopyPasteSupport(GuiEditor uiEditor) {
        this.myEditor = uiEditor;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            CutCopyPasteSupport.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CutCopyPasteSupport.$$$reportNull$$$0(1);
        }
        return FormEditingUtil.getSelectedComponents(this.myEditor).size() > 0 && !this.myEditor.getInplaceEditingLayer().isEditing();
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CutCopyPasteSupport.$$$reportNull$$$0(2);
        }
        return true;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CutCopyPasteSupport.$$$reportNull$$$0(3);
        }
        this.doCopy();
    }

    private boolean doCopy() {
        ArrayList<RadComponent> selectedComponents = FormEditingUtil.getSelectedComponents(this.myEditor);
        SerializedComponentData data = new SerializedComponentData(CutCopyPasteSupport.serializeForCopy(this.myEditor, selectedComponents));
        SimpleTransferable<SerializedComponentData> transferable = new SimpleTransferable<SerializedComponentData>(data, SerializedComponentData.class, ourDataFlavor);
        try {
            CopyPasteManager.getInstance().setContents(transferable);
            return true;
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
            return false;
        }
    }

    public boolean isCutEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CutCopyPasteSupport.$$$reportNull$$$0(4);
        }
        return this.isCopyEnabled(dataContext) && FormEditingUtil.canDeleteSelection(this.myEditor);
    }

    public boolean isCutVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CutCopyPasteSupport.$$$reportNull$$$0(5);
        }
        return true;
    }

    public void performCut(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CutCopyPasteSupport.$$$reportNull$$$0(6);
        }
        if (this.doCopy() && this.myEditor.ensureEditable()) {
            CommandProcessor.getInstance().executeCommand(this.myEditor.getProject(), () -> FormEditingUtil.deleteSelection(this.myEditor), UIDesignerBundle.message("command.cut", new Object[0]), null);
        }
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CutCopyPasteSupport.$$$reportNull$$$0(7);
        }
        return this.isPasteEnabled(dataContext);
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CutCopyPasteSupport.$$$reportNull$$$0(8);
        }
        return CutCopyPasteSupport.getSerializedComponents() != null && !this.myEditor.getInplaceEditingLayer().isEditing();
    }

    public void performPaste(@NotNull DataContext dataContext) {
        String serializedComponents;
        if (dataContext == null) {
            CutCopyPasteSupport.$$$reportNull$$$0(9);
        }
        if ((serializedComponents = CutCopyPasteSupport.getSerializedComponents()) == null) {
            return;
        }
        ArrayList<RadComponent> componentsToPaste = new ArrayList<RadComponent>();
        IntArrayList xs = new IntArrayList();
        IntArrayList ys = new IntArrayList();
        CutCopyPasteSupport.loadComponentsToPaste(this.myEditor, serializedComponents, (IntList)xs, (IntList)ys, componentsToPaste);
        this.myEditor.getMainProcessor().startPasteProcessor(componentsToPaste, (IntList)xs, (IntList)ys);
    }

    @Nullable
    private static ArrayList<RadComponent> deserializeComponents(GuiEditor editor, String serializedComponents) {
        IntArrayList xs = new IntArrayList();
        IntArrayList ys = new IntArrayList();
        ArrayList<RadComponent> components = new ArrayList<RadComponent>();
        if (!CutCopyPasteSupport.loadComponentsToPaste(editor, serializedComponents, (IntList)xs, (IntList)ys, components)) {
            return null;
        }
        return components;
    }

    private static boolean loadComponentsToPaste(final GuiEditor editor, String serializedComponents, IntList xs, IntList ys, ArrayList<? super RadComponent> componentsToPaste) {
        PsiPropertiesProvider provider = new PsiPropertiesProvider(editor.getModule());
        try {
            Document document = SAX_BUILDER.build((Reader)new StringReader(serializedComponents), "UTF-8");
            Element rootElement = document.getRootElement();
            if (!rootElement.getName().equals(ELEMENT_SERIALIZED)) {
                return false;
            }
            List children = rootElement.getChildren();
            for (Object aChildren : children) {
                Element e = (Element)aChildren;
                LwContainer container = new LwContainer(JPanel.class.getName());
                String parentLayout = e.getAttributeValue(ATTRIBUTE_PARENT_LAYOUT);
                if (parentLayout != null) {
                    container.setLayoutManager(parentLayout);
                }
                int x = Integer.parseInt(e.getAttributeValue(ATTRIBUTE_X));
                int y = Integer.parseInt(e.getAttributeValue(ATTRIBUTE_Y));
                xs.add(x);
                ys.add(y);
                Element componentElement = (Element)e.getChildren().get(0);
                LwComponent lwComponent = LwContainer.createComponentFromTag((Element)componentElement);
                container.addComponent(lwComponent);
                lwComponent.read(componentElement, (PropertiesProvider)provider);
                FormEditingUtil.iterate((IComponent)lwComponent, new FormEditingUtil.ComponentVisitor<LwComponent>(){

                    @Override
                    public boolean visit(LwComponent c) {
                        if (c.getBinding() != null && FormEditingUtil.findComponentWithBinding(editor.getRootContainer(), c.getBinding()) != null) {
                            c.setBinding(null);
                        }
                        c.setId(FormEditingUtil.generateId(editor.getRootContainer()));
                        return true;
                    }
                });
                ClassLoader loader = LoaderFactory.getInstance(editor.getProject()).getLoader(editor.getFile());
                RadComponent radComponent = XmlReader.createComponent(editor, lwComponent, loader, editor.getStringDescriptorLocale());
                componentsToPaste.add(radComponent);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Nullable
    private static String getSerializedComponents() {
        try {
            Object transferData = CopyPasteManager.getInstance().getContents(ourDataFlavor);
            if (!(transferData instanceof SerializedComponentData)) {
                return null;
            }
            SerializedComponentData dataProxy = (SerializedComponentData)transferData;
            return dataProxy.getSerializedComponents();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static List<RadComponent> copyComponents(GuiEditor editor, List<RadComponent> components) {
        return CutCopyPasteSupport.deserializeComponents(editor, CutCopyPasteSupport.serializeForCopy(editor, components));
    }

    private static String serializeForCopy(GuiEditor editor, List<RadComponent> components) {
        XmlWriter writer = new XmlWriter();
        writer.startElement(ELEMENT_SERIALIZED, "http://www.intellij.com/uidesigner/form/");
        for (RadComponent component : components) {
            String parentLayout;
            Point shift = component.getParent() != null ? SwingUtilities.convertPoint(component.getParent().getDelegee(), component.getX(), component.getY(), editor.getRootContainer().getDelegee()) : new Point(0, 0);
            component.getX();
            writer.startElement("item");
            writer.addAttribute(ATTRIBUTE_X, shift.x);
            writer.addAttribute(ATTRIBUTE_Y, shift.y);
            if (component.getParent() != null && (parentLayout = component.getParent().getLayoutManager().getName()) != null) {
                writer.addAttribute(ATTRIBUTE_PARENT_LAYOUT, parentLayout);
            }
            component.write(writer);
            writer.endElement();
        }
        writer.endElement();
        return writer.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/CutCopyPasteSupport";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/CutCopyPasteSupport";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isCopyEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isCopyVisible";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performCopy";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isCutEnabled";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isCutVisible";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performCut";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isPastePossible";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isPasteEnabled";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "performPaste";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

