/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.projectView;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.uiDesigner.binding.FormClassIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class Form
implements Navigatable,
Iterable<PsiElement> {
    public static final DataKey<Form[]> DATA_KEY = DataKey.create((String)"form.array");
    private final Collection<PsiFile> myFormFiles;
    @NotNull
    private final PsiClass myClassToBind;

    public Form(@NotNull PsiClass classToBind) {
        if (classToBind == null) {
            Form.$$$reportNull$$$0(0);
        }
        this.myClassToBind = classToBind;
        this.myFormFiles = FormClassIndex.findFormsBoundToClass(classToBind.getProject(), classToBind);
    }

    public Form(@NotNull PsiClass classToBind, Collection<? extends PsiFile> formFiles) {
        if (classToBind == null) {
            Form.$$$reportNull$$$0(1);
        }
        this.myClassToBind = classToBind;
        this.myFormFiles = new HashSet<PsiFile>(formFiles);
    }

    public boolean equals(Object object) {
        if (object instanceof Form) {
            Form form = (Form)object;
            return this.myFormFiles.equals(form.myFormFiles) && this.myClassToBind.equals(form.myClassToBind);
        }
        return false;
    }

    public int hashCode() {
        return this.myFormFiles.hashCode() ^ this.myClassToBind.hashCode();
    }

    public String getName() {
        return this.myClassToBind.getName();
    }

    @NotNull
    public PsiClass getClassToBind() {
        PsiClass psiClass = this.myClassToBind;
        if (psiClass == null) {
            Form.$$$reportNull$$$0(2);
        }
        return psiClass;
    }

    public PsiFile[] getFormFiles() {
        return PsiUtilCore.toPsiFileArray(this.myFormFiles);
    }

    public void navigate(boolean requestFocus) {
        for (PsiFile psiFile : this.myFormFiles) {
            if (psiFile == null || !psiFile.canNavigate()) continue;
            psiFile.navigate(requestFocus);
        }
    }

    public boolean canNavigateToSource() {
        for (PsiFile psiFile : this.myFormFiles) {
            if (psiFile == null || !psiFile.canNavigateToSource()) continue;
            return true;
        }
        return false;
    }

    public boolean canNavigate() {
        for (PsiFile psiFile : this.myFormFiles) {
            if (psiFile == null || !psiFile.canNavigate()) continue;
            return true;
        }
        return false;
    }

    public boolean isValid() {
        if (this.myFormFiles.size() == 0) {
            return false;
        }
        for (PsiFile psiFile : this.myFormFiles) {
            if (psiFile.isValid()) continue;
            return false;
        }
        return this.myClassToBind.isValid();
    }

    public boolean containsFile(VirtualFile vFile) {
        VirtualFile classVFile;
        PsiFile classFile = this.myClassToBind.getContainingFile();
        VirtualFile virtualFile = classVFile = classFile == null ? null : classFile.getVirtualFile();
        if (classVFile != null && classVFile.equals(vFile)) {
            return true;
        }
        for (PsiFile psiFile : this.myFormFiles) {
            VirtualFile virtualFile2 = psiFile.getVirtualFile();
            if (virtualFile2 == null || !virtualFile2.equals(vFile)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Iterator<PsiElement> iterator() {
        ArrayList<PsiFile> list = new ArrayList<PsiFile>(this.myFormFiles);
        list.add(0, (PsiFile)this.myClassToBind);
        Iterator<PsiFile> iterator = list.iterator();
        if (iterator == null) {
            Form.$$$reportNull$$$0(3);
        }
        return iterator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classToBind";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/projectView/Form";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/projectView/Form";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassToBind";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

