/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ngram.slp.modeling.ngram;

import com.intellij.completion.ngram.slp.counting.Counter;
import com.intellij.completion.ngram.slp.counting.trie.MapTrieCounter;
import com.intellij.completion.ngram.slp.modeling.AbstractModel;
import com.intellij.completion.ngram.slp.modeling.ngram.JMModel;
import com.intellij.completion.ngram.slp.modeling.ngram.NGramModel;
import com.intellij.completion.ngram.slp.modeling.runners.ModelRunner;
import com.intellij.completion.ngram.slp.sequencing.NGramSequencer;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u0000 -2\u00020\u0001:\u0002-.B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0007\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0014J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0014J\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0018H\u0016J\u001e\u0010\u0019\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00182\u0006\u0010\u001a\u001a\u00020\u0006H\u0016J\u0016\u0010\u001b\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0018H\u0016J\u001e\u0010\u001c\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00182\u0006\u0010\u001a\u001a\u00020\u0006H\u0016J*\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00182\u0006\u0010\u001a\u001a\u00020\u0006H\u0016J*\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\u00182\u0006\u0010\"\u001a\u00020#H$J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u0012H\u0016J8\u0010&\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0\u001e0'2\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u0006H\u0016J2\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060)2\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u0006H\u0002J\b\u0010+\u001a\u00020,H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006/"}, d2={"Lcom/intellij/completion/ngram/slp/modeling/ngram/NGramModel;", "Lcom/intellij/completion/ngram/slp/modeling/AbstractModel;", "counter", "Lcom/intellij/completion/ngram/slp/counting/Counter;", "(Lcom/intellij/completion/ngram/slp/counting/Counter;)V", "order", "", "(ILcom/intellij/completion/ngram/slp/counting/Counter;)V", "config", "Lcom/intellij/completion/ngram/slp/modeling/ngram/NGramModel$Config;", "getConfig", "()Lcom/intellij/completion/ngram/slp/modeling/ngram/NGramModel$Config;", "getCounter", "()Lcom/intellij/completion/ngram/slp/counting/Counter;", "setCounter", "getOrder", "()I", "buildConfigFileName", "Ljava/io/File;", "directory", "buildCounterFileName", "forget", "", "input", "", "forgetToken", "index", "learn", "learnToken", "modelAtIndex", "Lkotlin/Pair;", "", "modelWithConfidence", "subList", "counts", "", "notify", "next", "predictAtIndex", "", "prob", "", "prediction", "toString", "", "Companion", "Config", "bd0177eacd27ae4e"})
public abstract class NGramModel
extends AbstractModel {
    @NotNull
    private final Config config;
    private final int order;
    @NotNull
    private Counter counter;
    private static Class<? extends NGramModel> standard;
    public static final Companion Companion;

    @Override
    public void notify(@NotNull File next) {
        Intrinsics.checkParameterIsNotNull((Object)next, (String)"next");
    }

    @Override
    public void learn(@NotNull List<Integer> input) {
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
        this.counter.countBatch(NGramSequencer.INSTANCE.sequenceForward(input, this.order));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void learnToken(@NotNull List<Integer> input, int index) {
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
        List<Integer> sequence = NGramSequencer.INSTANCE.sequenceAt(input, index, this.order);
        int n = 0;
        int n2 = ((Collection)sequence).size();
        while (n < n2) {
            void i;
            this.counter.count(sequence.subList((int)i, sequence.size()));
            ++i;
        }
    }

    @Override
    public void forget(@NotNull List<Integer> input) {
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
        this.counter.unCountBatch(NGramSequencer.INSTANCE.sequenceForward(input, this.order));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void forgetToken(@NotNull List<Integer> input, int index) {
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
        List<Integer> sequence = NGramSequencer.INSTANCE.sequenceAt(input, index, this.order);
        int n = 0;
        int n2 = ((Collection)sequence).size();
        while (n < n2) {
            void i;
            this.counter.unCount(sequence.subList((int)i, sequence.size()));
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Pair<Double, Double> modelAtIndex(@NotNull List<Integer> input, int index) {
        void i;
        List<Integer> sub;
        long[] counts;
        Intrinsics.checkParameterIsNotNull(input, (String)"input");
        List<Integer> sequence = NGramSequencer.INSTANCE.sequenceAt(input, index, this.order);
        double probability = 0.0;
        double mass = 0.0;
        int hits = 0;
        int n = ((Collection)sequence).size();
        --n;
        boolean bl = false;
        while (n >= 0 && (counts = this.counter.getCounts(sub = sequence.subList((int)i, sequence.size())))[1] != 0L) {
            Intrinsics.checkExpressionValueIsNotNull((Object)counts, (String)"counts");
            Pair<Double, Double> resN = this.modelWithConfidence(sub, counts);
            double prob = ((Number)resN.getFirst()).doubleValue();
            double conf = ((Number)resN.getSecond()).doubleValue();
            mass = (1.0 - conf) * mass + conf;
            probability = (1.0 - conf) * probability + conf * prob;
            ++hits;
            --i;
        }
        if (mass > 0.0) {
            probability /= mass;
        }
        double d = 2.0;
        double d2 = -hits;
        double d3 = 1.0;
        boolean bl2 = false;
        double d4 = Math.pow(d, d2);
        double confidence = d3 - d4;
        return new Pair((Object)probability, (Object)confidence);
    }

    @NotNull
    protected abstract Pair<Double, Double> modelWithConfidence(@NotNull List<Integer> var1, @NotNull long[] var2);

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Integer, Pair<Double, Double>> predictAtIndex(@Nullable List<Integer> input, int index) {
        List<Integer> list = input;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        List<Integer> sequence = NGramSequencer.INSTANCE.sequenceAt(list, index - 1, this.order);
        HashSet predictions = new HashSet();
        int n = 0;
        int n2 = sequence.size();
        if (n <= n2) {
            int limit;
            while ((limit = ModelRunner.Companion.getPredictionCutoff() - predictions.size()) > 0) {
                void i;
                predictions.addAll(this.counter.getTopSuccessors(sequence.subList((int)i, sequence.size()), limit));
                if (i == n2) break;
                ++i;
            }
        }
        Map<Integer, Pair<Double, Double>> map2 = predictions.stream().collect(Collectors.toMap(predictAtIndex.1.INSTANCE, new Function<T, U>(this, input, index){
            final /* synthetic */ NGramModel this$0;
            final /* synthetic */ List $input;
            final /* synthetic */ int $index;

            @NotNull
            public final Pair<Double, Double> apply(Integer p) {
                List list = CollectionsKt.toMutableList((Collection)this.$input);
                Integer n = p;
                if (n == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"p!!");
                return NGramModel.access$prob(this.this$0, list, this.$index, n);
            }
            {
                this.this$0 = nGramModel;
                this.$input = list;
                this.$index = n;
            }
        }));
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"predictions.stream().col\u2026 index, p!!) })\n        )");
        return map2;
    }

    private final Pair<Double, Double> prob(List<Integer> input, int index, int prediction) {
        boolean added;
        boolean bl = added = index == input.size();
        if (added) {
            input.add(0);
        }
        int prev = ((Number)input.set(index, prediction)).intValue();
        Pair<Double, Double> prob = this.modelAtIndex(input, index);
        if (added) {
            input.remove(input.size() - 1);
        } else {
            input.set(index, prev);
        }
        return prob;
    }

    @NotNull
    public String toString() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        return string;
    }

    @NotNull
    protected Config getConfig() {
        return this.config;
    }

    @NotNull
    protected File buildCounterFileName(@NotNull File directory) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        return new File(directory.getAbsolutePath() + File.separator + "counter.obj");
    }

    @NotNull
    protected File buildConfigFileName(@NotNull File directory) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        return new File(directory.getAbsolutePath() + File.separator + "config.json");
    }

    public final int getOrder() {
        return this.order;
    }

    @NotNull
    public final Counter getCounter() {
        return this.counter;
    }

    public final void setCounter(@NotNull Counter counter) {
        Intrinsics.checkParameterIsNotNull((Object)counter, (String)"<set-?>");
        this.counter = counter;
    }

    @JvmOverloads
    public NGramModel(int order, @NotNull Counter counter) {
        Intrinsics.checkParameterIsNotNull((Object)counter, (String)"counter");
        this.order = order;
        this.counter = counter;
        String string = this.getClass().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this::class.java.toString()");
        this.config = new Config(this.order, string);
    }

    public /* synthetic */ NGramModel(int n, Counter counter, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 6;
        }
        if ((n2 & 2) != 0) {
            counter = new MapTrieCounter();
        }
        this(n, counter);
    }

    @JvmOverloads
    public NGramModel(int order) {
        this(order, null, 2, null);
    }

    @JvmOverloads
    public NGramModel() {
        this(0, null, 3, null);
    }

    public NGramModel(@NotNull Counter counter) {
        Intrinsics.checkParameterIsNotNull((Object)counter, (String)"counter");
        this(6, counter);
    }

    static {
        Companion = new Companion(null);
        standard = JMModel.class;
    }

    public static final /* synthetic */ Pair access$prob(NGramModel $this, List input, int index, int prediction) {
        return $this.prob(input, index, prediction);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/completion/ngram/slp/modeling/ngram/NGramModel$Config;", "", "order", "", "name", "", "(ILjava/lang/String;)V", "getName", "()Ljava/lang/String;", "getOrder", "()I", "bd0177eacd27ae4e"})
    public static class Config {
        private final int order;
        @NotNull
        private final String name;

        public final int getOrder() {
            return this.order;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public Config(int order, @NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            this.order = order;
            this.name = name;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004J\u0006\u0010\u0003\u001a\u00020\u0005J\u000e\u0010\u0003\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nR\u0016\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/completion/ngram/slp/modeling/ngram/NGramModel$Companion;", "", "()V", "standard", "Ljava/lang/Class;", "Lcom/intellij/completion/ngram/slp/modeling/ngram/NGramModel;", "setStandard", "", "clazz", "counter", "Lcom/intellij/completion/ngram/slp/counting/Counter;", "bd0177eacd27ae4e"})
    public static final class Companion {
        public final void setStandard(@NotNull Class<? extends NGramModel> clazz) {
            Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
            standard = clazz;
        }

        @NotNull
        public final NGramModel standard() {
            try {
                Object t = standard.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"standard.getDeclaredConstructor().newInstance()");
                return (NGramModel)t;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                return new JMModel(0, 0.0, null, 7, null);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return new JMModel(0, 0.0, null, 7, null);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                return new JMModel(0, 0.0, null, 7, null);
            }
            catch (SecurityException e) {
                e.printStackTrace();
                return new JMModel(0, 0.0, null, 7, null);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                return new JMModel(0, 0.0, null, 7, null);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                return new JMModel(0, 0.0, null, 7, null);
            }
        }

        @NotNull
        public final NGramModel standard(@NotNull Counter counter) {
            Intrinsics.checkParameterIsNotNull((Object)counter, (String)"counter");
            try {
                Object t = standard.getConstructor(Counter.class).newInstance(counter);
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"standard.getConstructor(\u2026ava).newInstance(counter)");
                return (NGramModel)t;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                return new JMModel(0, 0.0, null, 7, null);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return new JMModel(0, 0.0, null, 7, null);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                return new JMModel(0, 0.0, null, 7, null);
            }
            catch (SecurityException e) {
                e.printStackTrace();
                return new JMModel(0, 0.0, null, 7, null);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                return new JMModel(0, 0.0, null, 7, null);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                return new JMModel(0, 0.0, null, 7, null);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

