/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DelegateKeyStore
extends KeyStoreSpi {
    protected static Provider ourProvider = new Provider("IDEA", 1.0, "IDEA Key Store"){
        {
            Security.addProvider(this);
        }
    };
    private final KeyStore delegate;

    protected KeyStore getDelegate() {
        this.validate(this.delegate);
        return this.delegate;
    }

    protected void validate(KeyStore keyStore) {
    }

    static String getDefaultKeyStorePath() {
        File base = new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + "security");
        File jssecacerts = new File(base, "jssecacerts");
        return jssecacerts.exists() ? jssecacerts.getPath() : new File(base, "cacerts").getPath();
    }

    public DelegateKeyStore(String type) {
        try {
            this.delegate = KeyStore.getInstance(type);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    public DelegateKeyStore(KeyStore delegate) {
        this.delegate = delegate;
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        try {
            return this.getDelegate().getKey(alias, password);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        try {
            return this.getDelegate().getCertificateChain(alias);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        try {
            return this.getDelegate().getCertificate(alias);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        try {
            return this.getDelegate().getCreationDate(alias);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        this.getDelegate().setKeyEntry(alias, key, password, chain);
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        this.getDelegate().setKeyEntry(alias, key, chain);
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        this.getDelegate().setCertificateEntry(alias, cert);
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        this.getDelegate().deleteEntry(alias);
    }

    @Override
    public Enumeration<String> engineAliases() {
        try {
            return this.getDelegate().aliases();
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        try {
            return this.getDelegate().containsAlias(alias);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int engineSize() {
        try {
            return this.getDelegate().size();
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        try {
            return this.getDelegate().isKeyEntry(alias);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        try {
            return this.getDelegate().isCertificateEntry(alias);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        try {
            return this.getDelegate().getCertificateAlias(cert);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        try {
            this.getDelegate().store(stream, password);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.delegate.load(stream, password);
    }

    @Nullable
    protected static KeyStore loadKeyStore(@NotNull String path, char[] password) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        File file;
        if (path == null) {
            DelegateKeyStore.$$$reportNull$$$0(0);
        }
        if (!(file = new File(path)).exists()) {
            return null;
        }
        KeyStore tmpStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (FileInputStream stream = new FileInputStream(file);){
            tmpStore.load(stream, password);
        }
        return tmpStore;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/execution/rmi/ssl/DelegateKeyStore", "loadKeyStore"));
    }
}

