/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.io.IOException;
import java.io.InputStream;

public class PeekInputStream
extends InputStream {
    private final InputStream delegate;
    private byte[] buffer;
    private int charsBuffered;

    public PeekInputStream(InputStream delegate) {
        this.delegate = delegate;
        this.buffer = new byte[4];
    }

    public int peek(int depth) throws IOException {
        if (depth < this.charsBuffered) {
            return this.buffer[depth];
        }
        if (depth != this.charsBuffered) {
            throw new UnsupportedOperationException("Not yet implemented.");
        }
        int ch = this.delegate.read();
        if (ch < 0) {
            return ch;
        }
        this.buffer[this.charsBuffered] = (byte)ch;
        ++this.charsBuffered;
        return ch;
    }

    public void consumeAll() {
        this.charsBuffered = 0;
    }

    public int read() throws IOException {
        if (this.charsBuffered > 0) {
            byte result2 = this.buffer[0];
            --this.charsBuffered;
            for (int i = 0; i < this.charsBuffered; ++i) {
                this.buffer[i] = this.buffer[i + 1];
            }
            return result2;
        }
        return this.delegate.read();
    }
}

