/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.Closeable;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheLockingAccessCoordinator;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheMetadata;
import org.gradle.api.internal.artifacts.ivyservice.CacheLayout;
import org.gradle.api.internal.cache.CacheConfigurationsInternal;
import org.gradle.api.internal.cache.DefaultCacheCleanupStrategy;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheCleanupStrategy;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.IndexedCache;
import org.gradle.cache.IndexedCacheParameters;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.UnscopedCacheBuilderFactory;
import org.gradle.cache.internal.CompositeCleanupAction;
import org.gradle.cache.internal.LeastRecentlyUsedCacheCleanup;
import org.gradle.cache.internal.SingleDepthFilesFinder;
import org.gradle.cache.internal.UnusedVersionsCacheCleanup;
import org.gradle.cache.internal.UsedGradleVersions;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.Factory;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.time.TimestampSuppliers;

public class WritableArtifactCacheLockingAccessCoordinator
implements ArtifactCacheLockingAccessCoordinator,
Closeable {
    private final PersistentCache cache;

    public WritableArtifactCacheLockingAccessCoordinator(UnscopedCacheBuilderFactory unscopedCacheBuilderFactory, ArtifactCacheMetadata cacheMetaData, FileAccessTimeJournal fileAccessTimeJournal, UsedGradleVersions usedGradleVersions, CacheConfigurationsInternal cacheConfigurations) {
        this.cache = unscopedCacheBuilderFactory.cache(cacheMetaData.getCacheDir()).withCrossVersionCache(CacheBuilder.LockTarget.CacheDirectory).withDisplayName("artifact cache").withLockOptions(LockOptionsBuilder.mode(FileLockManager.LockMode.OnDemand)).withCleanupStrategy(this.createCacheCleanupStrategy(cacheMetaData, fileAccessTimeJournal, usedGradleVersions, cacheConfigurations)).open();
    }

    private CacheCleanupStrategy createCacheCleanupStrategy(ArtifactCacheMetadata cacheMetaData, FileAccessTimeJournal fileAccessTimeJournal, UsedGradleVersions usedGradleVersions, CacheConfigurationsInternal cacheConfigurations) {
        return DefaultCacheCleanupStrategy.from(this.createCleanupAction(cacheMetaData, fileAccessTimeJournal, usedGradleVersions, cacheConfigurations), cacheConfigurations.getCleanupFrequency());
    }

    private CleanupAction createCleanupAction(ArtifactCacheMetadata cacheMetaData, FileAccessTimeJournal fileAccessTimeJournal, UsedGradleVersions usedGradleVersions, CacheConfigurationsInternal cacheConfigurations) {
        return CompositeCleanupAction.builder().add(UnusedVersionsCacheCleanup.create(CacheLayout.ROOT.getName(), CacheLayout.ROOT.getVersionMapping(), usedGradleVersions)).add(cacheMetaData.getExternalResourcesStoreDirectory(), UnusedVersionsCacheCleanup.create(CacheLayout.RESOURCES.getName(), CacheLayout.RESOURCES.getVersionMapping(), usedGradleVersions), new LeastRecentlyUsedCacheCleanup(new SingleDepthFilesFinder(2), fileAccessTimeJournal, this.getMaxAgeTimestamp(cacheConfigurations))).add(cacheMetaData.getFileStoreDirectory(), UnusedVersionsCacheCleanup.create(CacheLayout.FILE_STORE.getName(), CacheLayout.FILE_STORE.getVersionMapping(), usedGradleVersions), new LeastRecentlyUsedCacheCleanup(new SingleDepthFilesFinder(4), fileAccessTimeJournal, this.getMaxAgeTimestamp(cacheConfigurations))).add(cacheMetaData.getMetaDataStoreDirectory().getParentFile(), UnusedVersionsCacheCleanup.create(CacheLayout.META_DATA.getName(), CacheLayout.META_DATA.getVersionMapping(), usedGradleVersions)).build();
    }

    private Supplier<Long> getMaxAgeTimestamp(CacheConfigurationsInternal cacheConfigurations) {
        Integer maxAgeProperty = Integer.getInteger("org.gradle.internal.cleanup.external.max.age");
        if (maxAgeProperty == null) {
            return cacheConfigurations.getDownloadedResources().getRemoveUnusedEntriesOlderThanAsSupplier();
        }
        return TimestampSuppliers.daysAgo(maxAgeProperty);
    }

    @Override
    public void close() {
        this.cache.close();
    }

    @Override
    public <T> T withFileLock(Factory<? extends T> action) {
        return this.cache.withFileLock(action);
    }

    @Override
    public void withFileLock(Runnable action) {
        this.cache.withFileLock(action);
    }

    @Override
    public <T> T useCache(Factory<? extends T> action) {
        return this.cache.useCache(action);
    }

    @Override
    public void useCache(Runnable action) {
        this.cache.useCache(action);
    }

    @Override
    public <K, V> IndexedCache<K, V> createCache(String cacheName, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        String cacheFileInMetaDataStore = CacheLayout.META_DATA.getKey() + "/" + cacheName;
        IndexedCache<K, V> indexedCache = this.cache.createIndexedCache(IndexedCacheParameters.of(cacheFileInMetaDataStore, keySerializer, valueSerializer));
        return new CacheLockingIndexedCache<K, V>(indexedCache);
    }

    private class CacheLockingIndexedCache<K, V>
    implements IndexedCache<K, V> {
        private final IndexedCache<K, V> indexedCache;

        public CacheLockingIndexedCache(IndexedCache<K, V> indexedCache) {
            this.indexedCache = indexedCache;
        }

        @Override
        @Nullable
        public V getIfPresent(K key) {
            return (V)WritableArtifactCacheLockingAccessCoordinator.this.cache.useCache(() -> this.indexedCache.getIfPresent(key));
        }

        @Override
        public V get(K key, Function<? super K, ? extends V> producer) {
            return (V)WritableArtifactCacheLockingAccessCoordinator.this.cache.useCache(() -> this.indexedCache.get(key, producer));
        }

        @Override
        public void put(K key, V value) {
            WritableArtifactCacheLockingAccessCoordinator.this.cache.useCache(() -> this.indexedCache.put(key, value));
        }

        @Override
        public void remove(K key) {
            WritableArtifactCacheLockingAccessCoordinator.this.cache.useCache(() -> this.indexedCache.remove(key));
        }
    }
}

