/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.util.Set;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryDisabler;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.resolve.ResolveExceptionAnalyzer;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value=Scopes.BuildTree.class)
public class ConnectionFailureRepositoryDisabler
implements RepositoryDisabler {
    private static final Logger LOGGER = Logging.getLogger(ConnectionFailureRepositoryDisabler.class);
    private final Set<String> disabledRepositories = Sets.newConcurrentHashSet();

    @Override
    public boolean isDisabled(String repositoryId) {
        return this.disabledRepositories.contains(repositoryId);
    }

    @Override
    public boolean disableRepository(String repositoryId, Throwable throwable) {
        boolean disabled = this.isDisabled(repositoryId);
        if (disabled) {
            return true;
        }
        if (ResolveExceptionAnalyzer.isCriticalFailure(throwable)) {
            LOGGER.debug("Repository {} has been disabled for this build due to connectivity issues", repositoryId);
            this.disabledRepositories.add(repositoryId);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public Set<String> getDisabledRepositories() {
        return this.disabledRepositories;
    }
}

