/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.verification.model;

import java.util.List;
import java.util.Set;
import org.gradle.api.internal.artifacts.verification.model.ArtifactVerificationMetadata;
import org.gradle.api.internal.artifacts.verification.model.Checksum;
import org.gradle.api.internal.artifacts.verification.model.IgnoredKey;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

public class ImmutableArtifactVerificationMetadata
implements ArtifactVerificationMetadata {
    private final String artifactName;
    private final List<Checksum> checksums;
    private final Set<String> trustedPgpKeys;
    private final Set<IgnoredKey> ignoredPgpKeys;
    private final int hashCode;

    public ImmutableArtifactVerificationMetadata(String artifactName, List<Checksum> checksums, Set<String> trustedPgpKeys, Set<IgnoredKey> ignoredPgpKeys) {
        this.artifactName = artifactName;
        this.checksums = ImmutableList.copyOf(checksums);
        this.trustedPgpKeys = ImmutableSet.copyOf(trustedPgpKeys);
        this.ignoredPgpKeys = ImmutableSet.copyOf(ignoredPgpKeys);
        this.hashCode = this.computeHashCode();
    }

    @Override
    public String getArtifactName() {
        return this.artifactName;
    }

    @Override
    public List<Checksum> getChecksums() {
        return this.checksums;
    }

    @Override
    public Set<String> getTrustedPgpKeys() {
        return this.trustedPgpKeys;
    }

    @Override
    public Set<IgnoredKey> getIgnoredPgpKeys() {
        return this.ignoredPgpKeys;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableArtifactVerificationMetadata that = (ImmutableArtifactVerificationMetadata)o;
        if (!this.artifactName.equals(that.artifactName)) {
            return false;
        }
        if (!this.checksums.equals(that.checksums)) {
            return false;
        }
        if (!this.ignoredPgpKeys.equals(that.ignoredPgpKeys)) {
            return false;
        }
        return this.trustedPgpKeys.equals(that.trustedPgpKeys);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int result2 = this.artifactName.hashCode();
        result2 = 31 * result2 + this.checksums.hashCode();
        result2 = 31 * result2 + this.trustedPgpKeys.hashCode();
        result2 = 31 * result2 + this.ignoredPgpKeys.hashCode();
        return result2;
    }
}

