/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.catalog.problems;

import java.util.Collection;
import javax.annotation.Nonnull;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.initialization.dsl.VersionCatalogBuilder;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.problems.DocLink;
import org.gradle.api.problems.Problem;
import org.gradle.api.problems.ReportableProblem;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;
import org.gradle.util.internal.TextUtil;

public class DefaultCatalogProblemBuilder {
    private static final DocumentationRegistry DOCUMENTATION_REGISTRY = new DocumentationRegistry();
    public static final String VERSION_CATALOG_PROBLEMS = "version_catalog_problems";

    public static void maybeThrowError(String error, Collection<ReportableProblem> problems) {
        if (!problems.isEmpty()) {
            throw DefaultCatalogProblemBuilder.throwErrorWithNewProblemsApi(error, problems);
        }
    }

    public static RuntimeException throwErrorWithNewProblemsApi(String error, Collection<ReportableProblem> problems) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node(error);
        formatter.startChildren();
        for (Problem problem2 : problems) {
            DefaultCatalogProblemBuilder.reportInto(formatter, problem2);
        }
        formatter.endChildren();
        for (ReportableProblem reportableProblem : problems) {
            reportableProblem.report();
        }
        throw new InvalidUserDataException(formatter.toString());
    }

    private static void reportInto(TreeFormatter output, Problem problem2) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node(problem2.getLabel());
        if (problem2.getDetails() != null) {
            formatter.blankLine();
            formatter.node("Reason: " + StringUtils.capitalize((String)TextUtil.endLineWithDot(problem2.getDetails())));
        }
        TypeValidationProblemRenderer.renderSolutionsWithNewProblemsApi(formatter, problem2.getSolutions());
        DocLink documentationLink = problem2.getDocumentationLink();
        if (documentationLink != null) {
            formatter.blankLine();
            formatter.node(DOCUMENTATION_REGISTRY.getDocumentationRecommendationFor("information", documentationLink));
        }
        output.node(formatter.toString());
    }

    @Nonnull
    public static String getProblemInVersionCatalog(VersionCatalogBuilder builder) {
        return DefaultCatalogProblemBuilder.getProblemInVersionCatalog(builder.getName());
    }

    @Nonnull
    public static String getProblemInVersionCatalog(String name) {
        return "Problem: " + DefaultCatalogProblemBuilder.getInVersionCatalog(name);
    }

    @Nonnull
    public static String getInVersionCatalog(String name) {
        return "In version catalog " + name;
    }
}

