/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FilePermissions;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.DefaultFilePermissions;
import org.gradle.api.internal.file.archive.AbstractArchiveFileTree;
import org.gradle.api.internal.file.archive.AbstractArchiveFileTreeElement;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.provider.Provider;
import org.gradle.cache.internal.DecompressionCache;
import org.gradle.internal.file.Chmod;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.impldep.org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.gradle.internal.impldep.org.apache.commons.compress.archivers.zip.ZipFile;

public class ZipFileTree
extends AbstractArchiveFileTree {
    private final Provider<File> fileProvider;
    private final Chmod chmod;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;
    private final FileHasher fileHasher;

    public ZipFileTree(Provider<File> zipFile, Chmod chmod, DirectoryFileTreeFactory directoryFileTreeFactory, FileHasher fileHasher, DecompressionCache decompressionCache) {
        super(decompressionCache);
        this.fileProvider = zipFile;
        this.chmod = chmod;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
        this.fileHasher = fileHasher;
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public String getDisplayName() {
        return String.format("ZIP '%s'", this.fileProvider.getOrNull());
    }

    @Override
    public DirectoryFileTree getMirror() {
        return this.directoryFileTreeFactory.create(this.getExpandedDir());
    }

    @Override
    public void visit(FileVisitor visitor) {
        this.decompressionCache.useCache(() -> {
            File zipFile = this.fileProvider.get();
            if (!zipFile.exists()) {
                throw new InvalidUserDataException(String.format("Cannot expand %s as it does not exist.", this.getDisplayName()));
            }
            if (!zipFile.isFile()) {
                throw new InvalidUserDataException(String.format("Cannot expand %s as it is not a file.", this.getDisplayName()));
            }
            AtomicBoolean stopFlag = new AtomicBoolean();
            File expandedDir = this.getExpandedDir();
            try (ZipFile zip = new ZipFile(zipFile);){
                Iterator<ZipArchiveEntry> sortedEntries = this.entriesSortedByName(zip);
                while (!stopFlag.get() && sortedEntries.hasNext()) {
                    ZipArchiveEntry entry = sortedEntries.next();
                    DetailsImpl details = new DetailsImpl(zipFile, expandedDir, entry, zip, stopFlag, this.chmod);
                    if (entry.isDirectory()) {
                        visitor.visitDir(details);
                        continue;
                    }
                    visitor.visitFile(details);
                }
            }
            catch (Exception e) {
                throw new GradleException(String.format("Cannot expand %s.", this.getDisplayName()), e);
            }
        });
    }

    private Iterator<ZipArchiveEntry> entriesSortedByName(ZipFile zip) {
        TreeMap<String, ZipArchiveEntry> entriesByName = new TreeMap<String, ZipArchiveEntry>();
        Enumeration entries = zip.getEntries();
        while (entries.hasMoreElements()) {
            ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
            entriesByName.put(entry.getName(), entry);
        }
        return entriesByName.values().iterator();
    }

    @Override
    public Provider<File> getBackingFileProvider() {
        return this.fileProvider;
    }

    private File getExpandedDir() {
        File zipFile = this.fileProvider.get();
        String expandedDirName = "zip_" + this.fileHasher.hash(zipFile);
        return new File(this.decompressionCache.getBaseDir(), expandedDirName);
    }

    private static final class DetailsImpl
    extends AbstractArchiveFileTreeElement {
        private final File originalFile;
        private final ZipArchiveEntry entry;
        private final ZipFile zip;

        public DetailsImpl(File originalFile, File expandedDir, ZipArchiveEntry entry, ZipFile zip, AtomicBoolean stopFlag, Chmod chmod) {
            super(chmod, expandedDir, stopFlag);
            this.originalFile = originalFile;
            this.entry = entry;
            this.zip = zip;
        }

        @Override
        public String getDisplayName() {
            return String.format("zip entry %s!%s", this.originalFile, this.entry.getName());
        }

        @Override
        protected String getEntryName() {
            return this.entry.getName();
        }

        protected ZipArchiveEntry getArchiveEntry() {
            return this.entry;
        }

        @Override
        public InputStream open() {
            try {
                return this.zip.getInputStream(this.entry);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public FilePermissions getPermissions() {
            int unixMode = this.entry.getUnixMode() & 0x1FF;
            if (unixMode != 0) {
                return new DefaultFilePermissions(unixMode);
            }
            return super.getPermissions();
        }
    }
}

