/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junitplatform;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.TestFrameworkDistributionModule;
import org.gradle.api.internal.tasks.testing.WorkerTestClassProcessorFactory;
import org.gradle.api.internal.tasks.testing.detection.TestFrameworkDetector;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.internal.tasks.testing.junitplatform.JUnitPlatformSpec;
import org.gradle.api.internal.tasks.testing.junitplatform.JUnitPlatformTestClassProcessorFactory;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.testing.TestFilter;
import org.gradle.api.tasks.testing.junitplatform.JUnitPlatformOptions;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.jvm.UnsupportedJavaRuntimeException;
import org.gradle.process.internal.worker.WorkerProcessBuilder;

public class JUnitPlatformTestFramework
implements TestFramework {
    private static final Logger LOGGER = Logging.getLogger(JUnitPlatformTestFramework.class);
    private static final List<TestFrameworkDistributionModule> DISTRIBUTION_MODULES = ImmutableList.of((Object)new TestFrameworkDistributionModule("junit-platform-engine", Pattern.compile("junit-platform-engine-1.*\\.jar"), "org.gradle.internal.impldep.org.junit.platform.engine.DiscoverySelector"), (Object)new TestFrameworkDistributionModule("junit-platform-launcher", Pattern.compile("junit-platform-launcher-1.*\\.jar"), "org.gradle.internal.impldep.org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder"), (Object)new TestFrameworkDistributionModule("junit-platform-commons", Pattern.compile("junit-platform-commons-1.*\\.jar"), "org.gradle.internal.impldep.org.junit.platform.commons.util.ReflectionUtils"));
    private final JUnitPlatformOptions options;
    private final DefaultTestFilter filter;
    private final boolean useImplementationDependencies;
    private final Provider<Boolean> dryRun;

    public JUnitPlatformTestFramework(DefaultTestFilter filter, boolean useImplementationDependencies, Provider<Boolean> dryRun) {
        this(filter, useImplementationDependencies, new JUnitPlatformOptions(), dryRun);
    }

    private JUnitPlatformTestFramework(DefaultTestFilter filter, boolean useImplementationDependencies, JUnitPlatformOptions options, Provider<Boolean> dryRun) {
        this.filter = filter;
        this.useImplementationDependencies = useImplementationDependencies;
        this.options = options;
        this.dryRun = dryRun;
    }

    @Override
    public TestFramework copyWithFilters(TestFilter newTestFilters) {
        JUnitPlatformOptions copiedOptions = new JUnitPlatformOptions();
        copiedOptions.copyFrom(this.options);
        return new JUnitPlatformTestFramework((DefaultTestFilter)newTestFilters, this.useImplementationDependencies, copiedOptions, this.dryRun);
    }

    @Override
    public WorkerTestClassProcessorFactory getProcessorFactory() {
        if (!JavaVersion.current().isJava8Compatible()) {
            throw new UnsupportedJavaRuntimeException("Running JUnit Platform requires Java 8+, please configure your test java executable with Java 8 or higher.");
        }
        this.validateOptions();
        return new JUnitPlatformTestClassProcessorFactory(new JUnitPlatformSpec(this.filter.toSpec(), this.options.getIncludeEngines(), this.options.getExcludeEngines(), this.options.getIncludeTags(), this.options.getExcludeTags(), this.dryRun.get()));
    }

    @Override
    public Action<WorkerProcessBuilder> getWorkerConfigurationAction() {
        return workerProcessBuilder -> workerProcessBuilder.sharedPackages("org.gradle.internal.impldep.org.junit");
    }

    @Override
    public List<TestFrameworkDistributionModule> getWorkerApplicationModulepathModules() {
        return DISTRIBUTION_MODULES;
    }

    @Override
    public boolean getUseDistributionDependencies() {
        return this.useImplementationDependencies;
    }

    @Override
    public JUnitPlatformOptions getOptions() {
        return this.options;
    }

    @Override
    public TestFrameworkDetector getDetector() {
        return null;
    }

    @Override
    public void close() throws IOException {
    }

    private void validateOptions() {
        HashSet intersection = Sets.newHashSet(this.options.getIncludeTags());
        intersection.retainAll(this.options.getExcludeTags());
        if (!intersection.isEmpty()) {
            if (intersection.size() == 1) {
                LOGGER.warn("The tag '" + (String)intersection.iterator().next() + "' is both included and excluded.  This will result in the tag being excluded, which may not be what was intended.  Please either include or exclude the tag but not both.");
            } else {
                String allTags = intersection.stream().sorted().map(s -> "'" + s + "'").collect(Collectors.joining(", "));
                LOGGER.warn("The tags " + allTags + " are both included and excluded.  This will result in the tags being excluded, which may not be what was intended.  Please either include or exclude the tags but not both.");
            }
        }
    }
}

