/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.artifact;

import java.io.File;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.api.publish.ivy.internal.artifact.AbstractIvyArtifact;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationCoordinates;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.impldep.com.google.common.io.Files;

public class FileBasedIvyArtifact
extends AbstractIvyArtifact {
    private final File file;
    private final String extension;
    private final IvyPublicationCoordinates coordinates;

    public FileBasedIvyArtifact(File file, IvyPublicationCoordinates coordinates, TaskDependencyFactory taskDependencyFactory) {
        super(taskDependencyFactory);
        this.file = file;
        this.extension = Files.getFileExtension((String)file.getName());
        this.coordinates = coordinates;
    }

    @Override
    protected String getDefaultName() {
        return (String)this.coordinates.getModule().get();
    }

    @Override
    protected String getDefaultType() {
        return this.extension;
    }

    @Override
    protected String getDefaultExtension() {
        return this.extension;
    }

    @Override
    protected String getDefaultClassifier() {
        return null;
    }

    @Override
    protected String getDefaultConf() {
        return null;
    }

    @Override
    protected TaskDependency getDefaultBuildDependencies() {
        return TaskDependencyInternal.EMPTY;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public boolean shouldBePublished() {
        return true;
    }
}

