/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.tools.ant.types.Commandline;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.jvm.ModularitySpec;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.internal.JavaExecExecutableUtils;
import org.gradle.api.tasks.options.Option;
import org.gradle.internal.jvm.DefaultModularitySpec;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.internal.JavaExecutableUtils;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.process.ExecResult;
import org.gradle.process.JavaDebugOptions;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.ProcessForkOptions;
import org.gradle.process.internal.DefaultJavaExecSpec;
import org.gradle.process.internal.ExecActionFactory;
import org.gradle.process.internal.JavaExecAction;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Gradle would require more information to cache this task")
public abstract class JavaExec
extends ConventionTask
implements JavaExecSpec {
    private final DefaultJavaExecSpec javaExecSpec;
    private final Property<String> mainModule;
    private final Property<String> mainClass;
    private final ModularitySpec modularity;
    private final Property<ExecResult> execResult;
    private final Property<JavaLauncher> javaLauncher;
    private final ListProperty<String> jvmArguments;

    public JavaExec() {
        ObjectFactory objectFactory = this.getObjectFactory();
        this.mainModule = objectFactory.property(String.class);
        this.mainClass = objectFactory.property(String.class);
        this.modularity = objectFactory.newInstance(DefaultModularitySpec.class, new Object[0]);
        this.execResult = objectFactory.property(ExecResult.class);
        this.javaExecSpec = objectFactory.newInstance(DefaultJavaExecSpec.class, new Object[0]);
        Provider<Iterable> jvmArgumentsConvention = this.getProviderFactory().provider(this::jvmArgsConventionValue);
        this.jvmArguments = objectFactory.listProperty(String.class).convention(jvmArgumentsConvention);
        this.javaExecSpec.getMainClass().convention(this.mainClass);
        this.javaExecSpec.getMainModule().convention(this.mainModule);
        this.javaExecSpec.getModularity().getInferModulePath().convention(this.modularity.getInferModulePath());
        JavaToolchainService javaToolchainService = this.getJavaToolchainService();
        Provider<JavaLauncher> javaLauncherConvention = this.getProviderFactory().provider(() -> JavaExecExecutableUtils.getExecutableOverrideToolchainSpec(this, objectFactory)).flatMap(javaToolchainService::launcherFor).orElse(javaToolchainService.launcherFor(it -> {}));
        this.javaLauncher = objectFactory.property(JavaLauncher.class).convention(javaLauncherConvention);
        this.javaLauncher.finalizeValueOnRead();
    }

    @TaskAction
    public void exec() {
        this.validateExecutableMatchesToolchain();
        List jvmArgs = (List)this.jvmArguments.getOrNull();
        if (jvmArgs != null) {
            this.javaExecSpec.setExtraJvmArgs(jvmArgs);
        }
        JavaExecAction javaExecAction = this.getExecActionFactory().newJavaExecAction();
        this.javaExecSpec.copyTo(javaExecAction);
        String effectiveExecutable = ((JavaLauncher)this.getJavaLauncher().get()).getExecutablePath().toString();
        javaExecAction.setExecutable(effectiveExecutable);
        this.execResult.set(javaExecAction.execute());
    }

    private void validateExecutableMatchesToolchain() {
        File toolchainExecutable = ((JavaLauncher)this.getJavaLauncher().get()).getExecutablePath().getAsFile();
        String customExecutable = this.getExecutable();
        JavaExecutableUtils.validateExecutable(customExecutable, "Toolchain from `executable` property", toolchainExecutable, "toolchain from `javaLauncher` property");
    }

    @Override
    public List<String> getAllJvmArgs() {
        return this.javaExecSpec.getAllJvmArgs();
    }

    @Override
    public void setAllJvmArgs(List<String> arguments) {
        this.javaExecSpec.setAllJvmArgs(arguments);
    }

    @Override
    public void setAllJvmArgs(Iterable<?> arguments) {
        this.javaExecSpec.setAllJvmArgs(arguments);
    }

    @Override
    public List<String> getJvmArgs() {
        return (List)this.jvmArguments.getOrNull();
    }

    @Override
    public void setJvmArgs(List<String> arguments) {
        this.jvmArguments.empty();
        this.jvmArgs(arguments);
    }

    @Override
    public void setJvmArgs(Iterable<?> arguments) {
        this.jvmArguments.empty();
        this.jvmArgs((Iterable)arguments);
    }

    @Override
    public JavaExec jvmArgs(Iterable<?> arguments) {
        this.addJvmArguments(arguments);
        this.javaExecSpec.checkDebugConfiguration(arguments);
        return this;
    }

    private void addJvmArguments(Iterable<?> arguments) {
        for (Object arg : arguments) {
            this.jvmArguments.add(arg.toString());
        }
    }

    @Override
    public JavaExec jvmArgs(Object ... arguments) {
        this.jvmArgs(Arrays.asList(arguments));
        return this;
    }

    @Override
    public Map<String, Object> getSystemProperties() {
        return this.javaExecSpec.getSystemProperties();
    }

    @Override
    public void setSystemProperties(Map<String, ?> properties) {
        this.javaExecSpec.setSystemProperties(properties);
    }

    @Override
    public JavaExec systemProperties(Map<String, ?> properties) {
        this.javaExecSpec.systemProperties(properties);
        return this;
    }

    @Override
    public JavaExec systemProperty(String name, Object value) {
        this.javaExecSpec.systemProperty(name, value);
        return this;
    }

    @Override
    public FileCollection getBootstrapClasspath() {
        return this.javaExecSpec.getBootstrapClasspath();
    }

    @Override
    public void setBootstrapClasspath(FileCollection classpath) {
        this.javaExecSpec.setBootstrapClasspath(classpath);
    }

    @Override
    public JavaExec bootstrapClasspath(Object ... classpath) {
        this.javaExecSpec.bootstrapClasspath(classpath);
        return this;
    }

    @Override
    public String getMinHeapSize() {
        return this.javaExecSpec.getMinHeapSize();
    }

    @Override
    public void setMinHeapSize(String heapSize) {
        this.javaExecSpec.setMinHeapSize(heapSize);
    }

    @Override
    public String getDefaultCharacterEncoding() {
        return this.javaExecSpec.getDefaultCharacterEncoding();
    }

    @Override
    public void setDefaultCharacterEncoding(String defaultCharacterEncoding) {
        this.javaExecSpec.setDefaultCharacterEncoding(defaultCharacterEncoding);
    }

    @Override
    public String getMaxHeapSize() {
        return this.javaExecSpec.getMaxHeapSize();
    }

    @Override
    public void setMaxHeapSize(String heapSize) {
        this.javaExecSpec.setMaxHeapSize(heapSize);
    }

    @Override
    public boolean getEnableAssertions() {
        return this.javaExecSpec.getEnableAssertions();
    }

    @Override
    public void setEnableAssertions(boolean enabled) {
        this.javaExecSpec.setEnableAssertions(enabled);
    }

    @Override
    public boolean getDebug() {
        return this.javaExecSpec.getDebug();
    }

    @Override
    @Option(option="debug-jvm", description="Enable debugging for the process. The process is started suspended and listening on port 5005.")
    public void setDebug(boolean enabled) {
        this.javaExecSpec.setDebug(enabled);
    }

    @Override
    public JavaDebugOptions getDebugOptions() {
        return this.javaExecSpec.getDebugOptions();
    }

    @Override
    public void debugOptions(Action<JavaDebugOptions> action) {
        this.javaExecSpec.debugOptions(action);
    }

    @Override
    public Property<String> getMainModule() {
        return this.mainModule;
    }

    @Override
    public Property<String> getMainClass() {
        return this.mainClass;
    }

    @Override
    public List<String> getArgs() {
        return this.javaExecSpec.getArgs();
    }

    @Option(option="args", description="Command line arguments passed to the main class.")
    public JavaExec setArgsString(String args) {
        return this.setArgs((List)Arrays.asList(Commandline.translateCommandline((String)args)));
    }

    @Override
    public JavaExec setArgs(List<String> applicationArgs) {
        this.javaExecSpec.setArgs(applicationArgs);
        return this;
    }

    @Override
    public JavaExec setArgs(Iterable<?> applicationArgs) {
        this.javaExecSpec.setArgs(applicationArgs);
        return this;
    }

    @Override
    public JavaExec args(Object ... args) {
        this.javaExecSpec.args(args);
        return this;
    }

    @Override
    public JavaExecSpec args(Iterable<?> args) {
        this.javaExecSpec.args(args);
        return this;
    }

    @Override
    public List<CommandLineArgumentProvider> getArgumentProviders() {
        return this.javaExecSpec.getArgumentProviders();
    }

    @Override
    public JavaExec setClasspath(FileCollection classpath) {
        this.javaExecSpec.setClasspath(classpath);
        return this;
    }

    @Override
    public JavaExec classpath(Object ... paths) {
        this.javaExecSpec.classpath(paths);
        return this;
    }

    @Override
    public FileCollection getClasspath() {
        return this.javaExecSpec.getClasspath();
    }

    @Override
    public ModularitySpec getModularity() {
        return this.modularity;
    }

    @Override
    public JavaExec copyTo(JavaForkOptions options) {
        this.javaExecSpec.copyTo(options);
        return this;
    }

    @Input
    public JavaVersion getJavaVersion() {
        return JavaVersion.toVersion(((JavaLauncher)this.getJavaLauncher().get()).getMetadata().getLanguageVersion().asInt());
    }

    @Override
    @Internal(value="covered by getJavaVersion")
    @Nullable
    public String getExecutable() {
        return this.javaExecSpec.getExecutable();
    }

    @Override
    public void setExecutable(String executable) {
        this.javaExecSpec.setExecutable(executable);
    }

    @Override
    public void setExecutable(Object executable) {
        this.javaExecSpec.setExecutable(executable);
    }

    @Override
    public JavaExec executable(Object executable) {
        this.javaExecSpec.executable(executable);
        return this;
    }

    @Override
    @Internal
    public File getWorkingDir() {
        return this.javaExecSpec.getWorkingDir();
    }

    @Override
    public void setWorkingDir(File dir) {
        this.javaExecSpec.setWorkingDir(dir);
    }

    @Override
    public void setWorkingDir(Object dir) {
        this.javaExecSpec.setWorkingDir(dir);
    }

    @Override
    public JavaExec workingDir(Object dir) {
        this.javaExecSpec.workingDir(dir);
        return this;
    }

    @Override
    @Internal
    public Map<String, Object> getEnvironment() {
        return this.javaExecSpec.getEnvironment();
    }

    @Override
    public void setEnvironment(Map<String, ?> environmentVariables) {
        this.javaExecSpec.setEnvironment(environmentVariables);
    }

    @Override
    public JavaExec environment(String name, Object value) {
        this.javaExecSpec.environment(name, value);
        return this;
    }

    @Override
    public JavaExec environment(Map<String, ?> environmentVariables) {
        this.javaExecSpec.environment(environmentVariables);
        return this;
    }

    @Override
    public JavaExec copyTo(ProcessForkOptions target) {
        this.javaExecSpec.copyTo(target);
        return this;
    }

    @Override
    public JavaExec setStandardInput(InputStream inputStream) {
        this.javaExecSpec.setStandardInput(inputStream);
        return this;
    }

    @Override
    @Internal
    public InputStream getStandardInput() {
        return this.javaExecSpec.getStandardInput();
    }

    @Override
    public JavaExec setStandardOutput(OutputStream outputStream) {
        this.javaExecSpec.setStandardOutput(outputStream);
        return this;
    }

    @Override
    @Internal
    public OutputStream getStandardOutput() {
        return this.javaExecSpec.getStandardOutput();
    }

    @Override
    public JavaExec setErrorOutput(OutputStream outputStream) {
        this.javaExecSpec.setErrorOutput(outputStream);
        return this;
    }

    @Override
    @Internal
    public OutputStream getErrorOutput() {
        return this.javaExecSpec.getErrorOutput();
    }

    @Override
    public JavaExecSpec setIgnoreExitValue(boolean ignoreExitValue) {
        this.javaExecSpec.setIgnoreExitValue(ignoreExitValue);
        return this;
    }

    @Override
    @Input
    public boolean isIgnoreExitValue() {
        return this.javaExecSpec.isIgnoreExitValue();
    }

    @Override
    @Internal
    public List<String> getCommandLine() {
        return this.javaExecSpec.getCommandLine();
    }

    @Override
    public List<CommandLineArgumentProvider> getJvmArgumentProviders() {
        return this.javaExecSpec.getJvmArgumentProviders();
    }

    @Override
    public ListProperty<String> getJvmArguments() {
        return this.jvmArguments;
    }

    @Internal
    public Provider<ExecResult> getExecutionResult() {
        return this.execResult;
    }

    @Nested
    public Property<JavaLauncher> getJavaLauncher() {
        return this.javaLauncher;
    }

    @Inject
    protected ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ExecActionFactory getExecActionFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected JavaToolchainService getJavaToolchainService() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ProviderFactory getProviderFactory() {
        throw new UnsupportedOperationException();
    }

    private Iterable<String> jvmArgsConventionValue() {
        List<String> jvmArgs = this.getConventionMapping().getConventionValue(null, "jvmArgs", false);
        return jvmArgs != null ? jvmArgs : Collections.emptyList();
    }
}

