/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.gradle.api.UncheckedIOException;
import org.gradle.buildinit.plugins.internal.BuildContentGenerator;
import org.gradle.buildinit.plugins.internal.InitSettings;

public class GitAttributesGenerator
implements BuildContentGenerator {
    @Override
    public void generate(InitSettings settings) {
        File file = settings.getTarget().file(".gitattributes").getAsFile();
        try (PrintWriter writer2 = new PrintWriter(new FileWriter(file));){
            writer2.println("#");
            writer2.println("# https://help.github.com/articles/dealing-with-line-endings/");
            writer2.println("#");
            writer2.println("# Linux start script should use lf");
            writer2.println("/gradlew        text eol=lf");
            writer2.println();
            writer2.println("# These are Windows script files and should use crlf");
            writer2.println("*.bat           text eol=crlf");
            writer2.println();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

