/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;
import org.gradle.buildinit.plugins.internal.modifiers.Language;

public class Description {
    public static final Description JAVA = new Description(Language.JAVA, BuildInitTestFramework.JUNIT_JUPITER, Arrays.asList(BuildInitTestFramework.JUNIT, BuildInitTestFramework.JUNIT_JUPITER, BuildInitTestFramework.TESTNG, BuildInitTestFramework.SPOCK), null, null);
    public static final Description GROOVY = new Description(Language.GROOVY, BuildInitTestFramework.SPOCK, Collections.singletonList(BuildInitTestFramework.SPOCK), "groovy", null);
    public static final Description SCALA = new Description(Language.SCALA, BuildInitTestFramework.SCALATEST, Collections.singletonList(BuildInitTestFramework.SCALATEST), "scala", null);
    public static final Description KOTLIN = new Description(Language.KOTLIN, BuildInitTestFramework.KOTLINTEST, Collections.singletonList(BuildInitTestFramework.KOTLINTEST), "org.gradle.internal.impldep.org.jetbrains.kotlin.jvm", "kotlin");
    private final Language language;
    private final BuildInitTestFramework defaultTestFramework;
    private final Set<BuildInitTestFramework> supportedTestFrameworks;
    private final Optional<String> pluginName;
    private final String pluginVersionProperty;

    private Description(Language language, BuildInitTestFramework defaultTestFramework, List<BuildInitTestFramework> supportedTestFrameworks, String pluginName, String pluginVersionProperty) {
        this.language = language;
        this.defaultTestFramework = defaultTestFramework;
        this.supportedTestFrameworks = new TreeSet<BuildInitTestFramework>(supportedTestFrameworks);
        this.pluginName = Optional.ofNullable(pluginName);
        this.pluginVersionProperty = pluginVersionProperty;
    }

    public Language getLanguage() {
        return this.language;
    }

    public BuildInitTestFramework getDefaultTestFramework() {
        return this.defaultTestFramework;
    }

    public Set<BuildInitTestFramework> getSupportedTestFrameworks() {
        return this.supportedTestFrameworks;
    }

    public Optional<String> getPluginName() {
        return this.pluginName;
    }

    @Nullable
    public String getPluginVersionProperty() {
        return this.pluginVersionProperty;
    }
}

