/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.gradle.api.Action;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.tasks.VerificationException;
import org.gradle.execution.plan.CompositeNodeGroup;
import org.gradle.execution.plan.FinalizerGroup;
import org.gradle.execution.plan.HasFinalizers;
import org.gradle.execution.plan.MutationInfo;
import org.gradle.execution.plan.NodeGroup;
import org.gradle.execution.plan.OrdinalGroup;
import org.gradle.execution.plan.TaskDependencyResolver;
import org.gradle.execution.plan.TaskNode;
import org.gradle.execution.plan.edges.DependencyNodesSet;
import org.gradle.execution.plan.edges.DependentNodesSet;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.resources.ResourceLock;

public abstract class Node {
    private ExecutionState state = ExecutionState.NOT_SCHEDULED;
    private boolean dependenciesProcessed;
    private DependenciesState dependenciesState = DependenciesState.NOT_COMPLETE;
    private Throwable executionFailure;
    private boolean filtered;
    private int index;
    private DependencyNodesSet dependencyNodes = DependencyNodesSet.EMPTY;
    private DependentNodesSet dependentNodes = DependentNodesSet.EMPTY;
    private final MutationInfo mutationInfo = new MutationInfo();
    private NodeGroup group = NodeGroup.DEFAULT_GROUP;

    @VisibleForTesting
    ExecutionState getState() {
        return this.state;
    }

    String healthDiagnostics() {
        if (this.isComplete()) {
            return this + " (state=" + (Object)((Object)this.state) + ")";
        }
        StringBuilder specificState = new StringBuilder();
        this.dependencyNodes.healthDiagnostics(specificState);
        this.nodeSpecificHealthDiagnostics(specificState);
        return this + " (state=" + (Object)((Object)this.state) + ", dependencies=" + (Object)((Object)this.dependenciesState) + ", group=" + this.group + ", " + specificState + " )";
    }

    public static String formatNodes(Iterable<? extends Node> nodes) {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        boolean first = true;
        for (Node node : nodes) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(node).append(" (").append((Object)node.getState()).append(")");
        }
        builder.append(']');
        return builder.toString();
    }

    protected void nodeSpecificHealthDiagnostics(StringBuilder builder) {
    }

    public NodeGroup getGroup() {
        return this.group;
    }

    public void setGroup(NodeGroup group) {
        if (this.group != group) {
            this.group.removeMember(this);
            this.group = group;
            this.group.addMember(this);
        }
    }

    @Nullable
    public OrdinalGroup getOrdinal() {
        return this.group.asOrdinal();
    }

    public void maybeInheritOrdinalAsDependency(@Nullable OrdinalGroup candidateOrdinal) {
        if (this.group == candidateOrdinal || candidateOrdinal == null) {
            return;
        }
        OrdinalGroup currentOrdinal = this.group.asOrdinal();
        if (currentOrdinal == null || candidateOrdinal.getOrdinal() < currentOrdinal.getOrdinal()) {
            this.setGroup(this.group.reachableFrom(candidateOrdinal));
        }
    }

    public void maybeInheritFinalizerGroups() {
        NodeGroup newGroup = this.group;
        for (Node predecessor : this.getDependencyPredecessors()) {
            if (!(predecessor.getGroup() instanceof HasFinalizers)) continue;
            newGroup = Node.maybeInheritGroupAsFinalizerDependency((HasFinalizers)predecessor.getGroup(), newGroup);
        }
        if (newGroup != this.group) {
            this.setGroup(newGroup);
        }
    }

    private static HasFinalizers maybeInheritGroupAsFinalizerDependency(HasFinalizers finalizers, NodeGroup current) {
        if (current == finalizers || current == NodeGroup.DEFAULT_GROUP) {
            return finalizers;
        }
        if (current instanceof OrdinalGroup) {
            return CompositeNodeGroup.mergeInto((OrdinalGroup)current, finalizers);
        }
        return CompositeNodeGroup.mergeInto((HasFinalizers)current, finalizers);
    }

    public void maybeUpdateOrdinalGroup() {
        OrdinalGroup ordinal;
        OrdinalGroup newOrdinal = ordinal = this.getGroup().asOrdinal();
        for (Node successor : this.getHardSuccessors()) {
            OrdinalGroup successorOrdinal = successor.getGroup().asOrdinal();
            if (successorOrdinal == null || newOrdinal != null && successorOrdinal.getOrdinal() <= newOrdinal.getOrdinal()) continue;
            newOrdinal = successorOrdinal;
        }
        if (newOrdinal != ordinal) {
            this.setGroup(this.getGroup().withOrdinalGroup(newOrdinal));
        }
    }

    @Nullable
    public FinalizerGroup getFinalizerGroup() {
        return this.group.asFinalizer();
    }

    public boolean isRequired() {
        return this.state == ExecutionState.SHOULD_RUN;
    }

    public boolean isDoNotIncludeInPlan() {
        return this.filtered || this.state == ExecutionState.NOT_SCHEDULED || this.isCannotRunInAnyPlan();
    }

    public boolean isCannotRunInAnyPlan() {
        return this.state == ExecutionState.EXECUTED || this.state == ExecutionState.FAILED_DEPENDENCY;
    }

    public boolean isReady() {
        return this.state == ExecutionState.SHOULD_RUN;
    }

    public boolean isCanCancel() {
        return this.group.isCanCancel();
    }

    public boolean isInKnownState() {
        return this.state != ExecutionState.NOT_SCHEDULED;
    }

    public boolean isExecuting() {
        return this.state == ExecutionState.EXECUTING;
    }

    public boolean isComplete() {
        return this.state == ExecutionState.EXECUTED || this.state == ExecutionState.FAILED_DEPENDENCY || this.state == ExecutionState.NOT_SCHEDULED || this.filtered;
    }

    public boolean isSuccessful() {
        return this.filtered || this.state == ExecutionState.EXECUTED && !this.isFailed();
    }

    public boolean isVerificationFailure() {
        return this.getNodeFailure() != null && this.getNodeFailure().getCause() instanceof VerificationException;
    }

    public boolean isFailed() {
        return this.getNodeFailure() != null || this.getExecutionFailure() != null;
    }

    public boolean isExecuted() {
        return this.state == ExecutionState.EXECUTED;
    }

    public boolean isPriority() {
        return false;
    }

    @Nullable
    public abstract Throwable getNodeFailure();

    public void startExecution(Consumer<Node> nodeStartAction) {
        assert (this.state == ExecutionState.SHOULD_RUN && this.allDependenciesComplete() && this.allDependenciesSuccessful());
        this.state = ExecutionState.EXECUTING;
        SortedSet<Node> finalizers = this.getFinalizers();
        if (!finalizers.isEmpty()) {
            for (Node finalizer : finalizers) {
                finalizer.getGroup().onNodeStart(finalizer, this);
            }
        }
        nodeStartAction.accept(this);
    }

    public void finishExecution(Consumer<Node> completionAction) {
        assert (this.state == ExecutionState.EXECUTING);
        this.state = ExecutionState.EXECUTED;
        completionAction.accept(this);
    }

    public void markFailedDueToDependencies(Consumer<Node> completionAction) {
        assert (this.state == ExecutionState.SHOULD_RUN);
        this.state = ExecutionState.FAILED_DEPENDENCY;
        completionAction.accept(this);
    }

    public void cancelExecution(Consumer<Node> completionAction) {
        if (this.state != ExecutionState.SHOULD_RUN && this.state != ExecutionState.NOT_SCHEDULED) {
            throw new IllegalStateException("Cannot cancel node " + this);
        }
        this.state = ExecutionState.NOT_SCHEDULED;
        completionAction.accept(this);
    }

    public void require() {
        if (this.isCannotRunInAnyPlan()) {
            return;
        }
        if (this.state != ExecutionState.SHOULD_RUN) {
            this.dependenciesProcessed = false;
            this.state = ExecutionState.SHOULD_RUN;
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void filtered() {
        if (this.isCannotRunInAnyPlan()) {
            return;
        }
        this.filtered = true;
    }

    public void reset() {
        this.group = NodeGroup.DEFAULT_GROUP;
        this.index = 0;
        if (!this.isCannotRunInAnyPlan()) {
            this.filtered = false;
            this.dependenciesProcessed = false;
            this.state = ExecutionState.NOT_SCHEDULED;
            this.dependenciesState = DependenciesState.NOT_COMPLETE;
        }
    }

    public void setExecutionFailure(Throwable failure) {
        assert (this.state == ExecutionState.EXECUTING);
        this.executionFailure = failure;
    }

    @Nullable
    public Throwable getExecutionFailure() {
        return this.executionFailure;
    }

    public SortedSet<Node> getDependencyPredecessors() {
        return this.dependentNodes.getDependencyPredecessors();
    }

    public Set<Node> getDependencySuccessors() {
        return this.dependencyNodes.getDependencySuccessors();
    }

    public void addDependencySuccessor(Node toNode) {
        this.dependencyNodes = this.dependencyNodes.addDependency(toNode);
        toNode.addDependencyPredecessor(this);
    }

    void addDependencyPredecessor(Node fromNode) {
        this.dependentNodes = this.dependentNodes.addDependencyPredecessors(fromNode);
        this.mutationInfo.addConsumer(fromNode);
    }

    void addMustPredecessor(TaskNode fromNode) {
        this.dependentNodes = this.dependentNodes.addMustPredecessor(fromNode);
    }

    protected DependencyNodesSet getDependencyNodes() {
        return this.dependencyNodes;
    }

    protected void updateDependencyNodes(DependencyNodesSet newDependencies) {
        this.dependencyNodes = newDependencies;
    }

    public void onNodeComplete(Node node) {
        this.dependencyNodes.onNodeComplete(this, node);
        this.updateAllDependenciesComplete();
    }

    @OverridingMethodsMustInvokeSuper
    protected DependenciesState doCheckDependenciesComplete() {
        DependenciesState state = this.dependencyNodes.getState(this);
        if (state == DependenciesState.NOT_COMPLETE || state == DependenciesState.COMPLETE_AND_NOT_SUCCESSFUL) {
            return state;
        }
        return this.group.checkSuccessorsCompleteFor(this);
    }

    public void updateAllDependenciesComplete() {
        if (this.dependenciesState == DependenciesState.NOT_COMPLETE) {
            this.forceAllDependenciesCompleteUpdate();
        }
    }

    public void forceAllDependenciesCompleteUpdate() {
        this.dependenciesState = this.doCheckDependenciesComplete();
    }

    public boolean allDependenciesComplete() {
        return this.state == ExecutionState.SHOULD_RUN && this.dependenciesState != DependenciesState.NOT_COMPLETE;
    }

    public boolean allDependenciesSuccessful() {
        return this.dependenciesState == DependenciesState.COMPLETE_AND_SUCCESSFUL;
    }

    public boolean shouldCancelExecutionDueToDependencies() {
        return this.dependenciesState == DependenciesState.COMPLETE_AND_CAN_SKIP;
    }

    public boolean shouldContinueExecution(Node dependency) {
        return dependency.isSuccessful() || dependency.isVerificationFailure() && !this.dependsOnOutcome(dependency);
    }

    protected boolean dependsOnOutcome(Node dependency) {
        return false;
    }

    protected void visitAllNodesWaitingForThisNode(Consumer<Node> visitor) {
        this.dependentNodes.visitAllNodes(visitor);
    }

    public void prepareForScheduling() {
        ExecutionState initialState = this.getInitialState();
        if (initialState != null) {
            this.state = initialState;
        }
    }

    @Nullable
    protected ExecutionState getInitialState() {
        return null;
    }

    public void prepareForExecution(Action<Node> monitor) {
    }

    public abstract void resolveDependencies(TaskDependencyResolver var1);

    public boolean getDependenciesProcessed() {
        return this.dependenciesProcessed;
    }

    public void dependenciesProcessed() {
        this.dependenciesProcessed = true;
    }

    @OverridingMethodsMustInvokeSuper
    public Iterable<Node> getAllSuccessors() {
        return this.getHardSuccessors();
    }

    @OverridingMethodsMustInvokeSuper
    public Iterable<Node> getHardSuccessors() {
        return this.dependencyNodes.getDependencySuccessors();
    }

    @OverridingMethodsMustInvokeSuper
    public void visitHardSuccessors(Consumer<? super Node> visitor) {
        this.dependencyNodes.getDependencySuccessors().forEach(visitor);
    }

    public SortedSet<Node> getFinalizers() {
        return this.dependentNodes.getFinalizers();
    }

    public void addFinalizer(Node finalizer) {
        this.dependentNodes = this.dependentNodes.addFinalizer(finalizer);
    }

    public Set<Node> getFinalizingSuccessors() {
        return Collections.emptySet();
    }

    public void visitPreExecutionNodes(Consumer<? super Node> visitor) {
    }

    public boolean hasPendingPreExecutionNodes() {
        return false;
    }

    public void visitPostExecutionNodes(Consumer<? super Node> visitor) {
    }

    public MutationInfo getMutationInfo() {
        return this.mutationInfo;
    }

    public boolean isPublicNode() {
        return false;
    }

    @Nullable
    public ResourceLock getProjectToLock() {
        return null;
    }

    @Nullable
    public ProjectInternal getOwningProject() {
        return null;
    }

    public List<? extends ResourceLock> getResourcesToLock() {
        return Collections.emptyList();
    }

    public abstract String toString();

    public static enum DependenciesState {
        NOT_COMPLETE,
        COMPLETE_AND_SUCCESSFUL,
        COMPLETE_AND_NOT_SUCCESSFUL,
        COMPLETE_AND_CAN_SKIP;

    }

    @VisibleForTesting
    static enum ExecutionState {
        NOT_SCHEDULED,
        SHOULD_RUN,
        EXECUTING,
        EXECUTED,
        FAILED_DEPENDENCY;

    }
}

