/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.UnknownProjectException;
import org.gradle.api.cache.CacheConfigurations;
import org.gradle.api.initialization.ConfigurableIncludedBuild;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.initialization.Settings;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.initialization.resolve.DependencyResolutionManagement;
import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.cache.CacheConfigurationsInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptHandlerFactory;
import org.gradle.api.internal.plugins.DefaultObjectConfigurationAction;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.project.AbstractPluginAware;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.toolchain.management.ToolchainManagement;
import org.gradle.caching.configuration.BuildCacheConfiguration;
import org.gradle.caching.configuration.internal.BuildCacheConfigurationInternal;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.initialization.DefaultProjectDescriptor;
import org.gradle.initialization.IncludedBuildSpec;
import org.gradle.initialization.ProjectDescriptorRegistry;
import org.gradle.internal.Actions;
import org.gradle.internal.buildoption.FeatureFlags;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.impldep.org.apache.commons.lang.ArrayUtils;
import org.gradle.internal.management.DependencyResolutionManagementInternal;
import org.gradle.internal.management.ToolchainManagementInternal;
import org.gradle.internal.resource.TextUriResourceLoader;
import org.gradle.internal.scripts.ScriptFileResolver;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;
import org.gradle.plugin.management.PluginManagementSpec;
import org.gradle.plugin.management.internal.PluginManagementSpecInternal;
import org.gradle.vcs.SourceControl;

public abstract class DefaultSettings
extends AbstractPluginAware
implements SettingsInternal {
    private ScriptSource settingsScript;
    private StartParameter startParameter;
    private File settingsDir;
    private DefaultProjectDescriptor rootProjectDescriptor;
    private DefaultProjectDescriptor defaultProjectDescriptor;
    private final GradleInternal gradle;
    private final ClassLoaderScope classLoaderScope;
    private final ClassLoaderScope baseClassLoaderScope;
    private final ScriptHandler scriptHandler;
    private final ServiceRegistry services;
    private final List<IncludedBuildSpec> includedBuildSpecs = new ArrayList<IncludedBuildSpec>();
    private final DependencyResolutionManagementInternal dependencyResolutionManagement;
    private final ToolchainManagementInternal toolchainManagement;

    public DefaultSettings(ServiceRegistryFactory serviceRegistryFactory2, GradleInternal gradle, ClassLoaderScope classLoaderScope, ClassLoaderScope baseClassLoaderScope, ScriptHandler settingsScriptHandler, File settingsDir, ScriptSource settingsScript, StartParameter startParameter) {
        this.gradle = gradle;
        this.classLoaderScope = classLoaderScope;
        this.baseClassLoaderScope = baseClassLoaderScope;
        this.scriptHandler = settingsScriptHandler;
        this.settingsDir = settingsDir;
        this.settingsScript = settingsScript;
        this.startParameter = startParameter;
        this.services = serviceRegistryFactory2.createFor(this);
        this.rootProjectDescriptor = this.createProjectDescriptor(null, DefaultSettings.getProjectName(settingsDir), settingsDir);
        this.dependencyResolutionManagement = this.services.get(DependencyResolutionManagementInternal.class);
        this.toolchainManagement = this.services.get(ToolchainManagementInternal.class);
    }

    private static String getProjectName(File settingsDir) {
        if (ArrayUtils.contains((Object[])File.listRoots(), (Object)settingsDir)) {
            String rootIndicator = settingsDir.toPath().getRoot().toString().replaceAll("[\\\\:\\/]*", "");
            return "generated-" + rootIndicator + (rootIndicator.isEmpty() ? "" : "-") + Hashing.sha512().hashString(Instant.now().toString()).toString().substring(0, 6);
        }
        return settingsDir.getName();
    }

    public String toString() {
        return "settings '" + this.rootProjectDescriptor.getName() + "'";
    }

    @Override
    public GradleInternal getGradle() {
        return this.gradle;
    }

    @Override
    public List<IncludedBuildSpec> getIncludedBuilds() {
        return this.includedBuildSpecs;
    }

    @Override
    public Settings getSettings() {
        return this;
    }

    @Override
    public ScriptHandler getBuildscript() {
        return this.scriptHandler;
    }

    public DefaultProjectDescriptor createProjectDescriptor(@Nullable DefaultProjectDescriptor parent, String name, File dir) {
        return new DefaultProjectDescriptor(parent, name, dir, this.getProjectDescriptorRegistry(), this.getFileResolver(), this.getScriptFileResolver());
    }

    @Override
    public DefaultProjectDescriptor findProject(String path) {
        return (DefaultProjectDescriptor)this.getProjectDescriptorRegistry().getProject(path);
    }

    @Override
    public DefaultProjectDescriptor findProject(File projectDir) {
        return (DefaultProjectDescriptor)this.getProjectDescriptorRegistry().getProject(projectDir);
    }

    @Override
    public DefaultProjectDescriptor project(String path) {
        DefaultProjectDescriptor projectDescriptor = (DefaultProjectDescriptor)this.getProjectDescriptorRegistry().getProject(path);
        if (projectDescriptor == null) {
            throw new UnknownProjectException(String.format("Project with path '%s' could not be found.", path));
        }
        return projectDescriptor;
    }

    @Override
    public DefaultProjectDescriptor project(File projectDir) {
        DefaultProjectDescriptor projectDescriptor = (DefaultProjectDescriptor)this.getProjectDescriptorRegistry().getProject(projectDir);
        if (projectDescriptor == null) {
            throw new UnknownProjectException(String.format("Project with path '%s' could not be found.", projectDir));
        }
        return projectDescriptor;
    }

    @Override
    public void include(Iterable<String> projectPaths) {
        for (String projectPath : projectPaths) {
            String subPath = "";
            String[] pathElements = this.removeTrailingColon(projectPath).split(":");
            DefaultProjectDescriptor parentProjectDescriptor = this.rootProjectDescriptor;
            for (String pathElement : pathElements) {
                subPath = subPath + ":" + pathElement;
                DefaultProjectDescriptor projectDescriptor = (DefaultProjectDescriptor)this.getProjectDescriptorRegistry().getProject(subPath);
                parentProjectDescriptor = projectDescriptor == null ? this.createProjectDescriptor(parentProjectDescriptor, pathElement, new File(parentProjectDescriptor.getProjectDir(), pathElement)) : projectDescriptor;
            }
        }
    }

    @Override
    public void includeFlat(Iterable<String> projectNames) {
        for (String projectName : projectNames) {
            this.createProjectDescriptor(this.rootProjectDescriptor, projectName, new File(this.rootProjectDescriptor.getProjectDir().getParentFile(), projectName));
        }
    }

    private String removeTrailingColon(String projectPath) {
        if (projectPath.startsWith(":")) {
            return projectPath.substring(1);
        }
        return projectPath;
    }

    @Override
    public ProjectDescriptor getRootProject() {
        return this.rootProjectDescriptor;
    }

    public void setRootProjectDescriptor(DefaultProjectDescriptor rootProjectDescriptor) {
        this.rootProjectDescriptor = rootProjectDescriptor;
    }

    @Override
    public DefaultProjectDescriptor getDefaultProject() {
        return this.defaultProjectDescriptor;
    }

    @Override
    public void setDefaultProject(DefaultProjectDescriptor defaultProjectDescriptor) {
        this.defaultProjectDescriptor = defaultProjectDescriptor;
    }

    @Override
    public File getRootDir() {
        return this.rootProjectDescriptor.getProjectDir();
    }

    @Override
    public StartParameter getStartParameter() {
        return this.startParameter;
    }

    public void setStartParameter(StartParameter startParameter) {
        this.startParameter = startParameter;
    }

    @Override
    public File getSettingsDir() {
        return this.settingsDir;
    }

    public void setSettingsDir(File settingsDir) {
        this.settingsDir = settingsDir;
    }

    @Override
    public ScriptSource getSettingsScript() {
        return this.settingsScript;
    }

    public void setSettingsScript(ScriptSource settingsScript) {
        this.settingsScript = settingsScript;
    }

    @Override
    @Inject
    public abstract ProviderFactory getProviders();

    @Inject
    public abstract ProjectDescriptorRegistry getProjectDescriptorRegistry();

    @Inject
    public abstract TextUriResourceLoader.Factory getTextUriResourceLoaderFactory();

    @Inject
    public abstract ScriptFileResolver getScriptFileResolver();

    @Override
    public ProjectRegistry<DefaultProjectDescriptor> getProjectRegistry() {
        return this.getProjectDescriptorRegistry();
    }

    @Override
    protected DefaultObjectConfigurationAction createObjectConfigurationAction() {
        return new DefaultObjectConfigurationAction(this.getFileResolver(), this.getScriptPluginFactory(), this.getScriptHandlerFactory(), this.baseClassLoaderScope, this.getTextUriResourceLoaderFactory(), this);
    }

    @Override
    public ClassLoaderScope getBaseClassLoaderScope() {
        return this.baseClassLoaderScope;
    }

    @Override
    public ClassLoaderScope getClassLoaderScope() {
        return this.classLoaderScope;
    }

    @Override
    public ServiceRegistry getServices() {
        return this.services;
    }

    @Inject
    protected abstract ScriptHandlerFactory getScriptHandlerFactory();

    @Inject
    protected abstract ScriptPluginFactory getScriptPluginFactory();

    @Inject
    protected abstract FileResolver getFileResolver();

    @Override
    @Inject
    public abstract PluginManagerInternal getPluginManager();

    @Override
    public void includeBuild(Object rootProject) {
        this.includeBuild(rootProject, Actions.doNothing());
    }

    @Override
    public void includeBuild(Object rootProject, Action<ConfigurableIncludedBuild> configuration) {
        File projectDir = this.getFileResolver().resolve(rootProject);
        this.includedBuildSpecs.add(IncludedBuildSpec.includedBuild(projectDir, configuration));
    }

    @Override
    public void buildCache(Action<? super BuildCacheConfiguration> action) {
        action.execute(this.getBuildCache());
    }

    @Override
    @Inject
    public abstract BuildCacheConfigurationInternal getBuildCache();

    @Override
    public void pluginManagement(Action<? super PluginManagementSpec> rule) {
        rule.execute(this.getPluginManagement());
        this.includedBuildSpecs.addAll(((PluginManagementSpecInternal)this.getPluginManagement()).getIncludedBuilds());
    }

    @Override
    @Inject
    public abstract PluginManagementSpec getPluginManagement();

    @Override
    public void sourceControl(Action<? super SourceControl> configuration) {
        configuration.execute(this.getSourceControl());
    }

    @Override
    @Inject
    public abstract SourceControl getSourceControl();

    @Override
    public void enableFeaturePreview(String name) {
        FeaturePreviews.Feature feature = FeaturePreviews.Feature.withName(name);
        if (feature.isActive()) {
            this.services.get(FeatureFlags.class).enable(feature);
        } else {
            ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder)DeprecationLogger.deprecate("enableFeaturePreview('" + feature.name() + "')").withAdvice("The feature flag is no longer relevant, please remove it from your settings file.")).willBeRemovedInGradle9().withUserManual("feature_lifecycle", "feature_preview")).nagUser();
        }
    }

    @Override
    public void preventFromFurtherMutation() {
        this.dependencyResolutionManagement.preventFromFurtherMutation();
        this.toolchainManagement.preventFromFurtherMutation();
    }

    @Override
    public void dependencyResolutionManagement(Action<? super DependencyResolutionManagement> dependencyResolutionConfiguration) {
        dependencyResolutionConfiguration.execute(this.dependencyResolutionManagement);
    }

    @Override
    public DependencyResolutionManagementInternal getDependencyResolutionManagement() {
        return this.dependencyResolutionManagement;
    }

    @Override
    public ToolchainManagement getToolchainManagement() {
        return this.toolchainManagement;
    }

    @Override
    public void toolchainManagement(Action<? super ToolchainManagement> toolchainManagementConfiguration) {
        toolchainManagementConfiguration.execute(this.toolchainManagement);
    }

    @Override
    @Inject
    public abstract CacheConfigurationsInternal getCaches();

    @Override
    public void caches(Action<? super CacheConfigurations> cachesConfiguration) {
        cachesConfiguration.execute(this.getCaches());
    }
}

